/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.xic;

import fr.proline.core.orm.lcms.Feature;
import fr.proline.core.orm.lcms.Peakel;
import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.export.ExportModelUtilities;
import fr.proline.studio.extendedtablemodel.CompoundTableModel;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.DoubleFilter;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.filter.IntegerFilter;
import fr.proline.studio.graphics.PlotInformation;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.rsmexplorer.gui.renderer.FloatRenderer;
import fr.proline.studio.table.LazyData;
import fr.proline.studio.table.LazyTable;
import fr.proline.studio.table.LazyTableModel;
import fr.proline.studio.table.TableDefaultRendererManager;
import fr.proline.studio.table.renderer.DefaultAlignRenderer;
import fr.proline.studio.table.renderer.DoubleRenderer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableCellRenderer;

public class PeakelTableModel
extends LazyTableModel
implements GlobalTableModelInterface {
    public static final int COLTYPE_PEAKEL_ID = 0;
    public static final int COLTYPE_PEAKEL_MOZ = 1;
    public static final int COLTYPE_PEAKEL_ELUTION_TIME = 2;
    public static final int COLTYPE_PEAKEL_APEX_INTENSITY = 3;
    public static final int COLTYPE_PEAKEL_AREA = 4;
    public static final int COLTYPE_PEAKEL_DURATION = 5;
    public static final int COLTYPE_PEAKEL_FWHM = 6;
    public static final int COLTYPE_PEAKEL_IS_OVERLAPPING = 7;
    public static final int COLTYPE_PEAKEL_FEATURE_COUNT = 8;
    public static final int COLTYPE_PEAKEL_PEAK_COUNT = 9;
    private static final String[] m_columnNames = new String[]{"Id", "m/z", "Elution Time", "Apex Intensity", "Area", "Duration (sec)", "FWHM (sec)", "Is Overlapping", "#Features", "#Peaks"};
    private static final String[] m_toolTipColumns = new String[]{"Peakel Id", "Mass to Charge Ratio", "Elution Time", "Apex Intensity", "Area", "Duration (sec)", "FWHM (sec)", "Is Overlapping", "#Features", "#Peaks"};
    private Feature m_feature = null;
    private List<Peakel> m_peakels = null;
    private Color m_color = null;
    private String m_title = null;
    private String m_modelName;
    private final HashMap<Integer, TableCellRenderer> m_rendererMap = new HashMap();

    public PeakelTableModel(LazyTable table) {
        super(table);
    }

    public int getColumnCount() {
        return m_columnNames.length;
    }

    public String getColumnName(int col) {
        return m_columnNames[col];
    }

    public String getExportColumnName(int col) {
        return m_columnNames[col];
    }

    public String getToolTipForHeader(int col) {
        return m_toolTipColumns[col];
    }

    public String getTootlTipValue(int row, int col) {
        return null;
    }

    public Class getColumnClass(int col) {
        if (col == 0) {
            return Long.class;
        }
        return LazyData.class;
    }

    @Override
    public int getSubTaskId(int col) {
        return 0;
    }

    public int getRowCount() {
        if (this.m_peakels == null) {
            return 0;
        }
        return this.m_peakels.size();
    }

    public Object getValueAt(int row, int col) {
        Peakel peakel = this.m_peakels.get(row);
        switch (col) {
            case 0: {
                return peakel.getId();
            }
            case 1: {
                LazyData lazyData = this.getLazyData(row, col);
                if (peakel.getFeatureCount() == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else {
                    lazyData.setData((Comparable)Double.valueOf(peakel.getMoz()));
                }
                return lazyData;
            }
            case 2: {
                LazyData lazyData = this.getLazyData(row, col);
                if (peakel.getFeatureCount() == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else {
                    lazyData.setData((Comparable)Float.valueOf(peakel.getElutionTime()));
                }
                return lazyData;
            }
            case 3: {
                LazyData lazyData = this.getLazyData(row, col);
                if (peakel.getFeatureCount() == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else {
                    lazyData.setData((Comparable)Float.valueOf(peakel.getApexIntensity()));
                }
                return lazyData;
            }
            case 4: {
                LazyData lazyData = this.getLazyData(row, col);
                if (peakel.getFeatureCount() == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else {
                    lazyData.setData((Comparable)Float.valueOf(peakel.getArea()));
                }
                return lazyData;
            }
            case 5: {
                LazyData lazyData = this.getLazyData(row, col);
                if (peakel.getFeatureCount() == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else {
                    lazyData.setData((Comparable)Float.valueOf(peakel.getDuration()));
                }
                return lazyData;
            }
            case 6: {
                LazyData lazyData = this.getLazyData(row, col);
                if (peakel.getFeatureCount() == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else {
                    lazyData.setData((Comparable)Float.valueOf(peakel.getFwhm()));
                }
                return lazyData;
            }
            case 7: {
                LazyData lazyData = this.getLazyData(row, col);
                if (peakel.getFeatureCount() == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else {
                    lazyData.setData((Comparable)((Object)(peakel.getIsOverlapping() != false ? "Yes" : "No")));
                }
                return lazyData;
            }
            case 8: {
                LazyData lazyData = this.getLazyData(row, col);
                if (peakel.getFeatureCount() == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else {
                    lazyData.setData((Comparable)peakel.getFeatureCount());
                }
                return lazyData;
            }
            case 9: {
                LazyData lazyData = this.getLazyData(row, col);
                if (peakel.getFeatureCount() == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else {
                    lazyData.setData((Comparable)peakel.getPeakCount());
                }
                return lazyData;
            }
        }
        return null;
    }

    public void setData(Long taskId, Feature feature, List<Peakel> peakels, Color color, String title) {
        this.m_peakels = peakels;
        this.m_feature = feature;
        this.m_color = color;
        this.m_title = title;
        this.m_taskId = taskId;
        this.fireTableDataChanged();
    }

    public void dataUpdated() {
        this.fireTableDataChanged();
    }

    public Feature getFeature() {
        return this.m_feature;
    }

    public Color getColor() {
        return this.m_color;
    }

    public String getTitle() {
        return this.m_title;
    }

    public Peakel getPeakel(int i) {
        return this.m_peakels.get(i);
    }

    public int findRow(long peakelId) {
        int nb = this.m_peakels.size();
        for (int i = 0; i < nb; ++i) {
            if (peakelId != this.m_peakels.get(i).getId()) continue;
            return i;
        }
        return -1;
    }

    public void sortAccordingToModel(ArrayList<Long> peakelIds, CompoundTableModel compoundTableModel) {
        if (this.m_peakels == null) {
            return;
        }
        HashSet<Long> peakelIdMap = new HashSet<Long>(peakelIds.size());
        peakelIdMap.addAll(peakelIds);
        int nb = this.m_table.getRowCount();
        int iCur = 0;
        for (int iView = 0; iView < nb; ++iView) {
            Peakel p;
            int iModel = this.m_table.convertRowIndexToModel(iView);
            if (compoundTableModel != null) {
                iModel = compoundTableModel.convertCompoundRowToBaseModelRow(iModel);
            }
            if (!peakelIdMap.contains((p = this.getPeakel(iModel)).getId())) continue;
            peakelIds.set(iCur++, p.getId());
        }
    }

    public void addFilters(LinkedHashMap<Integer, Filter> filtersMap) {
        filtersMap.put(1, (Filter)new DoubleFilter(this.getColumnName(1), null, 1));
        filtersMap.put(2, (Filter)new DoubleFilter(this.getColumnName(2), null, 2));
        filtersMap.put(3, (Filter)new DoubleFilter(this.getColumnName(3), null, 3));
        filtersMap.put(4, (Filter)new DoubleFilter(this.getColumnName(4), null, 4));
        filtersMap.put(5, (Filter)new DoubleFilter(this.getColumnName(5), null, 5));
        filtersMap.put(6, (Filter)new DoubleFilter(this.getColumnName(6), null, 6));
        filtersMap.put(8, (Filter)new IntegerFilter(this.getColumnName(8), null, 8));
        filtersMap.put(9, (Filter)new IntegerFilter(this.getColumnName(9), null, 9));
    }

    public int getLoadingPercentage() {
        return this.m_table.getLoadingPercentage();
    }

    public boolean isLoaded() {
        return this.m_table.isLoaded();
    }

    public String getDataColumnIdentifier(int columnIndex) {
        return this.getColumnName(columnIndex);
    }

    public Class getDataColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Long.class;
            }
            case 1: {
                return Double.class;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return Float.class;
            }
            case 7: {
                return Boolean.class;
            }
            case 8: 
            case 9: {
                return Integer.class;
            }
        }
        return null;
    }

    public Object getDataValueAt(int rowIndex, int columnIndex) {
        Peakel peakel = this.m_peakels.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return peakel.getId();
            }
            case 1: {
                return peakel.getMoz();
            }
            case 2: {
                return Float.valueOf(peakel.getElutionTime());
            }
            case 3: {
                return Float.valueOf(peakel.getApexIntensity());
            }
            case 4: {
                return Float.valueOf(peakel.getArea());
            }
            case 5: {
                return Float.valueOf(peakel.getDuration());
            }
            case 6: {
                return Float.valueOf(peakel.getFwhm());
            }
            case 7: {
                return peakel.getIsOverlapping();
            }
            case 8: {
                return peakel.getFeatureCount();
            }
            case 9: {
                return peakel.getPeakCount();
            }
        }
        return null;
    }

    public int[] getKeysColumn() {
        int[] keys = new int[]{0};
        return keys;
    }

    public void setName(String name) {
        this.m_modelName = name;
    }

    public String getName() {
        return this.m_modelName;
    }

    public PlotType getBestPlotType() {
        return PlotType.SCATTER_PLOT;
    }

    public int[] getBestColIndex(PlotType plotType) {
        switch (plotType) {
            case HISTOGRAM_PLOT: {
                int[] cols = new int[]{3, 3};
                return cols;
            }
            case SCATTER_PLOT: {
                int[] cols = new int[]{2, 3};
                return cols;
            }
        }
        return null;
    }

    public int getInfoColumn() {
        return 0;
    }

    public Map<String, Object> getExternalData() {
        return null;
    }

    public PlotInformation getPlotInformation() {
        return null;
    }

    public String getExportRowCell(int row, int col) {
        return ExportModelUtilities.getExportRowCell((ExtendedTableModelInterface)this, (int)row, (int)col);
    }

    public ArrayList<ExportFontData> getExportFonts(int row, int col) {
        return null;
    }

    public TableCellRenderer getRenderer(int row, int col) {
        if (this.m_rendererMap.containsKey(col)) {
            return this.m_rendererMap.get(col);
        }
        Object renderer = null;
        switch (col) {
            case 1: {
                renderer = new DoubleRenderer((TableCellRenderer)new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 4));
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                renderer = new FloatRenderer((TableCellRenderer)new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 4));
                break;
            }
            case 7: {
                renderer = new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 2);
                break;
            }
            case 8: 
            case 9: {
                renderer = new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(Integer.class), 4);
            }
        }
        this.m_rendererMap.put(col, (TableCellRenderer)renderer);
        return renderer;
    }

    public GlobalTableModelInterface getFrozzenModel() {
        return this;
    }

    public ArrayList<ExtraDataType> getExtraDataTypes() {
        ArrayList<ExtraDataType> list = new ArrayList<ExtraDataType>();
        list.add(new ExtraDataType(Peakel.class, true));
        list.add(new ExtraDataType(Feature.class, false));
        this.registerSingleValuesAsExtraTypes(list);
        return list;
    }

    public Object getValue(Class c) {
        if (c.equals(Feature.class)) {
            return this.m_feature;
        }
        return this.getSingleValue(c);
    }

    public Object getRowValue(Class c, int row) {
        if (c.equals(Peakel.class)) {
            return this.m_peakels.get(row);
        }
        return null;
    }

    public Object getColValue(Class c, int col) {
        return null;
    }
}

