/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.xic;

import fr.proline.core.orm.msi.dto.DMasterQuantProteinSet;
import fr.proline.core.orm.msi.dto.DQuantProteinSet;
import fr.proline.core.orm.uds.dto.DDatasetType;
import fr.proline.core.orm.uds.dto.DQuantitationChannel;
import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.export.ExportModelUtilities;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.graphics.PlotInformation;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.rsmexplorer.gui.renderer.FloatRenderer;
import fr.proline.studio.table.LazyData;
import fr.proline.studio.table.LazyTable;
import fr.proline.studio.table.LazyTableModel;
import fr.proline.studio.table.TableDefaultRendererManager;
import fr.proline.studio.table.renderer.BigFloatOrDoubleRenderer;
import fr.proline.studio.table.renderer.DefaultAlignRenderer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.table.TableCellRenderer;

public class ProteinQuantTableModel
extends LazyTableModel
implements GlobalTableModelInterface {
    public static final int COLTYPE_QC_ID = 0;
    public static final int COLTYPE_QC_NAME = 1;
    public static final int COLTYPE_ABUNDANCE = 2;
    public static final int COLTYPE_RAW_ABUNDANCE = 3;
    public static final int COLTYPE_PSM = 4;
    private static final String[] m_columnNames = new String[]{"Id", "Quant. Channel", "Abundance", "Raw Abundance", "Pep. match count"};
    private static final String[] m_columnNames_SC = new String[]{"Id", "Quant. Channel", "Abundance", "Specific SC", "Basic SC"};
    private DMasterQuantProteinSet m_quantProtein = null;
    private DQuantitationChannel[] m_quantChannels = null;
    private String m_modelName;
    private DDatasetType.QuantitationMethodInfo m_quantMethodInfo = DDatasetType.QuantitationMethodInfo.FEATURES_EXTRACTION;

    public ProteinQuantTableModel(LazyTable table) {
        super(table);
    }

    private boolean isSpectralCountQuant() {
        return this.m_quantMethodInfo.equals((Object)DDatasetType.QuantitationMethodInfo.SPECTRAL_COUNTING);
    }

    public int getColumnCount() {
        return m_columnNames.length;
    }

    public String getColumnName(int col) {
        return this.isSpectralCountQuant() ? m_columnNames_SC[col] : m_columnNames[col];
    }

    @Override
    public int getSubTaskId(int col) {
        return -1;
    }

    public String getToolTipForHeader(int col) {
        return this.getColumnName(col);
    }

    public String getTootlTipValue(int row, int col) {
        return null;
    }

    public int getRowCount() {
        if (this.m_quantChannels == null) {
            return 0;
        }
        return this.m_quantChannels.length;
    }

    public Object getValueAt(int row, int col) {
        DQuantitationChannel qc = this.m_quantChannels[row];
        Map quantProteinSetByQchIds = this.m_quantProtein.getQuantProteinSetByQchIds();
        DQuantProteinSet quantProteinSet = (DQuantProteinSet)quantProteinSetByQchIds.get(qc.getId());
        switch (col) {
            case 0: {
                return qc.getId();
            }
            case 1: {
                return qc.getName();
            }
            case 2: {
                if (quantProteinSet == null || quantProteinSet.getAbundance() == null) {
                    return null;
                }
                return quantProteinSet.getAbundance().isNaN() ? null : quantProteinSet.getAbundance();
            }
            case 3: {
                if (quantProteinSet == null || quantProteinSet.getRawAbundance() == null) {
                    return null;
                }
                return quantProteinSet.getRawAbundance().isNaN() ? null : quantProteinSet.getRawAbundance();
            }
            case 4: {
                if (quantProteinSet == null || quantProteinSet.getPeptideMatchesCount() == null) {
                    return null;
                }
                return quantProteinSet.getPeptideMatchesCount();
            }
        }
        return null;
    }

    public void setData(DQuantitationChannel[] quantChannels, DMasterQuantProteinSet proteinSet, DDatasetType.QuantitationMethodInfo quantitationMethodInfo) {
        this.m_quantChannels = quantChannels;
        this.m_quantProtein = proteinSet;
        this.m_quantMethodInfo = quantitationMethodInfo;
        this.fireTableDataChanged();
    }

    public void dataUpdated() {
        this.fireTableDataChanged();
    }

    public void addFilters(LinkedHashMap<Integer, Filter> filtersMap) {
    }

    public boolean isLoaded() {
        return this.m_table.isLoaded();
    }

    public int getLoadingPercentage() {
        return this.m_table.getLoadingPercentage();
    }

    public String getDataColumnIdentifier(int columnIndex) {
        return this.isSpectralCountQuant() ? m_columnNames_SC[columnIndex] : m_columnNames[columnIndex];
    }

    public Class getDataColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Long.class;
            }
            case 1: {
                return String.class;
            }
            case 2: 
            case 3: {
                return Float.class;
            }
            case 4: {
                return Integer.class;
            }
        }
        return null;
    }

    public Object getDataValueAt(int rowIndex, int columnIndex) {
        Object data = this.getValueAt(rowIndex, columnIndex);
        if (data instanceof LazyData) {
            data = ((LazyData)data).getData();
        }
        return data;
    }

    public int[] getKeysColumn() {
        int[] keys = new int[]{0};
        return keys;
    }

    public int getInfoColumn() {
        return 1;
    }

    public void setName(String name) {
        this.m_modelName = name;
    }

    public String getName() {
        return this.m_modelName;
    }

    public Map<String, Object> getExternalData() {
        return null;
    }

    public PlotInformation getPlotInformation() {
        PlotInformation plotInformation = new PlotInformation();
        if (this.m_quantProtein.getProteinSet() != null && this.m_quantProtein.getProteinSet().getTypicalProteinMatch() != null) {
            plotInformation.setPlotTitle(this.m_quantProtein.getProteinSet().getTypicalProteinMatch().getAccession());
        }
        plotInformation.setDrawPoints(true);
        plotInformation.setDrawGap(true);
        return plotInformation;
    }

    public PlotType getBestPlotType() {
        return PlotType.LINEAR_PLOT;
    }

    public int[] getBestColIndex(PlotType plotType) {
        switch (plotType) {
            case LINEAR_PLOT: {
                int[] cols = new int[]{1, 3};
                return cols;
            }
        }
        return null;
    }

    public String getExportRowCell(int row, int col) {
        return ExportModelUtilities.getExportRowCell((ExtendedTableModelInterface)this, (int)row, (int)col);
    }

    public ArrayList<ExportFontData> getExportFonts(int row, int col) {
        return null;
    }

    public String getExportColumnName(int col) {
        return this.getColumnName(col);
    }

    public TableCellRenderer getRenderer(int row, int col) {
        FloatRenderer renderer = null;
        switch (col) {
            case 2: {
                if (this.isSpectralCountQuant()) {
                    renderer = new FloatRenderer((TableCellRenderer)new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 4), 2);
                    break;
                }
                renderer = new BigFloatOrDoubleRenderer((TableCellRenderer)new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 4), 0);
                break;
            }
            case 3: {
                renderer = this.isSpectralCountQuant() ? new FloatRenderer((TableCellRenderer)new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 4), 0) : new BigFloatOrDoubleRenderer((TableCellRenderer)new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 4), 0);
            }
        }
        return renderer;
    }

    public GlobalTableModelInterface getFrozzenModel() {
        return this;
    }

    public ArrayList<ExtraDataType> getExtraDataTypes() {
        ArrayList<ExtraDataType> list = new ArrayList<ExtraDataType>();
        list.add(new ExtraDataType(DQuantitationChannel.class, true));
        list.add(new ExtraDataType(DMasterQuantProteinSet.class, false));
        this.registerSingleValuesAsExtraTypes(list);
        return list;
    }

    public Object getValue(Class c) {
        if (c.equals(DMasterQuantProteinSet.class)) {
            return this.m_quantProtein;
        }
        return this.getSingleValue(c);
    }

    public Object getRowValue(Class c, int row) {
        if (c.equals(DQuantitationChannel.class)) {
            return this.m_quantChannels[row];
        }
        return null;
    }

    public Object getColValue(Class c, int col) {
        return null;
    }
}

