/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.xic;

import fr.proline.core.orm.msi.MasterQuantReporterIon;
import fr.proline.core.orm.msi.dto.DMasterQuantPeptideIon;
import fr.proline.core.orm.uds.dto.DDatasetType;
import fr.proline.core.orm.uds.dto.DQuantitationChannel;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.export.ExportButton;
import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.export.ExportModelInterface;
import fr.proline.studio.extendedtablemodel.AddDataAnalyzerButton;
import fr.proline.studio.extendedtablemodel.CompoundTableModel;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.GlobalTabelModelProviderInterface;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.FilterButton;
import fr.proline.studio.filter.FilterTableModelInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.gui.HourglassPanel;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.info.InfoInterface;
import fr.proline.studio.info.InfoToggleButton;
import fr.proline.studio.markerbar.MarkerComponentInterface;
import fr.proline.studio.markerbar.MarkerContainerPanel;
import fr.proline.studio.parameter.SettingsButton;
import fr.proline.studio.parameter.SettingsInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataAnalyzerWindowBoxManager;
import fr.proline.studio.pattern.DataBoxPanelInterface;
import fr.proline.studio.progress.ProgressInterface;
import fr.proline.studio.rsmexplorer.actions.table.DisplayTablePopupMenu;
import fr.proline.studio.rsmexplorer.gui.xic.QuantPepMatchReporterIonTableModel;
import fr.proline.studio.search.SearchToggleButton;
import fr.proline.studio.table.CustomColumnControlButton;
import fr.proline.studio.table.LazyTable;
import fr.proline.studio.table.TableInfo;
import fr.proline.studio.table.TablePopupMenu;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;

public class QuantPepMatchReporterIonPanel
extends HourglassPanel
implements DataBoxPanelInterface,
GlobalTabelModelProviderInterface {
    private AbstractDataBox m_dataBox;
    private JScrollPane m_reporterIonScrollPane;
    private QuantReporterIonTable m_quantReporterIonTable;
    private MarkerContainerPanel m_markerContainerPanel;
    private DQuantitationChannel[] m_quantChannels;
    private DDatasetType.QuantitationMethodInfo m_quantMethodInfo;
    private SettingsButton m_settingsButton;
    private FilterButton m_filterButton;
    private ExportButton m_exportButton;
    private AddDataAnalyzerButton m_addCompareDataButton;
    private InfoToggleButton m_infoToggleButton;
    private SearchToggleButton m_searchToggleButton;

    public QuantPepMatchReporterIonPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        final JPanel psmReporterIonPanel = this.createPepMatchReporterIonPanel();
        final JLayeredPane layeredPane = new JLayeredPane();
        layeredPane.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                Component c = e.getComponent();
                psmReporterIonPanel.setBounds(0, 0, c.getWidth(), c.getHeight());
                layeredPane.revalidate();
                layeredPane.repaint();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.add(layeredPane, "Center");
        layeredPane.add((Component)psmReporterIonPanel, JLayeredPane.DEFAULT_LAYER);
        layeredPane.add((Component)this.m_infoToggleButton.getInfoPanel(), JLayeredPane.PALETTE_LAYER);
        layeredPane.add((Component)this.m_searchToggleButton.getSearchPanel(), (Object)(JLayeredPane.PALETTE_LAYER + 1));
    }

    private JPanel createPepMatchReporterIonPanel() {
        JPanel pepMatchRepIonIonPanel = new JPanel();
        pepMatchRepIonIonPanel.setBounds(0, 0, 500, 400);
        pepMatchRepIonIonPanel.setLayout(new BorderLayout());
        JPanel internalPanel = this.createInternalPanel();
        JToolBar toolbar = this.initToolbar();
        pepMatchRepIonIonPanel.add((Component)toolbar, "West");
        pepMatchRepIonIonPanel.add((Component)internalPanel, "Center");
        return pepMatchRepIonIonPanel;
    }

    private JToolBar initToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        this.m_searchToggleButton = new SearchToggleButton((ProgressInterface)this.m_quantReporterIonTable, (JXTable)this.m_quantReporterIonTable, (FilterTableModelInterface)((CompoundTableModel)this.m_quantReporterIonTable.getModel()));
        toolbar.add((Component)this.m_searchToggleButton);
        this.m_settingsButton = new SettingsButton((ProgressInterface)this.m_quantReporterIonTable.getModel(), (SettingsInterface)this.m_quantReporterIonTable);
        this.m_filterButton = new FilterButton((FilterTableModelInterface)((CompoundTableModel)this.m_quantReporterIonTable.getModel())){

            protected void filteringDone() {
                QuantPepMatchReporterIonPanel.this.m_dataBox.addDataChanged(ExtendedTableModelInterface.class);
                QuantPepMatchReporterIonPanel.this.m_dataBox.propagateDataChanged();
                QuantPepMatchReporterIonPanel.this.m_infoToggleButton.updateInfo();
            }
        };
        this.m_exportButton = new ExportButton((ProgressInterface)((CompoundTableModel)this.m_quantReporterIonTable.getModel()), "Peptide Matches Reporter Ions", (JXTable)this.m_quantReporterIonTable);
        toolbar.add((Component)this.m_filterButton);
        toolbar.add((Component)this.m_settingsButton);
        toolbar.add((Component)this.m_exportButton);
        this.m_addCompareDataButton = new AddDataAnalyzerButton((ProgressInterface)((CompoundTableModel)this.m_quantReporterIonTable.getModel())){

            public void actionPerformed() {
                JXTable table = QuantPepMatchReporterIonPanel.this.getGlobalAssociatedTable();
                TableInfo tableInfo = new TableInfo(QuantPepMatchReporterIonPanel.this.m_dataBox.getId(), QuantPepMatchReporterIonPanel.this.m_dataBox.getUserName(), QuantPepMatchReporterIonPanel.this.m_dataBox.getDataName(), QuantPepMatchReporterIonPanel.this.m_dataBox.getTypeName(), table);
                Image i = QuantPepMatchReporterIonPanel.this.m_dataBox.getIcon();
                if (i != null) {
                    tableInfo.setIcon(new ImageIcon(i));
                }
                DataAnalyzerWindowBoxManager.addTableInfo(tableInfo);
            }
        };
        toolbar.add((Component)this.m_addCompareDataButton);
        this.m_infoToggleButton = new InfoToggleButton((ProgressInterface)this.m_quantReporterIonTable, (InfoInterface)this.m_quantReporterIonTable);
        toolbar.add((Component)this.m_infoToggleButton);
        return toolbar;
    }

    private JPanel createInternalPanel() {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        this.m_reporterIonScrollPane = new JScrollPane();
        this.m_quantReporterIonTable = new QuantReporterIonTable();
        this.m_quantReporterIonTable.setModel((TableModel)new CompoundTableModel((GlobalTableModelInterface)new QuantPepMatchReporterIonTableModel(this.m_quantReporterIonTable), true));
        CustomColumnControlButton customColumnControl = new CustomColumnControlButton((JXTable)this.m_quantReporterIonTable);
        this.m_quantReporterIonTable.setColumnControl((JComponent)customColumnControl);
        this.m_quantReporterIonTable.setSortable(false);
        this.m_markerContainerPanel = new MarkerContainerPanel(this.m_reporterIonScrollPane, (MarkerComponentInterface)this.m_quantReporterIonTable);
        this.m_reporterIonScrollPane.setViewportView((Component)((Object)this.m_quantReporterIonTable));
        this.m_quantReporterIonTable.setFillsViewportHeight(true);
        this.m_quantReporterIonTable.setViewport(this.m_reporterIonScrollPane.getViewport());
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 3;
        internalPanel.add((Component)this.m_markerContainerPanel, c);
        return internalPanel;
    }

    public void setData(Long taskId, DQuantitationChannel[] quantChannels, List<MasterQuantReporterIon> masterQuantRepIonsList, DDatasetType.QuantitationMethodInfo quantitationMethodInfo, boolean finished) {
        boolean qcChanged = true;
        if (this.m_quantChannels != null && this.m_quantChannels.length == quantChannels.length) {
            for (int q = 0; q < this.m_quantChannels.length; ++q) {
                qcChanged = !this.m_quantChannels[q].equals((Object)quantChannels[q]);
            }
        }
        this.m_quantChannels = quantChannels;
        this.m_quantMethodInfo = quantitationMethodInfo;
        ((QuantPepMatchReporterIonTableModel)((CompoundTableModel)this.m_quantReporterIonTable.getModel()).getBaseModel()).setData(taskId, quantChannels, masterQuantRepIonsList);
        if (masterQuantRepIonsList != null && masterQuantRepIonsList.size() > 0) {
            this.m_quantReporterIonTable.getSelectionModel().setSelectionInterval(0, 0);
            this.m_markerContainerPanel.setMaxLineNumber(masterQuantRepIonsList.size());
        }
        this.m_infoToggleButton.updateInfo();
        if (finished) {
            this.m_quantReporterIonTable.setSortable(true);
        }
        if (qcChanged) {
            this.setColumnsVisibility();
        }
    }

    public void dataUpdated(SubTask subTask, boolean finished) {
        this.m_quantReporterIonTable.dataUpdated(subTask, finished);
        if (finished) {
            this.m_quantReporterIonTable.setSortable(true);
        }
    }

    public void setColumnsVisibility() {
        List<Integer> listIdsToHide = ((QuantPepMatchReporterIonTableModel)((CompoundTableModel)this.m_quantReporterIonTable.getModel()).getBaseModel()).getDefaultColumnsToHide();
        List columns = this.m_quantReporterIonTable.getColumns(true);
        for (Integer id : listIdsToHide) {
            boolean columnVisible = ((TableColumnExt)columns.get(id)).isVisible();
            if (!columnVisible) continue;
            this.m_quantReporterIonTable.getColumnExt(this.m_quantReporterIonTable.convertColumnIndexToView(id)).setVisible(false);
        }
    }

    @Override
    public void setDataBox(AbstractDataBox dataBox) {
        this.m_dataBox = dataBox;
    }

    @Override
    public AbstractDataBox getDataBox() {
        return this.m_dataBox;
    }

    @Override
    public void addSingleValue(Object v) {
        this.getGlobalTableModelInterface().addSingleValue(v);
    }

    public GlobalTableModelInterface getGlobalTableModelInterface() {
        return (GlobalTableModelInterface)this.m_quantReporterIonTable.getModel();
    }

    public JXTable getGlobalAssociatedTable() {
        return this.m_quantReporterIonTable;
    }

    public ActionListener getRemoveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getRemoveAction(splittedPanel);
    }

    public ActionListener getAddAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getAddAction(splittedPanel);
    }

    public ActionListener getSaveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getSaveAction(splittedPanel);
    }

    public MasterQuantReporterIon getSelectedMasterQuantReporterIon() {
        return this.m_quantReporterIonTable.getSelectedMasterQuantReporterIon();
    }

    public CrossSelectionInterface getCrossSelectionInterface() {
        return this.m_quantReporterIonTable;
    }

    private class QuantReporterIonTable
    extends LazyTable
    implements ExportModelInterface,
    InfoInterface {
        private DisplayTablePopupMenu m_popupMenu;
        String searchTextBeingDone;
        private boolean selectionWillBeRestored;

        public QuantReporterIonTable() {
            super(QuantPepMatchReporterIonPanel.this.m_reporterIonScrollPane.getVerticalScrollBar());
            this.searchTextBeingDone = null;
            this.selectionWillBeRestored = false;
        }

        public void addTableModelListener(TableModelListener l) {
            this.getModel().addTableModelListener(l);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            super.valueChanged(e);
            if (this.selectionWillBeRestored) {
                return;
            }
            if (e.getValueIsAdjusting()) {
                return;
            }
            QuantPepMatchReporterIonPanel.this.m_dataBox.addDataChanged(DMasterQuantPeptideIon.class);
            QuantPepMatchReporterIonPanel.this.m_dataBox.propagateDataChanged();
        }

        public boolean selectPeptideMatchRepIon(Long peptideMatchRepIonId, String searchText) {
            QuantPepMatchReporterIonTableModel tableModel = (QuantPepMatchReporterIonTableModel)((CompoundTableModel)this.getModel()).getBaseModel();
            int row = tableModel.findRow(peptideMatchRepIonId);
            if (row == -1) {
                return false;
            }
            row = ((CompoundTableModel)this.getModel()).convertBaseModelRowToCompoundRow(row);
            if (row == -1) {
                return false;
            }
            this.searchTextBeingDone = searchText;
            row = this.convertRowIndexToView(row);
            this.getSelectionModel().setSelectionInterval(row, row);
            this.scrollRowToVisible(row);
            this.searchTextBeingDone = null;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dataUpdated(SubTask subTask, boolean finished) {
            LazyTable.LastAction keepLastAction = this.m_lastAction;
            try {
                int rowSelected = this.getSelectionModel().getMinSelectionIndex();
                int rowSelectedInModel = rowSelected == -1 ? -1 : this.convertRowIndexToModel(rowSelected);
                this.selectionWillBeRestored(true);
                try {
                    ((QuantPepMatchReporterIonTableModel)((CompoundTableModel)this.getModel()).getBaseModel()).dataUpdated();
                }
                finally {
                    this.selectionWillBeRestored(false);
                }
                if (rowSelectedInModel != -1) {
                    int rowSelectedInView = this.convertRowIndexToView(rowSelectedInModel);
                    this.setSelection(rowSelectedInView);
                    if ((keepLastAction == LazyTable.LastAction.ACTION_SELECTING || keepLastAction == LazyTable.LastAction.ACTION_SORTING) && subTask.getSubTaskId() == ((CompoundTableModel)this.getModel()).getSubTaskId(this.getSortedColumnIndex())) {
                        this.scrollRowToVisible(rowSelectedInView);
                    }
                }
            }
            finally {
                this.m_lastAction = keepLastAction;
            }
            if (finished) {
                this.setSortable(true);
            }
        }

        public void selectionWillBeRestored(boolean b) {
            this.selectionWillBeRestored = b;
        }

        public int getLoadingPercentage() {
            return QuantPepMatchReporterIonPanel.this.m_dataBox.getLoadingPercentage();
        }

        public boolean isLoaded() {
            return QuantPepMatchReporterIonPanel.this.m_dataBox.isLoaded();
        }

        public MasterQuantReporterIon getSelectedMasterQuantReporterIon() {
            int selectedRow = this.getSelectedRow();
            if (selectedRow == -1) {
                return null;
            }
            CompoundTableModel compoundTableModel = (CompoundTableModel)QuantPepMatchReporterIonPanel.this.m_quantReporterIonTable.getModel();
            if (compoundTableModel.getRowCount() == 0) {
                return null;
            }
            try {
                selectedRow = this.convertRowIndexToModel(selectedRow);
            }
            catch (Exception e) {
                m_loggerProline.debug("Exception catched as a wart : " + e.getMessage());
                return null;
            }
            selectedRow = compoundTableModel.convertCompoundRowToBaseModelRow(selectedRow);
            QuantPepMatchReporterIonTableModel tableModel = (QuantPepMatchReporterIonTableModel)compoundTableModel.getBaseModel();
            return tableModel.getPeptideMatchRepIon(selectedRow);
        }

        public String getExportColumnName(int col) {
            return ((CompoundTableModel)QuantPepMatchReporterIonPanel.this.m_quantReporterIonTable.getModel()).getExportColumnName(this.convertColumnIndexToModel(col));
        }

        public String getExportRowCell(int row, int col) {
            return ((CompoundTableModel)QuantPepMatchReporterIonPanel.this.m_quantReporterIonTable.getModel()).getExportRowCell(this.convertRowIndexToModel(row), this.convertColumnIndexToModel(col));
        }

        public ArrayList<ExportFontData> getExportFonts(int row, int col) {
            return ((CompoundTableModel)QuantPepMatchReporterIonPanel.this.m_quantReporterIonTable.getModel()).getExportFonts(this.convertRowIndexToModel(row), this.convertColumnIndexToModel(col));
        }

        public TablePopupMenu initPopupMenu() {
            this.m_popupMenu = new DisplayTablePopupMenu(QuantPepMatchReporterIonPanel.this);
            return this.m_popupMenu;
        }

        public void prepostPopupMenu() {
            this.m_popupMenu.prepostPopupMenu();
        }

        public String getInfo() {
            int count;
            return count + ((count = this.getModel().getRowCount()) > 1 ? " Peptides Ions" : " Peptide Ion");
        }
    }
}

