/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.xic;

import fr.proline.core.orm.msi.Peptide;
import fr.proline.core.orm.msi.PeptideReadablePtmString;
import fr.proline.core.orm.msi.dto.DMasterQuantPeptideIon;
import fr.proline.core.orm.msi.dto.DPeptideInstance;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DQuantPeptideIon;
import fr.proline.core.orm.uds.dto.DDatasetType;
import fr.proline.core.orm.uds.dto.DQuantitationChannel;
import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.extendedtablemodel.CompoundTableModel;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.ConvertValueInterface;
import fr.proline.studio.filter.DoubleFilter;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.filter.IntegerFilter;
import fr.proline.studio.filter.StringDiffFilter;
import fr.proline.studio.graphics.PlotInformation;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.rsmexplorer.gui.renderer.FloatRenderer;
import fr.proline.studio.rsmexplorer.gui.renderer.PeptideRenderer;
import fr.proline.studio.rsmexplorer.gui.renderer.ScoreRenderer;
import fr.proline.studio.rsmexplorer.gui.renderer.TimeRenderer;
import fr.proline.studio.rsmexplorer.gui.renderer.XicStatusRenderer;
import fr.proline.studio.table.LazyData;
import fr.proline.studio.table.LazyTable;
import fr.proline.studio.table.LazyTableModel;
import fr.proline.studio.table.TableDefaultRendererManager;
import fr.proline.studio.table.renderer.BigFloatOrDoubleRenderer;
import fr.proline.studio.table.renderer.DefaultAlignRenderer;
import fr.proline.studio.table.renderer.DoubleRenderer;
import fr.proline.studio.types.QuantitationType;
import fr.proline.studio.types.XicGroup;
import fr.proline.studio.utils.CyclicColorPalette;
import fr.proline.studio.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuantPeptideIonTableModel
extends LazyTableModel
implements GlobalTableModelInterface {
    private static final Logger m_logger = LoggerFactory.getLogger(QuantPeptideIonTableModel.class);
    public static final int COLTYPE_PEPTIDE_ID = 0;
    public static final int COLTYPE_PEPTIDE_ION_ID = 1;
    public static final int COLTYPE_PEPTIDE_ION_NAME = 2;
    public static final int COLTYPE_PEPTIDE_ION_STATUS = 3;
    public static final int COLTYPE_PEPTIDE_PTM = 4;
    public static final int COLTYPE_PEPTIDE_SCORE = 5;
    public static final int COLTYPE_PEPTIDE_ION_CHARGE = 6;
    public static final int COLTYPE_PEPTIDE_ION_MOZ = 7;
    public static final int COLTYPE_PEPTIDE_ION_RETENTION_TIME = 8;
    public static final int COLTYPE_PEPTIDE_PROTEIN_SET_COUNT = 9;
    public static final int COLTYPE_PEPTIDE_PROTEIN_SET_NAMES = 10;
    public static final int LAST_STATIC_COLUMN = 10;
    private static final String[] m_columnNames = new String[]{"Peptide Id", "QPeptideIon Id", "Peptide Sequence", "Status", "PTMs", "Score", "Charge", "m/z", "RT", "Protein Set Count", "Protein Sets"};
    private static final String[] m_columnNamesForFilter = new String[]{"Peptide Id", "QPeptideIon Id", "Peptide Sequence", "Status", "PTMs", "Score", "Charge", "m/z", "RT", "Protein Set Count", "Protein Sets"};
    private static final String[] m_toolTipColumns = new String[]{"Peptide Id", "MasterQuantPeptideIon Id", "Identified Peptide Sequence", "Peptide ion status: invalid, valid, valid and used for peptide abundance calculation, valid but not used for peptide abundance calculation.", "Post Translational Modifications", "Score", "Charge", "Mass to Charge Ratio", "Retention time (min)", "Protein Set Count", "Protein Sets"};
    public static final int COLTYPE_SELECTION_LEVEL = 0;
    public static final int COLTYPE_PSM = 1;
    public static final int COLTYPE_RAW_ABUNDANCE = 2;
    public static final int COLTYPE_ABUNDANCE = 3;
    private static final String[] m_columnNamesQC = new String[]{"Sel. level", "Pep. match count", "Raw abundance", "Abundance"};
    private static final String[] m_toolTipQC = new String[]{"Selection level", "Peptides match count", "Raw abundance", "Abundance"};
    private static final String[] m_columnNamesQC_SC = new String[]{"Sel. level", "Basic SC", "Specific SC", "Abundance"};
    private static final String[] m_toolTipQC_SC = new String[]{"Selection level", "Basic Spectral Count", "Specific Spectral Count", "Abundance"};
    private List<DMasterQuantPeptideIon> m_quantPeptideIons = null;
    private DQuantitationChannel[] m_quantChannels = null;
    private int m_quantChannelNumber;
    private DDatasetType.QuantitationMethodInfo m_quantitationMethodInfo;
    private final ScoreRenderer m_scoreRenderer = new ScoreRenderer();
    private String m_modelName;
    private final StringBuilder m_sb = new StringBuilder();
    private final HashMap<Integer, TableCellRenderer> m_rendererMap = new HashMap();

    public QuantPeptideIonTableModel(LazyTable table, DDatasetType.QuantitationMethodInfo quantitationMethodInfo) {
        super(table);
        this.m_quantitationMethodInfo = quantitationMethodInfo;
    }

    private boolean isSpectralCountQuant() {
        return this.m_quantitationMethodInfo.equals((Object)DDatasetType.QuantitationMethodInfo.SPECTRAL_COUNTING);
    }

    public int getColumnCount() {
        if (this.m_quantChannels == null) {
            return m_columnNames.length;
        }
        return m_columnNames.length + this.m_quantChannelNumber * m_columnNamesQC.length;
    }

    public String getColumnName(int col) {
        if (col <= 10) {
            return m_columnNames[col];
        }
        if (this.m_quantChannels != null) {
            int nbQc = (col - m_columnNames.length) / m_columnNamesQC.length;
            int id = col - m_columnNames.length - nbQc * m_columnNamesQC.length;
            StringBuilder sb = new StringBuilder();
            String rsmHtmlColor = CyclicColorPalette.getHTMLColor((int)nbQc);
            sb.append("<html><font color='").append(rsmHtmlColor).append("'>&#x25A0;&nbsp;</font>");
            if (this.isSpectralCountQuant()) {
                sb.append(m_columnNamesQC_SC[id]);
            } else {
                sb.append(m_columnNamesQC[id]);
            }
            sb.append("<br/>");
            sb.append(this.m_quantChannels[nbQc].getName());
            sb.append("</html>");
            return sb.toString();
        }
        return "";
    }

    public String getExportColumnName(int col) {
        if (col <= 10) {
            return m_columnNamesForFilter[col];
        }
        if (this.m_quantChannels != null) {
            int nbQc = (col - m_columnNames.length) / m_columnNamesQC.length;
            int id = col - m_columnNames.length - nbQc * m_columnNamesQC.length;
            StringBuilder sb = new StringBuilder();
            if (this.isSpectralCountQuant()) {
                sb.append(m_columnNamesQC_SC[id]);
            } else {
                sb.append(m_columnNamesQC[id]);
            }
            sb.append(" ");
            sb.append(this.m_quantChannels[nbQc].getName());
            return sb.toString();
        }
        return "";
    }

    public String getColumnNameForFilter(int col) {
        if (col <= 10) {
            return m_columnNamesForFilter[col];
        }
        if (this.m_quantChannels != null) {
            int nbQc = (col - m_columnNames.length) / m_columnNamesQC.length;
            int id = col - m_columnNames.length - nbQc * m_columnNamesQC.length;
            return this.isSpectralCountQuant() ? m_columnNamesQC_SC[id] : m_columnNamesQC[id];
        }
        return "";
    }

    public String getToolTipForHeader(int col) {
        if (col <= 10) {
            return m_toolTipColumns[col];
        }
        if (this.m_quantChannels != null) {
            int nbQc = (col - m_columnNames.length) / m_columnNamesQC.length;
            int id = col - m_columnNames.length - nbQc * m_columnNamesQC.length;
            String rawFilePath = StringUtils.truncate((String)this.m_quantChannels[nbQc].getRawFilePath(), (int)50);
            StringBuilder sb = new StringBuilder();
            String rsmHtmlColor = CyclicColorPalette.getHTMLColor((int)nbQc);
            sb.append("<html><font color='").append(rsmHtmlColor).append("'>&#x25A0;&nbsp;</font>");
            if (this.isSpectralCountQuant()) {
                sb.append(m_toolTipQC_SC[id]);
            } else {
                sb.append(m_toolTipQC[id]);
            }
            sb.append("<br/>");
            sb.append(this.m_quantChannels[nbQc].getFullName());
            sb.append("<br/>");
            sb.append(rawFilePath);
            sb.append("</html>");
            return sb.toString();
        }
        return "";
    }

    public String getTootlTipValue(int row, int col) {
        return null;
    }

    public Class getColumnClass(int col) {
        if (col == 1) {
            return Long.class;
        }
        if (col == 3) {
            return DMasterQuantPeptideIon.PepIonStatus.class;
        }
        return LazyData.class;
    }

    @Override
    public int getSubTaskId(int col) {
        return 0;
    }

    public int getRowCount() {
        if (this.m_quantPeptideIons == null) {
            return 0;
        }
        return this.m_quantPeptideIons.size();
    }

    public Object getValueAt(int row, int col) {
        DMasterQuantPeptideIon peptideIon = this.m_quantPeptideIons.get(row);
        switch (col) {
            case 1: {
                return peptideIon.getId();
            }
            case 0: {
                LazyData lazyData = this.getLazyData(row, col);
                if (peptideIon.getResultSummary() == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else if (peptideIon.getPeptideInstance() == null) {
                    lazyData.setData(null);
                } else {
                    lazyData.setData((Comparable)Long.valueOf(peptideIon.getPeptideInstance().getPeptideId()));
                }
                return lazyData;
            }
            case 2: {
                LazyData lazyData = this.getLazyData(row, col);
                if (peptideIon.getResultSummary() == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else if (peptideIon.getPeptideInstance() == null) {
                    lazyData.setData(null);
                } else {
                    lazyData.setData((Comparable)peptideIon.getPeptideInstance().getPeptide());
                }
                return lazyData;
            }
            case 3: {
                return peptideIon.getPepIonStatus();
            }
            case 4: {
                LazyData lazyData = this.getLazyData(row, col);
                DPeptideInstance peptideInstance = peptideIon.getPeptideInstance();
                if (peptideIon.getResultSummary() == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else if (peptideInstance == null) {
                    lazyData.setData((Comparable)((Object)""));
                } else if (peptideInstance.getBestPeptideMatch() != null) {
                    boolean ptmStringLoaded = peptideInstance.getBestPeptideMatch().getPeptide().getTransientData().isPeptideReadablePtmStringLoaded();
                    if (!ptmStringLoaded) {
                        lazyData.setData(null);
                    } else {
                        String ptm = "";
                        PeptideReadablePtmString ptmString = peptideInstance.getBestPeptideMatch().getPeptide().getTransientData().getPeptideReadablePtmString();
                        if (ptmString != null) {
                            ptm = ptmString.getReadablePtmString();
                        }
                        lazyData.setData((Comparable)((Object)ptm));
                    }
                } else {
                    lazyData.setData((Comparable)((Object)""));
                }
                return lazyData;
            }
            case 5: {
                LazyData lazyData = this.getLazyData(row, col);
                DPeptideMatch peptideMatch = peptideIon.getBestPeptideMatch();
                if (peptideMatch == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else {
                    Float score = Float.valueOf(peptideMatch.getScore().floatValue());
                    lazyData.setData((Comparable)score);
                }
                return lazyData;
            }
            case 9: {
                LazyData lazyData = this.getLazyData(row, col);
                DPeptideInstance peptideInstance = peptideIon.getPeptideInstance();
                if (peptideInstance == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else {
                    lazyData.setData((Comparable)Integer.valueOf(peptideInstance.getValidatedProteinSetCount()));
                }
                return lazyData;
            }
            case 10: {
                LazyData lazyData = this.getLazyData(row, col);
                DPeptideInstance peptideInstance = peptideIon.getPeptideInstance();
                if (peptideInstance == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else {
                    DPeptideMatch peptideMatch = peptideInstance.getBestPeptideMatch();
                    String[] proteinSetNames = peptideMatch.getProteinSetStringArray();
                    if (proteinSetNames == null) {
                        this.givePriorityTo(this.m_taskId, row, col);
                        lazyData.setData(null);
                    } else {
                        for (int i = 0; i < proteinSetNames.length; ++i) {
                            String name = proteinSetNames[i];
                            if (i < proteinSetNames.length - 1) {
                                this.m_sb.append(name).append(", ");
                                continue;
                            }
                            this.m_sb.append(name);
                        }
                        lazyData.setData((Comparable)((Object)this.m_sb.toString()));
                        this.m_sb.setLength(0);
                    }
                }
                return lazyData;
            }
            case 6: {
                LazyData lazyData = this.getLazyData(row, col);
                if (peptideIon.getResultSummary() == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else {
                    lazyData.setData((Comparable)Integer.valueOf(peptideIon.getCharge()));
                }
                return lazyData;
            }
            case 7: {
                LazyData lazyData = this.getLazyData(row, col);
                if (peptideIon.getResultSummary() == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else {
                    lazyData.setData((Comparable)Double.valueOf(peptideIon.getMoz()));
                }
                return lazyData;
            }
            case 8: {
                LazyData lazyData = this.getLazyData(row, col);
                if (peptideIon.getResultSummary() == null) {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                } else {
                    lazyData.setData((Comparable)Float.valueOf(peptideIon.getElutionTime()));
                }
                return lazyData;
            }
        }
        LazyData lazyData = this.getLazyData(row, col);
        if (peptideIon.getResultSummary() == null) {
            lazyData.setData(null);
            this.givePriorityTo(this.m_taskId, row, col);
        } else {
            int nbQc = (col - m_columnNames.length) / m_columnNamesQC.length;
            int id = col - m_columnNames.length - nbQc * m_columnNamesQC.length;
            Map quantPeptideIonByQchIds = peptideIon.getQuantPeptideIonByQchIds();
            if (quantPeptideIonByQchIds == null) {
                switch (id) {
                    case 0: {
                        lazyData.setData((Comparable)Integer.valueOf(0));
                        break;
                    }
                    case 3: {
                        lazyData.setData((Comparable)Float.valueOf(0.0f));
                        break;
                    }
                    case 2: {
                        lazyData.setData((Comparable)Float.valueOf(0.0f));
                        break;
                    }
                    case 1: {
                        lazyData.setData((Comparable)Integer.valueOf(0));
                    }
                }
            } else {
                DQuantPeptideIon quantPeptideIon = (DQuantPeptideIon)quantPeptideIonByQchIds.get(this.m_quantChannels[nbQc].getId());
                if (quantPeptideIon == null) {
                    switch (id) {
                        case 0: {
                            lazyData.setData((Comparable)Integer.valueOf(0));
                            break;
                        }
                        case 3: {
                            lazyData.setData((Comparable)Float.valueOf(0.0f));
                            break;
                        }
                        case 2: {
                            lazyData.setData((Comparable)Float.valueOf(0.0f));
                            break;
                        }
                        case 1: {
                            lazyData.setData((Comparable)Integer.valueOf(0));
                        }
                    }
                } else {
                    switch (id) {
                        case 0: {
                            lazyData.setData((Comparable)quantPeptideIon.getSelectionLevel());
                            break;
                        }
                        case 3: {
                            lazyData.setData((Comparable)(quantPeptideIon.getAbundance().isNaN() ? Float.valueOf(0.0f) : quantPeptideIon.getAbundance()));
                            break;
                        }
                        case 2: {
                            lazyData.setData((Comparable)(quantPeptideIon.getRawAbundance().isNaN() ? Float.valueOf(0.0f) : quantPeptideIon.getRawAbundance()));
                            break;
                        }
                        case 1: {
                            lazyData.setData((Comparable)(quantPeptideIon.getPeptideMatchesCount() == null ? Integer.valueOf(0) : quantPeptideIon.getPeptideMatchesCount()));
                        }
                    }
                }
            }
        }
        return lazyData;
    }

    public void setData(Long taskId, DQuantitationChannel[] quantChannels, List<DMasterQuantPeptideIon> peptideIons, DDatasetType.QuantitationMethodInfo quantMethodInfo) {
        boolean structureChanged = true;
        this.m_quantitationMethodInfo = quantMethodInfo;
        if (this.m_quantChannels != null && this.m_quantChannels.length == quantChannels.length) {
            for (int i = 0; i < this.m_quantChannels.length; ++i) {
                structureChanged = !this.m_quantChannels[i].equals((Object)quantChannels[i]);
            }
        }
        this.m_quantPeptideIons = peptideIons;
        this.m_quantChannels = quantChannels;
        this.m_quantChannelNumber = quantChannels.length;
        if (structureChanged) {
            this.fireTableStructureChanged();
        }
        this.m_taskId = taskId;
        this.fireTableDataChanged();
    }

    public void dataUpdated() {
        this.fireTableDataChanged();
    }

    public DMasterQuantPeptideIon getPeptideIon(int i) {
        return this.m_quantPeptideIons.get(i);
    }

    public int findRow(long peptideId) {
        int nb = this.m_quantPeptideIons.size();
        for (int i = 0; i < nb; ++i) {
            if (peptideId != this.m_quantPeptideIons.get(i).getId()) continue;
            return i;
        }
        return -1;
    }

    public void sortAccordingToModel(ArrayList<Long> peptideIds, CompoundTableModel compoundTableModel) {
        if (this.m_quantPeptideIons == null) {
            return;
        }
        HashSet<Long> peptideIdMap = new HashSet<Long>(peptideIds.size());
        peptideIdMap.addAll(peptideIds);
        int nb = this.m_table.getRowCount();
        int iCur = 0;
        for (int iView = 0; iView < nb; ++iView) {
            DMasterQuantPeptideIon p;
            int iModel = this.m_table.convertRowIndexToModel(iView);
            if (compoundTableModel != null) {
                iModel = compoundTableModel.convertCompoundRowToBaseModelRow(iModel);
            }
            if (!peptideIdMap.contains((p = this.getPeptideIon(iModel)).getId())) continue;
            peptideIds.set(iCur++, p.getId());
        }
    }

    public void addFilters(LinkedHashMap<Integer, Filter> filtersMap) {
        ConvertValueInterface peptideConverter = new ConvertValueInterface(){

            public Object convertValue(Object o) {
                if (o == null) {
                    return null;
                }
                return ((Peptide)o).getSequence();
            }
        };
        filtersMap.put(2, (Filter)new StringDiffFilter(this.getColumnNameForFilter(2), peptideConverter, 2));
        filtersMap.put(4, (Filter)new StringDiffFilter(this.getColumnName(4), null, 4));
        filtersMap.put(5, (Filter)new DoubleFilter(this.getColumnName(5), null, 5));
        filtersMap.put(6, (Filter)new IntegerFilter(this.getColumnNameForFilter(6), null, 6));
        filtersMap.put(7, (Filter)new DoubleFilter(this.getColumnNameForFilter(7), null, 7));
        filtersMap.put(9, (Filter)new IntegerFilter(this.getColumnName(9), null, 9));
        filtersMap.put(10, (Filter)new StringDiffFilter(this.getColumnName(10), null, 10));
        ConvertValueInterface minuteConverter = new ConvertValueInterface(){

            public Object convertValue(Object o) {
                if (o == null) {
                    return null;
                }
                return (double)((Float)o).floatValue() / 60.0;
            }
        };
        filtersMap.put(8, (Filter)new DoubleFilter(this.getColumnNameForFilter(8), minuteConverter, 8));
        int nbCol = this.getColumnCount();
        block6: for (int i = 11; i < nbCol; ++i) {
            int nbQc = (i - m_columnNames.length) / m_columnNamesQC.length;
            int id = i - m_columnNames.length - nbQc * m_columnNamesQC.length;
            switch (id) {
                case 0: {
                    filtersMap.put(i, (Filter)new IntegerFilter(this.getColumnName(i), null, i));
                    continue block6;
                }
                case 3: {
                    filtersMap.put(i, (Filter)new DoubleFilter(this.getColumnName(i), null, i));
                    continue block6;
                }
                case 2: {
                    filtersMap.put(i, (Filter)new DoubleFilter(this.getColumnName(i), null, i));
                    continue block6;
                }
                case 1: {
                    filtersMap.put(i, (Filter)new IntegerFilter(this.getColumnName(i), null, i));
                    continue block6;
                }
                default: {
                    filtersMap.put(i, (Filter)new DoubleFilter(this.getColumnName(i), null, i));
                }
            }
        }
    }

    public int getLoadingPercentage() {
        return this.m_table.getLoadingPercentage();
    }

    public boolean isLoaded() {
        return this.m_table.isLoaded();
    }

    public Long getResultSummaryId() {
        if (this.m_quantPeptideIons == null || this.m_quantPeptideIons.size() == 0) {
            return null;
        }
        return this.m_quantPeptideIons.get(0).getResultSummary().getId();
    }

    public List<Integer> getDefaultColumnsToHide() {
        ArrayList<Integer> listIds = new ArrayList<Integer>();
        listIds.add(0);
        listIds.add(1);
        if (this.m_quantChannels != null) {
            for (int i = this.m_quantChannels.length - 1; i >= 0; --i) {
                if (!this.isSpectralCountQuant()) {
                    listIds.add(m_columnNames.length + 2 + i * m_columnNamesQC.length);
                }
                listIds.add(m_columnNames.length + 0 + i * m_columnNamesQC.length);
            }
        }
        return listIds;
    }

    public String getExportRowCell(int row, int col) {
        int rowFiltered = row;
        DMasterQuantPeptideIon peptideIon = this.m_quantPeptideIons.get(rowFiltered);
        switch (col) {
            case 1: {
                return String.valueOf(peptideIon.getId());
            }
            case 0: {
                if (peptideIon.getResultSummary() == null) {
                    return "";
                }
                if (peptideIon.getPeptideInstance() == null) {
                    return "";
                }
                return String.valueOf(peptideIon.getPeptideInstance().getPeptideId());
            }
            case 2: {
                if (peptideIon.getResultSummary() == null) {
                    return "";
                }
                if (peptideIon.getPeptideInstance() == null) {
                    return "";
                }
                return peptideIon.getPeptideInstance().getPeptide().getSequence();
            }
            case 3: {
                return XicStatusRenderer.getPepIonStatusText(peptideIon.getPepIonStatus());
            }
            case 4: {
                DPeptideInstance peptideInstance = peptideIon.getPeptideInstance();
                if (peptideInstance == null) {
                    return "";
                }
                if (peptideInstance.getPeptide() != null) {
                    boolean ptmStringLoadeed = peptideInstance.getPeptide().getTransientData().isPeptideReadablePtmStringLoaded();
                    if (!ptmStringLoadeed) {
                        return null;
                    }
                    String ptm = "";
                    PeptideReadablePtmString ptmString = peptideInstance.getPeptide().getTransientData().getPeptideReadablePtmString();
                    if (ptmString != null) {
                        ptm = ptmString.getReadablePtmString();
                    }
                    return ptm;
                }
                return "";
            }
            case 5: {
                DPeptideMatch peptideMatch = peptideIon.getBestPeptideMatch();
                if (peptideMatch == null) {
                    return "";
                }
                float score = peptideMatch.getScore().floatValue();
                return String.valueOf(score);
            }
            case 9: {
                DPeptideInstance peptideInstance = peptideIon.getPeptideInstance();
                if (peptideInstance == null) {
                    return "";
                }
                return String.valueOf(peptideInstance.getValidatedProteinSetCount());
            }
            case 10: {
                DPeptideInstance peptideInstance = peptideIon.getPeptideInstance();
                if (peptideInstance == null) {
                    return "";
                }
                DPeptideMatch peptideMatch = peptideInstance.getBestPeptideMatch();
                String[] proteinSetNames = peptideMatch.getProteinSetStringArray();
                if (proteinSetNames == null) {
                    return "";
                }
                for (int i = 0; i < proteinSetNames.length; ++i) {
                    String name = proteinSetNames[i];
                    if (i < proteinSetNames.length - 1) {
                        this.m_sb.append(name).append(", ");
                        continue;
                    }
                    this.m_sb.append(name);
                }
                String t = this.m_sb.toString();
                this.m_sb.setLength(0);
                return t;
            }
            case 6: {
                if (peptideIon.getResultSummary() == null) {
                    return "";
                }
                return String.valueOf(peptideIon.getCharge());
            }
            case 7: {
                if (peptideIon.getResultSummary() == null) {
                    return "";
                }
                return String.valueOf(peptideIon.getMoz());
            }
            case 8: {
                if (peptideIon.getResultSummary() == null) {
                    return "";
                }
                return StringUtils.getTimeInMinutes((float)peptideIon.getElutionTime(), (int)2);
            }
        }
        int nbQc = (col - m_columnNames.length) / m_columnNamesQC.length;
        int id = col - m_columnNames.length - nbQc * m_columnNamesQC.length;
        if (peptideIon.getResultSummary() == null) {
            switch (id) {
                case 0: {
                    return Integer.toString(0);
                }
                case 3: {
                    return Float.toString(0.0f);
                }
                case 2: {
                    Float.toString(0.0f);
                }
                case 1: {
                    return Integer.toString(0);
                }
            }
        } else {
            Map quantPeptideIonByQchIds = peptideIon.getQuantPeptideIonByQchIds();
            if (quantPeptideIonByQchIds == null) {
                switch (id) {
                    case 0: {
                        return Integer.toString(0);
                    }
                    case 3: {
                        return Float.toString(0.0f);
                    }
                    case 2: {
                        Float.toString(0.0f);
                    }
                    case 1: {
                        return Integer.toString(0);
                    }
                }
            } else {
                DQuantPeptideIon quantPeptideIon = (DQuantPeptideIon)quantPeptideIonByQchIds.get(this.m_quantChannels[nbQc].getId());
                if (quantPeptideIon == null) {
                    switch (id) {
                        case 0: {
                            return Integer.toString(0);
                        }
                        case 3: {
                            return Float.toString(0.0f);
                        }
                        case 2: {
                            Float.toString(0.0f);
                        }
                        case 1: {
                            return Integer.toString(0);
                        }
                    }
                } else {
                    switch (id) {
                        case 0: {
                            return quantPeptideIon.getSelectionLevel() == null ? Integer.toString(0) : Integer.toString(quantPeptideIon.getSelectionLevel());
                        }
                        case 3: {
                            return quantPeptideIon.getAbundance() == null || quantPeptideIon.getAbundance().isNaN() ? Float.toString(0.0f) : Float.toString(quantPeptideIon.getAbundance().floatValue());
                        }
                        case 2: {
                            return quantPeptideIon.getRawAbundance() == null || quantPeptideIon.getRawAbundance().isNaN() ? Float.toString(0.0f) : Float.toString(quantPeptideIon.getRawAbundance().floatValue());
                        }
                        case 1: {
                            return quantPeptideIon.getPeptideMatchesCount() == null ? Integer.toString(0) : Integer.toString(quantPeptideIon.getPeptideMatchesCount());
                        }
                    }
                }
            }
        }
        return "";
    }

    public ArrayList<ExportFontData> getExportFonts(int row, int col) {
        return null;
    }

    public String getDataColumnIdentifier(int col) {
        if (col <= 10) {
            return m_columnNamesForFilter[col];
        }
        int nbQc = (col - m_columnNames.length) / m_columnNamesQC.length;
        int id = col - m_columnNames.length - nbQc * m_columnNamesQC.length;
        StringBuilder sb = new StringBuilder();
        if (this.isSpectralCountQuant()) {
            sb.append(m_columnNamesQC_SC[id]);
        } else {
            sb.append(m_columnNamesQC[id]);
        }
        sb.append(' ');
        sb.append(this.m_quantChannels[nbQc].getName());
        return sb.toString();
    }

    public Class getDataColumnClass(int col) {
        switch (col) {
            case 0: 
            case 1: {
                return Long.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
            case 5: {
                return Float.class;
            }
            case 4: 
            case 10: {
                return String.class;
            }
            case 6: 
            case 9: {
                return Integer.class;
            }
            case 7: {
                return Double.class;
            }
            case 8: {
                return Float.class;
            }
        }
        int nbQc = (col - m_columnNames.length) / m_columnNamesQC.length;
        int id = col - m_columnNames.length - nbQc * m_columnNamesQC.length;
        switch (id) {
            case 0: {
                return Integer.class;
            }
            case 3: {
                return Float.class;
            }
            case 2: {
                return Float.class;
            }
            case 1: {
                return Integer.class;
            }
        }
        return null;
    }

    public Object getDataValueAt(int rowIndex, int columnIndex) {
        Object data = this.getValueAt(rowIndex, columnIndex);
        if (columnIndex == 3) {
            return ((DMasterQuantPeptideIon.PepIonStatus)data).name();
        }
        if (data instanceof LazyData) {
            data = ((LazyData)data).getData();
        }
        if (data instanceof Peptide) {
            data = ((Peptide)data).getSequence();
        }
        return data;
    }

    public int[] getKeysColumn() {
        int[] keys = new int[]{2, 1};
        return keys;
    }

    public int getInfoColumn() {
        return 2;
    }

    public void setName(String name) {
        this.m_modelName = name;
    }

    public String getName() {
        return this.m_modelName;
    }

    public Map<String, Object> getExternalData() {
        return null;
    }

    public PlotInformation getPlotInformation() {
        return null;
    }

    public PlotType getBestPlotType() {
        return null;
    }

    public int[] getBestColIndex(PlotType plotType) {
        return null;
    }

    public TableCellRenderer getRenderer(int row, int col) {
        if (this.m_rendererMap.containsKey(col)) {
            return this.m_rendererMap.get(col);
        }
        TableCellRenderer renderer = null;
        block0 : switch (col) {
            case 3: {
                renderer = new XicStatusRenderer(null, 3);
                break;
            }
            case 2: {
                renderer = new PeptideRenderer();
                break;
            }
            case 4: {
                renderer = new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 2);
                break;
            }
            case 6: {
                renderer = new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(Integer.class), 4);
                break;
            }
            case 7: {
                renderer = new DoubleRenderer((TableCellRenderer)new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 4), 4);
                break;
            }
            case 8: {
                renderer = new TimeRenderer((TableCellRenderer)new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 4));
                break;
            }
            case 5: {
                renderer = this.m_scoreRenderer;
                break;
            }
            case 9: {
                renderer = new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(Integer.class), 4);
                break;
            }
            default: {
                int nbQc = (col - m_columnNames.length) / m_columnNamesQC.length;
                int id = col - m_columnNames.length - nbQc * m_columnNamesQC.length;
                switch (id) {
                    case 0: 
                    case 1: {
                        renderer = new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(Integer.class), 4);
                        break block0;
                    }
                    case 3: {
                        if (this.isSpectralCountQuant()) {
                            renderer = new FloatRenderer((TableCellRenderer)new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 4), 2);
                            break block0;
                        }
                        renderer = new BigFloatOrDoubleRenderer((TableCellRenderer)new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 4), 0);
                        break block0;
                    }
                    case 2: {
                        renderer = this.isSpectralCountQuant() ? new FloatRenderer((TableCellRenderer)new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 4), 0) : new BigFloatOrDoubleRenderer((TableCellRenderer)new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 4), 0);
                    }
                }
            }
        }
        this.m_rendererMap.put(col, renderer);
        return renderer;
    }

    public GlobalTableModelInterface getFrozzenModel() {
        return this;
    }

    public ArrayList<ExtraDataType> getExtraDataTypes() {
        ArrayList<ExtraDataType> list = new ArrayList<ExtraDataType>();
        list.add(new ExtraDataType(DMasterQuantPeptideIon.class, true));
        this.registerSingleValuesAsExtraTypes(list);
        return list;
    }

    public Object getValue(Class c) {
        return this.getSingleValue(c);
    }

    public Object getRowValue(Class c, int row) {
        if (c.equals(DMasterQuantPeptideIon.class)) {
            return this.m_quantPeptideIons.get(row);
        }
        return null;
    }

    public Object getColValue(Class c, int col) {
        if (c.equals(XicGroup.class)) {
            if (col <= 10) {
                return null;
            }
            int nbQc = (col - m_columnNames.length) / m_columnNamesQC.length;
            return new XicGroup(this.m_quantChannels[nbQc].getBiologicalGroupId(), null);
        }
        if (c.equals(QuantitationType.class)) {
            if (col <= 10) {
                return null;
            }
            int nbQc = (col - m_columnNames.length) / m_columnNamesQC.length;
            int id = col - m_columnNames.length - nbQc * m_columnNamesQC.length;
            if (this.isSpectralCountQuant()) {
                switch (id) {
                    case 1: {
                        return QuantitationType.getQuantitationType((int)2);
                    }
                    case 2: {
                        return QuantitationType.getQuantitationType((int)3);
                    }
                    case 3: {
                        return QuantitationType.getQuantitationType((int)4);
                    }
                }
            } else {
                switch (id) {
                    case 3: {
                        return QuantitationType.getQuantitationType((int)0);
                    }
                    case 2: {
                        return QuantitationType.getQuantitationType((int)1);
                    }
                }
            }
            return null;
        }
        return null;
    }
}

