/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.xic;

import fr.proline.core.orm.msi.dto.DMasterQuantPeptideIon;
import fr.proline.core.orm.uds.dto.DDatasetType;
import fr.proline.core.orm.uds.dto.DQuantitationChannel;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.export.ExportButton;
import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.export.ExportModelInterface;
import fr.proline.studio.extendedtablemodel.AddDataAnalyzerButton;
import fr.proline.studio.extendedtablemodel.CompoundTableModel;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.GlobalTabelModelProviderInterface;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.FilterButton;
import fr.proline.studio.filter.FilterTableModelInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.gui.HourglassPanel;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.info.InfoInterface;
import fr.proline.studio.info.InfoToggleButton;
import fr.proline.studio.markerbar.MarkerComponentInterface;
import fr.proline.studio.markerbar.MarkerContainerPanel;
import fr.proline.studio.parameter.SettingsButton;
import fr.proline.studio.parameter.SettingsInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataAnalyzerWindowBoxManager;
import fr.proline.studio.pattern.DataBoxPanelInterface;
import fr.proline.studio.progress.ProgressInterface;
import fr.proline.studio.rsmexplorer.actions.table.DisplayTablePopupMenu;
import fr.proline.studio.rsmexplorer.gui.xic.QuantPeptideIonTableModel;
import fr.proline.studio.search.SearchToggleButton;
import fr.proline.studio.table.CustomColumnControlButton;
import fr.proline.studio.table.LazyTable;
import fr.proline.studio.table.TableInfo;
import fr.proline.studio.table.TablePopupMenu;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;

public class XicPeptideIonPanel
extends HourglassPanel
implements DataBoxPanelInterface,
GlobalTabelModelProviderInterface {
    private AbstractDataBox m_dataBox;
    private JScrollPane m_peptideIonScrollPane;
    private QuantPeptideIonTable m_quantPeptideIonTable;
    private MarkerContainerPanel m_markerContainerPanel;
    private DQuantitationChannel[] m_quantChannels;
    private DDatasetType.QuantitationMethodInfo m_quantMethodInfo;
    private SettingsButton m_settingsButton;
    private FilterButton m_filterButton;
    private ExportButton m_exportButton;
    private AddDataAnalyzerButton m_addCompareDataButton;
    private InfoToggleButton m_infoToggleButton;
    private SearchToggleButton m_searchToggleButton;
    private boolean m_isAllPeptideIon = false;

    public void setIsAllPeptideIon(boolean isAllPeptideIon) {
        this.m_isAllPeptideIon = isAllPeptideIon;
    }

    public XicPeptideIonPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        final JPanel peptideIonPanel = this.createPeptideIonPanel();
        final JLayeredPane layeredPane = new JLayeredPane();
        layeredPane.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                Component c = e.getComponent();
                peptideIonPanel.setBounds(0, 0, c.getWidth(), c.getHeight());
                layeredPane.revalidate();
                layeredPane.repaint();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.add(layeredPane, "Center");
        layeredPane.add((Component)peptideIonPanel, JLayeredPane.DEFAULT_LAYER);
        layeredPane.add((Component)this.m_infoToggleButton.getInfoPanel(), JLayeredPane.PALETTE_LAYER);
        layeredPane.add((Component)this.m_searchToggleButton.getSearchPanel(), (Object)(JLayeredPane.PALETTE_LAYER + 1));
    }

    private JPanel createPeptideIonPanel() {
        JPanel peptideIonPanel = new JPanel();
        peptideIonPanel.setBounds(0, 0, 500, 400);
        peptideIonPanel.setLayout(new BorderLayout());
        JPanel internalPanel = this.createInternalPanel();
        JToolBar toolbar = this.initToolbar();
        peptideIonPanel.add((Component)toolbar, "West");
        peptideIonPanel.add((Component)internalPanel, "Center");
        return peptideIonPanel;
    }

    private JToolBar initToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        this.m_searchToggleButton = new SearchToggleButton((ProgressInterface)this.m_quantPeptideIonTable, (JXTable)this.m_quantPeptideIonTable, (FilterTableModelInterface)((CompoundTableModel)this.m_quantPeptideIonTable.getModel()));
        toolbar.add((Component)this.m_searchToggleButton);
        this.m_settingsButton = new SettingsButton((ProgressInterface)this.m_quantPeptideIonTable.getModel(), (SettingsInterface)this.m_quantPeptideIonTable);
        this.m_filterButton = new FilterButton((FilterTableModelInterface)((CompoundTableModel)this.m_quantPeptideIonTable.getModel())){

            protected void filteringDone() {
                XicPeptideIonPanel.this.m_dataBox.addDataChanged(ExtendedTableModelInterface.class);
                XicPeptideIonPanel.this.m_dataBox.propagateDataChanged();
                XicPeptideIonPanel.this.m_infoToggleButton.updateInfo();
            }
        };
        this.m_exportButton = new ExportButton((ProgressInterface)((CompoundTableModel)this.m_quantPeptideIonTable.getModel()), "Peptides Ions", (JXTable)this.m_quantPeptideIonTable);
        toolbar.add((Component)this.m_filterButton);
        toolbar.add((Component)this.m_settingsButton);
        toolbar.add((Component)this.m_exportButton);
        this.m_addCompareDataButton = new AddDataAnalyzerButton((ProgressInterface)((CompoundTableModel)this.m_quantPeptideIonTable.getModel())){

            public void actionPerformed() {
                JXTable table = XicPeptideIonPanel.this.getGlobalAssociatedTable();
                TableInfo tableInfo = new TableInfo(XicPeptideIonPanel.this.m_dataBox.getId(), XicPeptideIonPanel.this.m_dataBox.getUserName(), XicPeptideIonPanel.this.m_dataBox.getDataName(), XicPeptideIonPanel.this.m_dataBox.getTypeName(), table);
                Image i = XicPeptideIonPanel.this.m_dataBox.getIcon();
                if (i != null) {
                    tableInfo.setIcon(new ImageIcon(i));
                }
                DataAnalyzerWindowBoxManager.addTableInfo(tableInfo);
            }
        };
        toolbar.add((Component)this.m_addCompareDataButton);
        this.m_infoToggleButton = new InfoToggleButton((ProgressInterface)this.m_quantPeptideIonTable, (InfoInterface)this.m_quantPeptideIonTable);
        toolbar.add((Component)this.m_infoToggleButton);
        return toolbar;
    }

    private JPanel createInternalPanel() {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        this.m_peptideIonScrollPane = new JScrollPane();
        this.m_quantPeptideIonTable = new QuantPeptideIonTable();
        this.m_quantPeptideIonTable.setModel((TableModel)new CompoundTableModel((GlobalTableModelInterface)new QuantPeptideIonTableModel(this.m_quantPeptideIonTable, this.m_quantMethodInfo), true));
        CustomColumnControlButton customColumnControl = new CustomColumnControlButton((JXTable)this.m_quantPeptideIonTable);
        this.m_quantPeptideIonTable.setColumnControl((JComponent)customColumnControl);
        this.m_quantPeptideIonTable.setSortable(false);
        this.m_markerContainerPanel = new MarkerContainerPanel(this.m_peptideIonScrollPane, (MarkerComponentInterface)this.m_quantPeptideIonTable);
        this.m_peptideIonScrollPane.setViewportView((Component)((Object)this.m_quantPeptideIonTable));
        this.m_quantPeptideIonTable.setFillsViewportHeight(true);
        this.m_quantPeptideIonTable.setViewport(this.m_peptideIonScrollPane.getViewport());
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 3;
        internalPanel.add((Component)this.m_markerContainerPanel, c);
        return internalPanel;
    }

    public void setData(Long taskId, DQuantitationChannel[] quantChannels, List<DMasterQuantPeptideIon> peptideIons, DDatasetType.QuantitationMethodInfo quantitationMethodInfo, boolean finished) {
        boolean qcChanged = true;
        if (this.m_quantChannels != null && this.m_quantChannels.length == quantChannels.length) {
            for (int q = 0; q < this.m_quantChannels.length; ++q) {
                qcChanged = !this.m_quantChannels[q].equals((Object)quantChannels[q]);
            }
        }
        this.m_quantChannels = quantChannels;
        this.m_quantMethodInfo = quantitationMethodInfo;
        ((QuantPeptideIonTableModel)((CompoundTableModel)this.m_quantPeptideIonTable.getModel()).getBaseModel()).setData(taskId, quantChannels, peptideIons, this.m_quantMethodInfo);
        if (peptideIons != null && peptideIons.size() > 0) {
            this.m_quantPeptideIonTable.getSelectionModel().setSelectionInterval(0, 0);
            this.m_markerContainerPanel.setMaxLineNumber(peptideIons.size());
        }
        this.m_infoToggleButton.updateInfo();
        if (finished) {
            this.m_quantPeptideIonTable.setSortable(true);
        }
        if (qcChanged) {
            this.setColumnsVisibility();
        }
    }

    public void dataUpdated(SubTask subTask, boolean finished) {
        this.m_quantPeptideIonTable.dataUpdated(subTask, finished);
        if (finished) {
            this.m_quantPeptideIonTable.setSortable(true);
        }
    }

    public void setColumnsVisibility() {
        if (this.m_isAllPeptideIon) {
            int id = 3;
            this.m_quantPeptideIonTable.getColumnExt(this.m_quantPeptideIonTable.convertColumnIndexToView(id)).setVisible(false);
        }
        List<Integer> listIdsToHide = ((QuantPeptideIonTableModel)((CompoundTableModel)this.m_quantPeptideIonTable.getModel()).getBaseModel()).getDefaultColumnsToHide();
        List columns = this.m_quantPeptideIonTable.getColumns(true);
        for (Integer id : listIdsToHide) {
            boolean columnVisible = ((TableColumnExt)columns.get(id)).isVisible();
            if (!columnVisible) continue;
            this.m_quantPeptideIonTable.getColumnExt(this.m_quantPeptideIonTable.convertColumnIndexToView(id)).setVisible(false);
        }
    }

    @Override
    public void setDataBox(AbstractDataBox dataBox) {
        this.m_dataBox = dataBox;
    }

    @Override
    public AbstractDataBox getDataBox() {
        return this.m_dataBox;
    }

    @Override
    public void addSingleValue(Object v) {
        this.getGlobalTableModelInterface().addSingleValue(v);
    }

    public GlobalTableModelInterface getGlobalTableModelInterface() {
        return (GlobalTableModelInterface)this.m_quantPeptideIonTable.getModel();
    }

    public JXTable getGlobalAssociatedTable() {
        return this.m_quantPeptideIonTable;
    }

    public ActionListener getRemoveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getRemoveAction(splittedPanel);
    }

    public ActionListener getAddAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getAddAction(splittedPanel);
    }

    public ActionListener getSaveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getSaveAction(splittedPanel);
    }

    public DMasterQuantPeptideIon getSelectedMasterQuantPeptideIon() {
        return this.m_quantPeptideIonTable.getSelectedMasterQuantPeptideIon();
    }

    public CrossSelectionInterface getCrossSelectionInterface() {
        return this.m_quantPeptideIonTable;
    }

    private class QuantPeptideIonTable
    extends LazyTable
    implements ExportModelInterface,
    InfoInterface {
        String searchTextBeingDone;
        private boolean selectionWillBeRestored;
        private DisplayTablePopupMenu m_popupMenu;

        public QuantPeptideIonTable() {
            super(XicPeptideIonPanel.this.m_peptideIonScrollPane.getVerticalScrollBar());
            this.searchTextBeingDone = null;
            this.selectionWillBeRestored = false;
        }

        public void addTableModelListener(TableModelListener l) {
            this.getModel().addTableModelListener(l);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            super.valueChanged(e);
            if (this.selectionWillBeRestored) {
                return;
            }
            if (e.getValueIsAdjusting()) {
                return;
            }
            XicPeptideIonPanel.this.m_dataBox.addDataChanged(DMasterQuantPeptideIon.class);
            XicPeptideIonPanel.this.m_dataBox.propagateDataChanged();
        }

        public boolean selectPeptideIon(Long peptideIonId, String searchText) {
            QuantPeptideIonTableModel tableModel = (QuantPeptideIonTableModel)((CompoundTableModel)this.getModel()).getBaseModel();
            int row = tableModel.findRow(peptideIonId);
            if (row == -1) {
                return false;
            }
            row = ((CompoundTableModel)this.getModel()).convertBaseModelRowToCompoundRow(row);
            if (row == -1) {
                return false;
            }
            this.searchTextBeingDone = searchText;
            row = this.convertRowIndexToView(row);
            this.getSelectionModel().setSelectionInterval(row, row);
            this.scrollRowToVisible(row);
            this.searchTextBeingDone = null;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dataUpdated(SubTask subTask, boolean finished) {
            LazyTable.LastAction keepLastAction = this.m_lastAction;
            try {
                int rowSelected = this.getSelectionModel().getMinSelectionIndex();
                int rowSelectedInModel = rowSelected == -1 ? -1 : this.convertRowIndexToModel(rowSelected);
                this.selectionWillBeRestored(true);
                try {
                    ((QuantPeptideIonTableModel)((CompoundTableModel)this.getModel()).getBaseModel()).dataUpdated();
                }
                finally {
                    this.selectionWillBeRestored(false);
                }
                if (rowSelectedInModel != -1) {
                    int rowSelectedInView = this.convertRowIndexToView(rowSelectedInModel);
                    this.setSelection(rowSelectedInView);
                    if ((keepLastAction == LazyTable.LastAction.ACTION_SELECTING || keepLastAction == LazyTable.LastAction.ACTION_SORTING) && subTask.getSubTaskId() == ((CompoundTableModel)this.getModel()).getSubTaskId(this.getSortedColumnIndex())) {
                        this.scrollRowToVisible(rowSelectedInView);
                    }
                }
            }
            finally {
                this.m_lastAction = keepLastAction;
            }
            if (finished) {
                this.setSortable(true);
            }
        }

        public void selectionWillBeRestored(boolean b) {
            this.selectionWillBeRestored = b;
        }

        public int getLoadingPercentage() {
            return XicPeptideIonPanel.this.m_dataBox.getLoadingPercentage();
        }

        public boolean isLoaded() {
            return XicPeptideIonPanel.this.m_dataBox.isLoaded();
        }

        public DMasterQuantPeptideIon getSelectedMasterQuantPeptideIon() {
            int selectedRow = this.getSelectedRow();
            if (selectedRow == -1) {
                return null;
            }
            CompoundTableModel compoundTableModel = (CompoundTableModel)XicPeptideIonPanel.this.m_quantPeptideIonTable.getModel();
            if (compoundTableModel.getRowCount() == 0) {
                return null;
            }
            try {
                selectedRow = this.convertRowIndexToModel(selectedRow);
            }
            catch (Exception e) {
                m_loggerProline.debug("Exception catched as a wart : " + e.getMessage());
                return null;
            }
            selectedRow = compoundTableModel.convertCompoundRowToBaseModelRow(selectedRow);
            QuantPeptideIonTableModel tableModel = (QuantPeptideIonTableModel)compoundTableModel.getBaseModel();
            return tableModel.getPeptideIon(selectedRow);
        }

        public String getExportColumnName(int col) {
            return ((CompoundTableModel)XicPeptideIonPanel.this.m_quantPeptideIonTable.getModel()).getExportColumnName(this.convertColumnIndexToModel(col));
        }

        public String getExportRowCell(int row, int col) {
            return ((CompoundTableModel)XicPeptideIonPanel.this.m_quantPeptideIonTable.getModel()).getExportRowCell(this.convertRowIndexToModel(row), this.convertColumnIndexToModel(col));
        }

        public ArrayList<ExportFontData> getExportFonts(int row, int col) {
            return ((CompoundTableModel)XicPeptideIonPanel.this.m_quantPeptideIonTable.getModel()).getExportFonts(this.convertRowIndexToModel(row), this.convertColumnIndexToModel(col));
        }

        public TablePopupMenu initPopupMenu() {
            this.m_popupMenu = new DisplayTablePopupMenu(XicPeptideIonPanel.this);
            return this.m_popupMenu;
        }

        public void prepostPopupMenu() {
            this.m_popupMenu.prepostPopupMenu();
        }

        public String getInfo() {
            int count;
            return count + ((count = this.getModel().getRowCount()) > 1 ? " Peptides Ions" : " Peptide Ion");
        }
    }
}

