/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.xic;

import fr.proline.core.orm.msi.dto.DMasterQuantProteinSet;
import fr.proline.core.orm.msi.dto.DProteinSet;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.core.orm.uds.dto.DDatasetType;
import fr.proline.core.orm.uds.dto.DQuantitationChannel;
import fr.proline.studio.WindowManager;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dam.tasks.xic.DatabaseModifyPeptideTask;
import fr.proline.studio.export.ExportButton;
import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.export.ExportModelInterface;
import fr.proline.studio.extendedtablemodel.AddDataAnalyzerButton;
import fr.proline.studio.extendedtablemodel.CompoundTableModel;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.GlobalTabelModelProviderInterface;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.FilterButton;
import fr.proline.studio.filter.FilterTableModelInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.gui.DefaultFloatingPanel;
import fr.proline.studio.gui.HourglassPanel;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.info.InfoInterface;
import fr.proline.studio.info.InfoToggleButton;
import fr.proline.studio.markerbar.MarkerComponentInterface;
import fr.proline.studio.markerbar.MarkerContainerPanel;
import fr.proline.studio.parameter.ObjectParameter;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.parameter.SettingsButton;
import fr.proline.studio.parameter.SettingsInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataAnalyzerWindowBoxManager;
import fr.proline.studio.pattern.DataBoxPanelInterface;
import fr.proline.studio.pattern.xic.DataboxXicProteinSet;
import fr.proline.studio.progress.ProgressInterface;
import fr.proline.studio.rsmexplorer.DataBoxViewerManager;
import fr.proline.studio.rsmexplorer.actions.table.DisplayIdentificationProteinSetsAction;
import fr.proline.studio.rsmexplorer.actions.table.DisplayTablePopupMenu;
import fr.proline.studio.rsmexplorer.actions.xic.ComputeQuantPostProcessingAction;
import fr.proline.studio.rsmexplorer.gui.dialog.CalcDialog;
import fr.proline.studio.rsmexplorer.gui.xic.QuantProteinSetTableModel;
import fr.proline.studio.search.SearchToggleButton;
import fr.proline.studio.table.CustomColumnControlButton;
import fr.proline.studio.table.ExportTableSelectionInterface;
import fr.proline.studio.table.LazyTable;
import fr.proline.studio.table.TableInfo;
import fr.proline.studio.table.TablePopupMenu;
import fr.proline.studio.table.renderer.GrayedRenderer;
import fr.proline.studio.utils.IconManager;
import fr.proline.studio.utils.ResultCallback;
import fr.proline.studio.utils.URLCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;

public class XicProteinSetPanel
extends HourglassPanel
implements DataBoxPanelInterface,
GlobalTabelModelProviderInterface {
    private AbstractDataBox m_dataBox;
    private JScrollPane m_proteinSetScrollPane;
    private QuantProteinSetTable m_quantProteinSetTable;
    private DefaultFloatingPanel m_refineProteinsPanel;
    private MarkerContainerPanel m_markerContainerPanel;
    private DDatasetType.QuantitationMethodInfo m_quantMethodInfo = DDatasetType.QuantitationMethodInfo.FEATURES_EXTRACTION;
    private SettingsButton m_settingsButton;
    private FilterButton m_filterButton;
    private ExportButton m_exportButton;
    private AddDataAnalyzerButton m_addCompareDataButton;
    private JButton m_calcButton;
    private SearchToggleButton m_searchToggleButton;
    private InfoToggleButton m_infoToggleButton;
    private static final String OVERVIEW_KEY = "OVERVIEW_KEY";
    private boolean m_hideFirstTime = true;

    public XicProteinSetPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        final JPanel proteinSetPanel = this.createProteinSetPanel();
        this.m_refineProteinsPanel = this.createRefineProteinsPanel();
        final JLayeredPane layeredPane = new JLayeredPane();
        layeredPane.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                Component c = e.getComponent();
                proteinSetPanel.setBounds(0, 0, c.getWidth(), c.getHeight());
                layeredPane.revalidate();
                layeredPane.repaint();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.add(layeredPane, "Center");
        layeredPane.add((Component)proteinSetPanel, JLayeredPane.DEFAULT_LAYER);
        layeredPane.add((Component)this.m_infoToggleButton.getInfoPanel(), (Object)(JLayeredPane.PALETTE_LAYER + 1));
        layeredPane.add((Component)this.m_searchToggleButton.getSearchPanel(), (Object)(JLayeredPane.PALETTE_LAYER + 2));
        layeredPane.add((Component)this.m_refineProteinsPanel, JLayeredPane.PALETTE_LAYER);
    }

    private DefaultFloatingPanel createRefineProteinsPanel() {
        ResultCallback resultCallback = new ResultCallback(){

            public void run(boolean success) {
                XicProteinSetPanel.this.m_refineProteinsPanel.actionFinished(success, success ? null : "Computing Post-Processing on Abundances has failed. Look to Tasks Log for more information.");
                if (success) {
                    final ArrayList<DMasterQuantProteinSet> masterQuantProteinSetModified = XicProteinSetPanel.this.m_quantProteinSetTable.getModifiedQuantProteinSet();
                    AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

                        public boolean mustBeCalledInAWT() {
                            return true;
                        }

                        public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                            if (!success) {
                                return;
                            }
                            try {
                                for (DMasterQuantProteinSet masterQuantProteinSet : masterQuantProteinSetModified) {
                                    Map pmqSerializedMap = masterQuantProteinSet.getSerializedPropertiesAsMap();
                                    if (pmqSerializedMap == null) continue;
                                    pmqSerializedMap.put("selection_changed", Boolean.FALSE);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            DataBoxViewerManager.loadedDataModified(XicProteinSetPanel.this.m_dataBox.getProjectId(), XicProteinSetPanel.this.m_dataBox.getRsetId(), XicProteinSetPanel.this.m_dataBox.getRsmId(), DMasterQuantProteinSet.class, masterQuantProteinSetModified, DataBoxViewerManager.REASON_MODIF.REASON_PROTEINS_REFINED.getReasonValue());
                        }
                    };
                    DatabaseModifyPeptideTask task = new DatabaseModifyPeptideTask(callback);
                    DataboxXicProteinSet databox = (DataboxXicProteinSet)XicProteinSetPanel.this.m_dataBox;
                    DDataset dataset = (DDataset)databox.getData(DDataset.class);
                    task.initRemovePeptideModifiedOnProtein(XicProteinSetPanel.this.m_dataBox.getProjectId(), dataset, masterQuantProteinSetModified);
                    AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
                }
            }
        };
        ActionListener refineAction = e -> {
            DataboxXicProteinSet databox = (DataboxXicProteinSet)this.m_dataBox;
            long projectId = this.m_dataBox.getProjectId();
            DDataset dataset = (DDataset)databox.getData(DDataset.class);
            boolean okCalled = ComputeQuantPostProcessingAction.quantificationProfile(resultCallback, this.getX() + 20, this.getY() + 20, projectId, dataset);
            if (okCalled) {
                this.m_refineProteinsPanel.actionStarted();
            }
        };
        String[] actionText = new String[]{"Compute"};
        ActionListener[] actionListeners = new ActionListener[]{refineAction};
        Icon[] icons = new Icon[]{IconManager.getIcon((IconManager.IconType)IconManager.IconType.REFINE)};
        DefaultFloatingPanel refineProteinsPanel = new DefaultFloatingPanel("You need to compute Post-Processing on Abundances : ", actionText, actionListeners, icons){

            public void actionFinished(boolean success, String errorMessage) {
                super.actionFinished(success, errorMessage);
                int selectedRow = XicProteinSetPanel.this.m_quantProteinSetTable.getSelectedRow();
                int selectedModelRow = XicProteinSetPanel.this.m_quantProteinSetTable.convertRowIndexToModel(selectedRow);
                ((CompoundTableModel)XicProteinSetPanel.this.m_quantProteinSetTable.getModel()).fireTableDataChanged();
                selectedRow = XicProteinSetPanel.this.m_quantProteinSetTable.convertRowIndexToView(selectedModelRow);
                XicProteinSetPanel.this.m_quantProteinSetTable.setSelection(selectedRow);
            }
        };
        return refineProteinsPanel;
    }

    private JPanel createProteinSetPanel() {
        JPanel proteinSetPanel = new JPanel();
        proteinSetPanel.setBounds(0, 0, 500, 400);
        proteinSetPanel.setLayout(new BorderLayout());
        JPanel internalPanel = this.createInternalPanel();
        JToolBar toolbar = this.initToolbar();
        proteinSetPanel.add((Component)toolbar, "West");
        proteinSetPanel.add((Component)internalPanel, "Center");
        return proteinSetPanel;
    }

    private JToolBar initToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        this.m_searchToggleButton = new SearchToggleButton((ProgressInterface)this.m_quantProteinSetTable, (JXTable)this.m_quantProteinSetTable, (FilterTableModelInterface)((CompoundTableModel)this.m_quantProteinSetTable.getModel()));
        toolbar.add((Component)this.m_searchToggleButton);
        this.m_settingsButton = new SettingsButton((ProgressInterface)this.m_quantProteinSetTable.getModel(), (SettingsInterface)this.m_quantProteinSetTable);
        this.m_filterButton = new FilterButton((FilterTableModelInterface)((CompoundTableModel)this.m_quantProteinSetTable.getModel())){

            protected void filteringDone() {
                XicProteinSetPanel.this.m_dataBox.addDataChanged(ExtendedTableModelInterface.class);
                XicProteinSetPanel.this.m_dataBox.propagateDataChanged();
                XicProteinSetPanel.this.m_infoToggleButton.updateInfo();
            }
        };
        this.m_exportButton = new ExportButton((ProgressInterface)((CompoundTableModel)this.m_quantProteinSetTable.getModel()), "Protein Sets", (JXTable)this.m_quantProteinSetTable);
        toolbar.add((Component)this.m_filterButton);
        toolbar.add((Component)this.m_settingsButton);
        toolbar.add((Component)this.m_exportButton);
        this.m_addCompareDataButton = new AddDataAnalyzerButton((ProgressInterface)((CompoundTableModel)this.m_quantProteinSetTable.getModel())){

            public void actionPerformed() {
                JXTable table = XicProteinSetPanel.this.getGlobalAssociatedTable();
                TableInfo tableInfo = new TableInfo(XicProteinSetPanel.this.m_dataBox.getId(), XicProteinSetPanel.this.m_dataBox.getUserName(), XicProteinSetPanel.this.m_dataBox.getDataName(), XicProteinSetPanel.this.m_dataBox.getTypeName(), table);
                Image i = XicProteinSetPanel.this.m_dataBox.getIcon();
                if (i != null) {
                    tableInfo.setIcon(new ImageIcon(i));
                }
                DataAnalyzerWindowBoxManager.addTableInfo(tableInfo);
            }
        };
        toolbar.add((Component)this.m_addCompareDataButton);
        this.m_infoToggleButton = new InfoToggleButton((ProgressInterface)this.m_quantProteinSetTable, (InfoInterface)this.m_quantProteinSetTable);
        toolbar.add((Component)this.m_infoToggleButton);
        this.m_calcButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.CALCULATOR));
        this.m_calcButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalcDialog dialog = CalcDialog.getCalcDialog((Window)WindowManager.getDefault().getMainWindow(), (JXTable)XicProteinSetPanel.this.m_quantProteinSetTable);
                dialog.centerToWindow((Window)WindowManager.getDefault().getMainWindow());
                dialog.setVisible(true);
            }
        });
        toolbar.add(this.m_calcButton);
        return toolbar;
    }

    private JPanel createInternalPanel() {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        this.m_proteinSetScrollPane = new JScrollPane();
        this.m_quantProteinSetTable = new QuantProteinSetTable();
        this.m_quantProteinSetTable.setModel((TableModel)new CompoundTableModel((GlobalTableModelInterface)new QuantProteinSetTableModel(this.m_quantProteinSetTable), true));
        CustomColumnControlButton customColumnControl = new CustomColumnControlButton((JXTable)this.m_quantProteinSetTable);
        this.m_quantProteinSetTable.setColumnControl((JComponent)customColumnControl);
        this.m_quantProteinSetTable.getColumnExt(this.m_quantProteinSetTable.convertColumnIndexToView(0)).setVisible(false);
        this.m_quantProteinSetTable.setSortable(false);
        this.m_markerContainerPanel = new MarkerContainerPanel(this.m_proteinSetScrollPane, (MarkerComponentInterface)this.m_quantProteinSetTable);
        this.m_proteinSetScrollPane.setViewportView((Component)((Object)this.m_quantProteinSetTable));
        this.m_quantProteinSetTable.setFillsViewportHeight(true);
        this.m_quantProteinSetTable.setViewport(this.m_proteinSetScrollPane.getViewport());
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 3;
        internalPanel.add((Component)this.m_markerContainerPanel, c);
        return internalPanel;
    }

    public void setData(Long taskId, DQuantitationChannel[] quantChannels, List<DMasterQuantProteinSet> proteinSets, DDatasetType.QuantitationMethodInfo quantMethodInfo, boolean finished) {
        this.m_quantMethodInfo = quantMethodInfo;
        ((QuantProteinSetTableModel)((CompoundTableModel)this.m_quantProteinSetTable.getModel()).getBaseModel()).setData(taskId, quantChannels, proteinSets, this.m_quantMethodInfo);
        TableCellRenderer renderer = ((CompoundTableModel)this.m_quantProteinSetTable.getModel()).getRenderer(0, 1);
        URLCellRenderer urlRenderer = renderer instanceof GrayedRenderer ? (URLCellRenderer)((GrayedRenderer)renderer).getBaseRenderer() : (URLCellRenderer)renderer;
        this.m_quantProteinSetTable.addMouseListener((MouseListener)urlRenderer);
        this.m_quantProteinSetTable.addMouseMotionListener((MouseMotionListener)urlRenderer);
        if (proteinSets != null && proteinSets.size() > 0) {
            this.m_quantProteinSetTable.getSelectionModel().setSelectionInterval(0, 0);
            this.m_markerContainerPanel.setMaxLineNumber(proteinSets.size());
            if (this.m_hideFirstTime) {
                List<Integer> listIdsToHide = ((QuantProteinSetTableModel)((CompoundTableModel)this.m_quantProteinSetTable.getModel()).getBaseModel()).getDefaultColumnsToHide();
                for (Integer id : listIdsToHide) {
                    this.m_quantProteinSetTable.getColumnExt(this.m_quantProteinSetTable.convertColumnIndexToView(id)).setVisible(false);
                }
                this.m_hideFirstTime = false;
            }
            if (finished) {
                this.m_quantProteinSetTable.setSortable(true);
                try {
                    boolean containsModifier = ((QuantProteinSetTableModel)((CompoundTableModel)this.m_quantProteinSetTable.getModel()).getBaseModel()).containsModifiedQuantProteinSet();
                    if (containsModifier) {
                        this.m_refineProteinsPanel.setLocation(this.getX() + 20, this.getY() + 20);
                        this.m_refineProteinsPanel.setVisible(true);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void dataModified(ArrayList modificationsList, byte reason) {
        boolean modification = this.m_quantProteinSetTable.dataModified(modificationsList);
        if (modification && DataBoxViewerManager.REASON_MODIF.isReasonDefine(DataBoxViewerManager.REASON_MODIF.REASON_PEPTIDE_SUPPRESSED, reason)) {
            this.m_refineProteinsPanel.setLocation(this.getX() + 20, this.getY() + 20);
            this.m_refineProteinsPanel.setVisible(true);
        }
    }

    public void dataUpdated(SubTask subTask, boolean finished) {
        this.m_quantProteinSetTable.dataUpdated(subTask, finished);
        if (this.m_hideFirstTime) {
            List<Integer> listIdsToHide = ((QuantProteinSetTableModel)((CompoundTableModel)this.m_quantProteinSetTable.getModel()).getBaseModel()).getDefaultColumnsToHide();
            for (Integer id : listIdsToHide) {
                this.m_quantProteinSetTable.getColumnExt(this.m_quantProteinSetTable.convertColumnIndexToView(id)).setVisible(false);
            }
            this.m_hideFirstTime = false;
        }
        if (finished) {
            this.m_quantProteinSetTable.setSortable(true);
        }
    }

    public DProteinSet getSelectedProteinSet() {
        return this.m_quantProteinSetTable.getSelectedProteinSet();
    }

    public DMasterQuantProteinSet getSelectedMasterQuantProteinSet() {
        return this.m_quantProteinSetTable.getSelectedMasterQuantProteinSet();
    }

    @Override
    public void setDataBox(AbstractDataBox dataBox) {
        this.m_dataBox = dataBox;
    }

    @Override
    public AbstractDataBox getDataBox() {
        return this.m_dataBox;
    }

    @Override
    public void addSingleValue(Object v) {
        this.getGlobalTableModelInterface().addSingleValue(v);
    }

    public GlobalTableModelInterface getGlobalTableModelInterface() {
        return (GlobalTableModelInterface)this.m_quantProteinSetTable.getModel();
    }

    public JXTable getGlobalAssociatedTable() {
        return this.m_quantProteinSetTable;
    }

    public ActionListener getRemoveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getRemoveAction(splittedPanel);
    }

    public ActionListener getAddAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getAddAction(splittedPanel);
    }

    public ActionListener getSaveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getSaveAction(splittedPanel);
    }

    public CrossSelectionInterface getCrossSelectionInterface() {
        return this.m_quantProteinSetTable;
    }

    private class QuantProteinSetTable
    extends LazyTable
    implements ExportTableSelectionInterface,
    ExportModelInterface,
    InfoInterface {
        private ObjectParameter m_overviewParameter;
        private DisplayIdentificationProteinSetsAction m_idProteinSetAction;
        private DisplayTablePopupMenu m_popupMenu;
        private boolean selectionWillBeRestored;

        public QuantProteinSetTable() {
            super(XicProteinSetPanel.this.m_proteinSetScrollPane.getVerticalScrollBar());
            this.m_overviewParameter = null;
            this.selectionWillBeRestored = false;
        }

        public ArrayList<DMasterQuantProteinSet> getModifiedQuantProteinSet() {
            return ((QuantProteinSetTableModel)((CompoundTableModel)this.getModel()).getBaseModel()).getModifiedQuantProteinSet();
        }

        public ArrayList<ParameterList> getParameters() {
            ArrayList parameterListArray = super.getParameters();
            ParameterList overviewParameterList = new ParameterList("Overview Parameters");
            boolean isSC = XicProteinSetPanel.this.m_quantMethodInfo.equals((Object)DDatasetType.QuantitationMethodInfo.SPECTRAL_COUNTING);
            Object[] overviewDisplay = new String[]{!isSC ? "Overview on Pep. Match Count" : "Overview on Basic SC", !isSC ? "Overview on Raw Abundance" : "Overview on Specific SC", !isSC ? "Overview on Abundance" : "Overview on Weighted SC"};
            Object[] overviewValues = new Integer[]{0, 1, 2};
            List columns = this.getColumns(true);
            QuantProteinSetTableModel quantProteinSetTableModel = (QuantProteinSetTableModel)((CompoundTableModel)XicProteinSetPanel.this.m_quantProteinSetTable.getModel()).getBaseModel();
            int overviewType = quantProteinSetTableModel.getOverviewType();
            boolean overviewColumnVisible = ((TableColumnExt)columns.get(2)).isVisible();
            int defaultIndex = 0;
            if (overviewColumnVisible) {
                switch (overviewType) {
                    case 4: {
                        defaultIndex = 2;
                        break;
                    }
                    case 3: {
                        defaultIndex = 1;
                        break;
                    }
                    case 2: {
                        defaultIndex = 0;
                    }
                }
            }
            this.m_overviewParameter = new ObjectParameter(XicProteinSetPanel.OVERVIEW_KEY, "Overview", null, overviewDisplay, overviewValues, defaultIndex, null);
            overviewParameterList.add((Object)this.m_overviewParameter);
            parameterListArray.add(overviewParameterList);
            return parameterListArray;
        }

        public void parametersChanged() {
            super.parametersChanged();
            if (this.m_overviewParameter == null) {
                return;
            }
            Integer index = (Integer)this.m_overviewParameter.getAssociatedObjectValue();
            QuantProteinSetTableModel model = (QuantProteinSetTableModel)((CompoundTableModel)XicProteinSetPanel.this.m_quantProteinSetTable.getModel()).getBaseModel();
            if (index == 2) {
                model.setOverviewType(4);
            } else if (index == 1) {
                model.setOverviewType(3);
            } else if (index == 0) {
                model.setOverviewType(2);
            }
        }

        public void addTableModelListener(TableModelListener l) {
            this.getModel().addTableModelListener(l);
        }

        public TablePopupMenu initPopupMenu() {
            this.m_popupMenu = new DisplayTablePopupMenu(XicProteinSetPanel.this);
            this.m_idProteinSetAction = new DisplayIdentificationProteinSetsAction();
            this.m_popupMenu.addAction(this.m_idProteinSetAction);
            return this.m_popupMenu;
        }

        public void prepostPopupMenu() {
            this.m_idProteinSetAction.setBox(XicProteinSetPanel.this.m_dataBox);
            this.m_popupMenu.prepostPopupMenu();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            super.valueChanged(e);
            if (this.selectionWillBeRestored) {
                return;
            }
            if (e.getValueIsAdjusting()) {
                return;
            }
            XicProteinSetPanel.this.m_dataBox.addDataChanged(DProteinSet.class);
            XicProteinSetPanel.this.m_dataBox.addDataChanged(ExtendedTableModelInterface.class);
            XicProteinSetPanel.this.m_dataBox.propagateDataChanged();
        }

        public HashSet exportSelection(int[] rows) {
            CompoundTableModel tableModel = (CompoundTableModel)this.getModel();
            int[] modelRows = new int[rows.length];
            for (int i = 0; i < rows.length; ++i) {
                int compoundModelRow = this.convertRowIndexToModel(rows[i]);
                modelRows[i] = tableModel.convertRowToOriginalModel(compoundModelRow);
            }
            QuantProteinSetTableModel baseModel = (QuantProteinSetTableModel)tableModel.getBaseModel();
            return baseModel.exportSelection(modelRows);
        }

        public DProteinSet getSelectedProteinSet() {
            int selectedRow = this.getSelectedRow();
            if (selectedRow == -1) {
                return null;
            }
            CompoundTableModel compoundTableModel = (CompoundTableModel)this.getModel();
            if (compoundTableModel.getRowCount() == 0) {
                return null;
            }
            selectedRow = this.convertRowIndexToModel(selectedRow);
            selectedRow = compoundTableModel.convertCompoundRowToBaseModelRow(selectedRow);
            QuantProteinSetTableModel tableModel = (QuantProteinSetTableModel)compoundTableModel.getBaseModel();
            return tableModel.getProteinSet(selectedRow);
        }

        public DMasterQuantProteinSet getSelectedMasterQuantProteinSet() {
            int selectedRow = this.getSelectedRow();
            if (selectedRow == -1) {
                return null;
            }
            CompoundTableModel compoundTableModel = (CompoundTableModel)this.getModel();
            if (compoundTableModel.getRowCount() == 0) {
                return null;
            }
            selectedRow = this.convertRowIndexToModel(selectedRow);
            selectedRow = compoundTableModel.convertCompoundRowToBaseModelRow(selectedRow);
            QuantProteinSetTableModel tableModel = (QuantProteinSetTableModel)compoundTableModel.getBaseModel();
            return tableModel.getMasterQuantProteinSet(selectedRow);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dataUpdated(SubTask subTask, boolean finished) {
            LazyTable.LastAction keepLastAction = this.m_lastAction;
            try {
                int rowSelected = this.getSelectionModel().getMinSelectionIndex();
                int rowSelectedInModel = rowSelected == -1 ? -1 : this.convertRowIndexToModel(rowSelected);
                this.selectionWillBeRestored(true);
                try {
                    ((QuantProteinSetTableModel)((CompoundTableModel)this.getModel()).getBaseModel()).dataUpdated();
                }
                finally {
                    this.selectionWillBeRestored(false);
                }
                if (rowSelectedInModel != -1) {
                    int rowSelectedInView = this.convertRowIndexToView(rowSelectedInModel);
                    this.setSelection(rowSelectedInView);
                    if ((keepLastAction == LazyTable.LastAction.ACTION_SELECTING || keepLastAction == LazyTable.LastAction.ACTION_SORTING) && subTask.getSubTaskId() == ((CompoundTableModel)this.getModel()).getSubTaskId(this.getSortedColumnIndex())) {
                        this.scrollRowToVisible(rowSelectedInView);
                    }
                }
            }
            finally {
                this.m_lastAction = keepLastAction;
            }
            if (finished) {
                this.setSortable(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean dataModified(ArrayList modificationsList) {
            boolean modified = false;
            LazyTable.LastAction keepLastAction = this.m_lastAction;
            try {
                int rowSelected = this.getSelectionModel().getMinSelectionIndex();
                int rowSelectedInModel = rowSelected == -1 ? -1 : this.convertRowIndexToModel(rowSelected);
                this.selectionWillBeRestored(true);
                try {
                    modified = ((QuantProteinSetTableModel)((CompoundTableModel)XicProteinSetPanel.this.m_quantProteinSetTable.getModel()).getBaseModel()).dataModified(modificationsList);
                }
                finally {
                    this.selectionWillBeRestored(false);
                }
                if (rowSelectedInModel != -1) {
                    int rowSelectedInView = this.convertRowIndexToView(rowSelectedInModel);
                    this.setSelection(rowSelectedInView);
                    if (keepLastAction == LazyTable.LastAction.ACTION_SELECTING || keepLastAction == LazyTable.LastAction.ACTION_SORTING) {
                        this.scrollRowToVisible(rowSelectedInView);
                    }
                }
            }
            finally {
                this.m_lastAction = keepLastAction;
            }
            return modified;
        }

        public void selectionWillBeRestored(boolean b) {
            this.selectionWillBeRestored = b;
        }

        public int getLoadingPercentage() {
            return XicProteinSetPanel.this.m_dataBox.getLoadingPercentage();
        }

        public boolean isLoaded() {
            return XicProteinSetPanel.this.m_dataBox.isLoaded();
        }

        public String getExportColumnName(int col) {
            return ((CompoundTableModel)XicProteinSetPanel.this.m_quantProteinSetTable.getModel()).getExportColumnName(this.convertColumnIndexToModel(col));
        }

        public String getExportRowCell(int row, int col) {
            return ((CompoundTableModel)XicProteinSetPanel.this.m_quantProteinSetTable.getModel()).getExportRowCell(this.convertRowIndexToModel(row), this.convertColumnIndexToModel(col));
        }

        public ArrayList<ExportFontData> getExportFonts(int row, int col) {
            return ((CompoundTableModel)XicProteinSetPanel.this.m_quantProteinSetTable.getModel()).getExportFonts(this.convertRowIndexToModel(row), this.convertColumnIndexToModel(col));
        }

        public String getInfo() {
            int count;
            return count + ((count = this.getModel().getRowCount()) > 1 ? " Proteins Sets" : " Protein Set");
        }
    }
}

