/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.xic.alignment;

import fr.proline.core.orm.msi.Peptide;
import fr.proline.core.orm.msi.dto.DMasterQuantPeptideIon;
import fr.proline.core.orm.msi.dto.DPeptideInstance;
import fr.proline.core.orm.msi.dto.DQuantPeptideIon;
import fr.proline.studio.corewrapper.util.PeptideClassesUtils;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.graphics.PlotDataSpec;
import fr.proline.studio.graphics.PlotInformation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class IonsRTTableModel
implements ExtendedTableModelInterface {
    private String m_modelName;
    private Map<Long, Long> m_rsmIdByMapId;
    private long[] m_rsmIdArray;
    private List<IonRTMoZRow> m_data;
    private Map<Long, String> m_mapTitleByRsmId;
    private String[] m_columnName;
    private static final int PEPTIDE_ID = 0;
    private static final int PEPTIDE_SEQUENCE = 1;
    private static final int CHARGE = 2;
    private static final int MOZ = 3;
    private static final int DELTA_MOZ = 4;
    private static final int ELUTION_TIME_FROM = 5;
    private static final int START_ELUTION_TO = 6;
    private int m_mapCount;
    public static final int MOZ_COL_INDEX = 3;
    public static final int ELUTION_TIME_FROM_COL_INDEX = 5;
    public static final int DELTA_MOZ_COL_INDEX = 4;

    public IonsRTTableModel(List<DMasterQuantPeptideIon> m_masterQuantPeptideIonList, Map<Long, Long> rsmIdByMapId, Map<Long, String> mapTitleByRsmId, long[] rsmIdArray) {
        this.m_mapCount = rsmIdArray.length;
        this.m_mapTitleByRsmId = mapTitleByRsmId;
        this.m_rsmIdByMapId = rsmIdByMapId;
        this.m_rsmIdArray = rsmIdArray;
        this.m_data = new ArrayList<IonRTMoZRow>();
        this.m_columnName = new String[rsmIdArray.length + 5];
        this.m_columnName[0] = "Peptide Id";
        this.m_columnName[1] = "Peptide Sequence";
        this.m_columnName[2] = "Charge";
        this.m_columnName[3] = "moz";
        this.m_columnName[4] = "Delta moz (experimental - theoretical)";
        this.m_columnName[5] = "Time in Map " + this.m_mapTitleByRsmId.get(rsmIdArray[0]) + " (min)";
        for (int i = 6; i < rsmIdArray.length + 5; ++i) {
            this.m_columnName[i] = "Delta time in Map " + this.m_mapTitleByRsmId.get(rsmIdArray[i - 5]) + " (s)";
        }
        for (DMasterQuantPeptideIon masterQuantPeptideIon : m_masterQuantPeptideIonList) {
            Map qPepIonByQCId;
            float[] rTimeTo = new float[this.m_mapCount - 1];
            int[] matchCountTo = new int[rTimeTo.length];
            DPeptideInstance peptideInstance = masterQuantPeptideIon.getPeptideInstance();
            if (peptideInstance == null || (qPepIonByQCId = masterQuantPeptideIon.getQuantPeptideIonByQchIds()) == null || qPepIonByQCId.isEmpty()) continue;
            Long rsmIdFrom = rsmIdArray[0];
            this.m_modelName = mapTitleByRsmId.get(rsmIdFrom) + " ElutionTime compare table model";
            DQuantPeptideIon srcQPepIon = (DQuantPeptideIon)qPepIonByQCId.get(rsmIdFrom);
            if (srcQPepIon == null) continue;
            float rTimeFrom = srcQPepIon.getElutionTime().floatValue();
            int matchCountFrom = srcQPepIon.getPeptideMatchesCount();
            for (int i = 1; i < rsmIdArray.length; ++i) {
                float deltaTime;
                DQuantPeptideIon destQPepIon = (DQuantPeptideIon)qPepIonByQCId.get(rsmIdArray[i]);
                if (destQPepIon == null) {
                    rTimeTo[i - 1] = Float.NaN;
                    continue;
                }
                rTimeTo[i - 1] = deltaTime = destQPepIon.getElutionTime().floatValue() - rTimeFrom;
                matchCountTo[i - 1] = destQPepIon.getPeptideMatchesCount();
            }
            double deltaMoz = Double.NaN;
            if (masterQuantPeptideIon.getPeptideInstance().getPeptide() != null) {
                deltaMoz = PeptideClassesUtils.getDeltaMozFor((double)srcQPepIon.getMoz(), (double)masterQuantPeptideIon.getCharge(), (Peptide)masterQuantPeptideIon.getPeptideInstance().getPeptide()).floatValue();
            }
            this.m_data.add(new IonRTMoZRow(peptideInstance.getPeptideId(), peptideInstance.getPeptide().getSequence(), masterQuantPeptideIon.getCharge(), srcQPepIon.getMoz(), deltaMoz, rTimeFrom, rTimeTo, matchCountFrom, matchCountTo));
        }
    }

    public List<IonRTMoZRow> getData() {
        return this.m_data;
    }

    public String getInfo(int rowIndex) {
        return this.m_data.get(rowIndex).toString();
    }

    public PlotDataSpec getDataSpecAt(int i) {
        return null;
    }

    public int getRowCount() {
        return this.m_data.size();
    }

    public int getColumnCount() {
        return this.m_columnName.length;
    }

    public String getDataColumnIdentifier(int columnIndex) {
        return this.m_columnName[columnIndex];
    }

    public Class getDataColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Long.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Integer.class;
            }
            case 3: 
            case 4: {
                return Double.class;
            }
        }
        return Float.class;
    }

    public Object getDataValueAt(int rowIndex, int columnIndex) {
        IonRTMoZRow row = this.m_data.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return row._peptideId;
            }
            case 1: {
                return row._peptideSequence;
            }
            case 2: {
                return row._charge;
            }
            case 3: {
                return row._moz;
            }
            case 4: {
                return row._deltaMoz;
            }
            case 5: {
                return (double)row._eTimeFrom / 60.0;
            }
        }
        if (columnIndex > 5 && columnIndex < this.m_mapCount + 5) {
            return Float.valueOf(row._deltaTimeTo[columnIndex - 6]);
        }
        if (columnIndex == 5 + this.m_mapCount) {
            return row._MatchCountTo;
        }
        return row._MatchCountTo[columnIndex - 6 - this.m_mapCount];
    }

    public boolean isCrossAssigned(int rowIndex, int colY) {
        IonRTMoZRow row = this.m_data.get(rowIndex);
        int countFrom = row._MatchCountFrom;
        int countTo = colY < 6 ? 1 : row._MatchCountTo[colY - 6];
        return countFrom == 0 || countTo == 0;
    }

    public int getColumnIndex(Long mapId) {
        long rsmId = this.m_rsmIdByMapId.get(mapId);
        for (int i = 0; i < this.m_rsmIdArray.length; ++i) {
            if (this.m_rsmIdArray[i] != rsmId) continue;
            return i + 5;
        }
        return -1;
    }

    public int[] getKeysColumn() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getInfoColumn() {
        return 1;
    }

    public String getToolTipInfo(int rowIndex) {
        IonRTMoZRow row = this.m_data.get(rowIndex);
        StringBuilder infoValueSB = new StringBuilder(" Peptide id : ");
        infoValueSB.append(row._peptideId).append("<BR>");
        infoValueSB.append("Sequence : ").append(row._peptideSequence).append("<BR>");
        infoValueSB.append("charge : ").append(row._charge).append("<BR>");
        infoValueSB.append("moz: ").append(row._moz).append(" dmoz: ").append(row._deltaMoz).append("<BR>");
        return infoValueSB.toString();
    }

    public void setName(String name) {
        this.m_modelName = name;
    }

    public String getName() {
        return this.m_modelName;
    }

    public Map<String, Object> getExternalData() {
        return null;
    }

    public PlotInformation getPlotInformation() {
        PlotInformation plotInformation = new PlotInformation();
        plotInformation.setPlotTitle("");
        plotInformation.setDrawPoints(true);
        plotInformation.setDrawGap(true);
        return plotInformation;
    }

    public long row2UniqueId(int rowIndex) {
        return rowIndex;
    }

    public int uniqueId2Row(long id) {
        return (int)id;
    }

    public ArrayList<ExtraDataType> getExtraDataTypes() {
        return null;
    }

    public Object getValue(Class c) {
        return null;
    }

    public Object getRowValue(Class c, int row) {
        return null;
    }

    public Object getColValue(Class c, int col) {
        return null;
    }

    public void addSingleValue(Object v) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object getSingleValue(Class c) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected class IonRTMoZRow {
        long _peptideId;
        String _peptideSequence;
        int _charge;
        float _eTimeFrom;
        float[] _deltaTimeTo;
        int _MatchCountFrom;
        int[] _MatchCountTo;
        double _moz;
        double _deltaMoz;

        public IonRTMoZRow(long peptideId, String peptideSequence, int charge, double moz, double delaMoz, float eTimeFrom, float[] eTimeTo, int matchCountFrom, int[] matchCountTo) {
            this._peptideId = peptideId;
            this._peptideSequence = peptideSequence;
            this._charge = charge;
            this._eTimeFrom = eTimeFrom;
            this._deltaTimeTo = eTimeTo;
            this._moz = moz;
            this._deltaMoz = delaMoz;
            this._MatchCountFrom = matchCountFrom;
            this._MatchCountTo = matchCountTo;
        }

        public String toString() {
            Object s = "";
            for (float f : this._deltaTimeTo) {
                s = (String)s + ";" + f;
            }
            return this._peptideId + ";" + this._peptideSequence + ";" + this._charge + ";" + this._eTimeFrom + (String)s;
        }
    }
}

