/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.tree.xic;

import fr.proline.studio.dam.data.AbstractData;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.utils.IconManager;
import javax.swing.ImageIcon;

public class DatasetReferenceNode
extends AbstractNode {
    private boolean m_invalidReference = false;
    private boolean m_isAggregation;

    public DatasetReferenceNode(AbstractData data) {
        super(AbstractNode.NodeTypes.DATASET_REFERENCE, data);
        this.m_isAggregation = false;
    }

    public DatasetReferenceNode(AbstractData data, boolean isAggragation) {
        super(AbstractNode.NodeTypes.DATASET_REFERENCE, data);
        this.m_isAggregation = isAggragation;
    }

    public void setInvalidReference(boolean isIncorrect) {
        this.m_invalidReference = isIncorrect;
    }

    public boolean isInvalidReference() {
        return this.m_invalidReference;
    }

    @Override
    public String toString() {
        if (this.m_isAggregation) {
            return super.toString();
        }
        return "Identification reference : " + super.toString();
    }

    @Override
    public ImageIcon getIcon(boolean expanded) {
        if (this.m_invalidReference) {
            return this.getIcon(IconManager.IconType.REFERENCE_RSM_ERR);
        }
        if (this.m_isAggregation) {
            return this.getIcon(IconManager.IconType.REFERENCE_AGRRE);
        }
        return this.getIcon(IconManager.IconType.REFERENCE_RSM);
    }

    @Override
    public AbstractNode copyNode() {
        return new DatasetReferenceNode(this.getData());
    }

    @Override
    public boolean canBeDeleted() {
        return false;
    }
}

