/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.tree.xic;

import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.dam.data.AbstractData;
import fr.proline.studio.dam.data.DataSetData;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import fr.proline.studio.rsmexplorer.tree.xic.XICRunNode;
import fr.proline.studio.utils.IconManager;
import javax.swing.ImageIcon;
import javax.swing.tree.MutableTreeNode;

public class XICBiologicalSampleAnalysisNode
extends DataSetNode {
    private String m_qcName;
    private Long m_quantLabelId;
    private XICRunNode m_xicRunNode;
    private SpectrumVerificationStatus m_verificationStatus;

    public XICBiologicalSampleAnalysisNode(AbstractData data) {
        super(AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE_ANALYSIS, data);
        this.m_qcName = data.getName();
        this.m_verificationStatus = SpectrumVerificationStatus.NOT_VERIFIED;
    }

    public void setVerificationStatus(SpectrumVerificationStatus status) {
        this.m_verificationStatus = status;
    }

    public SpectrumVerificationStatus getVerificationStatus() {
        return this.m_verificationStatus;
    }

    public void addXicRunNode(XICRunNode xicRunNode, boolean addToChild) {
        this.m_xicRunNode = xicRunNode;
        if (addToChild) {
            super.add(this.m_xicRunNode);
        }
    }

    @Override
    public void add(MutableTreeNode newChild) {
        if (!(newChild instanceof XICRunNode)) {
            throw new IllegalArgumentException("BiologicalSampleAnalysisNode only accept RunNode as child. (invalid " + newChild + " node )");
        }
        this.m_xicRunNode = (XICRunNode)newChild;
        super.add(this.m_xicRunNode);
    }

    public XICRunNode getXicRunNode() {
        return this.m_xicRunNode;
    }

    public void setQuantChannelName(String qcName) {
        this.m_qcName = qcName;
    }

    public String getQuantChannelName() {
        return this.m_qcName;
    }

    public Long getQuantLabelId() {
        return this.m_quantLabelId;
    }

    public void setQuantLabelId(Long quantLabelId) {
        this.m_quantLabelId = quantLabelId;
    }

    @Override
    public String getToolTipText() {
        AbstractNode childNode;
        int nbChild = this.getChildCount();
        if (nbChild == 1 && (childNode = (AbstractNode)this.getChildAt(0)).getType() == AbstractNode.NodeTypes.RUN) {
            String peakList = ((XICRunNode)childNode).getPeakListPath();
            if (peakList == null) {
                return null;
            }
            return "PeakList : " + peakList;
        }
        return null;
    }

    @Override
    public boolean hasResultSummary() {
        DDataset dataSet = ((DataSetData)this.getData()).getDataset();
        if (dataSet == null) {
            return false;
        }
        return dataSet.getResultSummaryId() != null;
    }

    @Override
    public ImageIcon getIcon(boolean expanded) {
        return this.getIcon(IconManager.IconType.DATASET_RSM);
    }

    @Override
    public AbstractNode copyNode() {
        return null;
    }

    @Override
    public void loadDataForProperties(Runnable callback) {
        super.loadDataForProperties(callback);
    }

    @Override
    public boolean canBeDeleted() {
        return true;
    }

    @Override
    public String toString() {
        if (this.m_qcName != null && !this.m_qcName.trim().isEmpty()) {
            return this.m_qcName;
        }
        return super.toString();
    }

    public static enum SpectrumVerificationStatus {
        NOT_VERIFIED,
        SUCCESSFULLY_VERIFIED,
        UNSUCCESSFULLY_VERIFIED;

    }
}

