/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.table;

import fr.proline.core.orm.msi.Peptide;
import fr.proline.core.orm.msi.dto.DPeptideInstance;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DPeptidePTM;
import fr.proline.studio.dam.tasks.data.ProjectInfo;
import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.export.ExportModelUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.poi.hssf.util.HSSFColor;

public class ExportFontModelUtilities
extends ExportModelUtilities {
    public static ArrayList<ExportFontData> getExportFonts(DPeptideMatch peptideMatch) {
        HashMap ptmMap;
        Peptide peptide = peptideMatch.getPeptide();
        if (peptide.getTransientData() != null && (ptmMap = peptide.getTransientData().getDPeptidePtmMap()) != null) {
            ArrayList<ExportFontData> ExportFontDatas = new ArrayList<ExportFontData>();
            String sequence = peptide.getSequence();
            int nb = sequence.length();
            for (int i = 0; i < nb; ++i) {
                ExportFontData newSubStringFont;
                boolean aminoAcidModification;
                DPeptidePTM cterPtm;
                boolean nTerOrCterModification = false;
                if (i == 0) {
                    DPeptidePTM nterPtm = (DPeptidePTM)ptmMap.get(0);
                    if (nterPtm != null) {
                        nTerOrCterModification = true;
                    }
                } else if (i == nb - 1 && (cterPtm = (DPeptidePTM)ptmMap.get(-1)) != null) {
                    nTerOrCterModification = true;
                }
                DPeptidePTM ptm = (DPeptidePTM)ptmMap.get(i + 1);
                boolean bl = aminoAcidModification = ptm != null;
                if (!nTerOrCterModification && !aminoAcidModification) continue;
                if (nTerOrCterModification && aminoAcidModification) {
                    newSubStringFont = new ExportFontData(i, i + 1, HSSFColor.HSSFColorPredefined.VIOLET.getIndex());
                    ExportFontDatas.add(newSubStringFont);
                    continue;
                }
                if (nTerOrCterModification) {
                    newSubStringFont = new ExportFontData(i, i + 1, HSSFColor.HSSFColorPredefined.GREEN.getIndex());
                    ExportFontDatas.add(newSubStringFont);
                    continue;
                }
                if (!aminoAcidModification) continue;
                newSubStringFont = new ExportFontData(i, i + 1, HSSFColor.HSSFColorPredefined.ORANGE.getIndex());
                ExportFontDatas.add(newSubStringFont);
            }
            return ExportFontDatas;
        }
        return null;
    }

    public static ArrayList<ExportFontData> getExportFonts(DPeptideInstance peptideInstance) {
        if (peptideInstance != null && peptideInstance.getBestPeptideMatch() != null) {
            return ExportFontModelUtilities.getExportFonts(peptideInstance.getBestPeptideMatch());
        }
        return null;
    }

    public static ArrayList<ExportFontData> getExportFonts(String projectIds, HashMap<String, ProjectInfo.Status> projectStatusMap) {
        if (projectIds != null && projectStatusMap != null) {
            ArrayList<ExportFontData> exportFontDatas = new ArrayList<ExportFontData>();
            String[] ids = projectIds.split(",");
            int start = 0;
            int stop = 0;
            for (String id : ids) {
                ProjectInfo.Status status = projectStatusMap.get(id);
                stop = start + id.length();
                exportFontDatas.add(new ExportFontData(start, stop, switch (status) {
                    case ProjectInfo.Status.ARCHIVED -> HSSFColor.HSSFColorPredefined.GREY_50_PERCENT.getIndex();
                    case ProjectInfo.Status.INACTIVE -> HSSFColor.HSSFColorPredefined.BLUE.getIndex();
                    default -> HSSFColor.HSSFColorPredefined.BLACK.getIndex();
                }));
                start = stop + 1;
            }
            return exportFontDatas;
        }
        return null;
    }
}

