/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.data;

import fr.proline.core.orm.msi.MsiSearch;
import fr.proline.core.orm.msi.ResultSet;
import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.msi.SearchSetting;
import fr.proline.core.orm.uds.Dataset;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.core.orm.uds.dto.DDatasetType;
import fr.proline.core.orm.util.DStoreCustomPoolConnectorFactory;
import fr.proline.core.orm.util.TransientDataAllocationListener;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.data.AbstractData;
import fr.proline.studio.dam.memory.TransientMemoryCacheManager;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseDataSetTask;
import fr.proline.studio.dam.tasks.xic.DatabaseLoadXicMasterQuantTask;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;

public class DataSetData
extends AbstractData {
    private DDataset m_dataset = null;
    private String m_temporaryName = null;
    private DDatasetType m_temporaryDatasetType = null;
    private Integer m_channelNumber = null;

    public Integer getChannelNumber() {
        return this.m_channelNumber;
    }

    public void setChannelNumber(Integer m_channelNumber) {
        this.m_channelNumber = m_channelNumber;
    }

    public static DataSetData createTemporaryFolder(String name) {
        DDatasetType type = new DDatasetType(null, Dataset.DatasetType.IDENTIFICATION_FOLDER, null, null);
        return new DataSetData(name, type);
    }

    public static DataSetData createTemporaryIdentification(String name) {
        DDatasetType type = new DDatasetType(null, Dataset.DatasetType.IDENTIFICATION, null, null);
        return new DataSetData(name, type);
    }

    public static DataSetData createTemporaryAggregate(String name) {
        DDatasetType type = new DDatasetType(null, Dataset.DatasetType.AGGREGATE, null, null);
        return new DataSetData(name, type);
    }

    public static DataSetData createTemporaryQuantitation(String name) {
        DDatasetType type = new DDatasetType(null, Dataset.DatasetType.QUANTITATION, null, null);
        return new DataSetData(name, type);
    }

    public DataSetData(DDataset dataSet) {
        this.m_dataType = AbstractData.DataTypes.DATA_SET;
        this.m_dataset = dataSet;
    }

    private DataSetData(String temporaryName, DDatasetType temporaryType) {
        this.m_dataType = AbstractData.DataTypes.DATA_SET;
        this.m_temporaryName = temporaryName;
        this.m_temporaryDatasetType = temporaryType;
    }

    public DDataset getDataset() {
        return this.m_dataset;
    }

    public void setDataset(DDataset dataset) {
        this.m_dataset = dataset;
        this.m_temporaryName = null;
        this.m_temporaryDatasetType = null;
    }

    @Override
    public boolean hasChildren() {
        if (this.m_dataset != null) {
            return this.m_dataset.getChildrenCount() > 0;
        }
        return false;
    }

    @Override
    public String getName() {
        if (this.m_dataset == null) {
            if (this.m_temporaryName != null) {
                return this.m_temporaryName;
            }
            return "";
        }
        return this.m_dataset.getName();
    }

    public void setTemporaryName(String name) {
        this.m_temporaryName = name;
    }

    public String getTemporaryName() {
        return this.m_temporaryName;
    }

    public String toString() {
        return this.getName();
    }

    public DDatasetType getDatasetType() {
        if (this.m_dataset == null) {
            return this.m_temporaryDatasetType;
        }
        return this.m_dataset.getType();
    }

    @Override
    public void load(AbstractDatabaseCallback callback, List<AbstractData> list, AbstractDatabaseTask.Priority priority, boolean identificationDataset) {
        if (!identificationDataset && this.m_dataset.getType().getQuantMethodInfo() == DDatasetType.QuantitationMethodInfo.FEATURES_EXTRACTION || this.m_dataset.getType().getQuantMethodInfo().equals((Object)DDatasetType.QuantitationMethodInfo.ISOBARIC_TAGGING)) {
            DatabaseLoadXicMasterQuantTask task = new DatabaseLoadXicMasterQuantTask(callback);
            task.initLoadQuantChannels(this.m_dataset.getProject().getId(), this.m_dataset);
            AccessDatabaseThread.getAccessDatabaseThread().addTask(task);
        } else {
            DatabaseDataSetTask task = new DatabaseDataSetTask(callback);
            task.initLoadChildrenDataset(this.m_dataset, list, identificationDataset);
            if (priority != null) {
                task.setPriority(priority);
            }
            AccessDatabaseThread.getAccessDatabaseThread().addTask(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fetchRsetAndRsmForOneDataset(DDataset d) {
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(d.getProject().getId()).createEntityManager();){
            Long rsmId;
            entityManagerMSI.getTransaction().begin();
            Long rsetId = d.getResultSetId();
            if (rsetId != null) {
                ResultSet rsetFound = (ResultSet)entityManagerMSI.find(ResultSet.class, (Object)rsetId);
                MsiSearch msiSearch = rsetFound.getMsiSearch();
                if (msiSearch != null) {
                    SearchSetting searchSetting = msiSearch.getSearchSetting();
                    Set enzymeSet = searchSetting.getEnzymes();
                    Iterator it = enzymeSet.iterator();
                    while (it.hasNext()) {
                        it.next();
                    }
                    Set searchSettingsSeqDatabaseMapSet = searchSetting.getSearchSettingsSeqDatabaseMaps();
                    Iterator itSeqDbMap = searchSettingsSeqDatabaseMapSet.iterator();
                    while (itSeqDbMap.hasNext()) {
                        itSeqDbMap.next();
                    }
                }
                d.setResultSet(rsetFound);
            }
            if ((rsmId = d.getResultSummaryId()) != null) {
                ResultSummary rsmFound = (ResultSummary)entityManagerMSI.find(ResultSummary.class, (Object)rsmId);
                rsmFound.getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).setDDataset(d);
                d.setResultSummary(rsmFound);
            }
            entityManagerMSI.getTransaction().commit();
        }
    }
}

