/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.data;

import java.util.HashMap;

public enum SelectLevelEnum {
    DESELECTED_MANUAL(0, "Invalidated manually"),
    DESELECTED_AUTO(1, "Invalidated automatically"),
    SELECTED_AUTO(2, "Validated automatically"),
    SELECTED_MANUAL(3, "Validated Manual"),
    UNKNOWN(-1, "Invalid (not quantified)"),
    RESET_AUTO(-2, "Reset auto");

    private int _intValue;
    private String _description;
    private static HashMap<Integer, SelectLevelEnum> map;

    private SelectLevelEnum(int value, String description) {
        this._intValue = value;
        this._description = description;
    }

    public boolean isSelected() {
        return this.equals((Object)SELECTED_AUTO) || this.equals((Object)SELECTED_MANUAL);
    }

    public boolean isDeselected() {
        return this.equals((Object)DESELECTED_AUTO) || this.equals((Object)DESELECTED_MANUAL);
    }

    public int getIntValue() {
        return this._intValue;
    }

    public String getDescription() {
        return this._description;
    }

    public static SelectLevelEnum valueOf(int status) {
        return map.get(status);
    }

    static {
        map = new HashMap();
        for (SelectLevelEnum status : SelectLevelEnum.values()) {
            map.put(status._intValue, status);
        }
    }
}

