/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.tasks;

import fr.proline.core.orm.msi.dto.DBioSequence;
import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.core.orm.util.DStoreCustomPoolConnectorFactory;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.Query;

public class DatabaseBioSequenceTask {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean fetchData(List<DProteinMatch> proteinMatchList, Long projectId) {
        Map<Long, DProteinMatch> proteinMatchById = proteinMatchList.stream().collect(Collectors.toMap(pm -> pm.getId(), pm -> pm));
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(projectId.longValue()).createEntityManager();){
            Query query = entityManagerMSI.createQuery("SELECT pm.id, bs.sequence, bs.mass, bs.pi FROM fr.proline.core.orm.msi.ProteinMatch pm, fr.proline.core.orm.msi.BioSequence bs WHERE bs.id = pm.bioSequenceId AND pm.id IN (:proteinMatchIds)");
            query.setParameter("proteinMatchIds", proteinMatchById.keySet());
            for (Object[] resCur : query.getResultList()) {
                Long proteinMatchId = (Long)resCur[0];
                String sequence = (String)resCur[1];
                Integer mass = (Integer)resCur[2];
                Float pI = (Float)resCur[3];
                proteinMatchById.get(proteinMatchId).setDBioSequence(new DBioSequence(sequence, (double)mass.intValue(), (double)pI.floatValue()));
            }
        }
        return true;
    }
}

