/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.tasks;

import fr.proline.core.orm.msi.Peptide;
import fr.proline.core.orm.msi.PeptideInstance;
import fr.proline.core.orm.msi.PeptideReadablePtmString;
import fr.proline.core.orm.msi.ResultSet;
import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.msi.SequenceMatch;
import fr.proline.core.orm.msi.dto.DMsQuery;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DPeptideSet;
import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.core.orm.msi.dto.DProteinSet;
import fr.proline.core.orm.msi.dto.DSpectrum;
import fr.proline.core.orm.util.DStoreCustomPoolConnectorFactory;
import fr.proline.core.orm.util.TransientDataAllocationListener;
import fr.proline.studio.dam.memory.TransientMemoryCacheManager;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseSlicerTask;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabasePTMsTask;
import fr.proline.studio.dam.tasks.SubTask;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.commons.lang3.tuple.Pair;

public class DatabaseLoadPeptideMatchTask
extends AbstractDatabaseSlicerTask {
    private static final int SLICE_SIZE = 1000;
    public static final int SUB_TASK_PEPTIDE_MATCH = 0;
    public static final int SUB_TASK_PEPTIDE = 1;
    public static final int SUB_TASK_MSQUERY = 2;
    public static final int SUB_TASK_PROTEINSET_NAME_LIST = 3;
    public static final int SUB_TASK_SRC_DAT_FILE = 4;
    public static final int SUB_TASK_COUNT_RSET = 5;
    public static final int SUB_TASK_COUNT_RSM = 5;
    private long m_projectId = -1L;
    private ResultSet m_rset = null;
    private ResultSummary m_rsm = null;
    private DProteinMatch m_proteinMatch = null;
    private DProteinSet m_proteinSet = null;
    private PeptideInstance m_peptideInstance = null;
    private DMsQuery m_msQuery = null;
    private List<DPeptideMatch> m_listPeptideMatches = null;
    private List<Long> m_peptideMatchIds = null;
    private Map<Long, DPeptideMatch> m_peptideMatchMap = null;
    private Map<Long, List<DPeptideMatch>> m_peptideMatchSequenceMatchArrayMap = null;
    private Map<Long, Integer> m_peptideMatchPosition = null;
    private final int m_action;
    private static final int LOAD_ALL_RSET = 0;
    private static final int LOAD_ALL_RSM = 1;
    private static final int LOAD_PEPTIDES_FOR_PROTEIN_RSET = 2;
    private static final int LOAD_PSM_FOR_PROTEIN_SET_RSM = 3;
    private static final int LOAD_PSM_FOR_PEPTIDE_RSM = 4;
    private static final int LOAD_PSM_FOR_MSQUERY = 5;

    public DatabaseLoadPeptideMatchTask(AbstractDatabaseCallback callback, long projectId, ResultSet rset) {
        super(callback, 5, new TaskInfo("Load Peptide Matches for Search Result " + rset.getId(), false, "Database Access", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_projectId = projectId;
        this.m_rset = rset;
        this.m_action = 0;
    }

    public DatabaseLoadPeptideMatchTask(AbstractDatabaseCallback callback, long projectId, ResultSet rset, DProteinMatch proteinMatch) {
        super(callback, 5, new TaskInfo("Load Peptide Matches for Protein Match " + proteinMatch.getAccession(), false, "Database Access", TaskInfo.INFO_IMPORTANCE_LOW));
        this.m_projectId = projectId;
        this.m_rset = rset;
        this.m_proteinMatch = proteinMatch;
        this.m_action = 2;
    }

    public DatabaseLoadPeptideMatchTask(AbstractDatabaseCallback callback, long projectId, ResultSummary rsm) {
        super(callback, 5, new TaskInfo("Load Peptide Matches for Identification Summary " + rsm.getId(), false, "Database Access", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_projectId = projectId;
        this.m_rsm = rsm;
        this.m_action = 1;
    }

    public DatabaseLoadPeptideMatchTask(AbstractDatabaseCallback callback, long projectId, ResultSummary rsm, DProteinSet proteinSet) {
        super(callback, 5, new TaskInfo("Load Peptide Matches for Protein Set " + proteinSet.getTypicalProteinMatch().getAccession(), false, "Database Access", TaskInfo.INFO_IMPORTANCE_LOW));
        this.m_projectId = projectId;
        this.m_rsm = rsm;
        this.m_proteinSet = proteinSet;
        this.m_action = 3;
    }

    public DatabaseLoadPeptideMatchTask(AbstractDatabaseCallback callback, long projectId, PeptideInstance pi) {
        super(callback, 5, new TaskInfo("Load PSM for Peptide " + pi.getTransientData().getBestPeptideMatch().getPeptide().getSequence(), false, "Database Access", TaskInfo.INFO_IMPORTANCE_LOW));
        this.m_projectId = projectId;
        this.m_peptideInstance = pi;
        this.m_rsm = pi.getResultSummary();
        this.m_action = 4;
    }

    public DatabaseLoadPeptideMatchTask(AbstractDatabaseCallback callback, long projectId, DMsQuery msQuery, ResultSummary rsm, ResultSet rs, List<DPeptideMatch> listPeptideMatches) {
        super(callback, 5, new TaskInfo("Load PSM for MsQuery " + (Serializable)(msQuery == null ? "null" : Long.valueOf(msQuery.getId())), false, "Database Access", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_projectId = projectId;
        this.m_msQuery = msQuery;
        this.m_rsm = rsm;
        this.m_rset = rs;
        this.m_listPeptideMatches = listPeptideMatches;
        this.m_action = 5;
    }

    @Override
    public void abortTask() {
        super.abortTask();
        switch (this.m_action) {
            case 0: {
                this.m_rset.getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).setPeptideMatchIds(null);
                this.m_rset.getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).setPeptideMatches(null);
                break;
            }
            case 1: {
                this.m_rsm.getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).setPeptideMatches(null);
                this.m_rsm.getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).setPeptideMatchesId(null);
                break;
            }
            case 2: {
                this.m_proteinMatch.setPeptideMatches(null);
                this.m_proteinMatch.setPeptideMatchesId(null);
                break;
            }
            case 3: {
                this.m_proteinSet.getTypicalProteinMatch().setPeptideMatches(null);
                break;
            }
            case 4: {
                this.m_peptideInstance.getTransientData().setPeptideMatches(null);
                this.m_peptideInstance.getTransientData().setPeptideMatchesId(null);
                break;
            }
            case 5: {
                this.m_listPeptideMatches = null;
            }
        }
    }

    @Override
    public boolean needToFetch() {
        switch (this.m_action) {
            case 0: {
                return this.m_rset.getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).getPeptideMatchIds() == null;
            }
            case 1: {
                return this.m_rsm.getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).getPeptideMatches() == null;
            }
            case 2: {
                return this.m_proteinMatch.getPeptideMatches() == null;
            }
            case 3: {
                return this.m_proteinSet.getTypicalProteinMatch().getPeptideMatches() == null;
            }
            case 4: {
                return this.m_peptideInstance.getTransientData().getPeptideMatches() == null;
            }
            case 5: {
                return this.m_listPeptideMatches == null || this.m_listPeptideMatches.isEmpty();
            }
        }
        return false;
    }

    @Override
    public boolean fetchData() {
        if (this.needToFetch()) {
            switch (this.m_action) {
                case 0: {
                    return this.fetchAllRsetMainTask();
                }
                case 1: {
                    return this.fetchAllRsmMainTask();
                }
                case 2: {
                    return this.fetchPeptidesForProteinRsetMainTask();
                }
                case 3: {
                    return this.fetchPeptidesForProteinSetRsmMainTask();
                }
                case 4: {
                    return this.fetchPSMForPeptideInstanceMainTask();
                }
                case 5: {
                    return this.fetchPSMForMsQueryMainTask();
                }
            }
            return false;
        }
        return this.fetchDataSubTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fetchAllRsetMainTask() {
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectId).createEntityManager();){
            entityManagerMSI.getTransaction().begin();
            Long rsetId = this.m_rset.getId();
            TypedQuery peptideMatchIdQuery = entityManagerMSI.createQuery("SELECT pm.id FROM PeptideMatch pm, fr.proline.core.orm.msi.Peptide p, MsQuery msq WHERE pm.resultSet.id=:rsetId AND pm.peptideId=p.id AND pm.msQuery=msq ORDER BY msq.initialId ASC, p.sequence ASC", Long.class);
            peptideMatchIdQuery.setParameter("rsetId", (Object)rsetId);
            List peptideMatchIds = peptideMatchIdQuery.getResultList();
            this.m_peptideMatchIds = new ArrayList<Long>(peptideMatchIds);
            long[] peptideMatchIdsArray = new long[this.m_peptideMatchIds.size()];
            this.m_peptideMatchPosition = new HashMap<Long, Integer>();
            for (int i = 0; i < peptideMatchIdsArray.length; ++i) {
                Long id = this.m_peptideMatchIds.get(i);
                peptideMatchIdsArray[i] = id;
                this.m_peptideMatchPosition.put(id, i);
            }
            this.m_rset.getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).setPeptideMatchIds(peptideMatchIdsArray);
            int nb = peptideMatchIds.size();
            DPeptideMatch[] peptideMatchArray = new DPeptideMatch[nb];
            this.m_rset.getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).setPeptideMatches(peptideMatchArray);
            int nbPeptideMatch = this.m_peptideMatchIds.size();
            if (nbPeptideMatch > 0) {
                boolean mergedData;
                SubTask subTask = this.m_subTaskManager.sliceATaskAndGetFirst(0, nbPeptideMatch, 1000);
                this.fetchPeptideMatch(entityManagerMSI, subTask);
                subTask = this.m_subTaskManager.sliceATaskAndGetFirst(1, nbPeptideMatch, 1000);
                this.fetchPeptide(entityManagerMSI, subTask);
                subTask = this.m_subTaskManager.sliceATaskAndGetFirst(2, nbPeptideMatch, 1000);
                DatabaseLoadPeptideMatchTask.fetchMsQuery(entityManagerMSI, subTask, this.m_peptideMatchIds, this.m_proteinMatch, this.m_peptideMatchSequenceMatchArrayMap, this.m_peptideMatchMap);
                ResultSet.Type rsType = this.m_rset.getType();
                boolean bl = mergedData = rsType == ResultSet.Type.USER || rsType == ResultSet.Type.DECOY_USER;
                if (mergedData) {
                    subTask = this.m_subTaskManager.sliceATaskAndGetFirst(4, nbPeptideMatch, 1000);
                    this.fetchSrcDatFile(entityManagerMSI, subTask);
                }
            }
            entityManagerMSI.getTransaction().commit();
        }
        this.m_defaultPriority = AbstractDatabaseTask.Priority.LOW;
        this.m_currentPriority = AbstractDatabaseTask.Priority.LOW;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fetchPeptidesForProteinRsetMainTask() {
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectId).createEntityManager();){
            boolean mergedData;
            entityManagerMSI.getTransaction().begin();
            TypedQuery peptideMatchQuery = entityManagerMSI.createQuery("SELECT new fr.proline.core.orm.msi.dto.DPeptideMatch(pm.id, pm.rank, pm.charge, pm.deltaMoz, pm.experimentalMoz, pm.missedCleavage, pm.score, pm.resultSet.id, pm.cdPrettyRank, pm.sdPrettyRank, pm.isDecoy, pm.serializedProperties) FROM PeptideMatch pm,  fr.proline.core.orm.msi.Peptide p, SequenceMatch sm WHERE sm.id.proteinMatchId=:proteinId AND sm.bestPeptideMatchId=pm.id AND pm.peptideId=p.id ORDER BY pm.msQuery.initialId ASC, p.sequence ASC", DPeptideMatch.class);
            peptideMatchQuery.setParameter("proteinId", (Object)this.m_proteinMatch.getId());
            Pair<long[], DPeptideMatch[]> matches = this.toArray(peptideMatchQuery);
            DPeptideMatch[] peptideMatchArray = (DPeptideMatch[])matches.getRight();
            long[] peptideMatchArrayIds = (long[])matches.getLeft();
            this.m_proteinMatch.setPeptideMatchesId(peptideMatchArrayIds);
            this.m_proteinMatch.setPeptideMatches(peptideMatchArray);
            this.m_peptideMatchIds = Arrays.stream(peptideMatchArrayIds).boxed().collect(Collectors.toList());
            this.m_peptideMatchSequenceMatchArrayMap = Arrays.stream(peptideMatchArray).collect(Collectors.groupingBy(pm -> pm.getId()));
            SubTask subTask = this.m_subTaskManager.sliceATaskAndGetFirst(1, peptideMatchArray.length, 1000);
            this.fetchPeptide(entityManagerMSI, subTask);
            subTask = this.m_subTaskManager.sliceATaskAndGetFirst(2, peptideMatchArray.length, 1000);
            DatabaseLoadPeptideMatchTask.fetchMsQuery(entityManagerMSI, subTask, this.m_peptideMatchIds, this.m_proteinMatch, this.m_peptideMatchSequenceMatchArrayMap, this.m_peptideMatchMap);
            ResultSet.Type rsType = this.m_rset.getType();
            boolean bl = mergedData = rsType == ResultSet.Type.USER || rsType == ResultSet.Type.DECOY_USER;
            if (mergedData) {
                subTask = this.m_subTaskManager.sliceATaskAndGetFirst(4, peptideMatchArray.length, 1000);
                this.fetchSrcDatFile(entityManagerMSI, subTask);
            }
            entityManagerMSI.getTransaction().commit();
        }
        this.m_defaultPriority = AbstractDatabaseTask.Priority.LOW;
        this.m_currentPriority = AbstractDatabaseTask.Priority.LOW;
        return true;
    }

    private Pair<long[], DPeptideMatch[]> toArray(TypedQuery peptideMatchQuery) {
        List resultList = peptideMatchQuery.getResultList();
        DPeptideMatch[] peptideMatchArray = new DPeptideMatch[resultList.size()];
        long[] peptideMatchIds = new long[resultList.size()];
        Iterator it = resultList.iterator();
        int index = 0;
        while (it.hasNext()) {
            DPeptideMatch pm = (DPeptideMatch)it.next();
            peptideMatchIds[index] = pm.getId();
            peptideMatchArray[index++] = pm;
        }
        return Pair.of((Object)peptideMatchIds, (Object)peptideMatchArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fetchAllRsmMainTask() {
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectId).createEntityManager();){
            entityManagerMSI.getTransaction().begin();
            Long rsmId = this.m_rsm.getId();
            TypedQuery peptideMatchQuery = entityManagerMSI.createQuery("SELECT new fr.proline.core.orm.msi.dto.DPeptideMatch(pm.id, pm.rank, pm.charge, pm.deltaMoz, pm.experimentalMoz, pm.missedCleavage, pm.score, pm.resultSet.id, pm.cdPrettyRank, pm.sdPrettyRank, pm.isDecoy, pm.serializedProperties) FROM fr.proline.core.orm.msi.PeptideMatch pm, fr.proline.core.orm.msi.PeptideInstancePeptideMatchMap pipm, fr.proline.core.orm.msi.Peptide p WHERE pipm.resultSummary.id=:rsmId AND pipm.id.peptideMatchId=pm.id AND pm.peptideId=p.id ORDER BY pm.msQuery.initialId ASC, p.sequence ASC", DPeptideMatch.class);
            peptideMatchQuery.setParameter("rsmId", (Object)rsmId);
            Pair<long[], DPeptideMatch[]> matches = this.toArray(peptideMatchQuery);
            DPeptideMatch[] peptideMatchArray = (DPeptideMatch[])matches.getRight();
            long[] peptideMatchArrayIds = (long[])matches.getLeft();
            this.m_rsm.getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).setPeptideMatches(peptideMatchArray);
            this.m_rsm.getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).setPeptideMatchesId(peptideMatchArrayIds);
            this.m_peptideMatchIds = Arrays.stream(peptideMatchArrayIds).boxed().collect(Collectors.toList());
            this.m_peptideMatchMap = Arrays.stream(peptideMatchArray).collect(Collectors.toMap(pm -> pm.getId(), pm -> pm));
            if (peptideMatchArray.length > 0) {
                boolean mergedData;
                SubTask subTask = this.m_subTaskManager.sliceATaskAndGetFirst(1, peptideMatchArray.length, 1000);
                this.fetchPeptide(entityManagerMSI, subTask);
                subTask = this.m_subTaskManager.sliceATaskAndGetFirst(2, peptideMatchArray.length, 1000);
                DatabaseLoadPeptideMatchTask.fetchMsQuery(entityManagerMSI, subTask, this.m_peptideMatchIds, this.m_proteinMatch, this.m_peptideMatchSequenceMatchArrayMap, this.m_peptideMatchMap);
                subTask = this.m_subTaskManager.sliceATaskAndGetFirst(3, peptideMatchArray.length, 1000);
                this.fetchProteinSetName(entityManagerMSI, subTask);
                ResultSet.Type rsType = this.m_rsm.getResultSet().getType();
                boolean bl = mergedData = rsType == ResultSet.Type.USER || rsType == ResultSet.Type.DECOY_USER;
                if (mergedData) {
                    subTask = this.m_subTaskManager.sliceATaskAndGetFirst(4, peptideMatchArray.length, 1000);
                    this.fetchSrcDatFile(entityManagerMSI, subTask);
                }
            }
            entityManagerMSI.getTransaction().commit();
        }
        this.m_defaultPriority = AbstractDatabaseTask.Priority.LOW;
        this.m_currentPriority = AbstractDatabaseTask.Priority.LOW;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchPeptidesForProteinSetRsmMainTask() {
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectId).createEntityManager();){
            DProteinMatch typicalProteinMatch;
            entityManagerMSI.getTransaction().begin();
            Long rsmId = this.m_rsm.getId();
            this.m_proteinMatch = typicalProteinMatch = this.m_proteinSet.getTypicalProteinMatch();
            DPeptideSet peptideSet = typicalProteinMatch.getPeptideSet(rsmId);
            if (peptideSet == null) {
                TypedQuery peptideSetQuery = entityManagerMSI.createQuery("SELECT new fr.proline.core.orm.msi.dto.DPeptideSet(ps.id, ps.score, ps.sequenceCount, ps.peptideCount, ps.peptideMatchCount, ps.resultSummaryId) FROM PeptideSet ps, PeptideSetProteinMatchMap ps_to_pm WHERE ps_to_pm.id.proteinMatchId=:proteinMatchId AND ps_to_pm.id.peptideSetId=ps.id AND ps_to_pm.resultSummary.id=:rsmId", DPeptideSet.class);
                peptideSetQuery.setParameter("proteinMatchId", (Object)typicalProteinMatch.getId());
                peptideSetQuery.setParameter("rsmId", (Object)rsmId);
                peptideSet = (DPeptideSet)peptideSetQuery.getSingleResult();
                typicalProteinMatch.setPeptideSet(rsmId, peptideSet);
            }
            TypedQuery psmQuery = entityManagerMSI.createQuery("SELECT new fr.proline.core.orm.msi.dto.DPeptideMatch(pm.id, pm.rank, pm.charge, pm.deltaMoz, pm.experimentalMoz, pm.missedCleavage, pm.score, pm.resultSet.id, pm.cdPrettyRank, pm.sdPrettyRank, pm.isDecoy, pm.serializedProperties) FROM fr.proline.core.orm.msi.PeptideInstance pi, fr.proline.core.orm.msi.PeptideSetPeptideInstanceItem ps_to_pi, fr.proline.core.orm.msi.PeptideMatch pm, fr.proline.core.orm.msi.PeptideInstancePeptideMatchMap pipm WHERE ps_to_pi.peptideSet.id=:peptideSetId AND ps_to_pi.peptideInstance.id=pi.id AND pipm.resultSummary.id=:rsmId AND pipm.id.peptideMatchId=pm.id AND pipm.id.peptideInstanceId=pi.id ORDER BY pm.score DESC", DPeptideMatch.class);
            psmQuery.setParameter("peptideSetId", (Object)peptideSet.getId());
            psmQuery.setParameter("rsmId", (Object)rsmId);
            Pair<long[], DPeptideMatch[]> matches = this.toArray(psmQuery);
            DPeptideMatch[] peptideMatchArray = (DPeptideMatch[])matches.getRight();
            long[] peptideMatchArrayIds = (long[])matches.getLeft();
            typicalProteinMatch.setPeptideMatches(peptideMatchArray);
            typicalProteinMatch.setPeptideMatchesId((long[])matches.getLeft());
            this.m_peptideMatchIds = Arrays.stream(peptideMatchArrayIds).boxed().collect(Collectors.toList());
            this.m_peptideMatchSequenceMatchArrayMap = Arrays.stream(peptideMatchArray).collect(Collectors.groupingBy(pm -> pm.getId()));
            this.m_peptideMatchMap = Arrays.stream(peptideMatchArray).collect(Collectors.toMap(pm -> pm.getId(), pm -> pm));
            if (peptideMatchArray.length > 0) {
                boolean mergedData;
                SubTask subTask = this.m_subTaskManager.sliceATaskAndGetFirst(1, peptideMatchArray.length, 1000);
                this.fetchPeptide(entityManagerMSI, subTask);
                subTask = this.m_subTaskManager.sliceATaskAndGetFirst(2, peptideMatchArray.length, 1000);
                DatabaseLoadPeptideMatchTask.fetchMsQuery(entityManagerMSI, subTask, this.m_peptideMatchIds, this.m_proteinMatch, this.m_peptideMatchSequenceMatchArrayMap, this.m_peptideMatchMap);
                subTask = this.m_subTaskManager.sliceATaskAndGetFirst(3, peptideMatchArray.length, 1000);
                this.fetchProteinSetName(entityManagerMSI, subTask);
                ResultSet.Type rsType = this.m_rsm.getResultSet().getType();
                boolean bl = mergedData = rsType == ResultSet.Type.USER || rsType == ResultSet.Type.DECOY_USER;
                if (mergedData) {
                    subTask = this.m_subTaskManager.sliceATaskAndGetFirst(4, peptideMatchArray.length, 1000);
                    this.fetchSrcDatFile(entityManagerMSI, subTask);
                }
            }
            entityManagerMSI.getTransaction().commit();
        }
        this.m_defaultPriority = AbstractDatabaseTask.Priority.LOW;
        this.m_currentPriority = AbstractDatabaseTask.Priority.LOW;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchPSMForPeptideInstanceMainTask() {
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectId).createEntityManager();){
            entityManagerMSI.getTransaction().begin();
            Long rsmId = this.m_rsm.getId();
            TypedQuery peptideMatchQuery = entityManagerMSI.createQuery("SELECT new fr.proline.core.orm.msi.dto.DPeptideMatch(pm.id, pm.rank, pm.charge, pm.deltaMoz, pm.experimentalMoz, pm.missedCleavage, pm.score, pm.resultSet.id, pm.cdPrettyRank, pm.sdPrettyRank, pm.isDecoy, pm.serializedProperties) FROM fr.proline.core.orm.msi.PeptideMatch pm, fr.proline.core.orm.msi.PeptideInstancePeptideMatchMap pipm, fr.proline.core.orm.msi.Peptide p WHERE pipm.resultSummary.id=:rsmId AND pipm.id.peptideMatchId=pm.id AND pm.peptideId=p.id AND pipm.id.peptideInstanceId=:piId ORDER BY pm.msQuery.initialId ASC, p.sequence ASC", DPeptideMatch.class);
            peptideMatchQuery.setParameter("rsmId", (Object)rsmId);
            peptideMatchQuery.setParameter("piId", (Object)this.m_peptideInstance.getId());
            Pair<long[], DPeptideMatch[]> matches = this.toArray(peptideMatchQuery);
            DPeptideMatch[] peptideMatchArray = (DPeptideMatch[])matches.getRight();
            this.m_peptideInstance.getTransientData().setPeptideMatches(peptideMatchArray);
            this.m_peptideInstance.getTransientData().setPeptideMatchesId((long[])matches.getLeft());
            int nb = peptideMatchArray.length;
            this.m_peptideMatchIds = new ArrayList<Long>(nb);
            this.m_peptideMatchMap = new HashMap<Long, DPeptideMatch>();
            for (int i = 0; i < nb; ++i) {
                DPeptideMatch pm = peptideMatchArray[i];
                Long pmId = pm.getId();
                this.m_peptideMatchIds.add(i, pmId);
                this.m_peptideMatchMap.put(pmId, pm);
            }
            if (nb > 0) {
                boolean mergedData;
                SubTask subTask = this.m_subTaskManager.sliceATaskAndGetFirst(1, peptideMatchArray.length, 1000);
                this.fetchPeptide(entityManagerMSI, subTask);
                subTask = this.m_subTaskManager.sliceATaskAndGetFirst(2, peptideMatchArray.length, 1000);
                DatabaseLoadPeptideMatchTask.fetchMsQuery(entityManagerMSI, subTask, this.m_peptideMatchIds, this.m_proteinMatch, this.m_peptideMatchSequenceMatchArrayMap, this.m_peptideMatchMap);
                subTask = this.m_subTaskManager.sliceATaskAndGetFirst(3, peptideMatchArray.length, 1000);
                this.fetchProteinSetName(entityManagerMSI, subTask);
                ResultSet.Type rsType = this.m_rsm.getResultSet().getType();
                boolean bl = mergedData = rsType == ResultSet.Type.USER || rsType == ResultSet.Type.DECOY_USER;
                if (mergedData) {
                    subTask = this.m_subTaskManager.sliceATaskAndGetFirst(4, peptideMatchArray.length, 1000);
                    this.fetchSrcDatFile(entityManagerMSI, subTask);
                }
            }
            entityManagerMSI.getTransaction().commit();
        }
        this.m_defaultPriority = AbstractDatabaseTask.Priority.LOW;
        this.m_currentPriority = AbstractDatabaseTask.Priority.LOW;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchDataSubTask() {
        SubTask subTask = this.m_subTaskManager.getNextSubTask();
        if (subTask == null) {
            return true;
        }
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectId).createEntityManager();){
            entityManagerMSI.getTransaction().begin();
            switch (subTask.getSubTaskId()) {
                case 0: {
                    this.fetchPeptideMatch(entityManagerMSI, subTask);
                    break;
                }
                case 1: {
                    this.fetchPeptide(entityManagerMSI, subTask);
                    break;
                }
                case 2: {
                    DatabaseLoadPeptideMatchTask.fetchMsQuery(entityManagerMSI, subTask, this.m_peptideMatchIds, this.m_proteinMatch, this.m_peptideMatchSequenceMatchArrayMap, this.m_peptideMatchMap);
                    break;
                }
                case 3: {
                    this.fetchProteinSetName(entityManagerMSI, subTask);
                    break;
                }
                case 4: {
                    this.fetchSrcDatFile(entityManagerMSI, subTask);
                }
            }
            entityManagerMSI.getTransaction().commit();
        }
        return true;
    }

    private void fetchPeptideMatch(EntityManager entityManagerMSI, SubTask subTask) {
        List sliceOfPeptideMatchIds = subTask.getSubList(this.m_peptideMatchIds);
        TypedQuery peptideMatchQuery = entityManagerMSI.createQuery("SELECT new fr.proline.core.orm.msi.dto.DPeptideMatch(pm.id, pm.rank, pm.charge, pm.deltaMoz, pm.experimentalMoz, pm.missedCleavage, pm.score, pm.resultSet.id, pm.cdPrettyRank, pm.sdPrettyRank, pm.isDecoy, pm.serializedProperties) FROM PeptideMatch pm WHERE pm.id IN (:listId)", DPeptideMatch.class);
        peptideMatchQuery.setParameter("listId", (Object)sliceOfPeptideMatchIds);
        List resultList = peptideMatchQuery.getResultList();
        if (this.m_peptideMatchMap == null) {
            this.m_peptideMatchMap = new HashMap<Long, DPeptideMatch>();
        }
        DPeptideMatch[] peptideMatches = this.m_rset.getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).getPeptideMatches();
        for (DPeptideMatch peptideMatch : resultList) {
            Long id = peptideMatch.getId();
            int position = this.m_peptideMatchPosition.get(id);
            peptideMatches[position] = peptideMatch;
            this.m_peptideMatchMap.put(id, peptideMatch);
        }
    }

    private void fetchPeptide(EntityManager entityManagerMSI, SubTask subTask) {
        List sliceOfPeptideMatchIds = subTask.getSubList(this.m_peptideMatchIds);
        HashMap<Long, Peptide> peptideMap = new HashMap<Long, Peptide>();
        if (this.m_proteinMatch != null) {
            long proteinMatchId = this.m_proteinMatch.getId();
            Query peptideQuery = entityManagerMSI.createQuery("SELECT pm.id, p, sm FROM PeptideMatch pm, fr.proline.core.orm.msi.Peptide p, fr.proline.core.orm.msi.SequenceMatch as sm WHERE pm.id IN (:listId) AND pm.peptideId=p.id AND sm.id.proteinMatchId=:proteinMatchId AND sm.id.peptideId=p.id");
            peptideQuery.setParameter("listId", (Object)sliceOfPeptideMatchIds);
            peptideQuery.setParameter("proteinMatchId", (Object)proteinMatchId);
            List<DPeptideMatch> sequenceMatchListPrevious = null;
            int indexArray = 0;
            List peptides = peptideQuery.getResultList();
            for (Object[] res : peptides) {
                Long peptideMatchId = (Long)res[0];
                Peptide peptide = (Peptide)res[1];
                SequenceMatch sm = (SequenceMatch)res[2];
                peptide.getTransientData().setPeptideReadablePtmStringLoaded();
                List<DPeptideMatch> sequenceMatchList = this.m_peptideMatchSequenceMatchArrayMap.get(peptideMatchId);
                if (sequenceMatchListPrevious != sequenceMatchList) {
                    sequenceMatchListPrevious = sequenceMatchList;
                    indexArray = 0;
                }
                sequenceMatchList.get(indexArray).setPeptide(peptide);
                sequenceMatchList.get(indexArray).setSequenceMatch(sm);
                ++indexArray;
                peptideMap.put(peptide.getId(), peptide);
            }
            DatabasePTMsTask.fillPeptidePTMForPeptides(entityManagerMSI, peptideMap, null);
        } else {
            Query peptideQuery = entityManagerMSI.createQuery("SELECT pm.id, p FROM PeptideMatch pm, fr.proline.core.orm.msi.Peptide p WHERE pm.id IN (:listId) AND pm.peptideId=p.id");
            peptideQuery.setParameter("listId", (Object)sliceOfPeptideMatchIds);
            List peptides = peptideQuery.getResultList();
            for (Object[] res : peptides) {
                Long peptideMatchId = (Long)res[0];
                Peptide peptide = (Peptide)res[1];
                peptide.getTransientData().setPeptideReadablePtmStringLoaded();
                this.m_peptideMatchMap.get(peptideMatchId).setPeptide(peptide);
                peptideMap.put(peptide.getId(), peptide);
            }
        }
        Long rsetId = this.m_rset != null ? this.m_rset.getId() : this.m_rsm.getResultSet().getId();
        Query ptmStingQuery = entityManagerMSI.createQuery("SELECT p.id, ptmString FROM fr.proline.core.orm.msi.Peptide p, fr.proline.core.orm.msi.PeptideReadablePtmString ptmString WHERE p.id IN (:listId) AND ptmString.peptide=p AND ptmString.resultSet.id=:rsetId");
        ptmStingQuery.setParameter("listId", peptideMap.keySet());
        ptmStingQuery.setParameter("rsetId", (Object)rsetId);
        List ptmStrings = ptmStingQuery.getResultList();
        for (Object[] res : ptmStrings) {
            Long peptideId = (Long)res[0];
            PeptideReadablePtmString ptmString = (PeptideReadablePtmString)res[1];
            Peptide peptide = peptideMap.get(peptideId);
            peptide.getTransientData().setPeptideReadablePtmString(ptmString);
        }
        DatabasePTMsTask.fillPeptidePTMForPeptides(entityManagerMSI, peptideMap, null);
    }

    public static void fetchMsQuery(EntityManager entityManagerMSI, SubTask subTask, List<Long> peptideMatchIds, Map<Long, DPeptideMatch> peptideMatchMap) {
        DatabaseLoadPeptideMatchTask.fetchMsQuery(entityManagerMSI, subTask, peptideMatchIds, null, null, peptideMatchMap);
    }

    private static void fetchMsQuery(EntityManager entityManagerMSI, SubTask subTask, List<Long> peptideMatchIds, DProteinMatch proteinMatch, Map<Long, List<DPeptideMatch>> peptideMatchSequenceMatchArrayMap, Map<Long, DPeptideMatch> peptideMatchMap) {
        List sliceOfPeptideMatchIds = subTask.getSubList(peptideMatchIds);
        Query msQueryQuery = entityManagerMSI.createQuery("SELECT pm.id, msq.id, msq.initialId, s.firstTime, s.precursorIntensity, s.title FROM PeptideMatch pm,MsQuery msq, Spectrum s WHERE pm.id IN (:listId) AND pm.msQuery=msq AND msq.spectrum=s");
        msQueryQuery.setParameter("listId", (Object)sliceOfPeptideMatchIds);
        List msQueries = msQueryQuery.getResultList();
        for (Object[] res : msQueries) {
            Float firstTime = (Float)res[3];
            Float precursorIntensity = (Float)res[4];
            String title = (String)res[5];
            DSpectrum spectrum = new DSpectrum();
            spectrum.setFirstTime(firstTime);
            spectrum.setPrecursorIntensity(precursorIntensity);
            spectrum.setTitle(title);
            DMsQuery q = new DMsQuery(((Long)res[0]).longValue(), ((Long)res[1]).longValue(), ((Integer)res[2]).intValue(), precursorIntensity);
            q.setDSpectrum(spectrum);
            if (proteinMatch != null) {
                List<DPeptideMatch> sequenceMatchArray = peptideMatchSequenceMatchArrayMap.get(q.getPeptideMatchId());
                for (DPeptideMatch peptideMatch : sequenceMatchArray) {
                    peptideMatch.setMsQuery(q);
                    peptideMatch.setRetentionTime(spectrum.getFirstTime());
                }
                continue;
            }
            DPeptideMatch peptideMatch = peptideMatchMap.get(q.getPeptideMatchId());
            peptideMatch.setMsQuery(q);
            peptideMatch.setRetentionTime(spectrum.getFirstTime());
        }
    }

    private void fetchSrcDatFile(EntityManager entityManagerMSI, SubTask subTask) {
        DatabaseLoadPeptideMatchTask.fetchSrcDatFile(entityManagerMSI, subTask, this.m_peptideMatchIds, this.m_proteinMatch, this.m_peptideMatchSequenceMatchArrayMap, this.m_peptideMatchMap);
    }

    public static void fetchSrcDatFile(EntityManager entityManagerMSI, SubTask subTask, List<Long> peptideMatchIds, DProteinMatch proteinMatch, Map<Long, List<DPeptideMatch>> peptideMatchSequenceMatchArrayMap, Map<Long, DPeptideMatch> peptideMatchMap) {
        List sliceOfPeptideMatchIds = subTask.getSubList(peptideMatchIds);
        Query query = entityManagerMSI.createQuery("SELECT pm.id, msiSearch.resultFileName FROM PeptideMatch pm, MsQuery msq, MsiSearch msiSearch WHERE pm.id IN (:listId) AND pm.msQuery=msq AND msq.msiSearch = msiSearch");
        query.setParameter("listId", (Object)sliceOfPeptideMatchIds);
        List resultList = query.getResultList();
        for (Object[] res : resultList) {
            Long pmId = (Long)res[0];
            String datFile = (String)res[1];
            if (proteinMatch != null) {
                List<DPeptideMatch> sequenceMatchArray = peptideMatchSequenceMatchArrayMap.get(pmId);
                for (DPeptideMatch peptideMatch : sequenceMatchArray) {
                    peptideMatch.setSourceDatFile(datFile);
                }
                continue;
            }
            DPeptideMatch peptideMatch = peptideMatchMap.get(pmId);
            peptideMatch.setSourceDatFile(datFile);
        }
    }

    private void fetchProteinSetName(EntityManager entityManagerMSI, SubTask subTask) {
        List sliceOfPeptideMatchIds = subTask.getSubList(this.m_peptideMatchIds);
        Query proteinSetQuery = entityManagerMSI.createQuery("SELECT typpm.accession, pepm.id FROM fr.proline.core.orm.msi.PeptideMatch pepm, fr.proline.core.orm.msi.PeptideInstance pepi, fr.proline.core.orm.msi.PeptideInstancePeptideMatchMap pi_pm, fr.proline.core.orm.msi.ProteinSet prots, fr.proline.core.orm.msi.PeptideSetPeptideInstanceItem ps_pi, fr.proline.core.orm.msi.PeptideSet peps, fr.proline.core.orm.msi.ProteinMatch typpm WHERE pepm.id IN (:listId) AND pi_pm.peptideMatch=pepm AND pi_pm.resultSummary.id=:rsmId AND pi_pm.peptideInstance=pepi AND ps_pi.peptideInstance=pepi AND ps_pi.peptideSet=peps AND peps.proteinSet=prots AND prots.representativeProteinMatchId = typpm.id AND prots.isValidated=true ORDER BY pepm.id ASC, typpm.accession ASC");
        proteinSetQuery.setParameter("listId", (Object)sliceOfPeptideMatchIds);
        proteinSetQuery.setParameter("rsmId", (Object)(this.m_rsm == null ? -1L : this.m_rsm.getId()));
        ArrayList<String> proteinSetNameArray = new ArrayList<String>();
        long prevPeptideMatchId = -1L;
        List msQueries = proteinSetQuery.getResultList();
        for (Object[] resCur : msQueries) {
            String proteinName = (String)resCur[0];
            Long peptideMatchId = (Long)resCur[1];
            if (peptideMatchId != prevPeptideMatchId) {
                if (prevPeptideMatchId != -1L) {
                    DPeptideMatch prevPeptideMatch = this.m_peptideMatchMap.get(prevPeptideMatchId);
                    String[] proteinSetNames = proteinSetNameArray.toArray(new String[proteinSetNameArray.size()]);
                    prevPeptideMatch.setProteinSetStringArray(proteinSetNames);
                    proteinSetNameArray.clear();
                    proteinSetNameArray.add(proteinName);
                } else {
                    proteinSetNameArray.add(proteinName);
                }
            } else {
                proteinSetNameArray.add(proteinName);
            }
            prevPeptideMatchId = peptideMatchId;
        }
        if (prevPeptideMatchId != -1L) {
            DPeptideMatch prevPeptideMatch = this.m_peptideMatchMap.get(prevPeptideMatchId);
            String[] proteinSetNames = proteinSetNameArray.toArray(new String[proteinSetNameArray.size()]);
            prevPeptideMatch.setProteinSetStringArray(proteinSetNames);
        }
        for (Long peptideMatchId : sliceOfPeptideMatchIds) {
            DPeptideMatch peptideMatch = this.m_peptideMatchMap.get(peptideMatchId);
            if (peptideMatch.getProteinSetStringArray() != null) continue;
            String[] proteinSetNames = new String[]{};
            peptideMatch.setProteinSetStringArray(proteinSetNames);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fetchPSMForMsQueryMainTask() {
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectId).createEntityManager();){
            entityManagerMSI.getTransaction().begin();
            ArrayList<Long> rsIdList = new ArrayList<Long>();
            rsIdList.add(this.m_rset.getId());
            if (this.m_rset.getDecoyResultSet() != null) {
                rsIdList.add(this.m_rset.getDecoyResultSet().getId());
            }
            String query = "SELECT new fr.proline.core.orm.msi.dto.DPeptideMatch(pm.id, pm.rank, pm.charge, pm.deltaMoz, pm.experimentalMoz, pm.missedCleavage, pm.score, pm.resultSet.id, pm.cdPrettyRank, pm.sdPrettyRank, pm.isDecoy, pm.serializedProperties) FROM fr.proline.core.orm.msi.PeptideMatch pm WHERE pm.msQuery.id =:msQueryId AND pm.resultSet.id IN (:rsIdList) ORDER BY pm.msQuery.initialId ASC";
            TypedQuery peptideMatchQuery = entityManagerMSI.createQuery(query, DPeptideMatch.class);
            peptideMatchQuery.setParameter("msQueryId", (Object)this.m_msQuery.getId());
            peptideMatchQuery.setParameter("rsIdList", rsIdList);
            Pair<long[], DPeptideMatch[]> matches = this.toArray(peptideMatchQuery);
            DPeptideMatch[] peptideMatchArray = (DPeptideMatch[])matches.getRight();
            int nb = peptideMatchArray.length;
            this.m_peptideMatchIds = new ArrayList<Long>(nb);
            this.m_peptideMatchMap = new HashMap<Long, DPeptideMatch>();
            for (int i = 0; i < nb; ++i) {
                DPeptideMatch pm = peptideMatchArray[i];
                pm.setValidated(Boolean.valueOf(false));
                Long pmId = pm.getId();
                this.m_peptideMatchIds.add(i, pmId);
                this.m_peptideMatchMap.put(pmId, pm);
            }
            String queryValidated = "SELECT pipmm.id.peptideMatchId , count(*) FROM fr.proline.core.orm.msi.PeptideInstancePeptideMatchMap pipmm  WHERE pipmm.id.peptideMatchId IN (:listId) AND  pipmm.resultSummary.id =:rsmId GROUP BY pipmm.id.peptideMatchId";
            if (this.m_peptideMatchIds != null && !this.m_peptideMatchIds.isEmpty() && this.m_rsm != null) {
                Query q = entityManagerMSI.createQuery(queryValidated);
                q.setParameter("rsmId", (Object)this.m_rsm.getId());
                q.setParameter("listId", this.m_peptideMatchIds);
                List rso = q.getResultList();
                for (Object[] o : rso) {
                    Integer nbPI;
                    Long pmId = (Long)o[0];
                    this.m_peptideMatchMap.get(pmId).setValidated(Boolean.valueOf((nbPI = Integer.valueOf(((Long)o[1]).intValue())) > 0));
                }
            }
            this.m_listPeptideMatches.addAll(Arrays.asList(peptideMatchArray));
            this.m_listPeptideMatches.sort(new Comparator<DPeptideMatch>(){

                @Override
                public int compare(DPeptideMatch o1, DPeptideMatch o2) {
                    return o1.getRank() - o2.getRank();
                }
            });
            if (nb > 0) {
                SubTask subTask = this.m_subTaskManager.sliceATaskAndGetFirst(1, peptideMatchArray.length, 1000);
                this.fetchPeptide(entityManagerMSI, subTask);
                subTask = this.m_subTaskManager.sliceATaskAndGetFirst(2, peptideMatchArray.length, 1000);
                DatabaseLoadPeptideMatchTask.fetchMsQuery(entityManagerMSI, subTask, this.m_peptideMatchIds, this.m_proteinMatch, this.m_peptideMatchSequenceMatchArrayMap, this.m_peptideMatchMap);
                subTask = this.m_subTaskManager.sliceATaskAndGetFirst(3, peptideMatchArray.length, 1000);
                this.fetchProteinSetName(entityManagerMSI, subTask);
            }
            entityManagerMSI.getTransaction().commit();
        }
        this.m_defaultPriority = AbstractDatabaseTask.Priority.LOW;
        this.m_currentPriority = AbstractDatabaseTask.Priority.LOW;
        return true;
    }
}

