/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.tasks;

import fr.proline.core.orm.uds.Project;
import fr.proline.core.orm.uds.ProjectUserAccountMap;
import fr.proline.core.orm.uds.UserAccount;
import fr.proline.core.orm.util.DStoreCustomPoolConnectorFactory;
import fr.proline.studio.dam.data.AbstractData;
import fr.proline.studio.dam.data.ProjectIdentificationData;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.data.DRawFile;
import fr.proline.studio.dam.tasks.data.ProjectInfo;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

public class DatabaseProjectTask
extends AbstractDatabaseTask {
    private String m_user = null;
    private Project m_p = null;
    private List<AbstractData> m_list = null;
    private String m_name = null;
    private String m_description = null;
    private List<UserAccount> m_userAccountList = null;
    private ArrayList<ProjectInfo> m_resultProjectsList = null;
    private ArrayList<DRawFile> m_resultRawFilesList = null;
    private List<Long> m_projectIds = null;
    private int m_action;
    private static final int LOAD_PROJECT = 0;
    private static final int CHANGE_SETTINGS_PROJECT = 1;
    private static final int LOAD_PROJECTS_LIST = 2;
    private static final int LOAD_RAW_FILES_LIST = 3;

    public DatabaseProjectTask(AbstractDatabaseCallback callback) {
        super(callback, null);
    }

    public void initLoadProject(String user, List<AbstractData> list) {
        this.setTaskInfo(new TaskInfo("Load Projects for User " + user, false, "Database Access", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_user = user;
        this.m_list = list;
        this.m_action = 0;
    }

    public void initChangeSettingsOfProject(Project p, String name, String description, ArrayList<UserAccount> userAccountList) {
        this.setTaskInfo(new TaskInfo("Change Settings of a Project", true, "Database Access", TaskInfo.INFO_IMPORTANCE_HIGH));
        this.m_p = p;
        this.m_name = name;
        this.m_description = description;
        this.m_userAccountList = userAccountList;
        this.m_action = 1;
    }

    public void initLoadProjectsList(ArrayList<ProjectInfo> resultProjectsList) {
        this.setTaskInfo(new TaskInfo("Load Projects List", true, "Database Access", TaskInfo.INFO_IMPORTANCE_HIGH));
        this.m_resultProjectsList = resultProjectsList;
        this.m_action = 2;
    }

    public void initLoadRawFilesList(List<Long> projectIds, ArrayList<DRawFile> resultRawfiles) {
        this.setTaskInfo(new TaskInfo("Load Raw files from projects List", true, "Database Access", TaskInfo.INFO_IMPORTANCE_HIGH));
        this.m_resultRawFilesList = resultRawfiles;
        this.m_projectIds = projectIds;
        this.m_action = 3;
    }

    @Override
    public boolean needToFetch() {
        return true;
    }

    @Override
    public boolean fetchData() {
        switch (this.m_action) {
            case 0: {
                return this.loadProject();
            }
            case 1: {
                return this.changeProjectSettings();
            }
            case 2: {
                return this.loadProjectsList();
            }
            case 3: {
                return this.loadRawFilesList();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadProject() {
        boolean result = true;
        try (EntityManager entityManagerUDS = DStoreCustomPoolConnectorFactory.getInstance().getUdsDbConnector().createEntityManager();){
            entityManagerUDS.getTransaction().begin();
            TypedQuery projectQuery = entityManagerUDS.createQuery("SELECT p FROM fr.proline.core.orm.uds.Project p, fr.proline.core.orm.uds.UserAccount user, fr.proline.core.orm.uds.ProjectUserAccountMap puam  WHERE  user.login=:user AND user.id = puam.userAccount.id AND puam.project.id = p.id ORDER BY p.name ASC", Project.class);
            projectQuery.setParameter("user", (Object)this.m_user);
            List projectList = projectQuery.getResultList();
            for (Project projectCur : projectList) {
                Set members = projectCur.getProjectUserAccountMap();
                for (ProjectUserAccountMap projectUserAccount : members) {
                    projectUserAccount.getUserAccount();
                }
                ProjectIdentificationData projectDataCur = new ProjectIdentificationData(projectCur);
                projectDataCur.setHasChildren(true);
                this.m_list.add(projectDataCur);
            }
            entityManagerUDS.getTransaction().commit();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadProjectsList() {
        this.m_resultProjectsList.clear();
        boolean result = true;
        try (EntityManager entityManagerUDS = DStoreCustomPoolConnectorFactory.getInstance().getUdsDbConnector().createEntityManager();){
            entityManagerUDS.getTransaction().begin();
            Query querySize = entityManagerUDS.createNativeQuery("SELECT p.id, p.name, p.description, p.serialized_properties, p.owner, d.size, p.db_name, p.last_dataset_date, raw_files_count\nFROM  (\nSELECT \nproject.id as id, \nproject.name as name, \nproject.description as description, \nproject.serialized_properties AS serialized_properties,\nuser_account.login as owner, \nexternal_db.name as db_name,\nmax(dataset.creation_timestamp) AS last_dataset_date,\ncount(DISTINCT(run_identification.raw_file_identifier)) AS raw_files_count\nFROM \n  public.project_db_map, \n  public.external_db, \n  public.user_account,\n  public.project\nLEFT JOIN public.data_set dataset ON dataset.project_id = project.id\nLEFT JOIN public.run_identification ON dataset.id = run_identification.id\nWHERE \n  project.owner_id = user_account.id AND\n  project_db_map.project_id = project.id AND\n  project_db_map.external_db_id = external_db.id\nGROUP BY \n  project.id, user_account.login, external_db.name\n) p\nLEFT JOIN (SELECT \n  pg_database.datname as db_name,\n  pg_database_size(pg_database.datname) AS size, \n  pg_database_size(pg_database.datname) as raw_size\nFROM pg_database) d\nON p.db_name = d.db_name\nORDER BY p.id -- d.raw_size DESC");
            List results = querySize.getResultList();
            HashMap<Long, ProjectInfo> projectMap = new HashMap<Long, ProjectInfo>();
            for (Object[] resCur : results) {
                long id = ((BigInteger)resCur[0]).longValue();
                BigInteger sizeInBits = (BigInteger)resCur[5];
                double sizeInMB = sizeInBits == null ? 0.0 : sizeInBits.doubleValue() / 1048576.0;
                Timestamp lastDatasetDate = (Timestamp)resCur[7];
                ProjectInfo projectToDB = (ProjectInfo)projectMap.get(id);
                if (projectToDB == null) {
                    projectToDB = new ProjectInfo(id, (String)resCur[1], (String)resCur[2], (String)resCur[3], (String)resCur[4]);
                    projectMap.put(id, projectToDB);
                    this.m_resultProjectsList.add(projectToDB);
                }
                projectToDB.addDb((String)resCur[6], sizeInMB);
                projectToDB.setLastDatasetDate(lastDatasetDate);
                projectToDB.setRawFilesCount(((BigInteger)resCur[8]).intValue());
            }
            entityManagerUDS.getTransaction().commit();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadRawFilesList() {
        this.m_resultRawFilesList.clear();
        boolean result = true;
        try (EntityManager entityManagerUDS = DStoreCustomPoolConnectorFactory.getInstance().getUdsDbConnector().createEntityManager();){
            entityManagerUDS.getTransaction().begin();
            Query query = entityManagerUDS.createNativeQuery("SELECT t.identifier, t.raw_file_cTimestamp, t.raw_file_properties, t.raw_file_dir, t.raw_file_name, t.project_count, array_to_string(t.project_ids,',')\nFROM \n(SELECT raw_file.identifier AS identifier, raw_file.creation_timestamp AS raw_file_cTimestamp, raw_file.serialized_properties AS raw_file_properties,\n        raw_file.mzdb_file_directory AS raw_file_dir, raw_file.mzdb_file_name AS raw_file_name, count(distinct(data_set.project_id)) AS project_count, array_agg(distinct(data_set.project_id)) AS project_ids \n\t\tFROM raw_file, run_identification, data_set\n\t\tWHERE data_set.id = run_identification.id\n\t\tAND run_identification.raw_file_identifier = raw_file.identifier \n\t\tGROUP BY raw_file.identifier ORDER BY identifier) t , run_identification, data_set, project\nWHERE data_set.id = run_identification.id\nAND run_identification.raw_file_identifier = t.identifier\nAND data_set.project_id = project.id\nAND project.id IN :projectIds\ngroup by project.id, project.name, project.owner_id, project.serialized_properties,  t.identifier,t.raw_file_cTimestamp, t.raw_file_properties, t.raw_file_dir, t.raw_file_name,t.project_count, t.project_ids\nORDER BY identifier\n");
            query.setParameter("projectIds", this.m_projectIds);
            List results = query.getResultList();
            for (Object[] resCur : results) {
                DRawFile rawFile = new DRawFile();
                rawFile.setIdentifier((String)resCur[0]);
                rawFile.setCreationTimestamp((Timestamp)resCur[1]);
                rawFile.setSerializedProperties((String)resCur[2]);
                rawFile.setRawFileDirectory((String)resCur[3]);
                rawFile.setRawFileName((String)resCur[4]);
                rawFile.setProjectsCount(((BigInteger)resCur[5]).intValue());
                rawFile.setProjectIds((String)resCur[6]);
                this.m_resultRawFilesList.add(rawFile);
            }
            entityManagerUDS.getTransaction().commit();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean changeProjectSettings() {
        try (EntityManager entityManagerUDS = DStoreCustomPoolConnectorFactory.getInstance().getUdsDbConnector().createEntityManager();){
            entityManagerUDS.getTransaction().begin();
            Project p = (Project)entityManagerUDS.find(Project.class, (Object)this.m_p.getId());
            p.setName(this.m_name);
            p.setDescription(this.m_description);
            if (this.m_userAccountList != null) {
                int nb = this.m_userAccountList.size();
                this.m_p.getProjectUserAccountMap().clear();
                LinkedList<UserAccount> userToBeRemovedList = new LinkedList<UserAccount>();
                for (ProjectUserAccountMap element : p.getProjectUserAccountMap()) {
                    UserAccount userAccountFromProject = element.getUserAccount();
                    boolean isInList = false;
                    for (int i = 0; i < nb; ++i) {
                        UserAccount userAccount = this.m_userAccountList.get(i);
                        if (userAccount.getId() != userAccountFromProject.getId()) continue;
                        isInList = true;
                        break;
                    }
                    if (isInList) continue;
                    userToBeRemovedList.add(userAccountFromProject);
                }
                for (UserAccount userAccount : userToBeRemovedList) {
                    p.removeMember(userAccount);
                }
                for (int i = 0; i < nb; ++i) {
                    UserAccount userAccount;
                    userAccount = this.m_userAccountList.get(i);
                    UserAccount userAccountInDB = (UserAccount)entityManagerUDS.find(UserAccount.class, (Object)userAccount.getId());
                    if (!p.isProjectMember(userAccountInDB)) {
                        p.addMember(userAccountInDB, true);
                    }
                    this.m_p.addMember(userAccount, true);
                }
            }
            entityManagerUDS.merge((Object)p);
            entityManagerUDS.getTransaction().commit();
        }
        return true;
    }
}

