/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.tasks;

import fr.proline.core.orm.msi.dto.DPeptideSet;
import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.core.orm.msi.dto.DProteinSet;
import fr.proline.core.orm.util.DStoreCustomPoolConnectorFactory;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseBioSequenceTask;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;

public class DatabaseProteinsFromProteinSetTask
extends AbstractDatabaseTask {
    private long m_projectId = -1L;
    private DProteinSet m_proteinSet = null;

    public DatabaseProteinsFromProteinSetTask(AbstractDatabaseCallback callback, long projectId, DProteinSet proteinSet) {
        super(callback, AbstractDatabaseTask.Priority.NORMAL_3, new TaskInfo("Load Proteins of a Protein Set " + DatabaseProteinsFromProteinSetTask.getProteinSetName(proteinSet), false, "Database Access", TaskInfo.INFO_IMPORTANCE_LOW));
        this.m_projectId = projectId;
        this.m_proteinSet = proteinSet;
    }

    public static String getProteinSetName(DProteinSet proteinSet) {
        DProteinMatch proteinMatch = proteinSet.getTypicalProteinMatch();
        String name = proteinMatch != null ? proteinMatch.getAccession() : String.valueOf(proteinSet.getId());
        return name;
    }

    @Override
    public boolean needToFetch() {
        return this.m_proteinSet.getSameSet() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean fetchData() {
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectId).createEntityManager();){
            entityManagerMSI.getTransaction().begin();
            DatabaseProteinsFromProteinSetTask.fetchProteins(entityManagerMSI, this.m_proteinSet, this.m_projectId);
            entityManagerMSI.getTransaction().commit();
        }
        return true;
    }

    protected static void fetchProteins(EntityManager entityManagerMSI, DProteinSet proteinSet, long projectId) throws Exception {
        DPeptideSet peptideSet;
        Long rsmId = proteinSet.getResultSummaryId();
        TypedQuery proteinMatchQuery = entityManagerMSI.createQuery("SELECT new fr.proline.core.orm.msi.dto.DProteinMatch(pm.id, pm.accession, pm.score, pm.peptideCount, pm.resultSet.id, pm.description, pm.geneName, pm.serializedProperties, pepset.id, pepset.score, pepset.sequenceCount, pepset.peptideCount, pepset.peptideMatchCount, pepset.resultSummaryId) FROM ProteinMatch pm, ProteinSetProteinMatchItem ps_to_pm, PeptideSet pepset, PeptideSetProteinMatchMap pepset_to_pm WHERE ps_to_pm.proteinSet.id=:proteinSetId AND ps_to_pm.proteinMatch.id=pm.id AND ps_to_pm.resultSummary.id=:rsmId AND pepset_to_pm.resultSummary.id=:rsmId AND pepset_to_pm.id.peptideSetId=pepset.id AND pepset_to_pm.id.proteinMatchId=pm.id ORDER BY pepset.score DESC", DProteinMatch.class);
        proteinMatchQuery.setParameter("proteinSetId", (Object)proteinSet.getId());
        proteinMatchQuery.setParameter("rsmId", (Object)rsmId);
        List proteinMatchList = proteinMatchQuery.getResultList();
        LinkedList<DProteinMatch> sameSet = new LinkedList<DProteinMatch>();
        ArrayList<DProteinMatch> subSet = new ArrayList<DProteinMatch>(proteinMatchList.size());
        if (proteinSet.getTypicalProteinMatch() == null) {
            throw new Exception("Error while loading typicalProteinMatch: please recalculate the SC!");
        }
        Long idTypicalProteinMatch = proteinSet.getTypicalProteinMatch().getId();
        Iterator it = proteinMatchList.iterator();
        int peptitesCountInSameSet = 0;
        while (it.hasNext()) {
            DProteinMatch proteinMatch = (DProteinMatch)it.next();
            peptideSet = proteinMatch.getPeptideSet(rsmId);
            int peptideCount = peptideSet.getPeptideCount();
            if (peptideCount <= peptitesCountInSameSet) continue;
            peptitesCountInSameSet = peptideCount;
        }
        for (DProteinMatch proteinMatch : proteinMatchList) {
            peptideSet = proteinMatch.getPeptideSet(rsmId);
            proteinMatch.setPeptideSet(rsmId, peptideSet);
            if (peptideSet.getPeptideCount() == peptitesCountInSameSet) {
                if (proteinMatch.getId() == idTypicalProteinMatch.longValue()) {
                    sameSet.addFirst(proteinMatch);
                    continue;
                }
                sameSet.add(proteinMatch);
                continue;
            }
            subSet.add(proteinMatch);
        }
        DatabaseBioSequenceTask.fetchData(proteinMatchList, projectId);
        DProteinMatch[] sameSetArray = sameSet.toArray(new DProteinMatch[sameSet.size()]);
        DProteinMatch[] subSetArray = subSet.toArray(new DProteinMatch[subSet.size()]);
        proteinSet.setSameSet(sameSetArray);
        proteinSet.setSubSet(subSetArray);
    }
}

