/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.tasks;

import fr.proline.core.orm.msi.ResultSet;
import fr.proline.core.orm.util.DStoreCustomPoolConnectorFactory;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;

public class DatabaseRsetTask
extends AbstractDatabaseTask {
    private long m_projectId = -1L;
    private ArrayList<ResultSet> m_resultSetArrayList = null;

    public DatabaseRsetTask(AbstractDatabaseCallback callback, long projectId, ArrayList<ResultSet> resultSetArrayList) {
        super(callback, new TaskInfo("Load All Search Results", false, "Database Access", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_projectId = projectId;
        this.m_resultSetArrayList = resultSetArrayList;
    }

    @Override
    public boolean needToFetch() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean fetchData() {
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectId).createEntityManager();){
            entityManagerMSI.getTransaction().begin();
            TypedQuery resultSetQuery = entityManagerMSI.createQuery("SELECT rset FROM fr.proline.core.orm.msi.ResultSet rset WHERE rset.type=:decoyType ORDER BY rset.id", ResultSet.class);
            resultSetQuery.setParameter("decoyType", (Object)ResultSet.Type.SEARCH);
            List resultSetList = resultSetQuery.getResultList();
            this.m_resultSetArrayList.addAll(resultSetList);
            entityManagerMSI.getTransaction().commit();
        }
        return true;
    }
}

