/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.tasks;

import fr.proline.studio.dam.tasks.SubTask;
import java.util.ArrayList;
import java.util.PriorityQueue;

public class SubTaskManager {
    private PriorityQueue<SubTask> m_subTasks = new PriorityQueue();
    private int[] m_subTaskCount;
    private SubTask m_currentTask = null;
    private int m_maxSlicesNumber;
    private ArrayList<SubTask> subTaskTmp = new ArrayList();

    public SubTaskManager(int nbDifferentSubTaskTypes) {
        this.m_subTaskCount = new int[nbDifferentSubTaskTypes];
    }

    public synchronized void deleteThis() {
        this.m_subTasks.clear();
    }

    public synchronized boolean isEmpty() {
        return this.m_subTasks.isEmpty();
    }

    public synchronized SubTask getCurrentTask() {
        return this.m_currentTask;
    }

    public synchronized void setCurrentTask(SubTask currentTask) {
        this.m_currentTask = currentTask;
    }

    public synchronized SubTask sliceATaskAndGetFirst(int subTaskId, int arrayLength, int range) {
        SubTask firstTask = null;
        int i = 0;
        while (i < arrayLength) {
            int indexStart = i;
            int indexEnd = i + range - 1;
            if (indexEnd >= arrayLength) {
                indexEnd = arrayLength - 1;
            }
            if (i == 0) {
                firstTask = new SubTask(subTaskId, indexStart, indexEnd);
            } else {
                this.m_subTasks.offer(new SubTask(subTaskId, indexStart, indexEnd));
                int n = subTaskId;
                this.m_subTaskCount[n] = this.m_subTaskCount[n] + 1;
            }
            i = indexEnd + 1;
        }
        this.m_maxSlicesNumber = this.m_subTasks.size();
        return firstTask;
    }

    public synchronized float getAccomplishedPercentage() {
        int nbTask = this.m_subTasks.size();
        return 100.0f - 100.0f * ((float)nbTask / (float)this.m_maxSlicesNumber);
    }

    public synchronized SubTask getNextSubTask() {
        if (this.m_subTasks.size() == 0) {
            this.m_currentTask = null;
        } else {
            this.m_currentTask = this.m_subTasks.poll();
            int n = this.m_currentTask.getSubTaskId();
            this.m_subTaskCount[n] = this.m_subTaskCount[n] - 1;
        }
        return this.m_currentTask;
    }

    public synchronized void givePriorityTo(int subTaskId, int indexStart, int indexEnd) {
        int nb;
        if (subTaskId != -1 && this.m_subTaskCount[subTaskId] > 0) {
            for (SubTask st : this.m_subTasks) {
                boolean bl = highPriority = st.getSubTaskId() == subTaskId;
                if ((!highPriority || st.isHighPriority()) && (highPriority || !st.isHighPriority())) continue;
                this.subTaskTmp.add(st);
            }
        } else {
            for (SubTask st : this.m_subTasks) {
                highPriority = st.hasCommonIndexes(indexStart, indexEnd);
                if ((!highPriority || st.isHighPriority()) && (highPriority || !st.isHighPriority())) continue;
                this.subTaskTmp.add(st);
            }
        }
        if ((nb = this.subTaskTmp.size()) > 0) {
            int i;
            for (i = 0; i < nb; ++i) {
                this.m_subTasks.remove(this.subTaskTmp.get(i));
            }
            for (i = 0; i < nb; ++i) {
                SubTask task;
                task.setHighPriority(!(task = this.subTaskTmp.get(i)).isHighPriority());
                this.m_subTasks.offer(task);
            }
            this.subTaskTmp.clear();
        }
    }

    public synchronized void resetPriority() {
        for (SubTask sb : this.m_subTasks) {
            if (!sb.isHighPriority()) continue;
            this.subTaskTmp.add(sb);
        }
        int nb = this.subTaskTmp.size();
        if (nb > 0) {
            int i;
            for (i = 0; i < nb; ++i) {
                this.m_subTasks.remove(this.subTaskTmp.get(i));
            }
            for (i = 0; i < nb; ++i) {
                SubTask task = this.subTaskTmp.get(i);
                task.setHighPriority(false);
                this.m_subTasks.offer(task);
            }
            this.subTaskTmp.clear();
        }
    }
}

