/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.tasks.data;

import java.util.Date;

public class ProjectInfo {
    private long m_projectId;
    private String m_name;
    private String m_description;
    private String m_user;
    private double m_size;
    private String m_dbname;
    private String m_properties;
    private Date m_lastDatasetDate;
    private Integer m_rawFilesCount;
    private Status m_status;
    private boolean m_selected;

    public ProjectInfo(long projectId, String name, String description, String properties, String user) {
        this.m_projectId = projectId;
        this.m_name = name;
        this.m_description = description;
        this.m_user = user;
        this.m_properties = properties;
        this.setStatus(this.m_properties);
    }

    private void setStatus(String properties) {
        if (properties == null || properties.isEmpty()) {
            this.m_status = Status.ACTIVE;
        } else if (properties.contains("\"is_active\":false")) {
            this.m_status = properties.contains("\"archive_date\":") ? Status.ARCHIVED : Status.INACTIVE;
        }
    }

    public Status getStatus() {
        return this.m_status;
    }

    public boolean isSelected() {
        return this.m_selected;
    }

    public void setSelected(boolean selected) {
        this.m_selected = selected;
    }

    public void addDb(String dbname, double size) {
        if (this.m_dbname == null) {
            this.m_dbname = dbname;
            this.m_size = size;
        } else {
            this.m_size += size;
            this.m_dbname = this.m_dbname + ", " + dbname;
        }
    }

    public Date getLastDatasetDate() {
        return this.m_lastDatasetDate;
    }

    public void setLastDatasetDate(Date date) {
        this.m_lastDatasetDate = date;
    }

    public long getProjectId() {
        return this.m_projectId;
    }

    public String getName() {
        return this.m_name;
    }

    public String getDescription() {
        return this.m_description;
    }

    public String getProperties() {
        return this.m_properties;
    }

    public String getUser() {
        return this.m_user;
    }

    public double getSize() {
        if (this.m_size == 0.0 && this.m_status != Status.ACTIVE) {
            return Double.NaN;
        }
        return this.m_size;
    }

    public String getDBName() {
        return this.m_dbname;
    }

    public Integer getRawFilesCount() {
        return this.m_rawFilesCount;
    }

    public void setRawFilesCount(int count) {
        this.m_rawFilesCount = count;
    }

    public static enum Status {
        ACTIVE,
        ARCHIVED,
        INACTIVE;

    }
}

