/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.tasks.data.ptm;

import fr.proline.core.orm.msi.dto.DMasterQuantPeptide;
import fr.proline.core.orm.msi.dto.DMasterQuantProteinSet;
import fr.proline.core.orm.msi.dto.DQuantPeptide;
import fr.proline.core.orm.uds.dto.DMasterQuantitationChannel;
import fr.proline.core.orm.uds.dto.DQuantitationChannel;
import fr.proline.studio.dam.tasks.data.ptm.AggregatedQuantPeptide;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregatedMasterQuantPeptide
extends DMasterQuantPeptide {
    protected final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ptm");
    private final List<DMasterQuantPeptide> m_mqPeptides;
    private final Integer m_selectionLevel;

    public AggregatedMasterQuantPeptide(List<DMasterQuantPeptide> mqPeptides, DMasterQuantitationChannel masterQC, DMasterQuantProteinSet masterQuantProteinSet) {
        this.m_mqPeptides = mqPeptides;
        Map<Long, Integer> selLevelByMQPepId = new HashMap<Long, Integer>();
        if (masterQuantProteinSet.getMasterQuantProtSetProperties() != null && masterQuantProteinSet.getMasterQuantProtSetProperties().getMqPeptideSelLevelById() != null) {
            selLevelByMQPepId = masterQuantProteinSet.getMasterQuantProtSetProperties().getMqPeptideSelLevelById();
        }
        this.m_selectionLevel = this.computeSelectionLevel(selLevelByMQPepId);
        for (DQuantitationChannel qc : masterQC.getQuantitationChannels()) {
            ArrayList<DQuantPeptide> qPeps = new ArrayList<DQuantPeptide>();
            HashMap<Long, Integer> localSelLevelByPepQuant = new HashMap<Long, Integer>();
            Map<Long, Integer> finalSelLevelByMQPepId = selLevelByMQPepId;
            mqPeptides.forEach(mqPep -> {
                DQuantPeptide qPep = (DQuantPeptide)mqPep.getQuantPeptideByQchIds().get(qc.getId());
                if (qPep != null) {
                    Integer mapSelLevel;
                    qPep.setPeptideInstanceId(Long.valueOf(mqPep.getPeptideInstanceId()));
                    if (localSelLevelByPepQuant.containsKey(qPep.getPeptideInstanceId())) {
                        this.m_logger.warn("!!!! Few Aggregate Quant Pep with SAME PeptideInstanceId !!!!");
                    }
                    localSelLevelByPepQuant.put(qPep.getPeptideInstanceId(), qPep.getSelectionLevel());
                    if (!finalSelLevelByMQPepId.isEmpty() && finalSelLevelByMQPepId.containsKey(mqPep.getId()) && !(mapSelLevel = (Integer)finalSelLevelByMQPepId.get(mqPep.getId())).equals(qPep.getSelectionLevel())) {
                        localSelLevelByPepQuant.put(qPep.getPeptideInstanceId(), mapSelLevel);
                    }
                    qPeps.add(qPep);
                }
            });
            if (qPeps.isEmpty()) continue;
            this.m_quantPeptideByQchIds.put(qc.getId(), new AggregatedQuantPeptide(qPeps, localSelLevelByPepQuant));
        }
    }

    private Integer computeSelectionLevel(Map<Long, Integer> selLevelByMQPepId) {
        Integer selLevel = -1;
        for (DMasterQuantPeptide mqPep : this.m_mqPeptides) {
            Integer mqPepSelLevel = mqPep.getSelectionLevel();
            if (selLevelByMQPepId.containsKey(mqPep.getId())) {
                mqPepSelLevel = selLevelByMQPepId.get(mqPep.getId());
            }
            if (mqPepSelLevel <= selLevel) continue;
            selLevel = mqPepSelLevel;
        }
        if (selLevel == -1) {
            selLevel = 2;
        }
        return selLevel;
    }

    public int getGenericSelectionLevel() {
        return this.m_selectionLevel;
    }

    public List<DMasterQuantPeptide> getAggregatedMQPeptides() {
        return this.m_mqPeptides;
    }
}

