/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.tasks.data.ptm;

import fr.proline.core.orm.msi.dto.DQuantPeptide;
import java.util.List;
import java.util.Map;

class AggregatedQuantPeptide
extends DQuantPeptide {
    private final List<DQuantPeptide> m_quantPeptides;
    private final Map<Long, Integer> m_localSelLevelByPepQuant;

    AggregatedQuantPeptide(List<DQuantPeptide> quantPeptides, Map<Long, Integer> localSelLevelByPepQuant) {
        this.m_quantPeptides = quantPeptides;
        this.m_localSelLevelByPepQuant = localSelLevelByPepQuant;
    }

    public Float getRawAbundance() {
        if (this.m_quantPeptides != null) {
            return Float.valueOf((float)this.m_quantPeptides.stream().filter(qpep -> this.m_localSelLevelByPepQuant.get(qpep.getPeptideInstanceId()) >= 2).mapToDouble(DQuantPeptide::getRawAbundance).filter(d -> !Double.isNaN(d)).sum());
        }
        return null;
    }

    public Float getAbundance() {
        if (this.m_quantPeptides != null) {
            return Float.valueOf((float)this.m_quantPeptides.stream().filter(qpep -> this.m_localSelLevelByPepQuant.get(qpep.getPeptideInstanceId()) >= 2).mapToDouble(DQuantPeptide::getAbundance).filter(d -> !Double.isNaN(d)).sum());
        }
        return null;
    }

    public Integer getSelectionLevel() {
        return super.getSelectionLevel();
    }

    public Integer getPeptideMatchesCount() {
        if (this.m_quantPeptides != null) {
            return this.m_quantPeptides.stream().mapToInt(DQuantPeptide::getPeptideMatchesCount).sum();
        }
        return null;
    }

    public Long getQuantChannelId() {
        return super.getQuantChannelId();
    }

    public Float getElutionTime() {
        return super.getElutionTime();
    }

    public Long getPeptideId() {
        return super.getPeptideId();
    }

    public Long getPeptideInstanceId() {
        return super.getPeptideInstanceId();
    }

    public Integer getIdentPeptideMatchCount() {
        if (this.m_quantPeptides != null) {
            return this.m_quantPeptides.stream().mapToInt(DQuantPeptide::getIdentPeptideMatchCount).sum();
        }
        return null;
    }
}

