/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.tasks.data.ptm;

import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.dam.tasks.data.ptm.PTMDataset;

public class PTMDatasetPair {
    private PTMDataset m_sitePTMDataset;
    private PTMDataset m_clusterPTMDataset;
    private int m_ptmDatasetType;
    private boolean m_shouldSave = false;
    public static int RAW_PTM_DATASET = 0;
    public static int ANNOTATED_PTM_DATASET = 1;

    public PTMDatasetPair(PTMDataset sitePTMDataset, PTMDataset clusterPTMDataset) {
        this(sitePTMDataset, clusterPTMDataset, false);
    }

    public PTMDatasetPair(PTMDataset sitePTMDataset, PTMDataset clusterPTMDataset, boolean isAnnotated) {
        if (sitePTMDataset == null || clusterPTMDataset == null) {
            throw new IllegalArgumentException("PTMDatasets should not be null");
        }
        this.m_sitePTMDataset = sitePTMDataset;
        this.m_clusterPTMDataset = clusterPTMDataset;
        this.m_ptmDatasetType = isAnnotated ? ANNOTATED_PTM_DATASET : RAW_PTM_DATASET;
    }

    public boolean shouldSavePTMDataset() {
        return this.m_shouldSave;
    }

    public void setShouldSavePTMDataset(boolean shouldSave) {
        this.m_shouldSave = shouldSave;
    }

    public DDataset getDataset() {
        return this.m_clusterPTMDataset.getDataset();
    }

    public PTMDataset getSitePTMDataset() {
        return this.m_sitePTMDataset;
    }

    public PTMDataset getClusterPTMDataset() {
        return this.m_clusterPTMDataset;
    }

    public void updateParentPTMPeptideInstanceClusters() {
        this.m_sitePTMDataset.updateParentPTMPeptideInstanceClusters(false);
        this.m_clusterPTMDataset.updateParentPTMPeptideInstanceClusters(true);
    }

    public int getPTMDatasetType() {
        return this.m_ptmDatasetType;
    }

    public void changePTMDatasetType(int datasetType) {
        if (datasetType == ANNOTATED_PTM_DATASET || datasetType == RAW_PTM_DATASET) {
            this.m_ptmDatasetType = datasetType;
        }
    }
}

