/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.tasks.xic;

import fr.proline.core.orm.lcms.Feature;
import fr.proline.core.orm.lcms.FeatureClusterItem;
import fr.proline.core.orm.lcms.Map;
import fr.proline.core.orm.lcms.MapAlignment;
import fr.proline.core.orm.lcms.MasterFeatureItem;
import fr.proline.core.orm.lcms.Peakel;
import fr.proline.core.orm.lcms.ProcessedMap;
import fr.proline.core.orm.lcms.RawMap;
import fr.proline.core.orm.lcms.dto.DFeature;
import fr.proline.core.orm.msi.dto.DMasterQuantPeptideIon;
import fr.proline.core.orm.msi.dto.DQuantPeptideIon;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.core.orm.uds.dto.DMasterQuantitationChannel;
import fr.proline.core.orm.uds.dto.DQuantitationChannel;
import fr.proline.core.orm.util.DStoreCustomPoolConnectorFactory;
import fr.proline.studio.dam.taskinfo.TaskError;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseSlicerTask;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dam.tasks.xic.DatabaseLoadXicMasterQuantTask;
import fr.proline.studio.dam.tasks.xic.MapAlignmentConverter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.hibernate.Hibernate;

public class DatabaseLoadLcMSTask
extends AbstractDatabaseSlicerTask {
    private static final int SLICE_SIZE = 300;
    private Long m_projectId;
    private DDataset m_dataset;
    private DMasterQuantPeptideIon m_masterQuantPeptideIon;
    private DQuantitationChannel[] m_quantChannels;
    private List<DFeature> m_childFeatureList;
    private Feature m_childFeature;
    private List<Peakel> m_peakelForChildFeatureList;
    private List<List<Peakel>> m_peakelListPerFeature;
    private List<Long> m_peakelForFeatureIds = null;
    private int action;
    private static final int LOAD_PEAKELS_FOR_FEATURE = 5;
    private static final int LOAD_FEATURE_FOR_PEPTIDE_ION_WITH_PEAKELS = 6;
    private static final int LOAD_ALIGNMENT_FOR_XIC = 7;
    public static final int SUB_TASK_COUNT_MAP = 0;
    public static final int SUB_TASK_COUNT_CHILD_FEATURE = 0;
    public static final int SUB_TASK_COUNT_PEAKEL_FOR_FEATURE = 1;
    public static final int SUB_TASK_PEAKEL_FOR_FEATURE = 0;

    public DatabaseLoadLcMSTask(AbstractDatabaseCallback callback) {
        super(callback);
    }

    public void initLoadChildFeatureForPeptideIonWithPeakel(long projectId, DMasterQuantPeptideIon masterQuantPeptideIon, DQuantitationChannel[] quantChannels, List<DFeature> childFeatureList, List<List<Peakel>> peakelListPerFeature, DDataset dataset) {
        this.init(0, new TaskInfo("Load Child Features + peakels for PeptideIon " + (Serializable)(masterQuantPeptideIon == null ? "" : Long.valueOf(masterQuantPeptideIon.getId())), false, "Database Access", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_projectId = projectId;
        this.m_masterQuantPeptideIon = masterQuantPeptideIon;
        this.m_quantChannels = quantChannels;
        this.m_childFeatureList = childFeatureList;
        this.m_peakelListPerFeature = peakelListPerFeature;
        this.m_dataset = dataset;
        this.action = 6;
    }

    public void initLoadPeakelForFeature(long projectId, Feature feature, List<Peakel> peakelList) {
        this.init(1, new TaskInfo("Load Peakels for Feature ", false, "Database Access", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_projectId = projectId;
        this.m_childFeature = feature;
        this.m_peakelForChildFeatureList = peakelList;
        this.action = 5;
    }

    public void initLoadAlignmentForXic(long projectId, DDataset dataset) {
        this.init(0, new TaskInfo("Load Map Alignment of XIC " + dataset.getName(), false, "Database Access", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_projectId = projectId;
        this.m_dataset = dataset;
        this.action = 7;
    }

    @Override
    public void abortTask() {
        super.abortTask();
        switch (this.action) {
            case 5: {
                this.m_peakelForChildFeatureList = null;
                break;
            }
            case 6: {
                this.m_childFeatureList = null;
                this.m_peakelListPerFeature = null;
                break;
            }
            case 7: {
                this.m_dataset.clearMapAlignments();
            }
        }
    }

    @Override
    public boolean fetchData() {
        if (this.action == 5) {
            if (this.needToFetch()) {
                return this.fetchDataMainTaskPeakelForFeature();
            }
            return this.fetchPeakelForFeatureDataSubTask();
        }
        if (this.action == 6) {
            if (this.needToFetch()) {
                if (this.m_dataset.getMapAlignments() == null || this.m_dataset.getMapAlignments().isEmpty()) {
                    this.m_taskError = DatabaseLoadLcMSTask.fetchDataMainTaskAlignmentForXic(this.m_projectId, this.m_dataset);
                }
                return this.fetchDataMainTaskChildFeatureForPeptideIonWithPeakels();
            }
        } else if (this.action == 7 && this.needToFetch()) {
            if (this.m_dataset.getMasterQuantitationChannels() == null || this.m_dataset.getMasterQuantitationChannels().isEmpty()) {
                this.m_taskError = DatabaseLoadXicMasterQuantTask.fetchDataQuantChannels(this.m_projectId, this.m_dataset);
            }
            return this.fetchDataMainTaskAlignmentForXic();
        }
        return true;
    }

    @Override
    public boolean needToFetch() {
        switch (this.action) {
            case 5: {
                return this.m_peakelForChildFeatureList == null || this.m_peakelForChildFeatureList.isEmpty();
            }
            case 6: {
                return this.m_childFeatureList == null || this.m_childFeatureList.isEmpty();
            }
            case 7: {
                return this.m_dataset.getMapAlignments() == null || this.m_dataset.getMapAlignments().isEmpty();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchDataMainTaskPeakelForFeature() {
        try (EntityManager entityManagerLCMS = DStoreCustomPoolConnectorFactory.getInstance().getLcMsDbConnector(this.m_projectId.longValue()).createEntityManager();){
            List listIds;
            entityManagerLCMS.getTransaction().begin();
            String queryP = "SELECT fpi.id.peakelId  FROM fr.proline.core.orm.lcms.FeaturePeakelItem fpi WHERE fpi.id.featureId =:featureId ORDER BY fpi.isotopeIndex ASC ";
            TypedQuery queryPeakel = entityManagerLCMS.createQuery(queryP, Long.class);
            queryPeakel.setParameter("featureId", (Object)(this.m_childFeature == null ? -1L : this.m_childFeature.getId()));
            this.m_peakelForFeatureIds = listIds = queryPeakel.getResultList();
            for (Long peakelId : this.m_peakelForFeatureIds) {
                Peakel p = new Peakel();
                p.setId(peakelId);
                this.m_peakelForChildFeatureList.add(p);
            }
            if (this.m_peakelForFeatureIds != null && this.m_peakelForFeatureIds.size() > 0) {
                SubTask subTask = this.m_subTaskManager.sliceATaskAndGetFirst(0, this.m_peakelForFeatureIds.size(), 300);
                this.fetchPeakelForFeatureData(subTask, entityManagerLCMS);
            }
            entityManagerLCMS.getTransaction().commit();
        }
        this.m_defaultPriority = AbstractDatabaseTask.Priority.LOW;
        this.m_currentPriority = AbstractDatabaseTask.Priority.LOW;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchPeakelForFeatureDataSubTask() {
        SubTask slice = this.m_subTaskManager.getNextSubTask();
        if (slice == null) {
            return true;
        }
        try (EntityManager entityManagerLCMS = DStoreCustomPoolConnectorFactory.getInstance().getLcMsDbConnector(this.m_projectId.longValue()).createEntityManager();){
            entityManagerLCMS.getTransaction().begin();
            switch (slice.getSubTaskId()) {
                case 0: {
                    this.fetchPeakelForFeatureData(slice, entityManagerLCMS);
                }
            }
            entityManagerLCMS.getTransaction().commit();
        }
        return true;
    }

    private boolean fetchPeakelForFeatureData(SubTask subTask, EntityManager entityManagerLCMS) {
        List sliceOfPeakelsIds = subTask.getSubList(this.m_peakelForFeatureIds);
        return this.fetchPeakelData(entityManagerLCMS, sliceOfPeakelsIds, this.m_peakelForChildFeatureList);
    }

    private boolean fetchPeakelData(EntityManager entityManagerLCMS, List<Long> listPeakelsIds, List<Peakel> peakelList) {
        int nbP = peakelList.size();
        String queryP = "SELECT p FROM fr.proline.core.orm.lcms.Peakel p WHERE p.id IN (:listId) ORDER BY p.id ASC ";
        TypedQuery queryPeakel = entityManagerLCMS.createQuery(queryP, Peakel.class);
        queryPeakel.setParameter("listId", listPeakelsIds);
        List resultList = queryPeakel.getResultList();
        for (Peakel peakel : resultList) {
            int index = -1;
            for (int k = 0; k < nbP; ++k) {
                if (!peakelList.get(k).getId().equals(peakel.getId())) continue;
                index = k;
                break;
            }
            peakelList.set(index, peakel);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchDataMainTaskChildFeatureForPeptideIonWithPeakels() {
        long start = System.currentTimeMillis();
        try (EntityManager entityManagerLCMS = DStoreCustomPoolConnectorFactory.getInstance().getLcMsDbConnector(this.m_projectId.longValue()).createEntityManager();){
            entityManagerLCMS.getTransaction().begin();
            if (this.m_masterQuantPeptideIon != null) {
                ArrayList<MapAlignment> allMapAlignments = new ArrayList<MapAlignment>();
                allMapAlignments.addAll(this.m_dataset.getMapAlignments());
                allMapAlignments.addAll(this.m_dataset.getMapReversedAlignments());
                Long alnRefMapId = this.m_dataset.getAlnReferenceMapId();
                List allProcessedMaps = this.m_dataset.getMaps();
                HashMap<Long, DQuantitationChannel> qcByProcessMapId = new HashMap<Long, DQuantitationChannel>();
                for (DQuantitationChannel qc : ((DMasterQuantitationChannel)this.m_dataset.getMasterQuantitationChannels().get(0)).getQuantitationChannels()) {
                    qcByProcessMapId.put(qc.getLcmsMapId(), qc);
                }
                HashSet<Long> listOfRawMapsId = new HashSet<Long>();
                Map<Long, Long> qcIdByFeatureId = this.m_masterQuantPeptideIon.getQuantPeptideIonByQchIds().entrySet().stream().filter(e -> ((DQuantPeptideIon)e.getValue()).getLcmsFeatureId() != null).collect(Collectors.toMap(entry -> ((DQuantPeptideIon)entry.getValue()).getLcmsFeatureId(), entry -> (Long)entry.getKey()));
                String queryMFI = "SELECT mfi FROM fr.proline.core.orm.lcms.MasterFeatureItem mfi WHERE mfi.childFeature.id IN (:featureIds) ";
                TypedQuery queryMasterFeatureItem = entityManagerLCMS.createQuery(queryMFI, MasterFeatureItem.class);
                queryMasterFeatureItem.setParameter("featureIds", qcIdByFeatureId.keySet());
                List resultMFIList = queryMasterFeatureItem.getResultList();
                HashSet<Feature> allFeature = new HashSet<Feature>();
                Feature bestChild = null;
                Double bestChildElutionTime = Double.NaN;
                fr.proline.core.orm.lcms.Map sourceMap = null;
                Float maxIntensity = Float.valueOf(Float.NaN);
                ArrayList<Long> childFeatureIdsForCluster = new ArrayList<Long>();
                for (MasterFeatureItem mfi : resultMFIList) {
                    allFeature.add(mfi.getChildFeature());
                    listOfRawMapsId.add(mfi.getChildFeature().getMap().getId());
                    if (mfi.getIsBestChild().booleanValue()) {
                        bestChild = mfi.getChildFeature();
                        bestChildElutionTime = bestChild.getElutionTime();
                        sourceMap = bestChild.getMap();
                    }
                    if (mfi.getChildFeature().getMap().getType() == Map.Type.RAW_MAP) continue;
                    childFeatureIdsForCluster.add(mfi.getChildFeature().getId());
                }
                if (!childFeatureIdsForCluster.isEmpty()) {
                    Iterator queryF = "SELECT fci FROM fr.proline.core.orm.lcms.FeatureClusterItem fci  WHERE fci.clusterFeature.id in (:listClusterFeatureId) ";
                    TypedQuery queryChildF = entityManagerLCMS.createQuery((String)((Object)queryF), FeatureClusterItem.class);
                    queryChildF.setParameter("listClusterFeatureId", childFeatureIdsForCluster);
                    for (FeatureClusterItem fci : queryChildF.getResultList()) {
                        Feature f = fci.getSubFeature();
                        allFeature.add(f);
                        listOfRawMapsId.add(f.getMap().getId());
                        qcIdByFeatureId.put(f.getId(), qcIdByFeatureId.get(fci.getClusterFeature().getId()));
                    }
                }
                for (ProcessedMap m : allProcessedMaps) {
                    Long rawMapId = m.getRawMap().getId();
                    Long processedMapId = m.getId();
                    if (listOfRawMapsId.contains(rawMapId) || listOfRawMapsId.contains(processedMapId)) continue;
                    fr.proline.core.orm.lcms.Map map = (fr.proline.core.orm.lcms.Map)entityManagerLCMS.find(fr.proline.core.orm.lcms.Map.class, (Object)processedMapId);
                    Feature fakeFeature = new Feature();
                    fakeFeature.setId(Long.valueOf(-processedMapId.longValue()));
                    fakeFeature.setMap(map);
                    fakeFeature.setCharge(Integer.valueOf(0));
                    fakeFeature.setIsOverlapping(Boolean.valueOf(false));
                    fakeFeature.setIsCluster(Boolean.valueOf(false));
                    allFeature.add(fakeFeature);
                    qcIdByFeatureId.put(fakeFeature.getId(), ((DQuantitationChannel)qcByProcessMapId.get(processedMapId)).getId());
                }
                if (bestChild == null) {
                    for (Feature feature : allFeature) {
                        if (feature.getIsCluster().booleanValue() || feature.getId() == -1L) continue;
                        boolean hasPredElTime = false;
                        Map prop = feature.getSerializedPropertiesAsMap();
                        if (prop != null) {
                            Object o = prop.get("predicted_elution_time");
                            boolean bl = hasPredElTime = o != null && o instanceof Double;
                        }
                        if (hasPredElTime || !maxIntensity.isNaN() && !(feature.getApexIntensity() > maxIntensity.floatValue())) continue;
                        maxIntensity = Float.valueOf(feature.getApexIntensity());
                        bestChild = feature;
                        bestChildElutionTime = bestChild.getElutionTime();
                        sourceMap = bestChild.getMap();
                    }
                }
                String queryP = "SELECT fpi.id.peakelId  FROM fr.proline.core.orm.lcms.FeaturePeakelItem fpi WHERE fpi.id.featureId =:featureId ORDER BY fpi.isotopeIndex ASC ";
                TypedQuery queryPeakel = entityManagerLCMS.createQuery(queryP, Long.class);
                for (Feature feature : allFeature) {
                    DQuantitationChannel[] dFeature = new DFeature(feature);
                    dFeature.setquantChannelId(qcIdByFeatureId.get(feature.getId()));
                    dFeature.setBestChild(false);
                    Map prop = dFeature.getSerializedPropertiesAsMap();
                    if (bestChild != null) {
                        try {
                            Long sourceProcessedMapId = sourceMap.getType() == Map.Type.RAW_MAP ? ((RawMap)sourceMap).getProcessedMap().getId() : sourceMap.getId();
                            Long destProcessedMapId = feature.getMap().getType() == Map.Type.RAW_MAP ? ((RawMap)feature.getMap()).getProcessedMap().getId() : feature.getMap().getId();
                            double predictedElutionTime = MapAlignmentConverter.convertElutionTime(bestChildElutionTime, sourceProcessedMapId, destProcessedMapId, allMapAlignments, alnRefMapId);
                            dFeature.setPredictedElutionTime(predictedElutionTime);
                        }
                        catch (Exception sourceProcessedMapId) {
                            // empty catch block
                        }
                        if (bestChild.getId().equals(dFeature.getId())) {
                            dFeature.setBestChild(true);
                        }
                    }
                    this.m_childFeatureList.add((DFeature)dFeature);
                    queryPeakel.setParameter("featureId", (Object)feature.getId());
                    List listIds = new ArrayList();
                    if (feature.getId() > -1L) {
                        listIds = queryPeakel.getResultList();
                    }
                    if (listIds != null && !listIds.isEmpty()) {
                        String queryPeakelLoadS = "SELECT p, fpi.isotopeIndex FROM fr.proline.core.orm.lcms.Peakel p, FeaturePeakelItem fpi WHERE p.id IN (:listId) AND p.id = fpi.id.peakelId AND fpi.id.featureId =:featureId ";
                        Query queryPeakelLoad = entityManagerLCMS.createQuery(queryPeakelLoadS);
                        queryPeakelLoad.setParameter("listId", listIds);
                        queryPeakelLoad.setParameter("featureId", (Object)feature.getId());
                        List resultPeakelList = queryPeakelLoad.getResultList();
                        ArrayList<Peakel> peakelResultList = new ArrayList<Peakel>();
                        for (Object[] resCur : resultPeakelList) {
                            Peakel peakel = (Peakel)resCur[0];
                            peakel.setIsotopeIndex((Integer)resCur[1]);
                            peakelResultList.add(peakel);
                        }
                        this.m_peakelListPerFeature.add(peakelResultList);
                        continue;
                    }
                    this.m_peakelListPerFeature.add(new ArrayList());
                }
                HashMap<Long, Integer> m_quantitationChannelOrderMap = new HashMap<Long, Integer>();
                int index = 0;
                for (DQuantitationChannel quantChannel : this.m_quantChannels) {
                    m_quantitationChannelOrderMap.put(quantChannel.getId(), index);
                    ++index;
                }
                int size = this.m_childFeatureList.size();
                for (int n = 0; n < size; ++n) {
                    for (int m = 0; m < size - 1 - n; ++m) {
                        int indexB;
                        DFeature featureA = this.m_childFeatureList.get(m);
                        DFeature featureB = this.m_childFeatureList.get(m + 1);
                        int indexA = (Integer)m_quantitationChannelOrderMap.get(featureA.getQuantChannelId());
                        if (indexA - (indexB = ((Integer)m_quantitationChannelOrderMap.get(featureB.getQuantChannelId())).intValue()) <= 0) continue;
                        this.m_childFeatureList.set(m, featureB);
                        this.m_childFeatureList.set(m + 1, featureA);
                        List<Peakel> peakelListA = this.m_peakelListPerFeature.get(m);
                        List<Peakel> peakelListB = this.m_peakelListPerFeature.get(m + 1);
                        this.m_peakelListPerFeature.set(m, peakelListB);
                        this.m_peakelListPerFeature.set(m + 1, peakelListA);
                    }
                }
            }
            entityManagerLCMS.getTransaction().commit();
        }
        this.m_defaultPriority = AbstractDatabaseTask.Priority.LOW;
        this.m_currentPriority = AbstractDatabaseTask.Priority.LOW;
        return true;
    }

    private boolean fetchDataMainTaskAlignmentForXic() {
        this.m_taskError = DatabaseLoadLcMSTask.fetchDataMainTaskAlignmentForXic(this.m_projectId, this.m_dataset);
        this.m_defaultPriority = AbstractDatabaseTask.Priority.LOW;
        this.m_currentPriority = AbstractDatabaseTask.Priority.LOW;
        return this.m_taskError == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TaskError fetchDataMainTaskAlignmentForXic(Long projectId, DDataset dataset) {
        long start = System.currentTimeMillis();
        EntityManager entityManagerLCMS = DStoreCustomPoolConnectorFactory.getInstance().getLcMsDbConnector(projectId.longValue()).createEntityManager();
        try {
            entityManagerLCMS.getTransaction().begin();
            if (dataset != null && dataset.getMasterQuantitationChannels() != null) {
                List listMasterQuantitationChannels = dataset.getMasterQuantitationChannels();
                for (DMasterQuantitationChannel masterQuantitationChannel : listMasterQuantitationChannels) {
                    List listQuantChannels = masterQuantitationChannel.getQuantitationChannels();
                    if (listQuantChannels == null || listQuantChannels.isEmpty()) continue;
                    ArrayList<MapAlignment> allMapAlignmentList = new ArrayList<MapAlignment>();
                    ArrayList<ProcessedMap> allMaps = new ArrayList<ProcessedMap>();
                    ArrayList<Long> listMapIds = new ArrayList<Long>();
                    for (DQuantitationChannel quantitationChannel : listQuantChannels) {
                        if (quantitationChannel.getLcmsMapId() == null) continue;
                        listMapIds.add(quantitationChannel.getLcmsMapId());
                    }
                    String queryMasterMap = "SELECT pm.id, pm.mapSet.id FROM fr.proline.core.orm.lcms.ProcessedMap pm WHERE pm.id IN (:listId) AND pm.isAlnReference is true ";
                    Query queryMasterMapQ = entityManagerLCMS.createQuery(queryMasterMap);
                    queryMasterMapQ.setParameter("listId", listMapIds);
                    List rl = new ArrayList();
                    Long mapSetId = -1L;
                    if (!listMapIds.isEmpty()) {
                        rl = queryMasterMapQ.getResultList();
                    }
                    for (Object[] res : rl) {
                        dataset.setAlnReferenceMapId((Long)res[0]);
                        mapSetId = (Long)res[1];
                    }
                    String queryAllAlignS = "SELECT ma FROM fr.proline.core.orm.lcms.MapAlignment ma WHERE ma.mapSet.id=:mapSetId  ";
                    TypedQuery queryAllAlign = entityManagerLCMS.createQuery(queryAllAlignS, MapAlignment.class);
                    queryAllAlign.setParameter("mapSetId", (Object)mapSetId);
                    List rs2 = queryAllAlign.getResultList();
                    for (MapAlignment ma : rs2) {
                        allMapAlignmentList.add(ma);
                    }
                    dataset.setMapAlignments(allMapAlignmentList);
                    Object orderBy = " case pm.id ";
                    int index = 1;
                    for (Long id : listMapIds) {
                        orderBy = (String)orderBy + " when " + id + " then " + index;
                        ++index;
                    }
                    orderBy = (String)orderBy + " else " + index + " end ";
                    String queryAllProcessedMapS = "SELECT pm FROM fr.proline.core.orm.lcms.ProcessedMap pm WHERE pm.id IN (:listId) ORDER BY " + (String)orderBy;
                    if (listMapIds.size() <= 0) continue;
                    TypedQuery queryAllProcessedMap = entityManagerLCMS.createQuery(queryAllProcessedMapS, ProcessedMap.class);
                    queryAllProcessedMap.setParameter("listId", listMapIds);
                    List rs3 = queryAllProcessedMap.getResultList();
                    for (ProcessedMap pm : rs3) {
                        Hibernate.initialize((Object)pm.getRawMaps());
                        Hibernate.initialize((Object)pm.getProcessedMapMozCalibration());
                        allMaps.add(pm);
                    }
                    dataset.setMaps(allMaps);
                }
            }
            entityManagerLCMS.getTransaction().commit();
        }
        catch (Exception e) {
            m_logger.error("fetchDataMainTaskAlignmentForXic failed", (Throwable)e);
            TaskError taskError = new TaskError(e);
            entityManagerLCMS.getTransaction().rollback();
            TaskError taskError2 = taskError;
            return taskError2;
        }
        finally {
            m_logger.info("fetchDataMainTaskAlignmentForXic took " + (System.currentTimeMillis() - start) + " ms");
            entityManagerLCMS.close();
        }
        return null;
    }
}

