/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.msfiles;

import fr.proline.mzscope.model.IExportParameters;
import fr.proline.mzscope.mzdb.MzdbRawFile;
import fr.proline.studio.dam.taskinfo.TaskError;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.msfiles.MgfExportSettings;
import java.io.File;

public class MgfExportTask
extends AbstractDatabaseTask {
    private final File m_file;
    private final MgfExportSettings m_exportSettings;

    public MgfExportTask(AbstractDatabaseCallback callback, File file, MgfExportSettings exportSettings) {
        super(callback, new TaskInfo("Export .mgf file for " + file.getAbsolutePath(), false, "Generic Task", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_file = file;
        this.m_exportSettings = exportSettings;
    }

    public boolean fetchData() {
        try {
            MzdbRawFile mzdbFile = new MzdbRawFile(this.m_file);
            String outputFileName = this.m_exportSettings.getDestinationDirectory() + File.separator + this.m_file.getName().substring(0, this.m_file.getName().lastIndexOf(".mzdb")) + ".mgf";
            mzdbFile.exportRawFile(outputFileName, (IExportParameters)this.m_exportSettings.getMgfExportParameters());
            return true;
        }
        catch (Exception ex) {
            this.m_taskError = new TaskError("Mgf Exportation Error", "Exporting .mgf for " + this.m_file.getAbsolutePath() + " failed.\n");
            return false;
        }
    }

    public boolean needToFetch() {
        return true;
    }
}

