/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern;

import fr.proline.core.orm.msi.ResultSet;
import fr.proline.core.orm.msi.dto.DMsQuery;
import fr.proline.core.orm.util.TransientDataInterface;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseLoadMSQueriesTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.GlobalTabelModelProviderInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.MsQueryInfoRset;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.pattern.ParameterSubtypeEnum;
import fr.proline.studio.rsmexplorer.gui.MSQueriesPanel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataBoxMSQueriesForRset
extends AbstractDataBox {
    private ResultSet m_rset = null;
    private List<DMsQuery> m_msQueriesList = null;
    private Map<Long, Integer> m_nbPeptideMatchesByMsQueryIdMap;

    public DataBoxMSQueriesForRset() {
        super(AbstractDataBox.DataboxType.DataBoxMSQueriesForRset, AbstractDataBox.DataboxStyle.STYLE_RSET);
        this.m_typeName = "MSQueries";
        this.m_description = "All MSQueries of a Search Result";
        ParameterList inParameter = new ParameterList();
        inParameter.addParameter(ResultSet.class);
        this.registerInParameter(inParameter);
        ParameterList outParameter = new ParameterList();
        outParameter.addParameter(DMsQuery.class);
        outParameter.addParameter(ResultSet.class);
        outParameter.addParameter(MsQueryInfoRset.class);
        outParameter.addParameter(ExtendedTableModelInterface.class);
        this.registerOutParameter(outParameter);
    }

    @Override
    public void createPanel() {
        MSQueriesPanel p = new MSQueriesPanel(false);
        p.setName(this.m_typeName);
        p.setDataBox(this);
        this.setDataBoxPanelInterface(p);
    }

    @Override
    public void dataChanged() {
        ResultSet _rset = this.m_rset != null ? this.m_rset : (ResultSet)this.getData(ResultSet.class);
        this.linkCache((TransientDataInterface)_rset);
        final int loadingId = this.setLoading();
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                if (subTask == null) {
                    ((MSQueriesPanel)DataBoxMSQueriesForRset.this.getDataBoxPanelInterface()).setData(taskId, DataBoxMSQueriesForRset.this.m_msQueriesList, DataBoxMSQueriesForRset.this.m_nbPeptideMatchesByMsQueryIdMap, finished);
                } else {
                    ((MSQueriesPanel)DataBoxMSQueriesForRset.this.getDataBoxPanelInterface()).dataUpdated(subTask, finished);
                }
                DataBoxMSQueriesForRset.this.setLoaded(loadingId);
                if (finished) {
                    DataBoxMSQueriesForRset.this.unregisterTask(taskId);
                    DataBoxMSQueriesForRset.this.addDataChanged(ExtendedTableModelInterface.class);
                    DataBoxMSQueriesForRset.this.propagateDataChanged();
                }
            }
        };
        this.m_msQueriesList = new ArrayList<DMsQuery>();
        this.m_nbPeptideMatchesByMsQueryIdMap = new HashMap<Long, Integer>();
        DatabaseLoadMSQueriesTask task = new DatabaseLoadMSQueriesTask(callback);
        task.initLoadMSQueries(this.getProjectId(), _rset, this.m_msQueriesList, this.m_nbPeptideMatchesByMsQueryIdMap);
        this.registerTask((AbstractDatabaseTask)task);
    }

    @Override
    public void setEntryData(Object data) {
        this.getDataBoxPanelInterface().addSingleValue(data);
        if (data instanceof ResultSet) {
            this.m_rset = (ResultSet)data;
            this.dataChanged();
        }
    }

    @Override
    public Object getDataImpl(Class parameterType, ParameterSubtypeEnum parameterSubtype) {
        if (parameterType != null && parameterSubtype == ParameterSubtypeEnum.SINGLE_DATA) {
            if (parameterType.equals(DMsQuery.class)) {
                return ((MSQueriesPanel)this.getDataBoxPanelInterface()).getSelectedMsQuery();
            }
            if (parameterType.equals(ResultSet.class)) {
                return this.m_rset;
            }
            if (parameterType.equals(MsQueryInfoRset.class)) {
                DMsQuery msq = ((MSQueriesPanel)this.getDataBoxPanelInterface()).getSelectedMsQuery();
                return new MsQueryInfoRset(msq, this.m_rset);
            }
            if (parameterType.equals(ExtendedTableModelInterface.class)) {
                return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getGlobalTableModelInterface();
            }
            if (parameterType.equals(CrossSelectionInterface.class)) {
                return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getCrossSelectionInterface();
            }
        }
        return super.getDataImpl(parameterType, parameterSubtype);
    }

    @Override
    public Class[] getDataboxNavigationOutParameterClasses() {
        Class[] classList = new Class[]{DMsQuery.class, MsQueryInfoRset.class};
        return classList;
    }

    @Override
    public String getDataboxNavigationDisplayValue() {
        DMsQuery q = (DMsQuery)this.getData(DMsQuery.class);
        if (q != null) {
            int id = q.getInitialId();
            return String.valueOf(id);
        }
        return null;
    }
}

