/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern;

import fr.proline.core.orm.msi.ResultSet;
import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.core.orm.util.TransientDataAllocationListener;
import fr.proline.core.orm.util.TransientDataInterface;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.memory.TransientMemoryCacheManager;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseProteinMatchesTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.GlobalTabelModelProviderInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.pattern.ParameterSubtypeEnum;
import fr.proline.studio.rsmexplorer.gui.RsetProteinsPanel;

public class DataBoxRsetAllProteinMatch
extends AbstractDataBox {
    private ResultSet m_rset;
    private Long m_previousTaskId = null;

    public DataBoxRsetAllProteinMatch() {
        super(AbstractDataBox.DataboxType.DataBoxRsetAllProteinMatch, AbstractDataBox.DataboxStyle.STYLE_RSET);
        this.m_typeName = "Proteins";
        this.m_description = "All Proteins of a Search Result";
        ParameterList inParameter = new ParameterList();
        inParameter.addParameter(ResultSet.class);
        this.registerInParameter(inParameter);
        ParameterList outParameter = new ParameterList();
        outParameter.addParameter(DProteinMatch.class);
        outParameter.addParameter(ResultSet.class);
        outParameter.addParameter(ExtendedTableModelInterface.class);
        this.registerOutParameter(outParameter);
    }

    @Override
    public void createPanel() {
        RsetProteinsPanel p = new RsetProteinsPanel(true);
        p.setName(this.m_typeName);
        p.setDataBox(this);
        this.setDataBoxPanelInterface(p);
    }

    @Override
    public void dataChanged() {
        final ResultSet _rset = this.m_rset != null ? this.m_rset : (ResultSet)this.getData(ResultSet.class);
        this.linkCache((TransientDataInterface)_rset);
        final int loadingId = this.setLoading();
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                if (subTask == null) {
                    DProteinMatch[] proteinMatchArray = _rset.getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).getProteinMatches();
                    ((RsetProteinsPanel)DataBoxRsetAllProteinMatch.this.getDataBoxPanelInterface()).setDataProteinMatchArray(proteinMatchArray, finished);
                } else {
                    ((RsetProteinsPanel)DataBoxRsetAllProteinMatch.this.getDataBoxPanelInterface()).dataUpdated(subTask, finished);
                }
                DataBoxRsetAllProteinMatch.this.setLoaded(loadingId);
                if (finished) {
                    DataBoxRsetAllProteinMatch.this.unregisterTask(taskId);
                    DataBoxRsetAllProteinMatch.this.addDataChanged(ExtendedTableModelInterface.class);
                    DataBoxRsetAllProteinMatch.this.propagateDataChanged();
                }
            }
        };
        DatabaseProteinMatchesTask task = new DatabaseProteinMatchesTask(callback, this.getProjectId(), _rset);
        Long taskId = task.getId();
        if (this.m_previousTaskId != null) {
            AccessDatabaseThread.getAccessDatabaseThread().abortTask(this.m_previousTaskId);
        }
        this.m_previousTaskId = taskId;
        this.registerTask((AbstractDatabaseTask)task);
    }

    @Override
    public Object getDataImpl(Class parameterType, ParameterSubtypeEnum parameterSubtype) {
        if (parameterType != null && parameterSubtype == ParameterSubtypeEnum.SINGLE_DATA) {
            if (parameterType.equals(DProteinMatch.class)) {
                return ((RsetProteinsPanel)this.getDataBoxPanelInterface()).getSelectedProteinMatch();
            }
            if (parameterType.equals(ResultSet.class) && this.m_rset != null) {
                return this.m_rset;
            }
            if (parameterType.equals(ExtendedTableModelInterface.class)) {
                return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getGlobalTableModelInterface();
            }
            if (parameterType.equals(CrossSelectionInterface.class)) {
                return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getCrossSelectionInterface();
            }
        }
        return super.getDataImpl(parameterType, parameterSubtype);
    }

    @Override
    public void setEntryData(Object data) {
        this.getDataBoxPanelInterface().addSingleValue(data);
        this.m_rset = (ResultSet)data;
        this.dataChanged();
    }

    @Override
    public Class[] getDataboxNavigationOutParameterClasses() {
        return new Class[]{DProteinMatch.class};
    }

    @Override
    public String getDataboxNavigationDisplayValue() {
        DProteinMatch pm = (DProteinMatch)this.getData(DProteinMatch.class);
        if (pm != null) {
            return pm.getAccession();
        }
        return null;
    }
}

