/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern;

import fr.proline.core.orm.msi.Peptide;
import fr.proline.core.orm.msi.ResultSet;
import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.msi.dto.DMsQuery;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.util.TransientDataInterface;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseLoadPeptideMatchTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.GlobalTabelModelProviderInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.MsQueryInfoRsm;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.pattern.ParameterSubtypeEnum;
import fr.proline.studio.rsmexplorer.gui.PeptideMatchPanel;
import java.util.ArrayList;
import java.util.List;

public class DataBoxRsmPSMForMsQuery
extends AbstractDataBox {
    private DMsQuery m_msQuery;
    private ResultSet m_rset;
    private ResultSummary m_rsm;
    private List<DPeptideMatch> m_peptideMatches;
    private boolean m_mergedData;

    public DataBoxRsmPSMForMsQuery() {
        this(false);
    }

    public DataBoxRsmPSMForMsQuery(boolean mergedData) {
        super(AbstractDataBox.DataboxType.DataBoxRSMPSMForMsQuery, AbstractDataBox.DataboxStyle.STYLE_RSM);
        this.m_mergedData = mergedData;
        this.m_typeName = "PSMs";
        this.m_description = "All PSMs corresponding to a MsQuery for an Identification Summary";
        ParameterList inParameter = new ParameterList();
        inParameter.addParameter(MsQueryInfoRsm.class);
        this.registerInParameter(inParameter);
        ParameterList outParameter = new ParameterList();
        outParameter.addParameter(DPeptideMatch.class);
        outParameter.addParameter(ExtendedTableModelInterface.class);
        outParameter.addParameter(CrossSelectionInterface.class);
        this.registerOutParameter(outParameter);
    }

    @Override
    public void createPanel() {
        PeptideMatchPanel p = new PeptideMatchPanel(true, this.m_mergedData, false, true, true);
        p.setName(this.m_typeName);
        p.setDataBox(this);
        this.setDataBoxPanelInterface(p);
    }

    @Override
    public void dataChanged() {
        long oldMsQId = this.m_msQuery == null ? -1L : this.m_msQuery.getId();
        MsQueryInfoRsm _msqI = (MsQueryInfoRsm)this.getData(MsQueryInfoRsm.class);
        if (_msqI == null) {
            this.m_msQuery = null;
            this.m_rset = null;
            this.m_rsm = null;
            ((PeptideMatchPanel)this.getDataBoxPanelInterface()).setData(-1L, null, null, true);
            return;
        }
        if (_msqI.getMsQuery() != null && oldMsQId == _msqI.getMsQuery().getId()) {
            return;
        }
        this.m_msQuery = _msqI.getMsQuery();
        this.m_rset = _msqI.getResultSet();
        this.m_rsm = _msqI.getResultSummary();
        this.linkCache((TransientDataInterface)this.m_rset);
        this.linkCache((TransientDataInterface)this.m_rsm);
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                if (subTask == null) {
                    int nb = DataBoxRsmPSMForMsQuery.this.m_peptideMatches.size();
                    DPeptideMatch[] peptideMatchArray = new DPeptideMatch[nb];
                    long[] peptideMatchIdArray = new long[nb];
                    for (int i = 0; i < nb; ++i) {
                        peptideMatchArray[i] = DataBoxRsmPSMForMsQuery.this.m_peptideMatches.get(i);
                        peptideMatchIdArray[i] = DataBoxRsmPSMForMsQuery.this.m_peptideMatches.get(i).getId();
                    }
                    ((PeptideMatchPanel)DataBoxRsmPSMForMsQuery.this.getDataBoxPanelInterface()).setData(taskId, peptideMatchArray, peptideMatchIdArray, finished);
                } else {
                    ((PeptideMatchPanel)DataBoxRsmPSMForMsQuery.this.getDataBoxPanelInterface()).dataUpdated(subTask, finished);
                }
                if (finished) {
                    DataBoxRsmPSMForMsQuery.this.unregisterTask(taskId);
                    DataBoxRsmPSMForMsQuery.this.addDataChanged(ExtendedTableModelInterface.class);
                    DataBoxRsmPSMForMsQuery.this.propagateDataChanged();
                }
            }
        };
        this.m_peptideMatches = new ArrayList<DPeptideMatch>();
        if (this.m_msQuery != null) {
            this.registerTask((AbstractDatabaseTask)new DatabaseLoadPeptideMatchTask(callback, this.getProjectId(), this.m_msQuery, this.m_rsm, this.m_rset, this.m_peptideMatches));
        }
    }

    @Override
    public Object getDataImpl(Class parameterType, ParameterSubtypeEnum parameterSubtype) {
        if (parameterType != null && parameterSubtype == ParameterSubtypeEnum.SINGLE_DATA) {
            if (parameterType.equals(DPeptideMatch.class)) {
                return ((PeptideMatchPanel)this.getDataBoxPanelInterface()).getSelectedPeptideMatch();
            }
            if (parameterType.equals(ExtendedTableModelInterface.class)) {
                return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getGlobalTableModelInterface();
            }
            if (parameterType.equals(CrossSelectionInterface.class)) {
                return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getCrossSelectionInterface();
            }
        }
        return super.getDataImpl(parameterType, parameterSubtype);
    }

    @Override
    public void setEntryData(Object data) {
        this.getDataBoxPanelInterface().addSingleValue(data);
        if (data instanceof MsQueryInfoRsm) {
            MsQueryInfoRsm o = (MsQueryInfoRsm)data;
            this.m_msQuery = o.getMsQuery();
            this.m_rset = o.getResultSet();
            this.getDataBoxPanelInterface().addSingleValue(this.m_rset);
            this.m_rsm = o.getResultSummary();
            this.getDataBoxPanelInterface().addSingleValue(this.m_rsm);
            this.dataChanged();
        }
    }

    @Override
    public Class[] getDataboxNavigationOutParameterClasses() {
        return new Class[]{DPeptideMatch.class};
    }

    @Override
    public String getDataboxNavigationDisplayValue() {
        Peptide peptide;
        DPeptideMatch p = (DPeptideMatch)this.getData(DPeptideMatch.class);
        if (p != null && (peptide = p.getPeptide()) != null) {
            return peptide.getSequence();
        }
        return null;
    }
}

