/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern;

import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.msi.dto.DInfoPTM;
import fr.proline.core.orm.msi.dto.DPeptideInstance;
import fr.proline.core.orm.msi.dto.DPeptideSet;
import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.core.orm.util.TransientDataInterface;
import fr.proline.studio.dam.tasks.DatabasePTMsTask;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.pattern.ParameterSubtypeEnum;
import fr.proline.studio.rsmexplorer.gui.RsmProteinAndPeptideSequencePanel;

public class DataBoxRsmProteinAndPeptideSequence
extends AbstractDataBox {
    public DataBoxRsmProteinAndPeptideSequence() {
        super(AbstractDataBox.DataboxType.DataBoxRsmProteinAndPeptideSequence, AbstractDataBox.DataboxStyle.STYLE_RSM);
        this.m_typeName = "Protein Sequence";
        this.m_description = "Protein Sequence and its Peptides Sequences";
        ParameterList inParameter = new ParameterList();
        inParameter.addParameter(DProteinMatch.class);
        inParameter.addParameter(DPeptideInstance.class, ParameterSubtypeEnum.SINGLE_DATA, false);
        inParameter.addParameter(ResultSummary.class);
        this.registerInParameter(inParameter);
    }

    @Override
    public void createPanel() {
        RsmProteinAndPeptideSequencePanel p = new RsmProteinAndPeptideSequencePanel();
        p.setName(this.m_typeName);
        p.setDataBox(this);
        this.setDataBoxPanelInterface(p);
    }

    @Override
    public void dataChanged() {
        DProteinMatch proteinMatch = (DProteinMatch)this.getData(DProteinMatch.class);
        DPeptideInstance selectedPeptide = (DPeptideInstance)this.getData(DPeptideInstance.class);
        ResultSummary resultSummary = (ResultSummary)this.getData(ResultSummary.class);
        if (proteinMatch == null || resultSummary == null) {
            ((RsmProteinAndPeptideSequencePanel)this.getDataBoxPanelInterface()).setData(null, null, null, null);
            return;
        }
        this.linkCache((TransientDataInterface)resultSummary);
        DPeptideSet peptideSet = proteinMatch.getPeptideSet(Long.valueOf(resultSummary.getId()));
        if (peptideSet == null) {
            ((RsmProteinAndPeptideSequencePanel)this.getDataBoxPanelInterface()).setData(null, null, null, null);
            return;
        }
        DPeptideInstance[] peptideInstances = peptideSet.getPeptideInstances();
        if (peptideInstances == null) {
            selectedPeptide = null;
        } else if (selectedPeptide != null) {
            boolean foundPeptide = false;
            for (DPeptideInstance peptideInstance : peptideInstances) {
                if (peptideInstance.getId() != selectedPeptide.getId()) continue;
                foundPeptide = true;
                break;
            }
            if (!foundPeptide) {
                selectedPeptide = null;
            }
        }
        Long projectId = this.getProjectId();
        if (DInfoPTM.getInfoPTMMap().isEmpty()) {
            DatabasePTMsTask ptmTask = new DatabasePTMsTask(null);
            ptmTask.initFillPTMInfo(projectId);
            ptmTask.fetchData();
        }
        ((RsmProteinAndPeptideSequencePanel)this.getDataBoxPanelInterface()).setData(projectId, proteinMatch, selectedPeptide, peptideInstances);
    }
}

