/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern;

import fr.proline.core.orm.msi.Peptide;
import fr.proline.core.orm.msi.ResultSet;
import fr.proline.core.orm.msi.dto.DMsQuery;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.util.TransientDataInterface;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseLoadPeptideMatchTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.GlobalTabelModelProviderInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.MsQueryInfoRset;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.pattern.ParameterSubtypeEnum;
import fr.proline.studio.rsmexplorer.gui.PeptideMatchPanel;
import java.util.ArrayList;
import java.util.List;

public class DataboxRsetPSMForMsQuery
extends AbstractDataBox {
    private DMsQuery m_msQuery;
    private ResultSet m_rset;
    private List<DPeptideMatch> m_peptideMatches;
    private boolean m_mergedData;

    public DataboxRsetPSMForMsQuery() {
        this(false);
    }

    public DataboxRsetPSMForMsQuery(boolean mergedData) {
        super(AbstractDataBox.DataboxType.DataBoxRsetPSMForMsQuery, AbstractDataBox.DataboxStyle.STYLE_RSET);
        this.m_mergedData = mergedData;
        this.m_typeName = "PSMs";
        this.m_description = "All PSMs corresponding to a MsQuery for a Search Result";
        ParameterList inParameter = new ParameterList();
        inParameter.addParameter(MsQueryInfoRset.class);
        this.registerInParameter(inParameter);
        ParameterList outParameter = new ParameterList();
        outParameter.addParameter(DPeptideMatch.class);
        outParameter.addParameter(ExtendedTableModelInterface.class);
        outParameter.addParameter(CrossSelectionInterface.class);
        this.registerOutParameter(outParameter);
    }

    @Override
    public void createPanel() {
        PeptideMatchPanel p = new PeptideMatchPanel(false, this.m_mergedData, false, true, true);
        p.setName(this.m_typeName);
        p.setDataBox(this);
        this.setDataBoxPanelInterface(p);
    }

    @Override
    public void dataChanged() {
        long oldMsQId = this.m_msQuery == null ? -1L : this.m_msQuery.getId();
        MsQueryInfoRset _msqI = (MsQueryInfoRset)this.getData(MsQueryInfoRset.class);
        if (_msqI == null || _msqI.getMsQuery() != null && oldMsQId == _msqI.getMsQuery().getId()) {
            return;
        }
        this.m_msQuery = _msqI.getMsQuery();
        this.m_rset = _msqI.getResultSet();
        this.linkCache((TransientDataInterface)this.m_rset);
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                if (subTask == null) {
                    int nb = DataboxRsetPSMForMsQuery.this.m_peptideMatches.size();
                    DPeptideMatch[] peptideMatchArray = new DPeptideMatch[nb];
                    long[] peptideMatchIdArray = new long[nb];
                    for (int i = 0; i < nb; ++i) {
                        peptideMatchArray[i] = DataboxRsetPSMForMsQuery.this.m_peptideMatches.get(i);
                        peptideMatchIdArray[i] = DataboxRsetPSMForMsQuery.this.m_peptideMatches.get(i).getId();
                    }
                    ((PeptideMatchPanel)DataboxRsetPSMForMsQuery.this.getDataBoxPanelInterface()).setData(taskId, peptideMatchArray, peptideMatchIdArray, finished);
                } else {
                    ((PeptideMatchPanel)DataboxRsetPSMForMsQuery.this.getDataBoxPanelInterface()).dataUpdated(subTask, finished);
                }
                if (finished) {
                    DataboxRsetPSMForMsQuery.this.unregisterTask(taskId);
                    DataboxRsetPSMForMsQuery.this.addDataChanged(ExtendedTableModelInterface.class);
                    DataboxRsetPSMForMsQuery.this.propagateDataChanged();
                }
            }
        };
        this.m_peptideMatches = new ArrayList<DPeptideMatch>();
        if (this.m_msQuery != null) {
            this.registerTask((AbstractDatabaseTask)new DatabaseLoadPeptideMatchTask(callback, this.getProjectId(), this.m_msQuery, null, this.m_rset, this.m_peptideMatches));
        }
    }

    @Override
    public Object getDataImpl(Class parameterType, ParameterSubtypeEnum parameterSubtype) {
        if (parameterType != null && parameterSubtype == ParameterSubtypeEnum.SINGLE_DATA) {
            if (parameterType.equals(DPeptideMatch.class)) {
                return ((PeptideMatchPanel)this.getDataBoxPanelInterface()).getSelectedPeptideMatch();
            }
            if (parameterType.equals(ExtendedTableModelInterface.class)) {
                return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getGlobalTableModelInterface();
            }
            if (parameterType.equals(CrossSelectionInterface.class)) {
                return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getCrossSelectionInterface();
            }
        }
        return super.getDataImpl(parameterType, parameterSubtype);
    }

    @Override
    public void setEntryData(Object data) {
        this.getDataBoxPanelInterface().addSingleValue(data);
        if (data instanceof MsQueryInfoRset) {
            MsQueryInfoRset o = (MsQueryInfoRset)data;
            this.m_msQuery = o.getMsQuery();
            this.getDataBoxPanelInterface().addSingleValue(this.m_msQuery);
            this.m_rset = o.getResultSet();
            this.getDataBoxPanelInterface().addSingleValue(this.m_rset);
            this.dataChanged();
        }
    }

    @Override
    public Class[] getDataboxNavigationOutParameterClasses() {
        return new Class[]{DPeptideMatch.class};
    }

    @Override
    public String getDataboxNavigationDisplayValue() {
        Peptide peptide;
        DPeptideMatch p = (DPeptideMatch)this.getData(DPeptideMatch.class);
        if (p != null && (peptide = p.getPeptide()) != null) {
            return peptide.getSequence();
        }
        return null;
    }
}

