/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern;

import fr.proline.core.orm.msi.ResultSet;
import fr.proline.core.orm.uds.dto.DDatasetType;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataBoxAdjacencyMatrix;
import fr.proline.studio.pattern.DataBoxAdjacencyMatrixChoice;
import fr.proline.studio.pattern.DataBoxDataAnalyzerResults;
import fr.proline.studio.pattern.DataBoxImage;
import fr.proline.studio.pattern.DataBoxMSQueriesForRSM;
import fr.proline.studio.pattern.DataBoxMSQueriesForRset;
import fr.proline.studio.pattern.DataBoxMzScope;
import fr.proline.studio.pattern.DataBoxPTMClusters;
import fr.proline.studio.pattern.DataBoxPTMPeptides;
import fr.proline.studio.pattern.DataBoxPTMPeptidesGraphic;
import fr.proline.studio.pattern.DataBoxRsetAll;
import fr.proline.studio.pattern.DataBoxRsetAllProteinMatch;
import fr.proline.studio.pattern.DataBoxRsetMSDiag;
import fr.proline.studio.pattern.DataBoxRsetPSM;
import fr.proline.studio.pattern.DataBoxRsetPeptideFragmentation;
import fr.proline.studio.pattern.DataBoxRsetPeptideSpectrum;
import fr.proline.studio.pattern.DataBoxRsetPeptideSpectrumError;
import fr.proline.studio.pattern.DataBoxRsetPeptideSpectrumValues;
import fr.proline.studio.pattern.DataBoxRsetProteinsForPeptideMatch;
import fr.proline.studio.pattern.DataBoxRsmAllProteinSet;
import fr.proline.studio.pattern.DataBoxRsmPSM;
import fr.proline.studio.pattern.DataBoxRsmPSMForMsQuery;
import fr.proline.studio.pattern.DataBoxRsmPeptideInstances;
import fr.proline.studio.pattern.DataBoxRsmPeptidesOfProtein;
import fr.proline.studio.pattern.DataBoxRsmProteinAndPeptideSequence;
import fr.proline.studio.pattern.DataBoxRsmProteinSetOfPeptides;
import fr.proline.studio.pattern.DataBoxRsmProteinsOfProteinSet;
import fr.proline.studio.pattern.DataBoxSystemTasks;
import fr.proline.studio.pattern.DataBoxTaskDescription;
import fr.proline.studio.pattern.DataBoxTaskList;
import fr.proline.studio.pattern.DataboxDataAnalyzer;
import fr.proline.studio.pattern.DataboxGeneric;
import fr.proline.studio.pattern.DataboxGraphics;
import fr.proline.studio.pattern.DataboxMultiGraphics;
import fr.proline.studio.pattern.DataboxRsetPSMForMsQuery;
import fr.proline.studio.pattern.DataboxRsetPeptidesOfProtein;
import fr.proline.studio.pattern.DataboxRsmPSMOfProteinSet;
import fr.proline.studio.pattern.WindowBox;
import fr.proline.studio.pattern.xic.DataboxChildFeature;
import fr.proline.studio.pattern.xic.DataboxExperimentalDesign;
import fr.proline.studio.pattern.xic.DataboxMapAlignment;
import fr.proline.studio.pattern.xic.DataboxXicParentsPeptideIon;
import fr.proline.studio.pattern.xic.DataboxXicPeptideIon;
import fr.proline.studio.pattern.xic.DataboxXicPeptideSet;
import fr.proline.studio.pattern.xic.DataboxXicProteinSet;
import fr.proline.studio.pattern.xic.DataboxXicReporterIon;
import fr.proline.studio.utils.IconManager;
import java.awt.Component;
import java.awt.Image;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class WindowBoxFactory {
    public static WindowBox getUserDefinedWindowBox(String dataName, String windowName, AbstractDataBox databox, boolean isDecoy, boolean isXIC, char windowType) {
        AbstractDataBox[] boxes = new AbstractDataBox[]{databox};
        boxes[0].setDataName(dataName);
        WindowBox winBox = new WindowBox(windowName, WindowBoxFactory.generatePanel(boxes), boxes[0], switch (windowType) {
            case '2' -> IconManager.getImage((IconManager.IconType)(isDecoy ? IconManager.IconType.DATASET_RSM_DECOY : IconManager.IconType.DATASET_RSM));
            case '1' -> IconManager.getImage((IconManager.IconType)(isDecoy ? IconManager.IconType.DATASET_RSET_DECOY : IconManager.IconType.DATASET_RSET));
            case '3' -> IconManager.getImage((IconManager.IconType)(isXIC ? IconManager.IconType.QUANT_XIC : IconManager.IconType.QUANT_SC));
            default -> databox.getDefaultIcon();
        });
        return winBox;
    }

    public static WindowBox getDetailWindowBox(String dataName, String windowName, AbstractDataBox databox) {
        AbstractDataBox[] boxes = WindowBoxFactory.createBoxArray(databox, dataName);
        Image icon = databox.getDefaultIcon();
        WindowBox winBox = new WindowBox(windowName, WindowBoxFactory.generatePanel(boxes), boxes[0], icon);
        return winBox;
    }

    private static AbstractDataBox[] createBoxArray(AbstractDataBox databox, String dataName) {
        AbstractDataBox[] boxes;
        ResultSet rset = (ResultSet)databox.getData(ResultSet.class);
        if (databox instanceof DataBoxRsetProteinsForPeptideMatch) {
            boolean mergedData = false;
            if (rset != null) {
                ResultSet.Type rsType = rset.getType();
                mergedData = rsType == ResultSet.Type.USER || rsType == ResultSet.Type.DECOY_USER;
            }
            boxes = new AbstractDataBox[2];
            boxes[1] = new DataboxRsetPeptidesOfProtein(mergedData);
        } else if (databox instanceof DataBoxRsetPeptideSpectrumValues) {
            boxes = new AbstractDataBox[2];
            boxes[1] = new DataBoxRsetPeptideSpectrum();
            boxes[1].setLayout(SplittedPanelContainer.PanelLayout.TABBED);
        } else if (databox instanceof DataBoxRsetPeptideSpectrum) {
            boxes = new AbstractDataBox[4];
            boxes[1] = new DataBoxRsetPeptideSpectrumError();
            boxes[1].setLayout(SplittedPanelContainer.PanelLayout.TABBED);
            boxes[2] = new DataBoxRsetPeptideFragmentation();
            boxes[2].setLayout(SplittedPanelContainer.PanelLayout.TABBED);
            boxes[3] = new DataBoxRsetPeptideSpectrumValues();
            boxes[3].setLayout(SplittedPanelContainer.PanelLayout.TABBED);
        } else if (databox instanceof DataBoxAdjacencyMatrixChoice) {
            DataBoxAdjacencyMatrixChoice adjacencyMatrixChoice = (DataBoxAdjacencyMatrixChoice)databox;
            adjacencyMatrixChoice.setKeepSameset(true);
            adjacencyMatrixChoice.doNotTakeFirstSelection(true);
            adjacencyMatrixChoice.createPanel();
            databox = new DataBoxAdjacencyMatrix();
            adjacencyMatrixChoice.addNextDataBox(databox);
            boxes = new AbstractDataBox[7];
            boxes[1] = new DataBoxRsetPeptideSpectrum();
            boxes[2] = new DataBoxRsetPeptideSpectrumError();
            boxes[2].setLayout(SplittedPanelContainer.PanelLayout.TABBED);
            boxes[3] = new DataBoxRsetPeptideFragmentation();
            boxes[3].setLayout(SplittedPanelContainer.PanelLayout.TABBED);
            boxes[4] = new DataBoxRsetPeptideSpectrumValues();
            boxes[4].setLayout(SplittedPanelContainer.PanelLayout.TABBED);
            boxes[5] = new DataBoxRsmProteinAndPeptideSequence();
            boxes[6] = new DataBoxRsmPeptidesOfProtein();
            boxes[6].setLayout(SplittedPanelContainer.PanelLayout.TABBED);
        } else if (databox instanceof DataBoxRsmProteinSetOfPeptides) {
            boxes = new AbstractDataBox[3];
            boxes[1] = new DataBoxRsmProteinsOfProteinSet();
            boxes[2] = new DataBoxRsmPeptidesOfProtein();
        } else if (databox instanceof DataBoxRsmProteinsOfProteinSet) {
            boxes = new AbstractDataBox[7];
            boxes[1] = new DataBoxRsmPeptidesOfProtein();
            boxes[2] = new DataBoxRsmProteinAndPeptideSequence();
            boxes[3] = new DataBoxRsetPeptideSpectrum();
            boxes[3].setLayout(SplittedPanelContainer.PanelLayout.TABBED);
            boxes[4] = new DataBoxRsetPeptideSpectrumError();
            boxes[4].setLayout(SplittedPanelContainer.PanelLayout.TABBED);
            boxes[5] = new DataBoxRsetPeptideFragmentation();
            boxes[5].setLayout(SplittedPanelContainer.PanelLayout.TABBED);
            boxes[6] = new DataBoxRsetPeptideSpectrumValues();
            boxes[6].setLayout(SplittedPanelContainer.PanelLayout.TABBED);
        } else if (databox instanceof DataboxRsmPSMOfProteinSet) {
            boxes = new AbstractDataBox[5];
            boxes[1] = new DataBoxRsetPeptideSpectrum();
            boxes[2] = new DataBoxRsetPeptideSpectrumError();
            boxes[2].setLayout(SplittedPanelContainer.PanelLayout.TABBED);
            boxes[3] = new DataBoxRsetPeptideFragmentation();
            boxes[3].setLayout(SplittedPanelContainer.PanelLayout.TABBED);
            boxes[4] = new DataBoxRsetPeptideSpectrumValues();
            boxes[4].setLayout(SplittedPanelContainer.PanelLayout.TABBED);
        } else if (databox instanceof DataBoxRsmPeptidesOfProtein) {
            boxes = new AbstractDataBox[6];
            boxes[1] = new DataBoxRsmProteinAndPeptideSequence();
            boxes[2] = new DataBoxRsetPeptideSpectrum();
            boxes[2].setLayout(SplittedPanelContainer.PanelLayout.TABBED);
            boxes[3] = new DataBoxRsetPeptideSpectrumError();
            boxes[3].setLayout(SplittedPanelContainer.PanelLayout.TABBED);
            boxes[4] = new DataBoxRsetPeptideFragmentation();
            boxes[4].setLayout(SplittedPanelContainer.PanelLayout.TABBED);
            boxes[5] = new DataBoxRsetPeptideSpectrumValues();
            boxes[5].setLayout(SplittedPanelContainer.PanelLayout.TABBED);
        } else {
            boxes = new AbstractDataBox[]{databox};
        }
        boxes[0].setDataName(dataName);
        return boxes;
    }

    public static WindowBox getPeptidesWindowBox(String dataName, boolean isDecoy, boolean isMerged) {
        return WindowBoxFactory.getPeptidesForRsetOnlyWindowBox(dataName, isDecoy, isMerged);
    }

    public static WindowBox getPeptidesForRsetOnlyWindowBox(String dataName, boolean isDecoy, boolean isMerged) {
        AbstractDataBox[] boxes = new AbstractDataBox[6];
        boxes[0] = new DataBoxRsetPSM(isMerged);
        boxes[0].setDataName(dataName);
        boxes[1] = new DataBoxRsetPeptideSpectrum();
        boxes[2] = new DataBoxRsetPeptideSpectrumError();
        boxes[2].setLayout(SplittedPanelContainer.PanelLayout.TABBED);
        boxes[3] = new DataBoxRsetPeptideFragmentation();
        boxes[3].setLayout(SplittedPanelContainer.PanelLayout.TABBED);
        boxes[4] = new DataBoxRsetPeptideSpectrumValues();
        boxes[4].setLayout(SplittedPanelContainer.PanelLayout.TABBED);
        boxes[5] = new DataBoxRsetProteinsForPeptideMatch();
        IconManager.IconType iconType = isDecoy ? IconManager.IconType.DATASET_RSET_DECOY : IconManager.IconType.DATASET_RSET;
        WindowBox winBox = new WindowBox(boxes[0].getFullName(), WindowBoxFactory.generatePanel(boxes), boxes[0], IconManager.getImage((IconManager.IconType)iconType));
        return winBox;
    }

    public static WindowBox getMSDiagWindowBox(String dataName, HashMap<String, String> resultMessage) {
        AbstractDataBox[] boxes = new AbstractDataBox[]{new DataBoxRsetMSDiag(resultMessage)};
        boxes[0].setDataName(dataName);
        IconManager.IconType iconType = IconManager.IconType.CHART_PIE;
        WindowBox winBox = new WindowBox(dataName, WindowBoxFactory.generatePanel(boxes), boxes[0], IconManager.getImage((IconManager.IconType)iconType));
        return winBox;
    }

    public static WindowBox getGraphicsWindowBox(String fullName, AbstractDataBox srcDatabox, boolean locked) {
        AbstractDataBox[] boxes = new AbstractDataBox[]{new DataboxGraphics(locked)};
        srcDatabox.addNextDataBox(boxes[0]);
        IconManager.IconType iconType = IconManager.IconType.CHART;
        WindowBox winBox = new WindowBox(fullName, WindowBoxFactory.generatePanel(boxes), boxes[0], IconManager.getImage((IconManager.IconType)iconType));
        boxes[0].dataChanged();
        return winBox;
    }

    public static WindowBox getGraphicsWindowBox(String fullName, ExtendedTableModelInterface srcDataInterface, boolean locked) {
        AbstractDataBox[] boxes = new AbstractDataBox[]{new DataboxGraphics(locked)};
        IconManager.IconType iconType = IconManager.IconType.CHART;
        WindowBox winBox = new WindowBox(fullName, WindowBoxFactory.generatePanel(boxes), boxes[0], IconManager.getImage((IconManager.IconType)iconType));
        boxes[0].setEntryData(srcDataInterface);
        return winBox;
    }

    public static WindowBox getMultiGraphicsWindowBox(String fullName, AbstractDataBox srcDatabox, boolean canChooseColor) {
        AbstractDataBox[] boxes = new AbstractDataBox[]{new DataboxMultiGraphics(true, canChooseColor)};
        srcDatabox.addNextDataBox(boxes[0]);
        IconManager.IconType iconType = IconManager.IconType.CHART;
        WindowBox winBox = new WindowBox(fullName, WindowBoxFactory.generatePanel(boxes), boxes[0], IconManager.getImage((IconManager.IconType)iconType));
        boxes[0].dataChanged();
        return winBox;
    }

    public static WindowBox getProteinMatchesForRsetWindowBox(String dataName, boolean isDecoy, boolean mergedData) {
        AbstractDataBox[] boxes = new AbstractDataBox[2];
        boxes[0] = new DataBoxRsetAllProteinMatch();
        boxes[0].setDataName(dataName);
        boxes[1] = new DataboxRsetPeptidesOfProtein(mergedData);
        IconManager.IconType iconType = isDecoy ? IconManager.IconType.DATASET_RSET_DECOY : IconManager.IconType.DATASET_RSET;
        WindowBox winBox = new WindowBox(boxes[0].getFullName(), WindowBoxFactory.generatePanel(boxes), boxes[0], IconManager.getImage((IconManager.IconType)iconType));
        return winBox;
    }

    public static WindowBox getPTMDataWindowBox(String dataName, boolean viewSites, boolean isAnnotated, boolean unsaved) {
        AbstractDataBox[] boxes = new AbstractDataBox[4];
        boxes[0] = new DataBoxPTMClusters(viewSites, isAnnotated);
        boxes[0].setDataName(dataName);
        boxes[1] = new DataBoxPTMPeptidesGraphic();
        boxes[2] = new DataBoxPTMPeptides(false, false);
        boxes[2].setLayout(SplittedPanelContainer.PanelLayout.HORIZONTAL);
        boxes[3] = new DataBoxPTMPeptides(false, true);
        boxes[3].setLayout(SplittedPanelContainer.PanelLayout.TABBED);
        IconManager.IconType iconType = IconManager.IconType.DATASET_RSM;
        Object title = boxes[0].getFullName();
        if (unsaved && !((String)title).endsWith("***")) {
            title = (String)title + " ***";
        }
        return new WindowBox((String)title, WindowBoxFactory.generatePanel(boxes), boxes[0], IconManager.getImage((IconManager.IconType)iconType));
    }

    public static WindowBox getXicPTMDataWindowBox(String dataName, boolean viewSites, boolean isAnnotated, boolean unsaved) {
        AbstractDataBox[] boxes = new AbstractDataBox[7];
        boxes[0] = new DataBoxPTMClusters(viewSites, isAnnotated);
        boxes[0].setDataName(dataName);
        ((DataBoxPTMClusters)boxes[0]).setQuantitationMethodInfo(DDatasetType.QuantitationMethodInfo.FEATURES_EXTRACTION);
        boxes[1] = new DataBoxPTMPeptides(true, false);
        boxes[2] = new DataBoxPTMPeptides(false, true);
        boxes[2].setLayout(SplittedPanelContainer.PanelLayout.TABBED);
        boxes[3] = new DataBoxPTMPeptidesGraphic();
        boxes[4] = new DataboxMultiGraphics(false, false, true);
        ((DataboxMultiGraphics)boxes[4]).setHideButton(true);
        boxes[4].setLayout(SplittedPanelContainer.PanelLayout.HORIZONTAL);
        boxes[5] = new DataboxXicPeptideSet(false);
        boxes[6] = new DataboxMultiGraphics(false, false, true);
        ((DataboxMultiGraphics)boxes[6]).setHideButton(true);
        boxes[6].setLayout(SplittedPanelContainer.PanelLayout.HORIZONTAL);
        IconManager.IconType iconType = IconManager.IconType.QUANT_XIC;
        Object title = boxes[0].getFullName();
        if (unsaved && !((String)title).endsWith("***")) {
            title = (String)title + " ***";
        }
        return new WindowBox((String)title, WindowBoxFactory.generatePanel(boxes), boxes[0], IconManager.getImage((IconManager.IconType)iconType));
    }

    public static WindowBox getRsmPSMWindowBox(String dataName, boolean isDecoy, boolean mergedData) {
        AbstractDataBox[] boxes = new AbstractDataBox[]{new DataBoxRsmPSM(mergedData)};
        boxes[0].setDataName(dataName);
        IconManager.IconType iconType = isDecoy ? IconManager.IconType.DATASET_RSM_DECOY : IconManager.IconType.DATASET_RSM;
        return new WindowBox(boxes[0].getFullName(), WindowBoxFactory.generatePanel(boxes), boxes[0], IconManager.getImage((IconManager.IconType)iconType));
    }

    public static WindowBox getRsmPeptidesWindowBox(String dataName, boolean isDecoy) {
        AbstractDataBox[] boxes = new AbstractDataBox[4];
        boxes[0] = new DataBoxRsmPeptideInstances();
        boxes[0].setDataName(dataName);
        boxes[1] = new DataBoxRsmProteinSetOfPeptides();
        boxes[2] = new DataBoxRsmProteinsOfProteinSet();
        boxes[3] = new DataBoxRsmPeptidesOfProtein();
        boxes[3].setLayout(SplittedPanelContainer.PanelLayout.HORIZONTAL);
        IconManager.IconType iconType = isDecoy ? IconManager.IconType.DATASET_RSM_DECOY : IconManager.IconType.DATASET_RSM;
        WindowBox winBox = new WindowBox(boxes[0].getFullName(), WindowBoxFactory.generatePanel(boxes), boxes[0], IconManager.getImage((IconManager.IconType)iconType));
        return winBox;
    }

    public static WindowBox getProteinSetsWindowBox(String dataName, boolean isDecoy) {
        AbstractDataBox[] boxes = new AbstractDataBox[8];
        boxes[0] = new DataBoxRsmAllProteinSet();
        boxes[0].setDataName(dataName);
        boxes[1] = new DataBoxRsmProteinsOfProteinSet();
        boxes[2] = new DataBoxRsmPeptidesOfProtein();
        boxes[3] = new DataBoxRsmProteinAndPeptideSequence();
        boxes[4] = new DataBoxRsetPeptideSpectrum();
        boxes[4].setLayout(SplittedPanelContainer.PanelLayout.TABBED);
        boxes[5] = new DataBoxRsetPeptideSpectrumError();
        boxes[5].setLayout(SplittedPanelContainer.PanelLayout.TABBED);
        boxes[6] = new DataBoxRsetPeptideFragmentation();
        boxes[6].setLayout(SplittedPanelContainer.PanelLayout.TABBED);
        boxes[7] = new DataBoxRsetPeptideSpectrumValues();
        boxes[7].setLayout(SplittedPanelContainer.PanelLayout.TABBED);
        IconManager.IconType iconType = isDecoy ? IconManager.IconType.DATASET_RSM_DECOY : IconManager.IconType.DATASET_RSM;
        WindowBox winBox = new WindowBox(boxes[0].getFullName(), WindowBoxFactory.generatePanel(boxes), boxes[0], IconManager.getImage((IconManager.IconType)iconType));
        return winBox;
    }

    public static WindowBox getAdjacencyMatrixWindowBox(String dataName, boolean isDecoy) {
        AbstractDataBox[] boxes = new AbstractDataBox[2];
        boxes[0] = new DataBoxAdjacencyMatrixChoice();
        boxes[0].setDataName(dataName);
        boxes[1] = new DataBoxAdjacencyMatrix();
        IconManager.IconType iconType = isDecoy ? IconManager.IconType.DATASET_RSM_DECOY : IconManager.IconType.DATASET_RSM;
        WindowBox winBox = new WindowBox(boxes[0].getFullName(), WindowBoxFactory.generatePanel(boxes), boxes[0], IconManager.getImage((IconManager.IconType)iconType));
        return winBox;
    }

    public static WindowBox getAllResultSetWindowBox(String dataName) {
        AbstractDataBox[] boxes = new AbstractDataBox[]{new DataBoxRsetAll()};
        boxes[0].setDataName(dataName);
        WindowBox winBox = new WindowBox(boxes[0].getFullName(), WindowBoxFactory.generatePanel(boxes), boxes[0], null);
        return winBox;
    }

    public static WindowBox getQuantificationProteinSetWindowBox(String dataName, String fullName, DDatasetType.QuantitationMethodInfo methodInfo, boolean aggregatedQuantiPeptideIon) {
        int nbBoxes;
        IconManager.IconType iconType = switch (methodInfo) {
            case DDatasetType.QuantitationMethodInfo.SPECTRAL_COUNTING -> {
                nbBoxes = 3;
                yield IconManager.IconType.QUANT_XIC;
            }
            case DDatasetType.QuantitationMethodInfo.ISOBARIC_TAGGING -> {
                if (aggregatedQuantiPeptideIon) {
                    nbBoxes = 5;
                    yield IconManager.IconType.QUANT_AGGREGATION_TMT;
                }
                nbBoxes = 5;
                yield IconManager.IconType.QUANT_TMT;
            }
            case DDatasetType.QuantitationMethodInfo.FEATURES_EXTRACTION -> {
                if (aggregatedQuantiPeptideIon) {
                    nbBoxes = 7;
                    yield IconManager.IconType.QUANT_AGGREGATION_XIC;
                }
                nbBoxes = 6;
                yield IconManager.IconType.QUANT_XIC;
            }
            default -> {
                nbBoxes = aggregatedQuantiPeptideIon ? 7 : 6;
                yield IconManager.IconType.QUANT_XIC;
            }
        };
        AbstractDataBox[] boxes = new AbstractDataBox[nbBoxes];
        boxes[0] = new DataboxXicProteinSet();
        boxes[0].setDataName(dataName);
        ((DataboxXicProteinSet)boxes[0]).setQuantitationMethodInfo(methodInfo);
        boxes[1] = new DataboxXicPeptideSet();
        ((DataboxXicPeptideSet)boxes[1]).setQuantitationMethodInfo(methodInfo);
        boxes[2] = new DataboxMultiGraphics(false, true, true);
        ((DataboxMultiGraphics)boxes[2]).setHideButton(true);
        boxes[2].setLayout(SplittedPanelContainer.PanelLayout.HORIZONTAL);
        if (!methodInfo.equals((Object)DDatasetType.QuantitationMethodInfo.SPECTRAL_COUNTING)) {
            boxes[3] = new DataboxXicPeptideIon();
            ((DataboxXicPeptideIon)boxes[3]).setQuantitationMethodInfo(methodInfo);
            boxes[3].setLayout(SplittedPanelContainer.PanelLayout.VERTICAL);
            if (aggregatedQuantiPeptideIon) {
                int nb = 4;
                if (!methodInfo.equals((Object)DDatasetType.QuantitationMethodInfo.ISOBARIC_TAGGING)) {
                    boxes[nb] = new DataboxXicParentsPeptideIon();
                    boxes[nb].setLayout(SplittedPanelContainer.PanelLayout.TABBED);
                    boxes[++nb] = new DataboxChildFeature();
                    boxes[nb].setLayout(SplittedPanelContainer.PanelLayout.TABBED);
                    boxes[++nb] = new DataboxMultiGraphics(false, false);
                    boxes[nb].setLayout(SplittedPanelContainer.PanelLayout.HORIZONTAL);
                } else {
                    boxes[nb] = new DataboxXicReporterIon();
                }
            } else if (methodInfo.equals((Object)DDatasetType.QuantitationMethodInfo.ISOBARIC_TAGGING)) {
                boxes[4] = new DataboxXicReporterIon();
            } else {
                boxes[4] = new DataboxChildFeature();
                boxes[4].setLayout(SplittedPanelContainer.PanelLayout.TABBED);
                boxes[5] = new DataboxMultiGraphics(false, false);
                boxes[5].setLayout(SplittedPanelContainer.PanelLayout.HORIZONTAL);
            }
        }
        return new WindowBox(fullName, WindowBoxFactory.generatePanel(boxes), boxes[0], IconManager.getImage((IconManager.IconType)iconType));
    }

    public static WindowBox getQuantificationPeptideSetWindowBox(String dataName, String fullName, DDatasetType.QuantitationMethodInfo methodInfo) {
        int nbBoxes = 0;
        IconManager.IconType iconType = switch (methodInfo) {
            case DDatasetType.QuantitationMethodInfo.SPECTRAL_COUNTING -> {
                nbBoxes = 1;
                yield IconManager.IconType.QUANT_SC;
            }
            case DDatasetType.QuantitationMethodInfo.FEATURES_EXTRACTION, DDatasetType.QuantitationMethodInfo.RESIDUE_LABELING -> {
                nbBoxes = 2;
                yield IconManager.IconType.QUANT_XIC;
            }
            case DDatasetType.QuantitationMethodInfo.ISOBARIC_TAGGING -> {
                nbBoxes = 2;
                yield IconManager.IconType.QUANT_TMT;
            }
            default -> throw new RuntimeException("Unsupported Quant method " + methodInfo);
        };
        AbstractDataBox[] boxes = new AbstractDataBox[nbBoxes];
        boxes[0] = new DataboxXicPeptideSet();
        boxes[0].setDataName(dataName);
        ((DataboxXicPeptideSet)boxes[0]).setQuantitationMethodInfo(methodInfo);
        if (nbBoxes > 1) {
            boxes[1] = new DataboxXicPeptideIon();
            ((DataboxXicPeptideIon)boxes[1]).setQuantitationMethodInfo(methodInfo);
        }
        return new WindowBox(fullName, WindowBoxFactory.generatePanel(boxes), boxes[0], IconManager.getImage((IconManager.IconType)iconType));
    }

    public static WindowBox getQuantificationReporterIonWindowBox(String dataName, String fullName, DDatasetType.QuantitationMethodInfo methodInfo) {
        AbstractDataBox[] boxes = new AbstractDataBox[]{new DataboxXicReporterIon()};
        boxes[0].setDataName(dataName);
        ((DataboxXicReporterIon)boxes[0]).setQuantitationMethodInfo(methodInfo);
        return new WindowBox(fullName, WindowBoxFactory.generatePanel(boxes), boxes[0], IconManager.getImage((IconManager.IconType)(switch (methodInfo) {
            case DDatasetType.QuantitationMethodInfo.SPECTRAL_COUNTING -> IconManager.IconType.QUANT_SC;
            case DDatasetType.QuantitationMethodInfo.FEATURES_EXTRACTION -> IconManager.IconType.QUANT_XIC;
            case DDatasetType.QuantitationMethodInfo.ISOBARIC_TAGGING -> IconManager.IconType.QUANT_TMT;
            case DDatasetType.QuantitationMethodInfo.RESIDUE_LABELING -> IconManager.IconType.QUANT_XIC;
            default -> throw new RuntimeException("Unsupported Quant method " + methodInfo);
        })));
    }

    public static WindowBox getQuantificationPeptideIonWindowBox(String dataName, String fullName, DDatasetType.QuantitationMethodInfo methodInfo) {
        AbstractDataBox[] boxes = new AbstractDataBox[]{new DataboxXicPeptideIon()};
        boxes[0].setDataName(dataName);
        ((DataboxXicPeptideIon)boxes[0]).setQuantitationMethodInfo(methodInfo);
        return new WindowBox(fullName, WindowBoxFactory.generatePanel(boxes), boxes[0], IconManager.getImage((IconManager.IconType)(switch (methodInfo) {
            case DDatasetType.QuantitationMethodInfo.SPECTRAL_COUNTING -> IconManager.IconType.QUANT_SC;
            case DDatasetType.QuantitationMethodInfo.FEATURES_EXTRACTION -> IconManager.IconType.QUANT_XIC;
            case DDatasetType.QuantitationMethodInfo.ISOBARIC_TAGGING -> IconManager.IconType.QUANT_TMT;
            case DDatasetType.QuantitationMethodInfo.RESIDUE_LABELING -> IconManager.IconType.QUANT_XIC;
            default -> throw new RuntimeException("Unsupported Quant method " + methodInfo);
        })));
    }

    public static WindowBox getMzScopeWindowBox() {
        AbstractDataBox[] boxes = new AbstractDataBox[]{new DataBoxMzScope()};
        WindowBox winBox = new WindowBox("MzScope", WindowBoxFactory.generatePanel(boxes), boxes[0], IconManager.getImage((IconManager.IconType)IconManager.IconType.WAVE));
        return winBox;
    }

    public static WindowBox getExperimentalDesignWindowBox(String dataName, String fullName, DDatasetType.QuantitationMethodInfo methodInfo) {
        AbstractDataBox[] boxes = new AbstractDataBox[]{new DataboxExperimentalDesign()};
        boxes[0].setDataName(dataName);
        ((DataboxExperimentalDesign)boxes[0]).setQuantitationMethodInfo(methodInfo);
        IconManager.IconType iconType = IconManager.IconType.QUANT_XIC;
        return new WindowBox(fullName, WindowBoxFactory.generatePanel(boxes), boxes[0], IconManager.getImage((IconManager.IconType)iconType));
    }

    public static WindowBox getMapAlignmentWindowBox(String dataName, String fullName) {
        AbstractDataBox[] boxes = new AbstractDataBox[2];
        boxes[0] = new DataboxMapAlignment();
        boxes[0].setDataName(dataName);
        boxes[1] = new DataboxMultiGraphics(false, false);
        boxes[1].setLayout(SplittedPanelContainer.PanelLayout.VERTICAL);
        IconManager.IconType iconType = IconManager.IconType.QUANT_XIC;
        return new WindowBox(fullName, WindowBoxFactory.generatePanel(boxes), boxes[0], IconManager.getImage((IconManager.IconType)iconType));
    }

    public static WindowBox getMapMozCalibrationWindowBox(String dataName, String fullName) {
        AbstractDataBox[] boxes = new AbstractDataBox[2];
        boxes[0] = new DataboxMapAlignment(true);
        boxes[0].setDataName(dataName);
        boxes[1] = new DataboxMultiGraphics(false, false);
        boxes[1].setLayout(SplittedPanelContainer.PanelLayout.VERTICAL);
        IconManager.IconType iconType = IconManager.IconType.QUANT_XIC;
        return new WindowBox(fullName, WindowBoxFactory.generatePanel(boxes), boxes[0], IconManager.getImage((IconManager.IconType)iconType));
    }

    public static WindowBox getMSQueriesWindowBoxForRsm(String dataName, boolean mergedData) {
        AbstractDataBox[] boxes = new AbstractDataBox[2];
        boxes[0] = new DataBoxMSQueriesForRSM();
        boxes[0].setDataName(dataName);
        boxes[1] = new DataBoxRsmPSMForMsQuery(mergedData);
        boxes[1].setLayout(SplittedPanelContainer.PanelLayout.VERTICAL);
        IconManager.IconType iconType = IconManager.IconType.DATASET_RSM;
        return new WindowBox(boxes[0].getFullName(), WindowBoxFactory.generatePanel(boxes), boxes[0], IconManager.getImage((IconManager.IconType)iconType));
    }

    public static WindowBox getMSQueriesWindowBoxForRset(String dataName, boolean mergedData) {
        AbstractDataBox[] boxes = new AbstractDataBox[2];
        boxes[0] = new DataBoxMSQueriesForRset();
        boxes[0].setDataName(dataName);
        boxes[1] = new DataboxRsetPSMForMsQuery(mergedData);
        boxes[1].setLayout(SplittedPanelContainer.PanelLayout.VERTICAL);
        IconManager.IconType iconType = IconManager.IconType.DATASET_RSET;
        return new WindowBox(boxes[0].getFullName(), WindowBoxFactory.generatePanel(boxes), boxes[0], IconManager.getImage((IconManager.IconType)iconType));
    }

    public static WindowBox getTaskListWindowBox() {
        AbstractDataBox[] boxes = new AbstractDataBox[]{new DataBoxTaskList(), new DataBoxTaskDescription()};
        WindowBox winBox = new WindowBox("User Tasks", WindowBoxFactory.generatePanel(boxes), boxes[0], null);
        return winBox;
    }

    public static WindowBox getSystemTaskLogWindowBox() {
        AbstractDataBox[] boxes = new AbstractDataBox[]{new DataBoxSystemTasks()};
        WindowBox winBox = new WindowBox("Server Tasks", WindowBoxFactory.generatePanel(boxes), boxes[0], null);
        return winBox;
    }

    public static WindowBox getDataAnalyzerWindowBox() {
        AbstractDataBox[] boxes = new AbstractDataBox[]{new DataboxDataAnalyzer(), new DataBoxDataAnalyzerResults()};
        WindowBox winBox = new WindowBox("Data Analyzer", WindowBoxFactory.generatePanel(boxes, false), boxes[0], IconManager.getImage((IconManager.IconType)IconManager.IconType.DATA_ANALYZER));
        return winBox;
    }

    public static WindowBox[] getSystemMonitoringWindowBox() {
        WindowBox[] m_windowBoxes = new WindowBox[]{WindowBoxFactory.getTaskListWindowBox(), WindowBoxFactory.getSystemTaskLogWindowBox()};
        return m_windowBoxes;
    }

    public static WindowBox getImageWindowBox(String dataName, Image img) {
        AbstractDataBox[] boxes = new AbstractDataBox[]{new DataBoxImage()};
        WindowBox winBox = new WindowBox(dataName + " Image", WindowBoxFactory.generatePanel(boxes, false), boxes[0], IconManager.getImage((IconManager.IconType)IconManager.IconType.WAVE));
        winBox.setEntryData(-1L, img);
        return winBox;
    }

    public static WindowBox getGenericWindowBox(String dataName, String functionName, IconManager.IconType iconType, boolean removeStripAndSort) {
        AbstractDataBox[] boxes = new AbstractDataBox[]{new DataboxGeneric(dataName, functionName, removeStripAndSort)};
        String windowName = dataName == null ? functionName : dataName + " " + functionName;
        WindowBox winBox = new WindowBox(windowName, WindowBoxFactory.generatePanel(boxes), boxes[0], IconManager.getImage((IconManager.IconType)iconType));
        return winBox;
    }

    public static WindowBox getFromBoxesWindowBox(String title, AbstractDataBox[] boxes, boolean isDecoy, boolean isXIC, char windowType) {
        WindowBox winBox = new WindowBox(title, WindowBoxFactory.generatePanel(boxes), boxes[0], IconManager.getImage((IconManager.IconType)(switch (windowType) {
            case '2' -> isDecoy ? IconManager.IconType.DATASET_RSM_DECOY : IconManager.IconType.DATASET_RSM;
            case '1' -> isDecoy ? IconManager.IconType.DATASET_RSET_DECOY : IconManager.IconType.DATASET_RSET;
            case '3' -> isXIC ? IconManager.IconType.QUANT_XIC : IconManager.IconType.QUANT_SC;
            default -> IconManager.IconType.CHALKBOARD;
        })));
        return winBox;
    }

    private static SplittedPanelContainer generatePanel(AbstractDataBox[] boxes) {
        return WindowBoxFactory.generatePanel(boxes, true);
    }

    private static SplittedPanelContainer generatePanel(AbstractDataBox[] boxes, boolean includeSaveAndAddButtonsInToolbar) {
        int i;
        int nb = boxes.length - 1;
        for (i = 0; i < nb; ++i) {
            boxes[i].addNextDataBox(boxes[i + 1]);
        }
        nb = boxes.length;
        for (i = 0; i < nb; ++i) {
            boxes[i].createPanel();
        }
        int nbContainerPanels = 0;
        for (int i2 = 0; i2 < nb; ++i2) {
            if (boxes[i2].getLayout() != SplittedPanelContainer.PanelLayout.VERTICAL) continue;
            ++nbContainerPanels;
        }
        JComponent[] panels = new JComponent[nbContainerPanels];
        int panelIdx = 0;
        SplittedPanelContainer.PanelLayout prevLayout = SplittedPanelContainer.PanelLayout.VERTICAL;
        for (int i3 = 0; i3 < nb; ++i3) {
            SplittedPanelContainer.PanelLayout layout = boxes[i3].getLayout();
            if (layout == SplittedPanelContainer.PanelLayout.VERTICAL) {
                panels[panelIdx++] = (JPanel)((Object)boxes[i3].getPanel());
            } else if (layout == SplittedPanelContainer.PanelLayout.HORIZONTAL) {
                JSplitPane sp = new JSplitPane();
                JComponent leftComponent = panels[--panelIdx];
                sp.setLeftComponent(leftComponent);
                JComponent rightComponent = (JComponent)((Object)boxes[i3].getPanel());
                sp.setRightComponent(rightComponent);
                sp.setName(leftComponent.getName() + " / " + rightComponent.getName());
                sp.setDividerLocation(350);
                panels[panelIdx++] = sp;
            } else if (layout == SplittedPanelContainer.PanelLayout.TABBED) {
                if (prevLayout == SplittedPanelContainer.PanelLayout.TABBED) {
                    tb = (JTabbedPane)panels[panelIdx - 1];
                    ((JTabbedPane)tb).addTab(boxes[i3].getTypeName(), (JPanel)((Object)boxes[i3].getPanel()));
                    ((Component)tb).setName(((Component)tb).getName() + " / " + boxes[i3].getTypeName());
                } else {
                    tb = new SplittedPanelContainer.ReactiveTabbedPane();
                    tb.setBorder((Border)new EmptyBorder(8, 8, 8, 8));
                    tb.addTab(boxes[i3 - 1].getTypeName(), (Component)panels[--panelIdx]);
                    tb.addTab(boxes[i3].getTypeName(), (Component)((JPanel)((Object)boxes[i3].getPanel())));
                    tb.setName(boxes[i3 - 1].getTypeName() + " / " + boxes[i3].getTypeName());
                    panels[panelIdx++] = tb;
                }
            }
            prevLayout = layout;
        }
        SplittedPanelContainer splittedPanel = new SplittedPanelContainer(includeSaveAndAddButtonsInToolbar);
        for (int i4 = 0; i4 < nbContainerPanels; ++i4) {
            splittedPanel.registerPanel(panels[i4]);
        }
        splittedPanel.createPanel();
        return splittedPanel;
    }
}

