/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern;

import fr.proline.core.orm.msi.ResultSet;
import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.NbPreferences;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataParameter;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.pattern.ParameterSubtypeEnum;
import fr.proline.studio.rsmexplorer.tree.identification.IdentificationTree;
import fr.proline.studio.rsmexplorer.tree.quantitation.QuantitationTree;
import java.util.ArrayList;
import java.util.prefs.Preferences;

public class WindowSavedManager {
    public static final char SAVE_WINDOW_FOR_RSET = '1';
    public static final char SAVE_WINDOW_FOR_RSM = '2';
    public static final char SAVE_WINDOW_FOR_QUANTI = '3';
    private static final String WINDOW_SAVED_KEY = "WindowSaved";
    private static ArrayList<String> m_windowSavedList = null;

    public static String writeBoxes(String windowName, ArrayList<AbstractDataBox> boxList, ArrayList<SplittedPanelContainer.PanelLayout> layoutList) {
        boolean rset = false;
        boolean rsm = false;
        boolean quanti = false;
        AbstractDataBox entryBox = boxList.get(0);
        ParameterList inParameter = entryBox.getInParameters();
        ArrayList<DataParameter> parametersList = inParameter.getParameterList();
        for (int i = 0; i < parametersList.size(); ++i) {
            DataParameter parameter = parametersList.get(i);
            if (parameter.equalsData(ResultSet.class, ParameterSubtypeEnum.SINGLE_DATA)) {
                rset = true;
                continue;
            }
            if (parameter.equalsData(ResultSummary.class, ParameterSubtypeEnum.SINGLE_DATA)) {
                rsm = true;
                continue;
            }
            if (!parameter.equalsData(DDataset.class, ParameterSubtypeEnum.SINGLE_DATA)) continue;
            quanti = true;
        }
        StringBuilder sb = new StringBuilder();
        if (rset) {
            sb.append('1');
            sb.append("#");
        } else if (rsm) {
            sb.append('2');
            sb.append("#");
        } else if (quanti) {
            sb.append('3');
            sb.append("#");
        } else {
            sb.append("0#");
        }
        sb.append(windowName);
        sb.append('#');
        for (int i = 0; i < boxList.size(); ++i) {
            sb.append(boxList.get(i).getType().intValue());
            sb.append('#');
            sb.append(layoutList.get(i).intValue());
            if (i >= boxList.size() - 1) continue;
            sb.append('#');
        }
        return sb.toString();
    }

    public static boolean hasResultSetParameter(String dump) {
        return dump.charAt(0) == '1';
    }

    public static boolean hasResultSummaryParameter(String dump) {
        return dump.charAt(0) == '2';
    }

    public static boolean hasQuantiParameter(String dump) {
        return dump.charAt(0) == '3';
    }

    public static char getWindowType(String dump) {
        return dump.charAt(0);
    }

    public static AbstractDataBox[] readBoxes(String dump) {
        String[] values = dump.split("\\#");
        int nbBoxes = (values.length - 2) / 2;
        AbstractDataBox[] boxes = new AbstractDataBox[nbBoxes];
        int boxId = 0;
        for (int i = 2; i < values.length; i += 2) {
            AbstractDataBox.DataboxType databoxType = AbstractDataBox.DataboxType.getDataboxType(Integer.parseInt(values[i]));
            SplittedPanelContainer.PanelLayout layout = SplittedPanelContainer.PanelLayout.getLayoutType((int)Integer.parseInt(values[i + 1]));
            AbstractDataBox databox = databoxType.getDatabox();
            databox.setLayout(layout);
            boxes[boxId++] = databox;
        }
        return boxes;
    }

    public static String getWindowName(String dump) {
        int endOfName = dump.indexOf(35, 2);
        return dump.substring(2, endOfName);
    }

    public static ArrayList<String> readSavedWindows() {
        String windowSaved;
        if (m_windowSavedList != null) {
            return m_windowSavedList;
        }
        Preferences preferences = NbPreferences.root();
        m_windowSavedList = new ArrayList();
        int i = 1;
        while ((windowSaved = preferences.get(WINDOW_SAVED_KEY + i, null)) != null) {
            m_windowSavedList.add(windowSaved);
            ++i;
        }
        return m_windowSavedList;
    }

    public static void setSavedWindows(ArrayList<String> windowSavedList) {
        m_windowSavedList = windowSavedList;
        WindowSavedManager.writeSavedWindows();
        IdentificationTree.reinitMainPopup();
    }

    public static void addSavedWindow(String savedWindow) {
        WindowSavedManager.readSavedWindows();
        m_windowSavedList.add(savedWindow);
        WindowSavedManager.writeSavedWindows();
        IdentificationTree.reinitMainPopup();
        QuantitationTree.reinitMainPopup();
    }

    public static void writeSavedWindows() {
        String key;
        String windowSaved;
        Preferences preferences = NbPreferences.root();
        int i = 1;
        while ((windowSaved = preferences.get(key = WINDOW_SAVED_KEY + i, null)) != null) {
            preferences.remove(key);
            ++i;
        }
        for (i = 0; i < m_windowSavedList.size(); ++i) {
            key = WINDOW_SAVED_KEY + (i + 1);
            preferences.put(key, m_windowSavedList.get(i));
        }
    }
}

