/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern.xic;

import fr.proline.core.orm.msi.Peptide;
import fr.proline.core.orm.msi.dto.DMasterQuantPeptide;
import fr.proline.core.orm.msi.dto.DMasterQuantPeptideIon;
import fr.proline.core.orm.msi.dto.DPeptideInstance;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.core.orm.uds.dto.DQuantitationChannel;
import fr.proline.core.orm.util.TransientDataInterface;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dam.tasks.xic.DatabaseLoadXicMasterQuantTask;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.pattern.ParameterSubtypeEnum;
import fr.proline.studio.rsmexplorer.gui.xic.QuantChannelInfo;
import fr.proline.studio.rsmexplorer.gui.xic.XicParentPeptideIonPanel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class DataboxXicParentsPeptideIon
extends AbstractDataBox {
    private DDataset m_dataset;
    private DMasterQuantPeptide m_masterQuantPeptide;
    private DMasterQuantPeptideIon m_aggregatedMasterQuantPeptideIon;
    private QuantChannelInfo m_quantChannelInfo;
    private HashMap<Long, DQuantitationChannel> m_quantitationChannelsMap = new HashMap();

    public DataboxXicParentsPeptideIon() {
        super(AbstractDataBox.DataboxType.DataboxXicParentsPeptideIon, AbstractDataBox.DataboxStyle.STYLE_XIC);
        this.m_typeName = "Source Quanti. Peptides Ions";
        this.m_description = "All Sources Quanti. Peptides Ions of an Aggregated Quanti. Peptide Ion";
        ParameterList inParameter = new ParameterList();
        inParameter.addParameter(DDataset.class, ParameterSubtypeEnum.SINGLE_DATA, false);
        inParameter.addParameter(QuantChannelInfo.class, ParameterSubtypeEnum.SINGLE_DATA, false);
        inParameter.addParameter(DMasterQuantPeptideIon.class);
        this.registerInParameter(inParameter);
        ParameterList outParameter = new ParameterList();
        outParameter.addParameter(DMasterQuantPeptideIon.class);
        outParameter.addParameter(QuantChannelInfo.class);
        outParameter.addParameter(DPeptideMatch.class);
        this.registerOutParameter(outParameter);
    }

    @Override
    public void createPanel() {
        XicParentPeptideIonPanel p = new XicParentPeptideIonPanel();
        p.setName(this.m_typeName);
        p.setDataBox(this);
        this.setDataBoxPanelInterface(p);
    }

    @Override
    public void dataChanged() {
        DMasterQuantPeptideIon oldParentMasterQuantPeptideIon = this.m_aggregatedMasterQuantPeptideIon;
        this.m_aggregatedMasterQuantPeptideIon = (DMasterQuantPeptideIon)this.m_previousDataBox.getData(DMasterQuantPeptideIon.class);
        if (this.m_aggregatedMasterQuantPeptideIon == null || this.m_aggregatedMasterQuantPeptideIon.equals(oldParentMasterQuantPeptideIon)) {
            if (this.m_aggregatedMasterQuantPeptideIon == null) {
                ((XicParentPeptideIonPanel)this.getDataBoxPanelInterface()).setData(null, null, null, null, null);
            }
            return;
        }
        this.m_masterQuantPeptide = (DMasterQuantPeptide)this.m_previousDataBox.getData(DMasterQuantPeptide.class);
        this.m_dataset = (DDataset)this.m_previousDataBox.getData(DDataset.class);
        this.m_quantChannelInfo = (QuantChannelInfo)this.m_previousDataBox.getData(QuantChannelInfo.class);
        Map map = null;
        try {
            map = this.m_dataset.getQuantProcessingConfigAsMap();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ArrayList<Long> childrenDatasetIds = new ArrayList<Long>();
        for (Integer id : (ArrayList)map.get("quantitation_ids")) {
            childrenDatasetIds.add(id.longValue());
        }
        final HashMap aggregatedToChildrenQuantChannelsId = new HashMap();
        ArrayList mappingList = (ArrayList)map.get("quant_channels_mapping");
        for (int i = 0; i < mappingList.size(); ++i) {
            Map m = (Map)mappingList.get(i);
            Integer quantChannelNumberIndex = (Integer)m.get("quant_channel_number");
            Long aggregatedQuantChannelId = this.m_quantChannelInfo.getQuantChannels()[quantChannelNumberIndex - 1].getId();
            HashSet<Long> childrenQuantitationId = new HashSet<Long>();
            aggregatedToChildrenQuantChannelsId.put(aggregatedQuantChannelId, childrenQuantitationId);
            Map quantChannelsMatching = (Map)m.get("quant_channels_matching");
            for (String key : quantChannelsMatching.keySet()) {
                Integer childQuantChannelId = (Integer)quantChannelsMatching.get(key);
                childrenQuantitationId.add(childQuantChannelId.longValue());
            }
        }
        final ArrayList masterQuantPeptideIonList = new ArrayList();
        final int loadingId = this.setLoading();
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                if (DataboxXicParentsPeptideIon.this.m_dataset != null) {
                    DataboxXicParentsPeptideIon.this.linkCache((TransientDataInterface)DataboxXicParentsPeptideIon.this.m_dataset.getResultSummary());
                }
                ((XicParentPeptideIonPanel)DataboxXicParentsPeptideIon.this.getDataBoxPanelInterface()).setData(DataboxXicParentsPeptideIon.this.m_aggregatedMasterQuantPeptideIon, masterQuantPeptideIonList, DataboxXicParentsPeptideIon.this.m_quantChannelInfo, aggregatedToChildrenQuantChannelsId, DataboxXicParentsPeptideIon.this.m_quantitationChannelsMap);
                DataboxXicParentsPeptideIon.this.setLoaded(loadingId);
                if (finished) {
                    DataboxXicParentsPeptideIon.this.unregisterTask(taskId);
                    DataboxXicParentsPeptideIon.this.addDataChanged(ExtendedTableModelInterface.class);
                    DataboxXicParentsPeptideIon.this.propagateDataChanged();
                }
            }
        };
        DatabaseLoadXicMasterQuantTask task = new DatabaseLoadXicMasterQuantTask(callback);
        task.initLoadParentPeptideIons(this.getProjectId(), this.m_dataset, this.m_masterQuantPeptide, this.m_aggregatedMasterQuantPeptideIon, masterQuantPeptideIonList, this.m_quantitationChannelsMap, childrenDatasetIds);
        this.registerTask((AbstractDatabaseTask)task);
    }

    @Override
    public void setEntryData(Object data) {
        this.getDataBoxPanelInterface().addSingleValue(data);
        this.m_dataset = (DDataset)data;
        this.dataChanged();
    }

    @Override
    public Object getDataImpl(Class parameterType, ParameterSubtypeEnum parameterSubtype) {
        if (parameterType != null && parameterSubtype == ParameterSubtypeEnum.SINGLE_DATA) {
            if (parameterType.equals(DMasterQuantPeptideIon.class)) {
                return ((XicParentPeptideIonPanel)this.getDataBoxPanelInterface()).getSelectedMasterQuantPeptideIon();
            }
            if (parameterType.equals(DPeptideMatch.class)) {
                DMasterQuantPeptideIon qpi = ((XicParentPeptideIonPanel)this.getDataBoxPanelInterface()).getSelectedMasterQuantPeptideIon();
                if (qpi == null) {
                    return null;
                }
                DPeptideInstance pi = qpi.getPeptideInstance();
                if (pi == null) {
                    return null;
                }
                return pi.getBestPeptideMatch();
            }
            if (parameterType.equals(QuantChannelInfo.class)) {
                return ((XicParentPeptideIonPanel)this.getDataBoxPanelInterface()).getSelectedQuantChannelInfo();
            }
        }
        return super.getDataImpl(parameterType, parameterSubtype);
    }

    @Override
    public String getFullName() {
        if (this.m_dataset == null) {
            return super.getFullName();
        }
        return this.m_dataset.getName() + " " + this.getTypeName();
    }

    @Override
    public Class[] getDataboxNavigationOutParameterClasses() {
        return new Class[]{DMasterQuantPeptideIon.class, DPeptideMatch.class};
    }

    @Override
    public String getDataboxNavigationDisplayValue() {
        Peptide peptide;
        DPeptideInstance peptideInstance;
        DMasterQuantPeptideIon peptideIon = (DMasterQuantPeptideIon)this.getData(DMasterQuantPeptideIon.class);
        if (peptideIon != null && (peptideInstance = peptideIon.getPeptideInstance()) != null && (peptide = peptideInstance.getPeptide()) != null) {
            return peptide.getSequence();
        }
        return null;
    }
}

