/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.identification;

import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.WindowManager;
import fr.proline.studio.dpm.AccessJMSManagerThread;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import fr.proline.studio.dpm.task.jms.DownloadProcessedFileTask;
import fr.proline.studio.dpm.task.jms.ExportDatasetTask;
import fr.proline.studio.dpm.task.jms.GetExportInformationTask;
import fr.proline.studio.export.CustomExportDialog;
import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.gui.dialog.LoadWaitingDialog;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportDatasetJMSAction
extends AbstractRSMAction {
    protected static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");
    private List<String> m_config;

    public ExportDatasetJMSAction(AbstractTree tree) {
        super("Excel...", tree);
    }

    public ExportDatasetJMSAction(AbstractTree tree, boolean exportTitle) {
        super("Export Excel...", tree);
    }

    @Override
    public void actionPerformed(final AbstractNode[] selectedNodes, final int x, final int y) {
        final DataSetNode dataSetNode = (DataSetNode)selectedNodes[0];
        this.m_config = new ArrayList<String>();
        String waitingTxt = "Please wait while loading template to configure export";
        final LoadWaitingDialog loadWaitingDialog = new LoadWaitingDialog((Window)WindowManager.getDefault().getMainWindow(), waitingTxt);
        DefaultDialog.ProgressTask loadConfigTasktask = new DefaultDialog.ProgressTask(){

            public int getMinValue() {
                return 0;
            }

            public int getMaxValue() {
                return 100;
            }

            protected Object doInBackground() throws Exception {
                AbstractJMSCallback getExportCallback = new AbstractJMSCallback(){

                    public boolean mustBeCalledInAWT() {
                        return true;
                    }

                    public void run(boolean success) {
                        final CustomExportDialog dialog = CustomExportDialog.getDialog((Window)WindowManager.getDefault().getMainWindow(), (selectedNodes.length == 1 ? 1 : 0) != 0);
                        loadWaitingDialog.setVisible(false);
                        if (success && !ExportDatasetJMSAction.this.m_config.isEmpty()) {
                            String conf = ExportDatasetJMSAction.this.m_config.get(0);
                            boolean mustUpdateConfig = dialog.setDefaultExportConfig(conf);
                            dialog.updateFileExport(mustUpdateConfig);
                        }
                        DefaultDialog.ProgressTask task = new DefaultDialog.ProgressTask(){

                            public int getMinValue() {
                                return 0;
                            }

                            public int getMaxValue() {
                                return 100;
                            }

                            protected Object doInBackground() throws Exception {
                                final AbstractJMSCallback downloadCallback = new AbstractJMSCallback(){

                                    public boolean mustBeCalledInAWT() {
                                        return true;
                                    }

                                    public void run(boolean success) {
                                        if (success) {
                                            this.setProgress(100);
                                        } else {
                                            this.setProgress(100);
                                        }
                                    }
                                };
                                final ArrayList _filePath = new ArrayList();
                                final ArrayList _jmsNodeId = new ArrayList();
                                AbstractJMSCallback exportCallback = new AbstractJMSCallback(){

                                    public boolean mustBeCalledInAWT() {
                                        return true;
                                    }

                                    public void run(boolean success) {
                                        if (success) {
                                            Object fileName = dialog.getFileName();
                                            String extension = dialog.getFileExtension();
                                            if (extension != null && !((String)fileName).endsWith("." + extension)) {
                                                fileName = (String)fileName + "." + extension;
                                            }
                                            if (_filePath.size() == 1) {
                                                DownloadProcessedFileTask task = new DownloadProcessedFileTask(downloadCallback, (String)fileName, (String)_filePath.get(0), (String)_jmsNodeId.get(0));
                                                AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)task);
                                            } else {
                                                int nb = 1;
                                                for (String fp : _filePath) {
                                                    int idFileName = fp.lastIndexOf("\\");
                                                    if (idFileName == -1) {
                                                        idFileName = fp.lastIndexOf("/");
                                                    }
                                                    int idUnderscore = fp.lastIndexOf("_");
                                                    int idExtC = ((String)fileName).lastIndexOf(".");
                                                    Object fn = fileName;
                                                    if (idFileName != -1 && idUnderscore != -1 && idExtC != -1) {
                                                        fn = ((String)fileName).substring(0, idExtC) + "_" + fp.substring(idFileName + 1, idUnderscore) + "." + extension;
                                                    }
                                                    if (!dialog.isFileExportMode()) {
                                                        Long dsId;
                                                        String dsName;
                                                        Object dirName = dialog.getFileName();
                                                        if (!((String)dirName).endsWith("\\")) {
                                                            dirName = (String)dirName + "\\";
                                                        }
                                                        if ((dsName = ExportDatasetJMSAction.this.getDatasetName(dsId = ExportDatasetJMSAction.this.getDatasetId(fp.substring(idFileName + 1)), selectedNodes)).length() > 20) {
                                                            dsName = dsName.substring(0, 20);
                                                        }
                                                        fn = (String)dirName + dsName + "_" + dsId.toString() + "_" + nb + "." + extension;
                                                    }
                                                    DownloadProcessedFileTask task = new DownloadProcessedFileTask(downloadCallback, (String)fn, fp, (String)_jmsNodeId.get(++nb - 2));
                                                    AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)task);
                                                }
                                            }
                                        } else {
                                            this.setProgress(100);
                                        }
                                    }
                                };
                                String exportConfig = dialog.getExportConfig();
                                ArrayList<DDataset> listDataset = new ArrayList<DDataset>();
                                for (AbstractNode node : selectedNodes) {
                                    listDataset.add(((DataSetNode)node).getDataset());
                                }
                                ExportDatasetTask task = new ExportDatasetTask(exportCallback, listDataset, exportConfig, _filePath, _jmsNodeId);
                                AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)task);
                                return null;
                            }
                        };
                        dialog.setTask(task);
                        dialog.setLocation(x, y);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                dialog.setVisible(true);
                            }
                        });
                    }
                };
                GetExportInformationTask task = new GetExportInformationTask(getExportCallback, dataSetNode.getDataset(), ExportDatasetJMSAction.this.m_config);
                AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)task);
                return null;
            }
        };
        loadWaitingDialog.setTask(loadConfigTasktask);
        loadWaitingDialog.setLocation(x, y);
        loadWaitingDialog.setVisible(true);
    }

    private String getDatasetName(Long dsId, AbstractNode[] selectedNodes) {
        for (AbstractNode node : selectedNodes) {
            if (((DataSetNode)node).getDataset().getId() != dsId.longValue()) continue;
            return ((DataSetNode)node).getDataset().getName();
        }
        return "";
    }

    private Long getDatasetId(String fileName) {
        Long dsId = -1L;
        int id0 = fileName.indexOf("-");
        int id1 = fileName.lastIndexOf("_");
        if (id0 > -1 && id1 > -1 && id0 < id1) {
            String dsIdStr = fileName.substring(id0 + 1, id1);
            try {
                dsId = Long.parseLong(dsIdStr);
            }
            catch (NumberFormatException e) {
                dsId = -1L;
            }
        }
        return dsId;
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        int nbSelectedNodes = selectedNodes.length;
        if (nbSelectedNodes < 1) {
            this.setEnabled(false);
            return;
        }
        int mode = -1;
        if (selectedNodes[0] instanceof DataSetNode) {
            mode = ((DataSetNode)selectedNodes[0]).isQuantSC() ? 1 : (((DataSetNode)selectedNodes[0]).isQuantitation() ? 2 : 0);
        }
        for (AbstractNode node : selectedNodes) {
            int currMode;
            if (node.isChanging()) {
                this.setEnabled(false);
                return;
            }
            AbstractNode.NodeTypes nodeType = node.getType();
            if (nodeType != AbstractNode.NodeTypes.DATA_SET && node.getType() != AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE_ANALYSIS) {
                this.setEnabled(false);
                return;
            }
            DataSetNode datasetNode = (DataSetNode)node;
            if (!datasetNode.hasResultSummary()) {
                this.setEnabled(false);
                return;
            }
            int n = datasetNode.isQuantSC() ? 1 : (currMode = datasetNode.isQuantitation() ? 2 : 0);
            if (currMode == mode) continue;
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }
}

