/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.identification;

import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.msi.dto.DBioSequence;
import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.core.orm.msi.dto.DProteinSet;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.core.orm.util.TransientDataAllocationListener;
import fr.proline.studio.NbPreferences;
import fr.proline.studio.WindowManager;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.memory.TransientMemoryCacheManager;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseDataSetTask;
import fr.proline.studio.dam.tasks.DatabaseProteinSetsTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dock.gui.InfoLabel;
import fr.proline.studio.dpm.AccessJMSManagerThread;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import fr.proline.studio.dpm.task.jms.RetrieveBioSeqTask;
import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.gui.InfoDialog;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import fr.proline.studio.utils.IconManager;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.tree.DefaultTreeModel;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportFastaAction
extends AbstractRSMAction {
    protected static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer.ExportFastaAction");

    public ExportFastaAction(AbstractTree tree) {
        super("Sequence Fasta", tree);
    }

    @Override
    public void actionPerformed(AbstractNode[] selectedNodes, int x, int y) {
        FastaExportMulitipleDialog exportMultipleDialog = new FastaExportMulitipleDialog((Window)WindowManager.getDefault().getMainWindow(), selectedNodes);
        ExportFastaProgressTask exportFastaProgressTask = new ExportFastaProgressTask(selectedNodes, exportMultipleDialog);
        exportMultipleDialog.setTask(exportFastaProgressTask);
        exportMultipleDialog.setLocation(x, y);
        exportMultipleDialog.setLocation(x, y);
        exportMultipleDialog.setVisible(true);
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        int nbSelectedNodes = selectedNodes.length;
        if (nbSelectedNodes != 1) {
            this.setEnabled(false);
            return;
        }
        int mode = -1;
        if (selectedNodes[0] instanceof DataSetNode) {
            DataSetNode datasetNode = (DataSetNode)selectedNodes[0];
            mode = datasetNode.isQuantSC() ? 1 : (datasetNode.isQuantitation() ? 2 : 0);
        }
        for (AbstractNode node : selectedNodes) {
            int currMode;
            if (node.isChanging()) {
                this.setEnabled(false);
                return;
            }
            AbstractNode.NodeTypes nodeType = node.getType();
            if (node.getType() != AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE_ANALYSIS) {
                this.setEnabled(false);
                return;
            }
            DataSetNode datasetNode = (DataSetNode)node;
            if (!datasetNode.hasResultSummary()) {
                this.setEnabled(false);
                return;
            }
            int n = datasetNode.isQuantSC() ? 1 : (currMode = datasetNode.isQuantitation() ? 2 : 0);
            if (currMode == mode) continue;
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }

    class FastaExportMulitipleDialog
    extends DefaultDialog {
        JFileChooser _fchooser;
        static final String EXT_FASTA = "fasta";
        static final int DATASET_NAME_LENGTH = 20;
        static final int MAX_FILENAME_LENGTH = 80;
        FileNameExtensionFilter FILTER_FASTA;
        private ExportFastaProgressTask _progressTask;
        AbstractNode[] _nodes;
        File _localFile;
        File _localDirectory;
        JTextField _pathTextField;
        HashMap<DataSetNode, JTextField> _dataSetFileNameMap;
        HashMap<DataSetNode, File> _dataSetExportFileMap;
        JCheckBox _multipleButton;

        private FastaExportMulitipleDialog(Window parent, AbstractNode[] selectedNodes) {
            super(parent, Dialog.ModalityType.APPLICATION_MODAL);
            this.FILTER_FASTA = new FileNameExtensionFilter("Fasta File (.fasta)", EXT_FASTA);
            this._progressTask = null;
            this._nodes = selectedNodes;
            this.setResizable(true);
            this.setTitle("Export Fasta Multiple");
            Preferences preferences = NbPreferences.root();
            String lastPath = preferences.get("DefaultFastaExportPath", System.getProperty("user.home"));
            this._dataSetFileNameMap = new HashMap();
            Object fn = ((DataSetNode)this._nodes[0]).toString() + ".fasta";
            int nbNode = selectedNodes.length;
            if (nbNode > 1) {
                fn = "";
                for (int i = 0; i < nbNode; ++i) {
                    DataSetNode node = (DataSetNode)selectedNodes[i];
                    fn = (String)fn + node.getDataset().getName();
                    if (i >= nbNode - 1) continue;
                    fn = (String)fn + "-";
                }
                if (((String)fn).length() > 80) {
                    fn = "";
                    int blocLength = 80 / nbNode;
                    for (int j = 0; j < nbNode; ++j) {
                        DataSetNode node = (DataSetNode)selectedNodes[j];
                        String n = node.getDataset().getName();
                        fn = (String)fn + StringUtils.right((String)n, (int)blocLength);
                        if (j >= nbNode - 1) continue;
                        fn = (String)fn + "-";
                    }
                }
                fn = (String)fn + ".fasta";
            }
            this._localFile = new File(lastPath + File.separator + (String)fn);
            this._fchooser = new JFileChooser(this._localFile);
            this._fchooser.addChoosableFileFilter(this.FILTER_FASTA);
            this._fchooser.setMultiSelectionEnabled(false);
            this._multipleButton = new JCheckBox("Mutiple Export: One fasta file for one DataSet");
            this.setInternalComponent(this.initComponent(this._localFile));
            this.setButtonName(0, "Export");
        }

        private JPanel initComponent(File defaultExportPath) {
            JPanel insidePanel = new JPanel(new GridBagLayout());
            JPanel pathPanel = new JPanel(new GridBagLayout());
            GridBagConstraints cp = new GridBagConstraints();
            cp.anchor = 18;
            cp.fill = 1;
            cp.insets = new Insets(5, 5, 5, 5);
            cp.gridx = 0;
            cp.gridy = 0;
            cp.weightx = 0.0;
            JLabel lblExportToFile = new JLabel("Export to file/Path:");
            pathPanel.add((Component)lblExportToFile, cp);
            ++cp.gridx;
            cp.weightx = 1.0;
            this._pathTextField = new JTextField(50);
            this._pathTextField.setText(defaultExportPath.getAbsolutePath());
            pathPanel.add((Component)this._pathTextField, cp);
            cp.weightx = 0.0;
            final JButton chooseFileBt = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.OPEN_FILE));
            chooseFileBt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int result;
                    String textFile = FastaExportMulitipleDialog.this._pathTextField.getText().trim();
                    if (textFile.length() > 0) {
                        File currentFile = new File(textFile);
                        FastaExportMulitipleDialog.this._fchooser.setSelectedFile(currentFile);
                    }
                    if ((result = FastaExportMulitipleDialog.this._fchooser.showOpenDialog(chooseFileBt)) == 0) {
                        FastaExportMulitipleDialog.this._pathTextField.setText(FastaExportMulitipleDialog.this._fchooser.getSelectedFile().getAbsolutePath());
                    }
                }
            });
            ++cp.gridx;
            pathPanel.add((Component)chooseFileBt, cp);
            this._multipleButton.setSelected(false);
            final JPanel optionPane = new JPanel(new GridBagLayout());
            optionPane.setVisible(false);
            if (this._nodes.length <= 1) {
                this._multipleButton.setVisible(false);
                this._multipleButton.setEnabled(false);
            }
            this._multipleButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 2) {
                        if (optionPane != null) {
                            optionPane.setVisible(false);
                        }
                        String directory = FastaExportMulitipleDialog.this._pathTextField.getText().trim();
                        String fileName = FastaExportMulitipleDialog.this._localFile.getName();
                        File f = new File(directory + File.separator + fileName);
                        FastaExportMulitipleDialog.this._fchooser.setFileSelectionMode(0);
                        FastaExportMulitipleDialog.this._fchooser.addChoosableFileFilter(FastaExportMulitipleDialog.this.FILTER_FASTA);
                        FastaExportMulitipleDialog.this._pathTextField.setText(f.getAbsolutePath());
                    } else {
                        String txt = FastaExportMulitipleDialog.this._pathTextField.getText().trim();
                        FastaExportMulitipleDialog.this._localFile = new File(txt);
                        String directory = FastaExportMulitipleDialog.this._localFile.isDirectory() ? txt : (FastaExportMulitipleDialog.this._localFile.getParentFile().isDirectory() ? FastaExportMulitipleDialog.this._localFile.getParent() : txt);
                        FastaExportMulitipleDialog.this._localDirectory = new File(directory);
                        FastaExportMulitipleDialog.this._pathTextField.setText(directory);
                        FastaExportMulitipleDialog.this._fchooser.removeChoosableFileFilter(FastaExportMulitipleDialog.this.FILTER_FASTA);
                        FastaExportMulitipleDialog.this._fchooser.setFileSelectionMode(1);
                        optionPane.removeAll();
                        GridBagConstraints co = new GridBagConstraints();
                        co.anchor = 18;
                        co.fill = 1;
                        co.insets = new Insets(5, 5, 5, 5);
                        boolean isFirstExpand = !FastaExportMulitipleDialog.this._dataSetFileNameMap.isEmpty();
                        co.gridy = 0;
                        int i = 0;
                        for (AbstractNode node : FastaExportMulitipleDialog.this._nodes) {
                            JTextField fNameField;
                            DataSetNode dNode = (DataSetNode)node;
                            String dataSetName = dNode.toString();
                            JLabel lb2File = new JLabel(dataSetName + ", Export to file:");
                            co.gridx = 0;
                            optionPane.add((Component)lb2File, co);
                            if (isFirstExpand) {
                                fNameField = FastaExportMulitipleDialog.this._dataSetFileNameMap.get(dNode);
                            } else {
                                fNameField = new JTextField(40);
                                StringUtils.right((String)dataSetName, (int)20);
                                fNameField.setText(dataSetName + ".fasta");
                                FastaExportMulitipleDialog.this._dataSetFileNameMap.put(dNode, fNameField);
                            }
                            ++co.gridx;
                            optionPane.add((Component)fNameField, co);
                            ++co.gridy;
                            ++i;
                        }
                        optionPane.setVisible(true);
                    }
                    FastaExportMulitipleDialog.this.revalidate();
                    FastaExportMulitipleDialog.this.repack();
                }
            });
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 18;
            c.fill = 1;
            c.insets = new Insets(5, 5, 5, 5);
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 0.0;
            insidePanel.add((Component)pathPanel, c);
            ++c.gridy;
            insidePanel.add((Component)this._multipleButton, c);
            ++c.gridy;
            insidePanel.add((Component)optionPane, c);
            return insidePanel;
        }

        protected boolean okCalled() {
            this._localFile = new File(this._pathTextField.getText().trim());
            Preferences preferences = NbPreferences.root();
            String dir = this._localFile.isDirectory() ? this._localFile.getAbsolutePath() : this._localFile.getAbsoluteFile().getParentFile().getAbsolutePath();
            preferences.put("DefaultFastaExportPath", dir);
            this._dataSetExportFileMap = new HashMap();
            if (!this._multipleButton.isSelected()) {
                if (this._localFile.isDirectory()) {
                    this.setStatus(true, "You should give the file name to export");
                    this.highlight(this._pathTextField);
                    return false;
                }
                if (!this.overwriteExistFile(this._localFile)) {
                    return false;
                }
                this._dataSetExportFileMap.put((DataSetNode)this._nodes[0], this._localFile);
            } else {
                String path = this._pathTextField.getText().trim();
                this._localDirectory = new File(path);
                if (!this._localDirectory.isDirectory()) {
                    this.setStatus(true, "Should not be a file / directory should exist");
                    this.highlight(this._pathTextField);
                    return false;
                }
                for (DataSetNode node : this._dataSetFileNameMap.keySet()) {
                    JTextField field = this._dataSetFileNameMap.get(node);
                    String fName = field.getText().trim();
                    if (fName.contains(File.separator) || fName.contains("\\") || fName.contains("/")) {
                        this.setStatus(true, "You should give the file name without directory");
                        this.highlight(field);
                        return false;
                    }
                    File aFile = new File(this._localDirectory + File.separator + fName);
                    if (!this.overwriteExistFile(aFile)) {
                        return false;
                    }
                    this._dataSetExportFileMap.put(node, aFile);
                }
            }
            this._progressTask.execute();
            return true;
        }

        private boolean overwriteExistFile(File file) {
            if (file.exists()) {
                String message = "The file " + file.getName() + " already exists. Do you want to overwrite it ?";
                String title = "Overwrite ?";
                Object[] options = new String[]{"Yes", "No"};
                int reply = JOptionPane.showOptionDialog((Component)((Object)this), message, title, 0, 1, null, options, "Yes");
                if (reply != 0) {
                    this.setStatus(true, "File " + file.getName() + " already exists.");
                    return false;
                }
            }
            return true;
        }

        public void setTask(ExportFastaProgressTask task) {
            this._progressTask = task;
        }

        public ExportMode getExportMode() {
            if (this._multipleButton.isSelected()) {
                return ExportMode.MULTIPLE;
            }
            return ExportMode.SINGLE;
        }

        public HashMap getDataSetExportFileMap() {
            return this._dataSetExportFileMap;
        }
    }

    class ExportFastaProgressTask
    extends DefaultDialog.ProgressTask {
        final String SEQUENCE_RETRIVED = "\"is_coverage_updated\":true";
        long m_projectId;
        FastaExportMulitipleDialog m_dialog;
        AbstractNode[] m_selectedNodes;
        ExportMode m_exportMode;
        HashMap<String, DProteinSet> m_proteinSetMap;
        int m_nombre;

        public ExportFastaProgressTask(AbstractNode[] selectedNodes, FastaExportMulitipleDialog fastaExportDialog) {
            this.m_selectedNodes = selectedNodes;
            this.m_dialog = fastaExportDialog;
        }

        public int getMinValue() {
            return 0;
        }

        public int getMaxValue() {
            return 100;
        }

        protected Object doInBackground() throws Exception {
            DefaultTreeModel treeModel = (DefaultTreeModel)ExportFastaAction.this.getTree().getModel();
            DataSetNode firstN = (DataSetNode)this.m_selectedNodes[0];
            this.m_projectId = firstN.getDataset().getProject().getId();
            this.m_exportMode = this.m_dialog.getExportMode();
            if (this.m_exportMode.equals((Object)ExportMode.SINGLE)) {
                if (this.m_selectedNodes.length > 1) {
                    this.m_exportMode = ExportMode.CONCATENATED;
                    this.m_nombre = 0;
                    this.m_proteinSetMap = new HashMap();
                    for (AbstractNode node : this.m_selectedNodes) {
                        DataSetNode dNode = (DataSetNode)node;
                        m_logger.debug("multiple export for : " + dNode.toString());
                        dNode.setIsChanging(true);
                        treeModel.nodeChanged(dNode);
                        this.extraitRsmSequenceRetrived(dNode);
                    }
                } else {
                    firstN.setIsChanging(true);
                    treeModel.nodeChanged(firstN);
                    this.extraitRsmSequenceRetrived(firstN);
                }
            } else {
                for (AbstractNode node : this.m_selectedNodes) {
                    DataSetNode dNode = (DataSetNode)node;
                    m_logger.debug("multiple export for : " + dNode.toString());
                    dNode.setIsChanging(true);
                    treeModel.nodeChanged(dNode);
                    this.extraitRsmSequenceRetrived(dNode);
                }
            }
            return null;
        }

        private void extraitRsmSequenceRetrived(DataSetNode node) {
            m_logger.debug("->extraitRsmSequenceRetrived: " + node.toString());
            ResultSummary rsm = node.getResultSummary();
            if (rsm == null) {
                this.loadResultSummary(node);
            } else {
                String properties = rsm.getSerializedProperties();
                if (properties != null && properties.contains("\"is_coverage_updated\":true") || node.isBioRetrived()) {
                    this.extraitProteinSet(node);
                } else {
                    this.retriveBioSequence(node);
                }
            }
        }

        private void loadResultSummary(final DataSetNode node) {
            final DDataset dataSet = node.getDataset();
            m_logger.debug("->loadResultSummary: " + dataSet.getName());
            AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

                public boolean mustBeCalledInAWT() {
                    return true;
                }

                public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                    m_logger.debug("->call back loadResultSummary " + dataSet.getName());
                    if (success) {
                        String properties = dataSet.getResultSummary().getSerializedProperties();
                        if (properties != null && properties.contains("\"is_coverage_updated\":true")) {
                            ExportFastaProgressTask.this.extraitProteinSet(node);
                        } else {
                            ExportFastaProgressTask.this.retriveBioSequence(node);
                        }
                    } else {
                        ExportFastaProgressTask.this.setProgress(100);
                    }
                }
            };
            DatabaseDataSetTask task = new DatabaseDataSetTask(callback);
            task.initLoadRsetAndRsm(dataSet);
            AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
        }

        private void retriveBioSequence(final DataSetNode node) {
            final DDataset dataSet = node.getDataset();
            Long projectId = dataSet.getProject().getId();
            ArrayList<Long> rsmIds = new ArrayList<Long>();
            rsmIds.add(dataSet.getResultSummaryId());
            AbstractJMSCallback callback = new AbstractJMSCallback(){

                public boolean mustBeCalledInAWT() {
                    return true;
                }

                public void run(boolean success) {
                    if (!success) {
                        String msg = this.getTaskError().getErrorTitle();
                        InfoDialog errorDialog = new InfoDialog((Window)WindowManager.getDefault().getMainWindow(), InfoDialog.InfoType.WARNING, "JMSTask Error", "Error: " + msg + "\nnProtein Sequence can't be retrived, verify that the Sequence Repository module is installed and started", false);
                        errorDialog.setButtonVisible(1, false);
                        errorDialog.centerToWindow((Window)WindowManager.getDefault().getMainWindow());
                        errorDialog.setVisible(true);
                        node.setIsChanging(false);
                        DefaultTreeModel treeModel = (DefaultTreeModel)ExportFastaAction.this.getTree().getModel();
                        treeModel.nodeChanged(node);
                    } else {
                        ResultSummary rsm = dataSet.getResultSummary();
                        rsm.clearMemory();
                        node.setBioRetrived(true);
                        ExportFastaProgressTask.this.loadProteinSet(node);
                    }
                }
            };
            RetrieveBioSeqTask task = new RetrieveBioSeqTask(callback, rsmIds, projectId.longValue(), true);
            AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)task);
        }

        private void extraitProteinSet(DataSetNode node) {
            ResultSummary rsm = node.getResultSummary();
            m_logger.debug("-->extraitProteinSet " + rsm.getId());
            ResultSummary.TransientData td = rsm.getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton());
            if (td != null && td.getProteinSetArray() != null) {
                m_logger.debug("--->proteinSetArray is ok, rsm: " + node.toString());
                if (this.m_exportMode.equals((Object)ExportMode.CONCATENATED)) {
                    this.addProteinSet(td.getProteinSetArray());
                } else {
                    this.writeBioSequence(node);
                }
            } else {
                m_logger.debug("--->proteinSetArray is null");
                this.loadProteinSet(node);
            }
        }

        private void loadProteinSet(final DataSetNode node) {
            m_logger.debug("---->loadProteinSet " + node.toString());
            final ResultSummary rsm = node.getResultSummary();
            AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

                public boolean mustBeCalledInAWT() {
                    return true;
                }

                public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                    if (success) {
                        DProteinSet[] proteinSetArray = rsm.getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).getProteinSetArray();
                        if (ExportFastaProgressTask.this.m_exportMode.equals((Object)ExportMode.CONCATENATED)) {
                            ExportFastaProgressTask.this.addProteinSet(proteinSetArray);
                        } else {
                            ExportFastaProgressTask.this.writeBioSequence(node);
                            ExportFastaProgressTask.this.setProgress(100);
                        }
                    } else {
                        ExportFastaProgressTask.this.setProgress(100);
                    }
                }
            };
            DatabaseProteinSetsTask task = new DatabaseProteinSetsTask(callback);
            task.initLoadProteinSets(this.m_projectId, rsm);
            AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeBioSequence(DataSetNode node) {
            DProteinSet[] proteinSetArray = node.getResultSummary().getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).getProteinSetArray();
            m_logger.debug("->writeBioSequence : " + proteinSetArray.length + " proteinSet");
            try {
                this.write(proteinSetArray, node);
            }
            catch (IOException ex) {
                WindowManager.getDefault().getMainWindow().alert(InfoLabel.INFO_LEVEL.ERROR, "IO Exception when write fasta file", (Throwable)ex);
            }
            finally {
                node.setIsChanging(false);
                DefaultTreeModel treeModel = (DefaultTreeModel)ExportFastaAction.this.getTree().getModel();
                treeModel.nodeChanged(node);
                m_logger.debug("write bio end " + node.toString());
            }
        }

        private void write(DProteinSet[] proteinSetArray, DataSetNode node) throws IOException {
            HashMap fileNameMap = this.m_dialog.getDataSetExportFileMap();
            File localFile = (File)fileNameMap.get(node);
            BufferedWriter bWriter = new BufferedWriter(new FileWriter(localFile));
            int lineLength = 60;
            for (DProteinSet prot : proteinSetArray) {
                DProteinMatch typicalProtM = prot.getTypicalProteinMatch();
                if (typicalProtM == null) continue;
                String name = typicalProtM.getAccession();
                String description = typicalProtM.getDescription();
                DBioSequence bioSequence = typicalProtM.getDBioSequence();
                String sequence = "";
                if (bioSequence == null) continue;
                sequence = bioSequence.getSequence();
                int seqLength = sequence.length();
                bWriter.append(">");
                bWriter.append(name);
                bWriter.append(" ");
                if (description.contains(">")) {
                    description = description.replace('>', ' ');
                }
                bWriter.append(description);
                bWriter.newLine();
                int start = 0;
                for (int i = 0; i < seqLength / lineLength; ++i) {
                    int stop = (i + 1) * lineLength;
                    bWriter.append(sequence.substring(start, stop));
                    bWriter.newLine();
                    start = stop;
                }
                if (start >= seqLength) continue;
                bWriter.append(sequence.substring(start));
                bWriter.newLine();
            }
            bWriter.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeBioSequence() {
            m_logger.debug("->writeBioSequence : " + ExportMode.CONCATENATED);
            DProteinSet[] proteinSetArray = new DProteinSet[this.m_proteinSetMap.size()];
            TreeMap<String, DProteinSet> protMapsortedByName = new TreeMap<String, DProteinSet>(this.m_proteinSetMap);
            Collection<DProteinSet> protSets = protMapsortedByName.values();
            proteinSetArray = protSets.toArray(proteinSetArray);
            DataSetNode firstNode = (DataSetNode)this.m_selectedNodes[0];
            try {
                this.write(proteinSetArray, firstNode);
            }
            catch (IOException ex) {
                WindowManager.getDefault().getMainWindow().alert(InfoLabel.INFO_LEVEL.ERROR, "IO Exception when write fasta file", (Throwable)ex);
            }
            finally {
                for (AbstractNode anode : this.m_selectedNodes) {
                    DataSetNode node = (DataSetNode)anode;
                    node.setIsChanging(false);
                    DefaultTreeModel treeModel = (DefaultTreeModel)ExportFastaAction.this.getTree().getModel();
                    treeModel.nodeChanged(node);
                }
                m_logger.debug("write bio end ");
            }
        }

        private void addProteinSet(DProteinSet[] proteinSetArray) {
            for (DProteinSet prot : proteinSetArray) {
                String accession = prot.getTypicalProteinMatch().getAccession();
                if (this.m_proteinSetMap.get(accession) != null) continue;
                this.m_proteinSetMap.put(accession, prot);
            }
            ++this.m_nombre;
            if (this.m_nombre == this.m_selectedNodes.length) {
                m_logger.debug("write " + ExportMode.CONCATENATED + " fasta file : " + this.m_proteinSetMap.size() + " ProteinSet");
                this.writeBioSequence();
            }
        }
    }

    public static enum ExportMode {
        SINGLE,
        MULTIPLE,
        CONCATENATED;

    }
}

