/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.identification;

import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.WindowManager;
import fr.proline.studio.dpm.AccessJMSManagerThread;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import fr.proline.studio.dpm.task.jms.DownloadProcessedFileTask;
import fr.proline.studio.dpm.task.jms.ExportDatasetTask;
import fr.proline.studio.export.ExportDialog;
import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportSpectraListJMSAction
extends AbstractRSMAction {
    protected static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");
    FormatCompatibility m_compatibility;

    public ExportSpectraListJMSAction(AbstractTree tree, FormatCompatibility compatibility) {
        super(compatibility.equals((Object)FormatCompatibility.PeakView) ? "PeakView..." : "Spectronaut...", tree);
        this.m_compatibility = compatibility;
    }

    @Override
    public void actionPerformed(AbstractNode[] selectedNodes, int x, int y) {
        final DataSetNode dataSetNode = (DataSetNode)selectedNodes[0];
        final ExportDialog dialog = ExportDialog.getDialog((Window)WindowManager.getDefault().getMainWindow(), (Boolean)false, (int)6);
        DefaultDialog.ProgressTask task = new DefaultDialog.ProgressTask(){

            public int getMinValue() {
                return 0;
            }

            public int getMaxValue() {
                return 100;
            }

            protected Object doInBackground() throws Exception {
                final AbstractJMSCallback downloadCallback = new AbstractJMSCallback(){

                    public boolean mustBeCalledInAWT() {
                        return true;
                    }

                    public void run(boolean success) {
                        if (success) {
                            this.setProgress(100);
                        } else {
                            this.setProgress(100);
                        }
                    }
                };
                final ArrayList _filePath = new ArrayList();
                final ArrayList _jmsNodeId = new ArrayList();
                AbstractJMSCallback exportCallback = new AbstractJMSCallback(){

                    public boolean mustBeCalledInAWT() {
                        return true;
                    }

                    public void run(boolean success) {
                        if (success) {
                            Object fileName = dialog.getFileName();
                            if (!((String)fileName).endsWith(".tsv") && !((String)fileName).endsWith(".TSV")) {
                                fileName = (String)fileName + ".tsv";
                            }
                            if (_filePath.size() == 1) {
                                DownloadProcessedFileTask task = new DownloadProcessedFileTask(downloadCallback, (String)fileName, (String)_filePath.get(0), (String)_jmsNodeId.get(0));
                                AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)task);
                            }
                        } else {
                            JOptionPane.showMessageDialog((Component)WindowManager.getDefault().getMainWindow(), this.getTaskError().getErrorText(), "Warning", 0);
                            this.setProgress(100);
                        }
                    }
                };
                ArrayList<DDataset> dsets = new ArrayList<DDataset>();
                dsets.add(dataSetNode.getDataset());
                HashMap<String, String> exportParams = new HashMap<String, String>();
                exportParams.put("format_compatibility", ExportSpectraListJMSAction.this.m_compatibility.toString().toLowerCase());
                ExportDatasetTask exportTask = new ExportDatasetTask(exportCallback, dsets, null, _filePath, _jmsNodeId, ExportDatasetTask.ExporterFormat.SPECTRA_LIST, exportParams);
                AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)exportTask);
                return null;
            }
        };
        dialog.setTask(task);
        dialog.setLocation(x, y);
        dialog.setVisible(true);
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        int nbSelectedNodes = selectedNodes.length;
        if (nbSelectedNodes != 1) {
            this.setEnabled(false);
            return;
        }
        AbstractNode node = selectedNodes[0];
        AbstractNode.NodeTypes nodeType = node.getType();
        if (nodeType != AbstractNode.NodeTypes.DATA_SET && node.getType() != AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE_ANALYSIS) {
            this.setEnabled(false);
            return;
        }
        if (node.isChanging()) {
            this.setEnabled(false);
            return;
        }
        DataSetNode datasetNode = (DataSetNode)node;
        if (!datasetNode.hasResultSummary()) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }

    public static enum FormatCompatibility {
        PeakView,
        Spectronaut;

    }
}

