/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.identification;

import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.NbPreferences;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseDataSetTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.parameter.ObjectParameter;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import fr.proline.studio.rsmexplorer.tree.identification.IdentificationTree;
import java.util.Hashtable;
import javax.swing.JOptionPane;

public class ImportManager {
    public static final String DEFAULT_SEARCH_RESULT_NAME_SOURCE_KEY = "DefaultSearchResultNameSource";
    public static final String MASCOT_DAEMON_RULE = "MASCOT_DAEMON_RULE";
    public static final String SEARCH_RESULT_NAME_SOURCE = "SEARCH_RESULT_NAME";
    public static final String PEAKLIST_PATH_SOURCE = "PEAKLIST_PATH";
    public static final String MSI_SEARCH_FILE_NAME_SOURCE = "MSI_SEARCH_FILE_NAME";
    private static final String GENERAL_APPLICATION_SETTINGS = "General Application Settings";
    public static final Hashtable<String, Boolean> VALID_NAME_SOURCES = new Hashtable<String, Boolean>(){
        {
            this.put(ImportManager.SEARCH_RESULT_NAME_SOURCE, true);
            this.put(ImportManager.PEAKLIST_PATH_SOURCE, true);
            this.put(ImportManager.MSI_SEARCH_FILE_NAME_SOURCE, true);
            this.put(ImportManager.MASCOT_DAEMON_RULE, true);
        }
    };

    public static void importRenaming(final DDataset dataset, final DataSetNode identificationNode, final IdentificationTree tree) {
        ParameterList parameterList = new ParameterList(GENERAL_APPLICATION_SETTINGS);
        Object[] objectTable = new Object[]{SEARCH_RESULT_NAME_SOURCE, PEAKLIST_PATH_SOURCE, MSI_SEARCH_FILE_NAME_SOURCE, MASCOT_DAEMON_RULE};
        ObjectParameter parameter = new ObjectParameter(DEFAULT_SEARCH_RESULT_NAME_SOURCE_KEY, "Default Search Result Name Source", objectTable, 2, null);
        parameterList.add((Object)parameter);
        parameterList.loadParameters(NbPreferences.root());
        final String naming = (String)parameter.getObjectValue();
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                if (IdentificationTree.renameNode(dataset, naming, identificationNode, tree)) {
                    JOptionPane.showMessageDialog(null, "Selected ResultSet was not transfered with the required name");
                }
            }
        };
        if (dataset.getResultSet() == null) {
            DatabaseDataSetTask task = new DatabaseDataSetTask(callback);
            task.initLoadRsetAndRsm(dataset);
            AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
        } else if (IdentificationTree.renameNode(dataset, naming, identificationNode, tree)) {
            JOptionPane.showMessageDialog(null, "Selected ResultSet was not transfered with the required name");
        }
    }
}

