/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.table;

import fr.proline.studio.WindowManager;
import fr.proline.studio.dock.AbstractTopPanel;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataBoxFrozenCopy;
import fr.proline.studio.pattern.DataboxManager;
import fr.proline.studio.pattern.WindowBox;
import fr.proline.studio.pattern.WindowBoxFactory;
import fr.proline.studio.rsmexplorer.DataBoxViewerTopPanel;
import java.awt.Image;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisplayViewInNewWindowAction
extends AbstractAction {
    private AbstractDataBox m_sourceBox;
    private AbstractDataBox m_destinationBox;
    protected static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");

    public DisplayViewInNewWindowAction(AbstractDataBox sourceBox, AbstractDataBox destinationBox, String description) {
        super(description);
        Image img = destinationBox.getDefaultIcon();
        if (img != null) {
            this.putValue("SmallIcon", new ImageIcon(img));
        }
        this.m_sourceBox = sourceBox;
        try {
            this.m_destinationBox = DataboxManager.getDataboxNewInstance(destinationBox);
        }
        catch (IllegalAccessException | InstantiationException e) {
            m_logger.error("Error creating new Databox ", (Throwable)e);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DataBoxFrozenCopy dataBoxFrozenCopy = new DataBoxFrozenCopy(this.m_sourceBox);
        dataBoxFrozenCopy.addNextDataBox(this.m_destinationBox);
        Object dataName = this.m_sourceBox.getDataboxNavigationDisplayValue();
        if (dataName != null && ((String)dataName).length() > 12) {
            dataName = ((String)dataName).substring(0, 10) + "...";
        }
        WindowBox wbox = WindowBoxFactory.getDetailWindowBox((String)dataName, (String)dataName + ": " + this.m_destinationBox.getDescription(), this.m_destinationBox);
        DataBoxViewerTopPanel win = new DataBoxViewerTopPanel(wbox);
        WindowManager.getDefault().getMainWindow().displayWindow((AbstractTopPanel)win);
        Class[] classes = this.m_sourceBox.getDataboxNavigationOutParameterClasses();
        if (classes != null) {
            for (int i = 0; i < classes.length; ++i) {
                dataBoxFrozenCopy.addDataChanged(classes[i], null);
            }
        }
        dataBoxFrozenCopy.propagateDataChanged();
    }
}

