/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.xic;

import fr.proline.core.orm.uds.Project;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.WindowManager;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.dam.data.DataSetData;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dam.tasks.xic.DatabaseLoadXicMasterQuantTask;
import fr.proline.studio.dpm.AccessJMSManagerThread;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import fr.proline.studio.dpm.task.jms.AggregateQuantitationTask;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.gui.ProjectExplorerPanel;
import fr.proline.studio.rsmexplorer.gui.dialog.xic.AggregateQuantitationDialog;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import fr.proline.studio.rsmexplorer.tree.quantitation.QuantitationTree;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultTreeModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateQuantitationsAction
extends AbstractRSMAction {
    protected static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");
    private int m_nbLoadedQuanti;

    public AggregateQuantitationsAction(AbstractTree tree) {
        super("Aggregate Quantitations", tree);
    }

    @Override
    public void actionPerformed(final AbstractNode[] selectedNodes, final int x, final int y) {
        if (ProjectExplorerPanel.getProjectExplorerPanel().getSelectedProject() == null) {
            JOptionPane.showMessageDialog((Component)WindowManager.getDefault().getMainWindow(), "A project should be selected !", "Warning", 0);
            return;
        }
        final ArrayList<Long> quantiId = new ArrayList<Long>();
        for (AbstractNode n : selectedNodes) {
            quantiId.add(((DataSetNode)n).getDataset().getId());
        }
        final DDataset[] loadedQuantitations = new DDataset[selectedNodes.length];
        this.m_nbLoadedQuanti = 0;
        final ArrayList m_quantMethods = new ArrayList();
        for (AbstractNode n : selectedNodes) {
            if (n.isRoot() || !DataSetNode.class.isInstance(n)) continue;
            DataSetNode node = (DataSetNode)n;
            final DataSetData dataset = (DataSetData)node.getData();
            AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

                public boolean mustBeCalledInAWT() {
                    return true;
                }

                public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                    if (success) {
                        DDataset quantiDs = dataset.getDataset();
                        long idQuanti = quantiDs.getId();
                        int index = quantiId.indexOf(idQuanti);
                        m_quantMethods.add(quantiDs.getQuantitationMethod());
                        loadedQuantitations[index] = quantiDs;
                        ++AggregateQuantitationsAction.this.m_nbLoadedQuanti;
                        if (AggregateQuantitationsAction.this.m_nbLoadedQuanti == selectedNodes.length) {
                            boolean launchAgregate = true;
                            Set<String> qmNames = m_quantMethods.stream().map(qm -> qm.getName()).collect(Collectors.toSet());
                            if (qmNames.size() > 1) {
                                StringBuffer sb = new StringBuffer("You are about to aggregate different quantitation methods: ");
                                qmNames.forEach(e -> sb.append("\n- " + e));
                                sb.append("\n\nAre you sure you want to continue ?");
                                int response = JOptionPane.showConfirmDialog((Component)WindowManager.getDefault().getMainWindow(), sb.toString(), "Aggregation Warning. ", 0, 2);
                                boolean bl = launchAgregate = response == 0;
                            }
                            if (launchAgregate) {
                                List<DDataset> loadedSelectedQuanti = Arrays.stream(loadedQuantitations).collect(Collectors.toList());
                                AggregateQuantitationsAction.this.createAggregationDialog(loadedSelectedQuanti, x, y);
                            }
                        }
                    }
                }
            };
            DatabaseLoadXicMasterQuantTask task = new DatabaseLoadXicMasterQuantTask(callback);
            task.initLoadQuantChannels(ProjectExplorerPanel.getProjectExplorerPanel().getSelectedProject().getId(), dataset.getDataset());
            AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
        }
    }

    private void createAggregationDialog(List<DDataset> loadedQuantitations, int x, int y) {
        Long projectID = ProjectExplorerPanel.getProjectExplorerPanel().getSelectedProject().getId();
        AggregateQuantitationDialog dialog = AggregateQuantitationDialog.getDialog((Window)WindowManager.getDefault().getMainWindow());
        dialog.setQuantitationDatasets(loadedQuantitations);
        dialog.setLocation(x, y);
        dialog.setVisible(true);
        if (dialog.getButtonClicked() == 0) {
            final Long[] _xicQuantiDataSetId = new Long[1];
            StringBuffer errorMsg = new StringBuffer("");
            DataSetData _quantiDS = (DataSetData)dialog.getExperimentalDesignNode().getData();
            String datasetName = _quantiDS.getTemporaryName();
            Map<String, Object> expParams = null;
            try {
                expParams = dialog.getExperimentalDesignParameters();
            }
            catch (IllegalAccessException iae) {
                errorMsg.append(iae.getMessage());
            }
            Map<String, Object> quantParams = dialog.getQuantiParameters();
            if (!errorMsg.toString().isEmpty()) {
                JOptionPane.showMessageDialog((Component)((Object)dialog), errorMsg, "Warning", 0);
                return;
            }
            m_logger.debug("Will Aggregate Quantitations with params " + quantParams);
            QuantitationTree tree = QuantitationTree.getCurrentTree();
            final DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
            final DataSetNode[] _quantitationNode = new DataSetNode[]{QuantitationTree.getCurrentTree().createQuantitationNode(datasetName)};
            AbstractJMSCallback xicCallback = new AbstractJMSCallback(){

                public boolean mustBeCalledInAWT() {
                    return true;
                }

                public void run(boolean success) {
                    if (success) {
                        m_logger.debug(" XIC SUCCESS : " + _xicQuantiDataSetId[0]);
                        QuantitationTree.getCurrentTree().loadDataSet(_xicQuantiDataSetId[0], _quantitationNode[0]);
                    } else {
                        m_logger.debug(" XIC ERROR ");
                        treeModel.removeNodeFromParent(_quantitationNode[0]);
                    }
                }
            };
            AggregateQuantitationTask task = new AggregateQuantitationTask(xicCallback, projectID, datasetName, quantParams, expParams, _xicQuantiDataSetId);
            AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)task);
        }
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        Project selectedProject = ProjectExplorerPanel.getProjectExplorerPanel().getSelectedProject();
        if (!DatabaseDataManager.getDatabaseDataManager().ownProject(selectedProject)) {
            this.setEnabled(false);
            return;
        }
        if (selectedNodes.length <= 1) {
            this.setEnabled(false);
            return;
        }
        boolean enabled = true;
        for (int k = 0; k < selectedNodes.length && enabled; ++k) {
            AbstractNode node = selectedNodes[k];
            boolean bl = enabled = enabled && !node.isChanging() && node.getType() == AbstractNode.NodeTypes.DATA_SET;
            if (!enabled) continue;
            DataSetNode datasetNode = (DataSetNode)node;
            enabled = enabled && datasetNode.isQuantXIC();
        }
        this.setEnabled(enabled);
    }
}

