/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.xic;

import fr.proline.core.orm.msi.PtmSpecificity;
import fr.proline.core.orm.uds.Project;
import fr.proline.core.orm.uds.QuantitationChannel;
import fr.proline.core.orm.uds.QuantitationMethod;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.core.orm.uds.dto.DDatasetType;
import fr.proline.core.orm.uds.dto.DMasterQuantitationChannel;
import fr.proline.studio.WindowManager;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.dam.data.AbstractData;
import fr.proline.studio.dam.data.DataSetData;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseDataSetTask;
import fr.proline.studio.dam.tasks.DatabasePTMsTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dpm.AccessJMSManagerThread;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import fr.proline.studio.dpm.task.jms.ComputeQuantPostProcessingTask;
import fr.proline.studio.gui.OptionDialog;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.gui.ProjectExplorerPanel;
import fr.proline.studio.rsmexplorer.gui.dialog.xic.QuantPostProcessingDialog;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import fr.proline.studio.rsmexplorer.tree.quantitation.QuantitationTree;
import fr.proline.studio.utils.ResultCallback;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultTreeModel;

public class ComputeQuantPostProcessingAction
extends AbstractRSMAction {
    private int m_nbLoadedQuanti;

    public ComputeQuantPostProcessingAction(AbstractTree tree) {
        super("Compute Post Processing on Abundances...", tree);
    }

    @Override
    public void actionPerformed(final AbstractNode[] selectedNodes, int x, int y) {
        if (ProjectExplorerPanel.getProjectExplorerPanel().getSelectedProject() == null) {
            JOptionPane.showMessageDialog((Component)WindowManager.getDefault().getMainWindow(), "A project should be selected !", "Warning", 0);
            return;
        }
        final Long pID = ProjectExplorerPanel.getProjectExplorerPanel().getSelectedProject().getId();
        final int posX = x;
        final int posY = y;
        final ArrayList computedList = new ArrayList();
        final ArrayList selectedDatasetNodeList = new ArrayList();
        this.m_nbLoadedQuanti = 0;
        for (AbstractNode n : selectedNodes) {
            final DataSetNode node = (DataSetNode)n;
            final DDataset dataSet = ((DataSetData)node.getData()).getDataset();
            AbstractDatabaseCallback masterQuantChannelCallback = new AbstractDatabaseCallback(){

                public boolean mustBeCalledInAWT() {
                    return true;
                }

                public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                    if (success) {
                        if (dataSet.getPostQuantProcessingConfig() != null) {
                            computedList.add(node);
                        } else {
                            selectedDatasetNodeList.add(node);
                        }
                        ++ComputeQuantPostProcessingAction.this.m_nbLoadedQuanti;
                        if (ComputeQuantPostProcessingAction.this.m_nbLoadedQuanti == selectedNodes.length) {
                            if (!computedList.isEmpty()) {
                                String[] options = new String[]{"Compute All", "Skip already computed"};
                                String computedNodeName = computedList.stream().map(node -> node.getDataset().getName()).collect(Collectors.joining(","));
                                String message = "Dataset " + computedNodeName + ": Proteins Sets Abundances have already been post-processed \n(Compute Quant Post-Processing done).";
                                OptionDialog yesNoDialog = new OptionDialog((Window)WindowManager.getDefault().getMainWindow(), "Compute Post-Processing on Proteins Sets Abundances", message);
                                yesNoDialog.setButtonName(0, options[0]);
                                yesNoDialog.setButtonName(1, options[1]);
                                yesNoDialog.setLocation(posX, posY);
                                yesNoDialog.setVisible(true);
                                if (yesNoDialog.getButtonClicked() == 0) {
                                    selectedDatasetNodeList.addAll(computedList);
                                }
                            }
                            if (!selectedDatasetNodeList.isEmpty()) {
                                ComputeQuantPostProcessingAction.quantificationProfile(null, posX, posY, pID, selectedDatasetNodeList, null);
                            }
                        }
                    }
                }
            };
            DatabaseDataSetTask loadTask = new DatabaseDataSetTask(masterQuantChannelCallback);
            loadTask.initLoadQuantitation(ProjectExplorerPanel.getProjectExplorerPanel().getSelectedProject(), dataSet);
            AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)loadTask);
        }
    }

    public static boolean quantificationProfile(final ResultCallback resultCallback, int posX, int posY, Long pID, ArrayList<DataSetNode> nodeList, DDataset paramsFromdataset) {
        ArrayList<PtmSpecificity> ptms = ComputeQuantPostProcessingAction.fetchPtmsFromDAM(nodeList);
        boolean isAggregation = ComputeQuantPostProcessingAction.isAllAggregation(nodeList, posX, posY);
        boolean isValidLabelQuant = ComputeQuantPostProcessingAction.isQuantLabelValid(nodeList);
        DDatasetType.QuantitationMethodInfo qMethodInfo = nodeList.get(0).getDataset().getQuantMethodInfo();
        QuantitationMethod quantMethod = nodeList.get(0).getDataset().getQuantitationMethod();
        QuantPostProcessingDialog dialog = new QuantPostProcessingDialog((Window)WindowManager.getDefault().getMainWindow(), ptms, isAggregation, quantMethod, qMethodInfo, paramsFromdataset, isValidLabelQuant);
        dialog.setLocation(posX, posY);
        dialog.setVisible(true);
        if (dialog.getButtonClicked() == 0) {
            String errorMsg = null;
            Map<String, Object> quantParams = dialog.getQuantParams();
            if (quantParams == null) {
                errorMsg = "Null Quantitation parameters !";
            }
            if (errorMsg != null) {
                JOptionPane.showMessageDialog((Component)((Object)dialog), errorMsg, "Warning", 0);
                return false;
            }
            for (final DataSetNode node : nodeList) {
                node.setIsChanging(true);
                QuantitationTree tree = QuantitationTree.getCurrentTree();
                DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
                treeModel.nodeChanged(node);
            }
            for (final DataSetNode node : nodeList) {
                DDataset dataset = node.getDataset();
                String xicName = dataset.getName();
                List listMasterQuantChannels = dataset.getMasterQuantitationChannels();
                if (listMasterQuantChannels == null || listMasterQuantChannels.isEmpty()) continue;
                Long masterQuantChannelId = ((DMasterQuantitationChannel)listMasterQuantChannels.get(0)).getId();
                AbstractJMSCallback xicCallback = new AbstractJMSCallback(){

                    public boolean mustBeCalledInAWT() {
                        return true;
                    }

                    public void run(boolean success) {
                        QuantitationTree tree = QuantitationTree.getCurrentTree();
                        DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
                        node.setIsChanging(false);
                        treeModel.nodeChanged(node);
                        if (resultCallback != null) {
                            resultCallback.run(success);
                        }
                    }
                };
                ComputeQuantPostProcessingTask task = new ComputeQuantPostProcessingTask(xicCallback, pID, masterQuantChannelId, quantParams, xicName);
                AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)task);
            }
            return true;
        }
        return false;
    }

    private static boolean isQuantLabelValid(ArrayList<DataSetNode> nodeList) {
        boolean isValidLabelQuant = true;
        List<QuantitationMethod> nodeMethods = nodeList.stream().map(node -> node.getDataset().getQuantitationMethod()).distinct().toList();
        if (nodeMethods.size() != 1) {
            isValidLabelQuant = false;
        } else {
            QuantitationMethod commonMethod = nodeMethods.get(0);
            for (DataSetNode node2 : nodeList) {
                DDataset dataSet = ((DataSetData)node2.getData()).getDataset();
                for (QuantitationChannel nextQCh : ((DMasterQuantitationChannel)dataSet.getMasterQuantitationChannels().get(0)).getQuantitationChannels()) {
                    if (commonMethod.getLabels().contains(nextQCh.getQuantitationLabel())) continue;
                    isValidLabelQuant = false;
                    break;
                }
                if (isValidLabelQuant) continue;
                break;
            }
        }
        return isValidLabelQuant;
    }

    public static boolean quantificationProfile(ResultCallback resultCallback, int posx, int posy, Long pID, DDataset paramsFromdataSet) {
        ArrayList<DataSetNode> nodeList = new ArrayList<DataSetNode>();
        nodeList.add(new DataSetNode((AbstractData)new DataSetData(paramsFromdataSet)));
        return ComputeQuantPostProcessingAction.quantificationProfile(resultCallback, posx, posy, pID, nodeList, paramsFromdataSet);
    }

    private static ArrayList<PtmSpecificity> fetchPtmsFromDAM(ArrayList<DataSetNode> nodeList) {
        ArrayList<PtmSpecificity> ptms = new ArrayList<PtmSpecificity>();
        DatabasePTMsTask task = new DatabasePTMsTask(null);
        ArrayList<Long> rsmIdList = new ArrayList<Long>();
        long projectId = nodeList.get(0).getDataset().getProject().getId();
        for (int i = 0; i < nodeList.size(); ++i) {
            DDataset dataset = nodeList.get(i).getDataset();
            rsmIdList.add(dataset.getResultSummaryId());
        }
        task.initLoadUsedPTMs(Long.valueOf(projectId), rsmIdList, ptms);
        task.fetchData();
        return ptms;
    }

    private static boolean isAllAggregation(ArrayList<DataSetNode> nodeList, int posX, int posY) {
        Object quantitationList = "";
        Object aggregationList = "";
        for (DataSetNode node : nodeList) {
            boolean test;
            DDataset dataset = node.getDataset();
            boolean bl = test = dataset.isQuantitation() && dataset.isAggregation();
            if (test) {
                aggregationList = (String)aggregationList + dataset.getName() + " ";
                continue;
            }
            quantitationList = (String)quantitationList + dataset.getName() + " ";
        }
        if (((String)quantitationList).isEmpty()) {
            return true;
        }
        if (((String)aggregationList).isEmpty()) {
            return false;
        }
        Object errorMsg = "The selection has Aggregated Quatitation dataSets and Quatitation datasets.";
        errorMsg = (String)errorMsg + "\n Quantitation: " + (String)quantitationList;
        errorMsg = (String)errorMsg + "\n Aggregation: " + (String)aggregationList;
        errorMsg = (String)errorMsg + "\n The option Discard_Peptides_Sharing_Peakels will not be available";
        JOptionPane pane = new JOptionPane(errorMsg, 1);
        JDialog d = pane.createDialog(null, "Warning");
        d.setLocation(posX, posY);
        d.setVisible(true);
        return true;
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        Project selectedProject = ProjectExplorerPanel.getProjectExplorerPanel().getSelectedProject();
        if (!DatabaseDataManager.getDatabaseDataManager().ownProject(selectedProject)) {
            this.setEnabled(false);
            return;
        }
        boolean first = true;
        DDatasetType.QuantitationMethodInfo methodInfo = DDatasetType.QuantitationMethodInfo.NONE;
        for (AbstractNode node : selectedNodes) {
            DataSetNode datasetNode = (DataSetNode)node;
            if (node.isChanging()) {
                this.setEnabled(false);
                return;
            }
            if (node.getType() != AbstractNode.NodeTypes.DATA_SET) {
                this.setEnabled(false);
                return;
            }
            if (!datasetNode.isQuantXIC()) {
                this.setEnabled(false);
                return;
            }
            if (first) {
                methodInfo = datasetNode.getDataset().getQuantMethodInfo();
                first = false;
                continue;
            }
            if (datasetNode.getDataset().getQuantMethodInfo().equals((Object)methodInfo)) continue;
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }
}

