/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.adjacencymatrix.ordering;

import fr.proline.studio.dam.tasks.data.LightPeptideMatch;
import fr.proline.studio.dam.tasks.data.LightProteinMatch;
import fr.proline.studio.rsmexplorer.adjacencymatrix.ordering.ExperimentData;
import fr.proline.studio.rsmexplorer.adjacencymatrix.ordering.dissimilarityValue;
import fr.proline.studio.rsmexplorer.adjacencymatrix.visualize.Component;
import fr.proline.studio.rsmexplorer.adjacencymatrix.visualize.DrawVisualization;
import java.util.ArrayList;
import java.util.HashMap;
import org.opencompare.hac.ClusteringBuilder;
import org.opencompare.hac.HierarchicalAgglomerativeClusterer;
import org.opencompare.hac.agglomeration.AgglomerationMethod;
import org.opencompare.hac.agglomeration.AverageLinkage;
import org.opencompare.hac.dendrogram.Dendrogram;
import org.opencompare.hac.dendrogram.DendrogramBuilder;
import org.opencompare.hac.dendrogram.DendrogramNode;
import org.opencompare.hac.dendrogram.MergeNode;
import org.opencompare.hac.dendrogram.ObservationNode;
import org.opencompare.hac.experiment.DissimilarityMeasure;
import org.opencompare.hac.experiment.Experiment;

public class ClusterAComponent {
    public static void clusterComponent(DrawVisualization drawVisualization) {
        ArrayList<Component> compList = drawVisualization.getComponentList();
        HashMap<LightPeptideMatch, ArrayList<LightProteinMatch>> peptideToProteinMap = drawVisualization.getPeptideToProteinMap();
        for (Component tempComp : compList) {
            int[][] peptProtMap = tempComp.getPeptProtMatrix(peptideToProteinMap);
            ArrayList<Integer> proteinOrder = ClusterAComponent.clusterDataArray(tempComp.getProteinArray(false).size(), peptProtMap);
            int[][] transpose = new int[peptProtMap[0].length][peptProtMap.length];
            for (int i = 0; i < peptProtMap.length; ++i) {
                for (int j = 0; j < peptProtMap[i].length; ++j) {
                    transpose[j][i] = peptProtMap[i][j];
                }
            }
            ArrayList<Integer> peptideOrder = ClusterAComponent.clusterDataArray(tempComp.getPeptideArray().size(), transpose);
            ArrayList<LightProteinMatch> proteinSetTemp = new ArrayList<LightProteinMatch>();
            proteinSetTemp.clear();
            ArrayList<LightPeptideMatch> peptideSetTemp = new ArrayList<LightPeptideMatch>();
            peptideSetTemp.clear();
            for (int index : proteinOrder) {
                proteinSetTemp.add(tempComp.getProteinArray(false).get(index));
            }
            tempComp.setProteinArray(proteinSetTemp);
            for (int index : peptideOrder) {
                peptideSetTemp.add(tempComp.getPeptideArray().get(index));
            }
            tempComp.setPeptideArray(peptideSetTemp);
        }
    }

    private static final ArrayList<Integer> clusterDataArray(int lengthData, int[][] peptProtMap) {
        int rowCount = peptProtMap.length;
        int colCount = peptProtMap[0].length;
        double[][] similarityMatrix = new double[colCount][colCount];
        for (int i = 0; i < colCount; ++i) {
            for (int j = 0; j < colCount; ++j) {
                if (i < j) {
                    similarityMatrix[i][j] = similarityMatrix[j][i];
                    continue;
                }
                if (i == j) {
                    similarityMatrix[i][j] = 1.0;
                    continue;
                }
                double similarityValue = 0.0;
                for (int k = 0; k < rowCount; ++k) {
                    similarityValue += (double)(peptProtMap[k][i] * peptProtMap[k][j]);
                }
                similarityMatrix[i][j] = similarityValue;
            }
        }
        ExperimentData experiment = new ExperimentData(lengthData);
        dissimilarityValue dissimilarityMeasure = new dissimilarityValue(similarityMatrix);
        AverageLinkage agglomerationMethod = new AverageLinkage();
        DendrogramBuilder dendrogramBuilder = new DendrogramBuilder(experiment.getNumberOfObservations());
        HierarchicalAgglomerativeClusterer clusterer = new HierarchicalAgglomerativeClusterer((Experiment)experiment, (DissimilarityMeasure)dissimilarityMeasure, (AgglomerationMethod)agglomerationMethod);
        clusterer.cluster((ClusteringBuilder)dendrogramBuilder);
        Dendrogram dendrogram = dendrogramBuilder.getDendrogram();
        ArrayList<Integer> clusterOrder = new ArrayList<Integer>();
        clusterOrder = ClusterAComponent.getDendogramOrder(dendrogram.getRoot(), clusterOrder);
        return clusterOrder;
    }

    private static ArrayList<Integer> getDendogramOrder(DendrogramNode d, ArrayList<Integer> order) {
        DendrogramNode root = d;
        if (root instanceof ObservationNode) {
            order.add(((ObservationNode)root).getObservation());
        } else if (root instanceof MergeNode) {
            order = ClusterAComponent.getDendogramOrder(d.getLeft(), order);
            order = ClusterAComponent.getDendogramOrder(d.getRight(), order);
        }
        return order;
    }

    private static int[][] getPeptProtMatrix(Component compTemp, HashMap<LightPeptideMatch, ArrayList<LightProteinMatch>> peptideToProteinMap) {
        if (compTemp == null) {
            return null;
        }
        int[][] tempMatch = new int[compTemp.getPeptideArray().size()][compTemp.getProteinArray(true).size()];
        int i = 0;
        int j = 0;
        for (LightPeptideMatch tempPept : compTemp.getPeptideArray()) {
            ArrayList<LightProteinMatch> proteinList = peptideToProteinMap.get(tempPept);
            j = 0;
            for (LightProteinMatch tempProt : compTemp.getProteinArray(true)) {
                tempMatch[i][j] = proteinList.contains(tempProt) ? 1 : 0;
                ++j;
            }
            ++i;
        }
        return tempMatch;
    }
}

