/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.adjacencymatrix.visualize;

import fr.proline.studio.dam.tasks.data.LightPeptideMatch;
import fr.proline.studio.dam.tasks.data.LightProteinMatch;
import fr.proline.studio.rsmexplorer.adjacencymatrix.visualize.Component;
import fr.proline.studio.rsmexplorer.adjacencymatrix.visualize.DrawVisualization;
import fr.proline.studio.utils.CyclicColorPalette;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JButton;

public class MatrixImageButton
extends JButton {
    private static final int SQUARE_SIZE = 3;
    private static final int DELTA = 1;
    private static final int FRAME = 2;
    private static final BasicStroke SELECT_STROKE = new BasicStroke(3.0f);
    private BufferedImage m_image = null;
    private boolean m_isSelected = false;
    private static final Color EMPTY_CASE_COLOR = new Color(224, 224, 224);

    public MatrixImageButton(int index, Component componentOfImage, DrawVisualization drawVisualization) {
        int nbPeptides = componentOfImage.getPeptideSize();
        int nbProteins = componentOfImage.getProteinSize(false);
        int width = nbProteins * 4 + 1 + 4;
        int height = nbPeptides * 4 + 1 + 4;
        Dimension dimension = new Dimension(width, height);
        this.setMaximumSize(dimension);
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
        this.createImage(index, componentOfImage, drawVisualization);
    }

    private void createImage(int index, Component componentOfImage, DrawVisualization drawVisualization) {
        int nbPeptides = componentOfImage.getPeptideSize();
        int nbProteins = componentOfImage.getProteinSize(false);
        boolean[][] flagArray = new boolean[nbPeptides][nbProteins];
        for (int i = 0; i < nbPeptides; ++i) {
            for (int j = 0; j < nbProteins; ++j) {
                flagArray[i][j] = false;
            }
        }
        HashMap<LightPeptideMatch, ArrayList<LightProteinMatch>> m_peptideToProteinMap = drawVisualization.getPeptideToProteinMap();
        ArrayList<LightPeptideMatch> peptideList = componentOfImage.getPeptideArray();
        int peptIndex = -1;
        for (LightPeptideMatch temp2 : peptideList) {
            ++peptIndex;
            ArrayList<LightProteinMatch> proteinList = m_peptideToProteinMap.get(temp2);
            for (LightProteinMatch temp3 : proteinList) {
                int protIndex = componentOfImage.getProteinArray(false).indexOf(temp3);
                flagArray[peptIndex][protIndex] = true;
            }
        }
        Dimension d = this.getPreferredSize();
        this.m_image = new BufferedImage(d.width, d.height, 1);
        Graphics g = this.m_image.getGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, d.width, d.height);
        Color color = CyclicColorPalette.getColor((int)index);
        for (int x = 0; x < nbPeptides; ++x) {
            for (int y = 0; y < nbProteins; ++y) {
                int i = y * 4 + 1 + 2;
                int j = x * 4 + 1 + 2;
                if (flagArray[x][y]) {
                    g.setColor(color);
                    g.fillRect(i, j, 3, 3);
                    continue;
                }
                g.setColor(EMPTY_CASE_COLOR);
                g.fillRect(i, j, 3, 3);
            }
        }
        g.setColor(Color.black);
        g.drawRect(0, 0, d.width - 1, d.height - 1);
    }

    public void setSelection(boolean isSelected) {
        this.m_isSelected = isSelected;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.drawImage((Image)this.m_image, 0, 0, null);
        if (this.m_isSelected) {
            Dimension d = this.getPreferredSize();
            g2d.setColor(Color.black);
            Stroke s = g2d.getStroke();
            g2d.setStroke(SELECT_STROKE);
            g2d.drawRect(1, 1, d.width - 3, d.height - 3);
            g2d.setStroke(s);
        }
    }
}

