/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.adjacencymatrix.visualize;

import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.studio.dam.tasks.data.LightPeptideMatch;
import fr.proline.studio.dam.tasks.data.LightProteinMatch;
import fr.proline.studio.export.ExportButton;
import fr.proline.studio.gui.HourglassPanel;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.parameter.BooleanParameter;
import fr.proline.studio.parameter.IntegerParameter;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.parameter.SettingsButton;
import fr.proline.studio.parameter.SettingsInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataBoxPanelInterface;
import fr.proline.studio.rsmexplorer.adjacencymatrix.visualize.Component;
import fr.proline.studio.rsmexplorer.adjacencymatrix.visualize.DrawVisualization;
import fr.proline.studio.utils.CyclicColorPalette;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;

public class MatrixPanel
extends HourglassPanel
implements DataBoxPanelInterface,
SettingsInterface {
    private AbstractDataBox m_dataBox;
    private static final int MIN_CELL_SIZE = 14;
    private static final int MAX_CELL_SIZE = 30;
    private static final int DELTA = 3;
    private static final int TITLE_SIZE = 20;
    private static final int INFO_SIZE = 50;
    private static final int PEPTIDE_NAME_NB_CHARS_MAX = 45;
    private static final int PROTEIN_NAME_NB_CHARS_MAX = 30;
    private static final int VISIBILITY_MARGE_SIZE = 20;
    private static final String PROTEINS = "Proteins";
    private static final String PEPTIDES = "Peptides";
    private int m_peptideNameNbCharsMax = 45;
    private int m_proteinNameNbCharsMax = 30;
    private int m_peptideNamePixelSize;
    private int m_proteinNamePixelSize;
    private List<Cell> m_cells;
    private Cell m_overedCell = null;
    private Cell m_selectedCell = null;
    private List<PeptideCell> m_peptideCells;
    private List<ProteinCell> m_proteinCells;
    private static final ArrayList<Color> SCORE_COLOR_LIST = new ArrayList(6);
    private static final StringBuilder m_sb = new StringBuilder();
    private static final Color COLOR_GRAY = new Color(95, 87, 88);
    private static final Color COLOR_PEPTIDE_RANK1 = new Color(134, 180, 96);
    private static final Color SELECTION_COLOR = new Color(51, 153, 255);
    private static final Font FONT_HELVETICA_12_BOLD = new Font("Helvetica", 1, 12);
    private static final Font FONT_HELVETICA_11 = new Font("Helvetica", 0, 11);
    private static final BasicStroke SELECTED_STROKE = new BasicStroke(2.0f);
    private boolean m_firstPaint = true;
    private Integer[] m_peptideRank;
    private Float[] m_peptideScore;
    private int m_squareSize;
    private int m_xOffset;
    private int m_xOffsetMatrix;
    private int m_yOffsetMatrix;
    private Component m_component;
    HashMap<Long, DProteinMatch> m_proteinMap;
    HashMap<Long, DPeptideMatch> m_peptideMap;
    Long m_rsmId;
    private int[] m_flagArray;
    private DrawVisualization m_drawVisualization = null;
    private HashMap<LightProteinMatch, ArrayList<LightPeptideMatch>> m_proteinToPeptideMap = new HashMap();
    HashMap<LightProteinMatch, LightProteinMatch> m_equivalentToMainProteinMap = new HashMap();
    private final HashMap<Long, Color> m_proteinSetColorMap = new HashMap();
    private final String[] m_info = new String[2];
    private final JPanel m_internalPanel;
    private ArrayList<ParameterList> m_parameterListArray = null;
    public static final String MATRIX_PARAMETERS = "Matrix Parameters";
    public static final String HIDE_EQUIVALENT_PROTEINS_KEY = "HideEquivalentProteins";
    public static final String PROTEIN_NAME_HEIGHT_KEY = "ProteinNameHeight";
    public static final String PEPTIDE_NAME_WIDTH_KEY = "ProteinNameWidth";
    private BooleanParameter m_hideEquivalentPoteinsParameter = null;
    private IntegerParameter m_proteinNameMaxCharsParameter = null;
    private IntegerParameter m_peptideNameMaxCharsParameter = null;
    private boolean m_showEquivalentProteins = true;

    public MatrixPanel() {
        this.setLoading(0);
        this.setBorder(BorderFactory.createLineBorder(COLOR_GRAY));
        this.setLayout(new BorderLayout());
        if (SCORE_COLOR_LIST.isEmpty()) {
            SCORE_COLOR_LIST.add(new Color(252, 187, 161));
            SCORE_COLOR_LIST.add(new Color(252, 146, 114));
            SCORE_COLOR_LIST.add(new Color(251, 106, 74));
            SCORE_COLOR_LIST.add(new Color(239, 59, 44));
            SCORE_COLOR_LIST.add(new Color(203, 24, 29));
            SCORE_COLOR_LIST.add(new Color(153, 0, 13));
        }
        JScrollPane scrollPane = new JScrollPane();
        this.m_internalPanel = new InternalPanel();
        scrollPane.setViewportView(this.m_internalPanel);
        JToolBar toolbar = this.initToolbar();
        this.add(toolbar, "West");
        this.add(scrollPane, "Center");
    }

    private JToolBar initToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        SettingsButton settingsButton = new SettingsButton(null, (SettingsInterface)this);
        toolbar.add((java.awt.Component)settingsButton);
        ExportButton exportImageButton = new ExportButton("Protein/Peptide Matrix", this.m_internalPanel);
        toolbar.add((java.awt.Component)exportImageButton);
        return toolbar;
    }

    public void setData(Component c, DrawVisualization drawVisualization, HashMap<Long, DProteinMatch> proteinMap, HashMap<Long, DPeptideMatch> peptideMap, Long rsmId) {
        int col;
        Cell cell;
        int row;
        this.setLoaded(0);
        this.m_proteinSetColorMap.clear();
        if (this.m_cells != null) {
            this.m_cells.clear();
            this.m_overedCell = null;
            this.m_selectedCell = null;
        }
        this.m_drawVisualization = drawVisualization;
        this.m_rsmId = rsmId;
        this.m_proteinToPeptideMap = this.m_drawVisualization.getProteinToPeptideMap();
        this.m_equivalentToMainProteinMap = this.m_drawVisualization.getEquivalentToMainProtein();
        this.m_component = c;
        this.m_component.searchWeakPeptides(this.m_drawVisualization, 100.0);
        this.m_proteinMap = proteinMap;
        this.m_peptideMap = peptideMap;
        int rowCount = this.m_component == null ? 0 : this.m_component.getPeptideSize();
        int columnCount = this.m_component == null ? 0 : this.m_component.getProteinSize(this.m_showEquivalentProteins);
        this.m_cells = new ArrayList<Cell>(columnCount * rowCount);
        this.m_peptideCells = new ArrayList<PeptideCell>(rowCount);
        this.m_proteinCells = new ArrayList<ProteinCell>(columnCount);
        for (row = 0; row < rowCount; ++row) {
            for (int col2 = 0; col2 < columnCount; ++col2) {
                cell = new Cell(row, col2);
                cell.setPeptideMatch(this.m_peptideMap.get(this.m_component.getPeptideArray().get(row).getId()));
                LightProteinMatch lpm = this.m_component.getProteinArray(this.m_showEquivalentProteins).get(col2);
                cell.setProteinMatch(this.m_proteinMap.get(lpm.getId()));
                if (this.m_component.isWeakPeptide(row, lpm.getProteinSetId())) {
                    cell.setShowWeakNess();
                }
                this.m_cells.add(cell);
            }
        }
        for (row = 0; row < rowCount; ++row) {
            PeptideCell cell2 = new PeptideCell(row);
            cell2.setPeptideMatch(this.m_peptideMap.get(this.m_component.getPeptideArray().get(row).getId()));
            this.m_peptideCells.add(cell2);
        }
        for (int col3 = 0; col3 < columnCount; ++col3) {
            ProteinCell cell3 = new ProteinCell(col3);
            cell3.setProteinMatch(this.m_proteinMap.get(this.m_component.getProteinArray(this.m_showEquivalentProteins).get(col3).getId()));
            this.m_proteinCells.add(cell3);
        }
        HashMap<Long, Integer> m_proteinSetPeptidesNumber = new HashMap<Long, Integer>();
        for (col = 0; col < columnCount; ++col) {
            LightProteinMatch lpm = this.m_component.getProteinArray(this.m_showEquivalentProteins).get(col);
            long proteinSetId = lpm.getProteinSetId();
            DProteinMatch pm = this.m_proteinMap.get(lpm.getId());
            int nbPeptides = pm.getPeptideSet(this.m_rsmId).getPeptideCount();
            Integer curNbPeptides = (Integer)m_proteinSetPeptidesNumber.get(proteinSetId);
            if (curNbPeptides != null && curNbPeptides >= nbPeptides) continue;
            m_proteinSetPeptidesNumber.put(proteinSetId, nbPeptides);
        }
        for (col = 0; col < columnCount; ++col) {
            cell = this.m_proteinCells.get(col);
            LightProteinMatch lpm = this.m_component.getProteinArray(this.m_showEquivalentProteins).get(col);
            long proteinSetId = lpm.getProteinSetId();
            DProteinMatch pm = this.m_proteinMap.get(lpm.getId());
            int nbPeptides = pm.getPeptideSet(this.m_rsmId).getPeptideCount();
            boolean sameset = nbPeptides >= (Integer)m_proteinSetPeptidesNumber.get(proteinSetId);
            cell.setProteinMatch(pm);
            ((ProteinCell)cell).setSameSet(sameset);
        }
        this.m_peptideRank = new Integer[rowCount];
        this.m_flagArray = new int[columnCount * rowCount];
        this.m_peptideScore = new Float[rowCount];
        int index = 0;
        if (this.m_component != null) {
            for (LightPeptideMatch peptideMatch : this.m_component.getPeptideArray()) {
                this.m_peptideScore[index] = peptideMatch.getScore();
                this.m_peptideRank[index] = peptideMatch.getCDPrettyRank();
                ++index;
            }
        }
        this.m_firstPaint = true;
        this.repaint();
    }

    public DProteinMatch getSelectedProteinMatch() {
        if (this.m_selectedCell == null) {
            return null;
        }
        return this.m_selectedCell.getProteinMatch();
    }

    public DPeptideMatch getSelectedPeptideMatch() {
        if (this.m_selectedCell == null) {
            return null;
        }
        return this.m_selectedCell.getPeptideMatch();
    }

    public ArrayList<ParameterList> getParameters() {
        if (this.m_parameterListArray == null) {
            this.initParameters();
        }
        return this.m_parameterListArray;
    }

    public void parametersChanged() {
        Boolean hideEquivalentProteins;
        if (this.m_parameterListArray == null) {
            this.initParameters();
        }
        this.m_showEquivalentProteins = (hideEquivalentProteins = (Boolean)this.m_hideEquivalentPoteinsParameter.getObjectValue()) == false;
        this.m_peptideNameNbCharsMax = (Integer)this.m_peptideNameMaxCharsParameter.getObjectValue();
        this.m_proteinNameNbCharsMax = (Integer)this.m_proteinNameMaxCharsParameter.getObjectValue();
        this.setData(this.m_component, this.m_drawVisualization, this.m_proteinMap, this.m_peptideMap, this.m_rsmId);
    }

    private void initParameters() {
        ParameterList parameterTableList = new ParameterList(MATRIX_PARAMETERS);
        this.m_hideEquivalentPoteinsParameter = new BooleanParameter(HIDE_EQUIVALENT_PROTEINS_KEY, "Hide Proteins with same peptides", JCheckBox.class, Boolean.FALSE);
        this.m_proteinNameMaxCharsParameter = new IntegerParameter(PROTEIN_NAME_HEIGHT_KEY, "Maximum Protein Name Length", JTextField.class, Integer.valueOf(30), Integer.valueOf(10), Integer.valueOf(150));
        this.m_peptideNameMaxCharsParameter = new IntegerParameter(PEPTIDE_NAME_WIDTH_KEY, "Maximum Peptide Name Length", JTextField.class, Integer.valueOf(45), Integer.valueOf(10), Integer.valueOf(225));
        parameterTableList.add((Object)this.m_hideEquivalentPoteinsParameter);
        parameterTableList.add((Object)this.m_proteinNameMaxCharsParameter);
        parameterTableList.add((Object)this.m_peptideNameMaxCharsParameter);
        parameterTableList.getPanel();
        this.m_parameterListArray = new ArrayList();
        this.m_parameterListArray.add(parameterTableList);
    }

    public boolean parametersCanceled() {
        return false;
    }

    @Override
    public void setDataBox(AbstractDataBox dataBox) {
        this.m_dataBox = dataBox;
    }

    @Override
    public AbstractDataBox getDataBox() {
        return this.m_dataBox;
    }

    @Override
    public void addSingleValue(Object v) {
    }

    public ActionListener getRemoveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getRemoveAction(splittedPanel);
    }

    public ActionListener getAddAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getAddAction(splittedPanel);
    }

    public ActionListener getSaveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getSaveAction(splittedPanel);
    }

    public class Cell {
        protected DPeptideMatch m_peptideMatch = null;
        protected DProteinMatch m_proteinMatch = null;
        protected boolean m_showHalfFilled = false;
        protected int m_row;
        protected int m_col;
        protected boolean m_flewOver = false;
        protected boolean m_selected = false;
        protected boolean m_showWeakness = false;
        private int[] m_xPoints;
        private int[] m_yPoints;

        public Cell(int row, int col) {
            this.m_row = row;
            this.m_col = col;
        }

        public void setShowWeakNess() {
            this.m_showWeakness = true;
        }

        public boolean isSelectedOrOver() {
            return this.m_selected || this.m_flewOver;
        }

        public void setPeptideMatch(DPeptideMatch peptideMatch) {
            this.m_peptideMatch = peptideMatch;
        }

        public void setProteinMatch(DProteinMatch proteinMatch) {
            this.m_proteinMatch = proteinMatch;
        }

        public DPeptideMatch getPeptideMatch() {
            return this.m_peptideMatch;
        }

        public DProteinMatch getProteinMatch() {
            return this.m_proteinMatch;
        }

        public long getPeptideMatchId() {
            if (this.m_peptideMatch == null) {
                return -1L;
            }
            return this.m_peptideMatch.getId();
        }

        public long getProteinMatchId() {
            if (this.m_proteinMatch == null) {
                return -1L;
            }
            return this.m_proteinMatch.getId();
        }

        public void draw(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g.setColor(this.getFillColor());
            if (this.m_showHalfFilled) {
                if (this.m_xPoints == null) {
                    this.m_xPoints = new int[3];
                    this.m_yPoints = new int[3];
                }
                this.m_xPoints[0] = this.getPixelX();
                this.m_xPoints[1] = this.getPixelX() + MatrixPanel.this.m_squareSize;
                this.m_xPoints[2] = this.getPixelX();
                this.m_yPoints[0] = this.getPixelY();
                this.m_yPoints[1] = this.getPixelY();
                this.m_yPoints[2] = this.getPixelY() + MatrixPanel.this.m_squareSize;
                g.fillPolygon(this.m_xPoints, this.m_yPoints, 3);
            } else {
                g.fillRect(this.getPixelX(), this.getPixelY(), MatrixPanel.this.m_squareSize, MatrixPanel.this.m_squareSize);
            }
            if (this.m_selected || this.m_flewOver) {
                g.setColor(SELECTION_COLOR);
            } else {
                g.setColor(Color.lightGray);
            }
            Stroke s = g2d.getStroke();
            if (this.m_selected || this.m_flewOver) {
                g2d.setStroke(SELECTED_STROKE);
            }
            g.drawRect(this.getPixelX(), this.getPixelY(), MatrixPanel.this.m_squareSize, MatrixPanel.this.m_squareSize);
            g2d.setStroke(s);
        }

        public void setSelected(boolean v) {
            this.m_selected = v;
        }

        public void setFlewOver(boolean v) {
            this.m_flewOver = v;
        }

        public int getPixelX() {
            return MatrixPanel.this.m_xOffsetMatrix + (this.m_col + 1) * MatrixPanel.this.m_squareSize + 3;
        }

        public int getPixelY() {
            return MatrixPanel.this.m_yOffsetMatrix + (this.m_row + 1) * MatrixPanel.this.m_squareSize + 3;
        }

        public boolean inside(int x, int y) {
            int pixelX = this.getPixelX();
            int pixelY = this.getPixelY();
            return x >= pixelX && x <= pixelX + MatrixPanel.this.m_squareSize && y >= pixelY && y <= pixelY + MatrixPanel.this.m_squareSize;
        }

        public Color getFillColor() {
            int index = this.m_row * MatrixPanel.this.m_component.getProteinSize(MatrixPanel.this.m_showEquivalentProteins) + this.m_col;
            if (MatrixPanel.this.m_flagArray[index] == 1) {
                float score = MatrixPanel.this.m_peptideScore[this.m_row].floatValue();
                int colorIndex = (int)score / 10;
                if (colorIndex < 0) {
                    colorIndex = 0;
                } else if (colorIndex > 5) {
                    colorIndex = 5;
                }
                return SCORE_COLOR_LIST.get(colorIndex);
            }
            return Color.white;
        }

        public void getInfo(String[] info) {
            LightPeptideMatch peptideMatch;
            LightProteinMatch proteinMatch = this.m_col >= 0 ? MatrixPanel.this.m_component.getProteinArray(MatrixPanel.this.m_showEquivalentProteins).get(this.m_col) : null;
            LightPeptideMatch lightPeptideMatch = peptideMatch = this.m_row >= 0 ? MatrixPanel.this.m_component.getPeptideArray().get(this.m_row) : null;
            if (proteinMatch == null) {
                info[0] = "";
            } else {
                m_sb.append("Protein: ");
                m_sb.append(proteinMatch.getAccession());
                m_sb.append("    Score: ");
                m_sb.append(MatrixPanel.this.m_proteinMap.get(proteinMatch.getId()).getPeptideSet(MatrixPanel.this.m_rsmId).getScore());
                info[0] = m_sb.toString();
                m_sb.setLength(0);
            }
            if (peptideMatch == null) {
                info[1] = "";
            } else {
                m_sb.append("Peptide: ");
                m_sb.append(peptideMatch.getSequence());
                m_sb.append("    Score: ");
                m_sb.append(peptideMatch.getScore());
                m_sb.append("    Rank: ");
                m_sb.append(peptideMatch.getCDPrettyRank() == null ? "-" : peptideMatch.getCDPrettyRank());
                info[1] = m_sb.toString();
                m_sb.setLength(0);
            }
        }
    }

    public class InternalPanel
    extends JPanel {
        private Font m_displayFont = null;
        private FontMetrics m_metrics = null;

        public InternalPanel() {
            MouseAdapter mouseHandler = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (MatrixPanel.this.m_component == null) {
                        return;
                    }
                    boolean selectionChanged = false;
                    if (MatrixPanel.this.m_selectedCell != null) {
                        MatrixPanel.this.m_selectedCell.setSelected(false);
                        MatrixPanel.this.m_selectedCell = null;
                        selectionChanged = true;
                    }
                    int mouseX = e.getX();
                    int mouseY = e.getY();
                    MatrixPanel.this.m_selectedCell = InternalPanel.this.findCell(mouseX, mouseY);
                    if (MatrixPanel.this.m_selectedCell != null) {
                        MatrixPanel.this.m_selectedCell.setSelected(true);
                        selectionChanged = true;
                    }
                    if (selectionChanged) {
                        MatrixPanel.this.m_dataBox.addDataChanged(DProteinMatch.class);
                        MatrixPanel.this.m_dataBox.addDataChanged(DPeptideMatch.class);
                        MatrixPanel.this.m_dataBox.propagateDataChanged();
                        InternalPanel.this.repaint();
                    }
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    this.mouseMoved(e);
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    if (MatrixPanel.this.m_component == null) {
                        return;
                    }
                    boolean needRepaint = false;
                    if (MatrixPanel.this.m_overedCell != null) {
                        MatrixPanel.this.m_overedCell.setFlewOver(false);
                        MatrixPanel.this.m_overedCell = null;
                        needRepaint = true;
                    }
                    int mouseX = e.getX();
                    int mouseY = e.getY();
                    MatrixPanel.this.m_overedCell = InternalPanel.this.findCell(mouseX, mouseY);
                    if (MatrixPanel.this.m_overedCell != null) {
                        MatrixPanel.this.m_overedCell.setFlewOver(true);
                        needRepaint = true;
                    }
                    if (needRepaint) {
                        InternalPanel.this.repaint();
                    }
                }
            };
            this.addMouseListener(mouseHandler);
            this.addMouseMotionListener(mouseHandler);
        }

        private Cell findCell(int mouseX, int mouseY) {
            int columnCount = MatrixPanel.this.m_component.getProteinSize(MatrixPanel.this.m_showEquivalentProteins);
            int matrixX1 = MatrixPanel.this.m_cells.get(0).getPixelX();
            int matrixX2 = MatrixPanel.this.m_cells.get(MatrixPanel.this.m_cells.size() - 1).getPixelX() + MatrixPanel.this.m_squareSize;
            int matrixY1 = MatrixPanel.this.m_cells.get(0).getPixelY();
            int matrixY2 = MatrixPanel.this.m_cells.get(MatrixPanel.this.m_cells.size() - 1).getPixelY() + MatrixPanel.this.m_squareSize;
            int proteinY1 = MatrixPanel.this.m_proteinCells.get(0).getPixelY();
            int proteinY2 = proteinY1 + MatrixPanel.this.m_squareSize;
            int peptideX1 = MatrixPanel.this.m_peptideCells.get(0).getPixelX();
            int peptideX2 = peptideX1 + MatrixPanel.this.m_squareSize;
            if (mouseX >= matrixX1 && mouseX < matrixX2 && mouseY >= matrixY1 && mouseY < matrixY2) {
                int row = (mouseY - matrixY1) / MatrixPanel.this.m_squareSize;
                int column = (mouseX - matrixX1) / MatrixPanel.this.m_squareSize;
                int indexCell = row * columnCount + column;
                if (indexCell < MatrixPanel.this.m_cells.size()) {
                    return MatrixPanel.this.m_cells.get(row * columnCount + column);
                }
            } else {
                if (mouseX >= matrixX1 && mouseX < matrixX2 && mouseY >= proteinY1 && mouseY < proteinY2) {
                    int column = (mouseX - matrixX1) / MatrixPanel.this.m_squareSize;
                    return MatrixPanel.this.m_proteinCells.get(column);
                }
                if (mouseY >= matrixY1 && mouseY < matrixY2 && mouseX >= peptideX1 && mouseX < peptideX2) {
                    int row = (mouseY - matrixY1) / MatrixPanel.this.m_squareSize;
                    return MatrixPanel.this.m_peptideCells.get(row);
                }
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void paint(Graphics g) {
            Cell displayCell;
            Cell cell;
            int i;
            int stringWidth;
            int y2;
            int x2;
            int y;
            int x;
            Cell cell2;
            Cell cell1;
            int width = this.getWidth();
            int height = this.getHeight();
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2d.setColor(Color.white);
            g2d.fillRect(0, 0, width, height);
            if (MatrixPanel.this.m_component == null) {
                return;
            }
            if (MatrixPanel.this.m_component != null && MatrixPanel.this.isLoading()) {
                if (this.m_displayFont == null) {
                    this.m_displayFont = new Font("SansSerif", 1, 12);
                    this.m_metrics = g.getFontMetrics(this.m_displayFont);
                }
                g.setFont(this.m_displayFont);
                int PAD = 10;
                int INTERNAL_PAD = 5;
                int BOX_HEIGHT = 26;
                String text = "No Cluster Selected";
                int stringWidth2 = this.m_metrics.stringWidth(text);
                int fontAscent = this.m_metrics.getAscent();
                int visibleHeight = this.getVisibleRect().height;
                g.setColor(Color.white);
                g.fillRect(10, visibleHeight - 26 - 10, stringWidth2 + 20, 26);
                g.setColor(Color.gray);
                g.drawRect(12, visibleHeight - 26 - 10 + 2, stringWidth2 + 20 - 4, 22);
                g.setColor(Color.black);
                g.drawString(text, 20, visibleHeight - 26 - 10 + 5 + fontAscent);
                return;
            }
            if (MatrixPanel.this.m_firstPaint) {
                this.computeNecessarySize(g);
            }
            int rowCount = MatrixPanel.this.m_component.getPeptideSize();
            int columnCount = MatrixPanel.this.m_component.getProteinSize(MatrixPanel.this.m_showEquivalentProteins);
            int squareSizeX = 16;
            int squareSizeY = 16;
            MatrixPanel.this.m_squareSize = Math.min(squareSizeX, squareSizeY);
            if (MatrixPanel.this.m_squareSize > 30) {
                MatrixPanel.this.m_squareSize = 30;
            } else if (MatrixPanel.this.m_squareSize < 14) {
                MatrixPanel.this.m_squareSize = 14;
            }
            int matrixWidth = (columnCount + 1) * MatrixPanel.this.m_squareSize + 3;
            int matrixTotalWidth = matrixWidth + 20 + MatrixPanel.this.m_peptideNamePixelSize;
            int matrixHeight = (rowCount + 1) * MatrixPanel.this.m_squareSize + 3;
            int matrixTotalHeight = matrixHeight + 50 + 20 + MatrixPanel.this.m_proteinNamePixelSize;
            MatrixPanel.this.m_xOffset = (width - matrixTotalWidth) / 2;
            if (MatrixPanel.this.m_xOffset < 0) {
                MatrixPanel.this.m_xOffset = 0;
            }
            MatrixPanel.this.m_xOffsetMatrix = MatrixPanel.this.m_xOffset + 20 + MatrixPanel.this.m_peptideNamePixelSize + 3;
            MatrixPanel.this.m_yOffsetMatrix = 70 + MatrixPanel.this.m_proteinNamePixelSize + 3;
            g2d.setColor(COLOR_GRAY);
            g2d.setFont(FONT_HELVETICA_12_BOLD);
            FontMetrics fontMetricsBold = g.getFontMetrics(g.getFont());
            int proteinsWidth = fontMetricsBold.stringWidth(MatrixPanel.PROTEINS);
            int peptidesWidth = fontMetricsBold.stringWidth(MatrixPanel.PEPTIDES);
            g2d.drawString(MatrixPanel.PROTEINS, MatrixPanel.this.m_xOffset + (matrixTotalWidth - proteinsWidth + MatrixPanel.this.m_peptideNamePixelSize) / 2, 60);
            this.drawRotatedLine(g2d, MatrixPanel.this.m_xOffset + 10, (matrixTotalHeight + peptidesWidth) / 2 + MatrixPanel.this.m_proteinNamePixelSize, 4.71238898038469, MatrixPanel.PEPTIDES);
            g2d.setFont(FONT_HELVETICA_11);
            FontMetrics fontMetricsPlain = g.getFontMetrics(FONT_HELVETICA_11);
            ArrayList<LightProteinMatch> proteinList = MatrixPanel.this.m_component.getProteinArray(MatrixPanel.this.m_showEquivalentProteins);
            int proteinIndex = -1;
            for (LightProteinMatch lightProteinMatch : proteinList) {
                void var21_39;
                ++proteinIndex;
                ArrayList<LightPeptideMatch> arrayList = MatrixPanel.this.m_proteinToPeptideMap.get(lightProteinMatch);
                if (arrayList == null) {
                    ArrayList<LightPeptideMatch> arrayList2 = MatrixPanel.this.m_proteinToPeptideMap.get(MatrixPanel.this.m_equivalentToMainProteinMap.get(lightProteinMatch));
                }
                for (LightPeptideMatch peptideMatch : var21_39) {
                    int peptIndex = MatrixPanel.this.m_component.getPeptideArray().indexOf(peptideMatch);
                    int z = peptIndex * columnCount + proteinIndex;
                    MatrixPanel.this.m_flagArray[z] = 1;
                }
            }
            for (Cell cell3 : MatrixPanel.this.m_cells) {
                if (cell3.isSelectedOrOver()) continue;
                cell3.draw(g2d);
            }
            for (Cell cell4 : MatrixPanel.this.m_cells) {
                if (!cell4.isSelectedOrOver()) continue;
                cell4.draw(g2d);
            }
            for (PeptideCell peptideCell : MatrixPanel.this.m_peptideCells) {
                if (peptideCell.isSelectedOrOver()) continue;
                peptideCell.draw(g2d);
            }
            for (ProteinCell proteinCell : MatrixPanel.this.m_proteinCells) {
                if (proteinCell.isSelectedOrOver()) continue;
                proteinCell.draw(g2d);
            }
            Stroke s = g2d.getStroke();
            g2d.setStroke(SELECTED_STROKE);
            for (PeptideCell peptideCell : MatrixPanel.this.m_peptideCells) {
                if (!peptideCell.isSelectedOrOver()) continue;
                peptideCell.draw(g2d);
                g2d.setColor(SELECTION_COLOR);
                cell1 = MatrixPanel.this.m_cells.get(peptideCell.m_row * columnCount);
                cell2 = MatrixPanel.this.m_cells.get(peptideCell.m_row * columnCount + columnCount - 1);
                x = cell1.getPixelX();
                y = cell1.getPixelY();
                x2 = cell2.getPixelX() + MatrixPanel.this.m_squareSize;
                y2 = cell2.getPixelY() + MatrixPanel.this.m_squareSize;
                g.drawRect(x, y, x2 - x, y2 - y);
            }
            for (ProteinCell proteinCell : MatrixPanel.this.m_proteinCells) {
                if (!proteinCell.isSelectedOrOver()) continue;
                proteinCell.draw(g2d);
                g2d.setColor(SELECTION_COLOR);
                cell1 = MatrixPanel.this.m_cells.get(proteinCell.m_col);
                cell2 = MatrixPanel.this.m_cells.get((rowCount - 1) * columnCount + proteinCell.m_col);
                x = cell1.getPixelX();
                y = cell1.getPixelY();
                x2 = cell2.getPixelX() + MatrixPanel.this.m_squareSize;
                y2 = cell2.getPixelY() + MatrixPanel.this.m_squareSize;
                g.drawRect(x, y, x2 - x, y2 - y);
            }
            g2d.setStroke(s);
            int n = fontMetricsPlain.getAscent();
            int n2 = fontMetricsPlain.getDescent();
            long id1 = MatrixPanel.this.m_selectedCell == null ? -1L : MatrixPanel.this.m_selectedCell.getPeptideMatchId();
            long id2 = MatrixPanel.this.m_overedCell == null ? -1L : MatrixPanel.this.m_overedCell.getPeptideMatchId();
            int dIndex = 0;
            for (LightPeptideMatch peptideMatch : MatrixPanel.this.m_component.getPeptideArray()) {
                boolean highlight;
                long id = peptideMatch.getId();
                boolean bl = highlight = id == id1 || id == id2;
                if (highlight) {
                    g2d.setColor(SELECTION_COLOR);
                } else {
                    g2d.setColor(COLOR_GRAY);
                }
                Object sequence = peptideMatch.getSequence();
                stringWidth = 0;
                for (i = 0; i < ((String)sequence).length(); ++i) {
                    if ((stringWidth += fontMetricsPlain.charWidth(((String)sequence).charAt(i))) <= MatrixPanel.this.m_peptideNamePixelSize) continue;
                    --i;
                    break;
                }
                if (i > 0 && i < ((String)sequence).length() - 1) {
                    sequence = ((String)sequence).substring(0, i - 1) + ".";
                }
                cell = MatrixPanel.this.m_cells.get(dIndex * columnCount);
                int top = cell.getPixelY();
                int bottom = top + MatrixPanel.this.m_squareSize;
                int baseline = top + (bottom + 1 - top) / 2 - (n + n2) / 2 + n;
                g2d.drawString((String)sequence, MatrixPanel.this.m_xOffset + 20, baseline);
                ++dIndex;
            }
            id1 = MatrixPanel.this.m_selectedCell == null ? -1L : MatrixPanel.this.m_selectedCell.getProteinMatchId();
            id2 = MatrixPanel.this.m_overedCell == null ? -1L : MatrixPanel.this.m_overedCell.getProteinMatchId();
            dIndex = 0;
            for (LightProteinMatch proteinMatch : MatrixPanel.this.m_component.getProteinArray(MatrixPanel.this.m_showEquivalentProteins)) {
                boolean highlight;
                Object proteinName = proteinMatch.getAccession();
                long id = proteinMatch.getId();
                boolean bl = highlight = id == id1 || id == id2;
                if (highlight) {
                    g2d.setColor(SELECTION_COLOR);
                } else {
                    g2d.setColor(COLOR_GRAY);
                }
                stringWidth = 0;
                for (i = 0; i < ((String)proteinName).length(); ++i) {
                    if ((stringWidth += fontMetricsPlain.charWidth(((String)proteinName).charAt(i))) <= MatrixPanel.this.m_proteinNamePixelSize) continue;
                    --i;
                    break;
                }
                if (i > 0 && i < ((String)proteinName).length() - 1) {
                    proteinName = ((String)proteinName).substring(0, i - 1) + ".";
                }
                cell = MatrixPanel.this.m_cells.get(dIndex);
                int x3 = cell.getPixelX();
                int y3 = cell.getPixelY();
                int top = x3;
                int bottom = x3 + MatrixPanel.this.m_squareSize;
                int baseline = top + (bottom + 1 - top) / 2 - (n + n2) / 2 + n;
                this.drawRotatedLine(g2d, baseline, y3 - 5 - MatrixPanel.this.m_squareSize, 4.71238898038469, (String)proteinName);
                ++dIndex;
            }
            Cell cell5 = displayCell = MatrixPanel.this.m_overedCell != null ? MatrixPanel.this.m_overedCell : MatrixPanel.this.m_selectedCell;
            if (displayCell != null) {
                displayCell.getInfo(MatrixPanel.this.m_info);
                g2d.setFont(new Font("Helvetica", 1, 12));
                g2d.setColor(COLOR_GRAY);
                g2d.drawString(MatrixPanel.this.m_info[0], 10, 16);
                g2d.drawString(MatrixPanel.this.m_info[1], 10, 32);
            }
            if (MatrixPanel.this.m_firstPaint) {
                this.setPreferredSize(new Dimension(matrixTotalWidth + 20, matrixTotalHeight + 20));
                MatrixPanel.this.m_firstPaint = false;
                this.revalidate();
                this.repaint();
            }
        }

        private void computeNecessarySize(Graphics g) {
            Object peptideName;
            int stringWidth;
            int nb;
            FontMetrics fontMetrics = g.getFontMetrics(FONT_HELVETICA_11);
            int maxStringLength = 0;
            for (LightProteinMatch proteinMatch : MatrixPanel.this.m_component.getProteinArray(MatrixPanel.this.m_showEquivalentProteins)) {
                String proteinName = proteinMatch.getAccession();
                int nb2 = proteinName.length();
                if (nb2 <= maxStringLength) continue;
                maxStringLength = nb2;
            }
            int stringLength = Math.min(MatrixPanel.this.m_proteinNameNbCharsMax, maxStringLength);
            int maxPixelWidth = 0;
            for (LightProteinMatch proteinMatch : MatrixPanel.this.m_component.getProteinArray(MatrixPanel.this.m_showEquivalentProteins)) {
                Object proteinName = proteinMatch.getAccession();
                nb = ((String)proteinName).length();
                if (nb > stringLength) {
                    proteinName = ((String)proteinName).substring(0, stringLength) + ".";
                }
                if ((stringWidth = fontMetrics.stringWidth((String)proteinName)) <= maxPixelWidth) continue;
                maxPixelWidth = stringWidth;
            }
            MatrixPanel.this.m_proteinNamePixelSize = maxPixelWidth;
            maxStringLength = 0;
            for (LightPeptideMatch peptideMatch : MatrixPanel.this.m_component.getPeptideArray()) {
                peptideName = peptideMatch.getSequence();
                nb = ((String)peptideName).length();
                if (nb <= maxStringLength) continue;
                maxStringLength = nb;
            }
            stringLength = Math.min(MatrixPanel.this.m_peptideNameNbCharsMax, maxStringLength);
            maxPixelWidth = 0;
            for (LightPeptideMatch peptideMatch : MatrixPanel.this.m_component.getPeptideArray()) {
                peptideName = peptideMatch.getSequence();
                nb = ((String)peptideName).length();
                if (nb > stringLength) {
                    peptideName = ((String)peptideName).substring(0, stringLength) + ".";
                }
                if ((stringWidth = fontMetrics.stringWidth((String)peptideName)) <= maxPixelWidth) continue;
                maxPixelWidth = stringWidth;
            }
            MatrixPanel.this.m_peptideNamePixelSize = maxPixelWidth;
        }

        private void drawRotatedLine(Graphics g, double x, double y, double theta, String label) {
            Graphics2D g2D = (Graphics2D)g;
            AffineTransform fontAT = new AffineTransform();
            Font theFont = g2D.getFont();
            fontAT.rotate(theta);
            Font theDerivedFont = theFont.deriveFont(fontAT);
            g2D.setFont(theDerivedFont);
            g2D.drawString(label, (int)x, (int)y);
            g2D.setFont(theFont);
        }
    }

    public class PeptideCell
    extends Cell {
        public PeptideCell(int row) {
            super(row, -1);
        }

        @Override
        public int getPixelX() {
            return super.getPixelX() - 3;
        }

        @Override
        public Color getFillColor() {
            if (MatrixPanel.this.m_peptideRank[this.m_row] != null && MatrixPanel.this.m_peptideRank[this.m_row] == 1) {
                return COLOR_PEPTIDE_RANK1;
            }
            return Color.lightGray;
        }
    }

    public class ProteinCell
    extends Cell {
        public ProteinCell(int col) {
            super(-1, col);
        }

        @Override
        public int getPixelY() {
            return super.getPixelY() - 3;
        }

        @Override
        public Color getFillColor() {
            Long proteinSetId = MatrixPanel.this.m_component.getProteinArray(MatrixPanel.this.m_showEquivalentProteins).get(this.m_col).getProteinSetId();
            Color c = MatrixPanel.this.m_proteinSetColorMap.get(proteinSetId);
            if (c == null) {
                c = CyclicColorPalette.getColor((int)MatrixPanel.this.m_proteinSetColorMap.size());
                MatrixPanel.this.m_proteinSetColorMap.put(proteinSetId, c);
            }
            return c;
        }

        public void setSameSet(boolean sameset) {
            this.m_showHalfFilled = !sameset;
        }
    }
}

