/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.adjacencymatrix.visualize;

import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.studio.dam.tasks.data.AdjacencyMatrixData;
import fr.proline.studio.dam.tasks.data.LightPeptideMatch;
import fr.proline.studio.dam.tasks.data.LightProteinMatch;
import fr.proline.studio.export.ExportButton;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.filter.FilterMapInterface;
import fr.proline.studio.filter.StringDiffFilter;
import fr.proline.studio.gui.HourglassPanel;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataBoxPanelInterface;
import fr.proline.studio.rsmexplorer.adjacencymatrix.ordering.ClusterAComponent;
import fr.proline.studio.rsmexplorer.adjacencymatrix.visualize.Component;
import fr.proline.studio.rsmexplorer.adjacencymatrix.visualize.DrawVisualization;
import fr.proline.studio.rsmexplorer.adjacencymatrix.visualize.MatrixImageButton;
import fr.proline.studio.search.ApplySearchInterface;
import fr.proline.studio.search.SearchInterface;
import fr.proline.studio.search.SearchToggleButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.swing.BorderFactory;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;

public class MatrixSelectionPanel
extends HourglassPanel
implements DataBoxPanelInterface,
SearchInterface,
FilterMapInterface,
ApplySearchInterface {
    private AbstractDataBox m_dataBox;
    private DrawVisualization m_drawVisualization = null;
    private HashMap<LightPeptideMatch, ArrayList<LightProteinMatch>> m_peptideToProteinMap;
    private ArrayList<Component> m_componentList;
    private ArrayList<MatrixImageButton> m_curImageButtonArray;
    private Component m_currentComponent = null;
    private MatrixImageButton m_currentImageButton = null;
    private InternalPanel m_internalPanel = null;
    private JScrollPane m_scrollPane = null;
    private SearchToggleButton m_searchToggleButton;
    private static final int PROTEIN = 0;
    private static final int PEPTIDE = 1;
    private String m_proteinName = "";
    private ArrayList<Integer> m_searchIds = null;
    private int m_searchIndex = 0;
    private Font m_displayFont = null;
    private FontMetrics m_metrics = null;

    public MatrixSelectionPanel() {
        this.setLoading(0);
        this.setLayout(new BorderLayout());
        final JPanel matrixPanel = this.createMatrixPanel();
        final JLayeredPane layeredPane = new JLayeredPane();
        layeredPane.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                java.awt.Component c = e.getComponent();
                matrixPanel.setBounds(0, 0, c.getWidth(), c.getHeight());
                layeredPane.revalidate();
                layeredPane.repaint();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.add(layeredPane, "Center");
        layeredPane.add((java.awt.Component)matrixPanel, JLayeredPane.DEFAULT_LAYER);
        layeredPane.add((java.awt.Component)this.m_searchToggleButton.getSearchPanel(), JLayeredPane.PALETTE_LAYER);
    }

    @Override
    public void setDataBox(AbstractDataBox dataBox) {
        this.m_dataBox = dataBox;
    }

    @Override
    public AbstractDataBox getDataBox() {
        return this.m_dataBox;
    }

    @Override
    public void addSingleValue(Object v) {
    }

    public ActionListener getRemoveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getRemoveAction(splittedPanel);
    }

    public ActionListener getAddAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getAddAction(splittedPanel);
    }

    public ActionListener getSaveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getSaveAction(splittedPanel);
    }

    private JPanel createMatrixPanel() {
        JPanel matrixPanel = new JPanel(new BorderLayout());
        matrixPanel.setBackground(Color.white);
        this.m_internalPanel = new InternalPanel();
        JToolBar toolbar = this.initToolbar();
        matrixPanel.add((java.awt.Component)toolbar, "West");
        matrixPanel.add((java.awt.Component)this.m_internalPanel, "Center");
        return matrixPanel;
    }

    private JToolBar initToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        this.m_searchToggleButton = new SearchToggleButton((ApplySearchInterface)this, null, (SearchInterface)this, (FilterMapInterface)this);
        ExportButton exportImageButton = new ExportButton("Adjacency Matrices", (JPanel)this.m_internalPanel);
        toolbar.add((java.awt.Component)this.m_searchToggleButton);
        toolbar.add((java.awt.Component)exportImageButton);
        return toolbar;
    }

    public int search(Filter f, boolean newSearch) {
        if (this.m_searchIds == null) {
            this.m_searchIds = new ArrayList();
            newSearch = true;
        }
        if (newSearch) {
            this.m_searchIndex = 0;
            this.m_searchIds.clear();
            int nb = this.m_componentList.size();
            for (int i = 0; i < nb; ++i) {
                int type = f.getModelColumn();
                boolean found = this.filter(f, i, type);
                if (!found) continue;
                this.m_searchIds.add(i);
            }
        } else {
            ++this.m_searchIndex;
            if (this.m_searchIndex >= this.m_searchIds.size()) {
                this.m_searchIndex = 0;
            }
        }
        if (this.m_searchIds.isEmpty()) {
            return -1;
        }
        return this.m_searchIds.get(this.m_searchIndex);
    }

    private boolean filter(Filter filter, int index, int type) {
        block3: {
            block2: {
                if (type != 0) break block2;
                Component c = this.m_componentList.get(index);
                ArrayList<LightProteinMatch> proteinSet = c.getProteinArray(true);
                int nbProteins = proteinSet.size();
                for (int i = 0; i < nbProteins; ++i) {
                    LightProteinMatch pm = proteinSet.get(i);
                    if (!((StringDiffFilter)filter).filter((Object)pm.getAccession(), null)) continue;
                    return true;
                }
                break block3;
            }
            if (type != 1) break block3;
            Component c = this.m_componentList.get(index);
            ArrayList<LightPeptideMatch> peptideSet = c.getPeptideArray();
            int nbPeptides = peptideSet.size();
            for (int i = 0; i < nbPeptides; ++i) {
                LightPeptideMatch pm = peptideSet.get(i);
                if (!((StringDiffFilter)filter).filter((Object)pm.getSequence(), null)) continue;
                return true;
            }
        }
        return false;
    }

    public LinkedHashMap<Integer, Filter> getFilters() {
        LinkedHashMap<Integer, Filter> filtersMap = new LinkedHashMap<Integer, Filter>(2);
        StringDiffFilter proteinFilter = new StringDiffFilter("Protein", null, 0);
        filtersMap.put(0, (Filter)proteinFilter);
        StringDiffFilter peptideFilter = new StringDiffFilter("Peptide", null, 1);
        filtersMap.put(1, (Filter)peptideFilter);
        return filtersMap;
    }

    public void doSearch(Filter f, boolean firstSearch) {
        int modelRowIndex = this.search(f, firstSearch);
        if (modelRowIndex == -1) {
            return;
        }
        this.selectCluster(modelRowIndex);
    }

    private void selectCluster(int index) {
        MatrixImageButton imageButton = this.m_curImageButtonArray.get(index);
        imageButton.doClick();
        Rectangle visibleRectangle = this.m_scrollPane.getBounds();
        double x1 = visibleRectangle.getX() + (double)this.m_scrollPane.getHorizontalScrollBar().getValue();
        double x2 = x1 + visibleRectangle.getWidth();
        Point imageButtonLocation = imageButton.getLocation();
        if (imageButtonLocation.getX() < x1 || imageButtonLocation.getX() + (double)imageButton.getWidth() > x2) {
            this.m_scrollPane.getViewport().setViewPosition(imageButton.getLocation());
        }
    }

    public DrawVisualization getDrawVisualization() {
        return this.m_drawVisualization;
    }

    public void setData(AdjacencyMatrixData matrixData, DProteinMatch proteinMatch, boolean keepSameSet, boolean doNotTakeFirstSelection) {
        try {
            this.m_drawVisualization = new DrawVisualization();
            this.m_drawVisualization.setData(matrixData, keepSameSet);
            ClusterAComponent.clusterComponent(this.m_drawVisualization);
            this.m_internalPanel.initPanel(doNotTakeFirstSelection);
            this.selectProtein(proteinMatch);
            this.setLoaded(0);
            this.revalidate();
            this.repaint();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void setData(DProteinMatch proteinMatch, boolean doNotTakeFirstSelection) {
        try {
            if (proteinMatch == null) {
                return;
            }
            this.selectProtein(proteinMatch);
            this.repaint();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void selectProtein(DProteinMatch proteinMatch) {
        if (proteinMatch == null) {
            this.m_proteinName = "";
            return;
        }
        this.m_proteinName = proteinMatch.getAccession();
        if (this.m_componentList == null) {
            return;
        }
        int nbComponents = this.m_componentList.size();
        for (int i = 0; i < nbComponents; ++i) {
            Component c = this.m_componentList.get(i);
            ArrayList<LightProteinMatch> proteinSetList = c.getProteinArray(true);
            int nbProteins = proteinSetList.size();
            for (int j = 0; j < nbProteins; ++j) {
                LightProteinMatch pm = proteinSetList.get(j);
                if (proteinMatch.getId() != pm.getId()) continue;
                this.selectCluster(i);
                return;
            }
        }
        if (this.m_currentImageButton != null) {
            this.m_currentImageButton.setSelection(false);
            this.m_currentImageButton = null;
            this.setCurrentComponent(null);
            this.m_dataBox.addDataChanged(Component.class);
            this.m_dataBox.propagateDataChanged();
        }
    }

    public void setCurrentComponent(Component c) {
        this.m_currentComponent = c;
    }

    public Component getCurrentComponent() {
        return this.m_currentComponent;
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.m_currentComponent == null) {
            if (this.m_displayFont == null) {
                this.m_displayFont = new Font("SansSerif", 1, 12);
                this.m_metrics = g.getFontMetrics(this.m_displayFont);
            }
            g.setFont(this.m_displayFont);
            int PAD = 10;
            int INTERNAL_PAD = 5;
            int BOX_HEIGHT = 26;
            int visibleHeight = this.getVisibleRect().height;
            Object text = this.m_proteinName.length() > 0 ? "No Cluster Found for " + this.m_proteinName : this.m_proteinName;
            FontMetrics metrics = g.getFontMetrics(this.m_displayFont);
            int stringWidth = metrics.stringWidth((String)text);
            int fontAscent = this.m_metrics.getAscent();
            g.setColor(Color.white);
            g.fillRect(10, visibleHeight - 26 - 10, stringWidth + 20, 26);
            g.setColor(Color.darkGray);
            g.drawRect(12, visibleHeight - 26 - 10 + 2, stringWidth + 20 - 4, 22);
            g.setColor(Color.black);
            g.drawString((String)text, 20, visibleHeight - 26 - 10 + 5 + fontAscent);
        }
    }

    public class InternalPanel
    extends JPanel {
        private InternalPanel() {
            this.setBackground(Color.white);
        }

        private void initPanel(boolean doNotTakeFirstSelection) {
            MatrixSelectionPanel.this.m_peptideToProteinMap = MatrixSelectionPanel.this.m_drawVisualization.getPeptideToProteinMap();
            MatrixSelectionPanel.this.m_componentList = MatrixSelectionPanel.this.m_drawVisualization.getComponentList();
            Collections.sort(MatrixSelectionPanel.this.m_componentList, new CustomComparator());
            this.setLayout(new BorderLayout());
            JPanel horizontalPanel = new JPanel(new FlowLayout(0));
            horizontalPanel.setBackground(Color.white);
            horizontalPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            int nbComponents = MatrixSelectionPanel.this.m_componentList.size();
            MatrixSelectionPanel.this.m_curImageButtonArray = new ArrayList(nbComponents);
            for (int i = 0; i < nbComponents; ++i) {
                final Component component = MatrixSelectionPanel.this.m_componentList.get(i);
                final MatrixImageButton curImageButton = new MatrixImageButton(i, component, MatrixSelectionPanel.this.m_drawVisualization);
                MatrixSelectionPanel.this.m_curImageButtonArray.add(curImageButton);
                if (MatrixSelectionPanel.this.m_currentImageButton == null) {
                    MatrixSelectionPanel.this.m_currentComponent = component;
                    MatrixSelectionPanel.this.m_currentImageButton = curImageButton;
                    curImageButton.setSelection(true);
                }
                curImageButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (MatrixSelectionPanel.this.m_currentImageButton != null) {
                            MatrixSelectionPanel.this.m_currentImageButton.setSelection(false);
                        }
                        curImageButton.setSelection(true);
                        MatrixSelectionPanel.this.m_currentImageButton = curImageButton;
                        MatrixSelectionPanel.this.setCurrentComponent(component);
                        MatrixSelectionPanel.this.m_dataBox.addDataChanged(Component.class);
                        MatrixSelectionPanel.this.m_dataBox.propagateDataChanged();
                        InternalPanel.this.repaint();
                    }
                });
                horizontalPanel.add(curImageButton);
            }
            MatrixSelectionPanel.this.m_scrollPane = new JScrollPane(horizontalPanel);
            this.add((java.awt.Component)MatrixSelectionPanel.this.m_scrollPane, "Center");
            if (!doNotTakeFirstSelection) {
                MatrixSelectionPanel.this.m_dataBox.addDataChanged(Component.class);
                MatrixSelectionPanel.this.m_dataBox.propagateDataChanged();
            }
        }
    }

    public class CustomComparator
    implements Comparator<Component> {
        @Override
        public int compare(Component o1, Component o2) {
            if (o1 == null || o2 == null) {
                throw new NullPointerException();
            }
            return o2.getPeptideSize() * o2.getProteinSize(false) - o1.getPeptideSize() * o1.getProteinSize(false);
        }
    }
}

