/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui;

import fr.proline.studio.export.ExportButton;
import fr.proline.studio.gui.HourglassPanel;
import fr.proline.studio.rsmexplorer.gui.FlipButton;
import fr.proline.studio.rsmexplorer.gui.MSDiagOutput_AW;
import fr.proline.studio.rsmexplorer.gui.RsetMSDiagPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.graphics2d.svg.SVGGraphics2D;
import org.jfree.graphics2d.svg.SVGUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MSDiag_CategoryPlot
extends HourglassPanel {
    public static final String SERIES_NAME = "Chromatogram";
    protected static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");
    private static final long serialVersionUID = 1L;
    private final DefaultCategoryDataset m_dataSet;
    private JFreeChart m_chart;
    private File m_pngFile;
    private JPanel m_chromatogragmPanel;
    private final RsetMSDiagPanel m_msdiagPanel;

    public MSDiag_CategoryPlot(RsetMSDiagPanel rsetMSDiagPanel) {
        this.m_msdiagPanel = rsetMSDiagPanel;
        this.m_dataSet = new DefaultCategoryDataset();
        NumberAxis numberaxis = new NumberAxis("X");
        numberaxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        this.m_chart = ChartFactory.createStackedBarChart((String)"", (String)"", (String)"", (CategoryDataset)this.m_dataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        this.m_chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = this.m_chart.getCategoryPlot();
        this.m_chart = new JFreeChart("Combined Chart title", new Font("SansSerif", 1, 12), (Plot)plot, true);
        StackedBarRenderer renderer = (StackedBarRenderer)plot.getRenderer();
        renderer.setShadowVisible(true);
        renderer.setSeriesPaint(0, (Paint)new Color(220, 220, 220));
        renderer.setSeriesPaint(1, (Paint)new Color(176, 190, 255));
        renderer.setSeriesPaint(2, (Paint)new Color(132, 153, 255));
        renderer.setSeriesPaint(3, (Paint)new Color(91, 120, 255));
        renderer.setSeriesPaint(4, (Paint)new Color(64, 98, 255));
        renderer.setSeriesPaint(5, (Paint)new Color(32, 71, 255));
        renderer.setSeriesPaint(6, (Paint)new Color(1, 191, 220));
        renderer.setSeriesPaint(7, (Paint)new Color(126, 84, 214));
        renderer.setDrawBarOutline(false);
        TextTitle textTitle = this.m_chart.getTitle();
        textTitle.setFont(textTitle.getFont().deriveFont(0, 10.0f));
        this.m_chart.getCategoryPlot().getDomainAxis().setTickLabelFont(new Font("SansSerif", 1, 10));
        this.m_chart.getCategoryPlot().getRangeAxis().setTickLabelFont(new Font("SansSerif", 1, 10));
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        ChartPanel cp = new ChartPanel(this.m_chart, true);
        cp.setMinimumDrawWidth(0);
        cp.setMinimumDrawHeight(0);
        cp.setMaximumDrawWidth(Integer.MAX_VALUE);
        cp.setMaximumDrawHeight(Integer.MAX_VALUE);
        this.m_chart.getPlot().setBackgroundPaint((Paint)Color.white);
        this.m_chromatogragmPanel = cp;
        JToolBar toolbar = this.initToolbar();
        this.add(toolbar, "West");
        this.add(this.m_chromatogragmPanel, "Center");
    }

    private JToolBar initToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        FlipButton flipModeButton = new FlipButton("flip button text", this.m_msdiagPanel);
        toolbar.add(flipModeButton);
        ExportButton exportImageButton = new ExportButton("chart", this.m_chromatogragmPanel);
        toolbar.add((Component)exportImageButton);
        return toolbar;
    }

    public void setData(MSDiagOutput_AW msdo) {
        this.constructChromatogram(msdo);
    }

    public void writeToPNG(String fileName) {
        this.m_pngFile = new File(fileName);
        try {
            ChartUtils.saveChartAsPNG((File)this.m_pngFile, (JFreeChart)this.m_chart, (int)this.m_chromatogragmPanel.getWidth(), (int)this.m_chromatogragmPanel.getHeight());
        }
        catch (IOException e) {
            LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer").error("writeToPNG", (Throwable)e);
        }
    }

    public void writeToSVG(String file) {
        SVGGraphics2D g2 = new SVGGraphics2D(this.m_chromatogragmPanel.getWidth(), this.m_chromatogragmPanel.getHeight());
        this.m_chromatogragmPanel.paint((Graphics)g2);
        try {
            SVGUtils.writeToSVG((File)new File(file), (String)g2.getSVGElement());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void constructChromatogram(MSDiagOutput_AW msdo) {
        this.m_dataSet.clear();
        if (msdo == null) {
            return;
        }
        String title = msdo.description;
        this.m_chart.setTitle(title);
        this.m_chart.getPlot().setBackgroundPaint((Paint)Color.white);
        this.m_chart.getCategoryPlot().getDomainAxis().setLabel(msdo.x_axis_description);
        this.m_chart.getCategoryPlot().getDomainAxis().setLabelFont(new Font("SansSerif", 0, 12));
        this.m_chart.getCategoryPlot().getRangeAxis().setLabel(msdo.y_axis_description);
        this.m_chart.getCategoryPlot().getRangeAxis().setLabelFont(new Font("SansSerif", 0, 12));
        int nbSeries = msdo.matrix[0].length;
        int nbCategories = msdo.matrix.length;
        for (int serie = 1; serie < nbSeries; ++serie) {
            for (int cat = 0; cat < nbCategories; ++cat) {
                String rowKey = msdo.matrix[cat][0].toString();
                double y = (Double)msdo.matrix[cat][serie];
                String seriesName = msdo.column_names[serie];
                if (!(y > 0.0)) continue;
                this.m_dataSet.addValue(y, (Comparable)((Object)seriesName), (Comparable)((Object)rowKey));
            }
        }
    }
}

