/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui;

import fr.proline.core.orm.msi.dto.DMsQuery;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.export.ExportButton;
import fr.proline.studio.extendedtablemodel.AddDataAnalyzerButton;
import fr.proline.studio.extendedtablemodel.CompoundTableModel;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.GlobalTabelModelProviderInterface;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.FilterButton;
import fr.proline.studio.filter.FilterTableModelInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.gui.HourglassPanel;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.info.InfoInterface;
import fr.proline.studio.info.InfoToggleButton;
import fr.proline.studio.markerbar.MarkerComponentInterface;
import fr.proline.studio.markerbar.MarkerContainerPanel;
import fr.proline.studio.parameter.SettingsButton;
import fr.proline.studio.parameter.SettingsInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataAnalyzerWindowBoxManager;
import fr.proline.studio.pattern.DataBoxPanelInterface;
import fr.proline.studio.pattern.MsQueryInfoRset;
import fr.proline.studio.pattern.MsQueryInfoRsm;
import fr.proline.studio.progress.ProgressInterface;
import fr.proline.studio.rsmexplorer.actions.table.DisplayTablePopupMenu;
import fr.proline.studio.rsmexplorer.gui.model.MSQueriesTableModel;
import fr.proline.studio.table.CustomColumnControlButton;
import fr.proline.studio.table.LazyTable;
import fr.proline.studio.table.TableInfo;
import fr.proline.studio.table.TablePopupMenu;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;

public class MSQueriesPanel
extends HourglassPanel
implements DataBoxPanelInterface,
GlobalTabelModelProviderInterface {
    private AbstractDataBox m_dataBox;
    private MSQueriesTable m_msqueriesTable;
    private JScrollPane m_scrollPane;
    private MarkerContainerPanel m_markerContainerPanel;
    private SettingsButton m_settingsButton;
    private FilterButton m_filterButton;
    private ExportButton m_exportButton;
    private AddDataAnalyzerButton m_addCompareDataButton;
    private InfoToggleButton m_infoToggleButton;
    private JLabel m_titleLabel;
    private final String TABLE_TITLE = "MS Queries";
    private boolean m_fromRSM;

    public MSQueriesPanel(boolean fromRSm) {
        this.m_fromRSM = fromRSm;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        final JPanel msqueryPanel = this.createMSQueryPanel();
        final JLayeredPane layeredPane = new JLayeredPane();
        layeredPane.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                Component c = e.getComponent();
                msqueryPanel.setBounds(0, 0, c.getWidth(), c.getHeight());
                layeredPane.revalidate();
                layeredPane.repaint();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.add(layeredPane, "Center");
        layeredPane.add((Component)msqueryPanel, JLayeredPane.DEFAULT_LAYER);
        layeredPane.add((Component)this.m_infoToggleButton.getInfoPanel(), JLayeredPane.PALETTE_LAYER);
    }

    private JPanel createMSQueryPanel() {
        JPanel msqueryPanel = new JPanel();
        msqueryPanel.setBounds(0, 0, 500, 400);
        msqueryPanel.setLayout(new BorderLayout());
        JPanel internalPanel = this.createInternalPanel();
        JToolBar toolbar = this.initToolbar();
        this.m_titleLabel = new JLabel("MS Queries");
        msqueryPanel.add((Component)this.m_titleLabel, "North");
        msqueryPanel.add((Component)toolbar, "West");
        msqueryPanel.add((Component)internalPanel, "Center");
        return msqueryPanel;
    }

    private JToolBar initToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        this.m_settingsButton = new SettingsButton((ProgressInterface)this.m_msqueriesTable.getModel(), (SettingsInterface)this.m_msqueriesTable);
        this.m_filterButton = new FilterButton((FilterTableModelInterface)((CompoundTableModel)this.m_msqueriesTable.getModel())){

            protected void filteringDone() {
                MSQueriesPanel.this.m_dataBox.addDataChanged(ExtendedTableModelInterface.class);
                MSQueriesPanel.this.m_dataBox.propagateDataChanged();
                MSQueriesPanel.this.m_infoToggleButton.updateInfo();
            }
        };
        this.m_exportButton = new ExportButton((ProgressInterface)((CompoundTableModel)this.m_msqueriesTable.getModel()), "MsQueries", (JXTable)this.m_msqueriesTable);
        toolbar.add((Component)this.m_filterButton);
        toolbar.add((Component)this.m_settingsButton);
        toolbar.add((Component)this.m_exportButton);
        this.m_addCompareDataButton = new AddDataAnalyzerButton((ProgressInterface)((CompoundTableModel)this.m_msqueriesTable.getModel())){

            public void actionPerformed() {
                JXTable table = MSQueriesPanel.this.getGlobalAssociatedTable();
                TableInfo tableInfo = new TableInfo(MSQueriesPanel.this.m_dataBox.getId(), MSQueriesPanel.this.m_dataBox.getUserName(), MSQueriesPanel.this.m_dataBox.getDataName(), MSQueriesPanel.this.m_dataBox.getTypeName(), table);
                Image i = MSQueriesPanel.this.m_dataBox.getIcon();
                if (i != null) {
                    tableInfo.setIcon(new ImageIcon(i));
                }
                DataAnalyzerWindowBoxManager.addTableInfo(tableInfo);
            }
        };
        toolbar.add((Component)this.m_addCompareDataButton);
        this.m_infoToggleButton = new InfoToggleButton((ProgressInterface)this.m_msqueriesTable, (InfoInterface)this.m_msqueriesTable);
        toolbar.add((Component)this.m_infoToggleButton);
        return toolbar;
    }

    private JPanel createInternalPanel() {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        this.m_scrollPane = new JScrollPane();
        this.m_msqueriesTable = new MSQueriesTable();
        this.m_msqueriesTable.setModel((TableModel)new CompoundTableModel((GlobalTableModelInterface)new MSQueriesTableModel(this.m_msqueriesTable, this.m_fromRSM), true));
        CustomColumnControlButton customColumnControl = new CustomColumnControlButton((JXTable)this.m_msqueriesTable);
        this.m_msqueriesTable.setColumnControl((JComponent)customColumnControl);
        this.m_msqueriesTable.getColumnExt(this.m_msqueriesTable.convertColumnIndexToView(0)).setVisible(false);
        this.m_msqueriesTable.setSortable(false);
        this.m_markerContainerPanel = new MarkerContainerPanel(this.m_scrollPane, (MarkerComponentInterface)this.m_msqueriesTable);
        this.m_scrollPane.setViewportView((Component)((Object)this.m_msqueriesTable));
        this.m_msqueriesTable.setFillsViewportHeight(true);
        this.m_msqueriesTable.setViewport(this.m_scrollPane.getViewport());
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 3;
        internalPanel.add((Component)this.m_markerContainerPanel, c);
        return internalPanel;
    }

    public void dataUpdated(SubTask subTask, boolean finished) {
        this.m_msqueriesTable.dataUpdated(subTask, finished);
        if (finished) {
            this.m_msqueriesTable.setSortable(true);
        }
    }

    public void setData(Long taskId, List<DMsQuery> msQueries, Map<Long, Integer> nbPeptideMatchesByMsQueryIdMap, boolean finished) {
        ((MSQueriesTableModel)((CompoundTableModel)this.m_msqueriesTable.getModel()).getBaseModel()).setData(taskId, msQueries, nbPeptideMatchesByMsQueryIdMap);
        int nbQ = msQueries.size();
        this.m_titleLabel.setText("MS Queries (" + msQueries.size() + ")");
        this.m_msqueriesTable.getColumnExt(this.m_msqueriesTable.convertColumnIndexToView(0)).setVisible(false);
        this.m_markerContainerPanel.setMaxLineNumber(nbQ);
        if (nbQ > 0) {
            this.m_msqueriesTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        this.m_infoToggleButton.updateInfo();
        if (finished) {
            this.m_msqueriesTable.setSortable(true);
        }
    }

    @Override
    public void setDataBox(AbstractDataBox dataBox) {
        this.m_dataBox = dataBox;
    }

    @Override
    public AbstractDataBox getDataBox() {
        return this.m_dataBox;
    }

    public ActionListener getRemoveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getRemoveAction(splittedPanel);
    }

    public ActionListener getAddAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getAddAction(splittedPanel);
    }

    public ActionListener getSaveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getSaveAction(splittedPanel);
    }

    @Override
    public void addSingleValue(Object v) {
        this.getGlobalTableModelInterface().addSingleValue(v);
    }

    public GlobalTableModelInterface getGlobalTableModelInterface() {
        return (GlobalTableModelInterface)this.m_msqueriesTable.getModel();
    }

    public JXTable getGlobalAssociatedTable() {
        return this.m_msqueriesTable;
    }

    public CrossSelectionInterface getCrossSelectionInterface() {
        return this.m_msqueriesTable;
    }

    public DMsQuery getSelectedMsQuery() {
        MSQueriesTable table = this.m_msqueriesTable;
        int selectedRow = table.getSelectedRow();
        if (selectedRow == -1) {
            return null;
        }
        selectedRow = table.convertRowIndexToModel(selectedRow);
        CompoundTableModel compoundTableModel = (CompoundTableModel)table.getModel();
        selectedRow = compoundTableModel.convertCompoundRowToBaseModelRow(selectedRow);
        MSQueriesTableModel tableModel = (MSQueriesTableModel)compoundTableModel.getBaseModel();
        return tableModel.getSelectedMsQuery(selectedRow);
    }

    private class MSQueriesTable
    extends LazyTable
    implements InfoInterface {
        private boolean selectionWillBeRestored;
        private DisplayTablePopupMenu m_popupMenu;

        public MSQueriesTable() {
            super(MSQueriesPanel.this.m_scrollPane.getVerticalScrollBar());
            this.selectionWillBeRestored = false;
        }

        public TablePopupMenu initPopupMenu() {
            this.m_popupMenu = new DisplayTablePopupMenu(MSQueriesPanel.this);
            return this.m_popupMenu;
        }

        public void prepostPopupMenu() {
            this.m_popupMenu.prepostPopupMenu();
        }

        public void addTableModelListener(TableModelListener l) {
            this.getModel().addTableModelListener(l);
        }

        public boolean isLoaded() {
            return MSQueriesPanel.this.m_dataBox.isLoaded();
        }

        public int getLoadingPercentage() {
            return MSQueriesPanel.this.m_dataBox.getLoadingPercentage();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dataUpdated(SubTask subTask, boolean finished) {
            LazyTable.LastAction keepLastAction = this.m_lastAction;
            try {
                int rowSelected = this.getSelectionModel().getMinSelectionIndex();
                int rowSelectedInModel = rowSelected == -1 ? -1 : this.convertRowIndexToModel(rowSelected);
                this.selectionWillBeRestored(true);
                try {
                    ((MSQueriesTableModel)((CompoundTableModel)this.getModel()).getBaseModel()).dataUpdated();
                }
                finally {
                    this.selectionWillBeRestored(false);
                }
                if (rowSelectedInModel != -1) {
                    int rowSelectedInView = this.convertRowIndexToView(rowSelectedInModel);
                    this.setSelection(rowSelectedInView);
                    if ((keepLastAction == LazyTable.LastAction.ACTION_SELECTING || keepLastAction == LazyTable.LastAction.ACTION_SORTING) && subTask.getSubTaskId() == ((CompoundTableModel)this.getModel()).getSubTaskId(this.getSortedColumnIndex())) {
                        this.scrollRowToVisible(rowSelectedInView);
                    }
                }
            }
            finally {
                this.m_lastAction = keepLastAction;
            }
            if (finished) {
                this.setSortable(true);
            }
        }

        public void selectionWillBeRestored(boolean b) {
            this.selectionWillBeRestored = b;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            super.valueChanged(e);
            if (this.selectionWillBeRestored) {
                return;
            }
            if (e.getValueIsAdjusting()) {
                return;
            }
            if (MSQueriesPanel.this.m_fromRSM) {
                MSQueriesPanel.this.m_dataBox.addDataChanged(MsQueryInfoRsm.class);
            } else {
                MSQueriesPanel.this.m_dataBox.addDataChanged(MsQueryInfoRset.class);
            }
            MSQueriesPanel.this.m_dataBox.propagateDataChanged();
        }

        public String getInfo() {
            int count;
            return count + ((count = this.getModel().getRowCount()) > 1 ? " Queries" : "Query");
        }
    }
}

