/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui;

import fr.proline.core.orm.msi.ResultSet;
import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.studio.WindowManager;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dock.AbstractTopPanel;
import fr.proline.studio.export.ExportButton;
import fr.proline.studio.extendedtablemodel.AddDataAnalyzerButton;
import fr.proline.studio.extendedtablemodel.CompoundTableModel;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.GlobalTabelModelProviderInterface;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.FilterButton;
import fr.proline.studio.filter.FilterTableModelInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.gui.HourglassPanel;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.info.InfoInterface;
import fr.proline.studio.info.InfoToggleButton;
import fr.proline.studio.markerbar.MarkerComponentInterface;
import fr.proline.studio.markerbar.MarkerContainerPanel;
import fr.proline.studio.parameter.SettingsButton;
import fr.proline.studio.parameter.SettingsInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataAnalyzerWindowBoxManager;
import fr.proline.studio.pattern.DataBoxPanelInterface;
import fr.proline.studio.pattern.SaveDataBoxActionListener;
import fr.proline.studio.pattern.WindowBox;
import fr.proline.studio.pattern.WindowBoxFactory;
import fr.proline.studio.pattern.WindowSavedManager;
import fr.proline.studio.progress.ProgressBarDialog;
import fr.proline.studio.progress.ProgressInterface;
import fr.proline.studio.rsmexplorer.DataBoxViewerTopPanel;
import fr.proline.studio.rsmexplorer.actions.table.DisplayTablePopupMenu;
import fr.proline.studio.rsmexplorer.gui.model.PeptideMatchTableModel;
import fr.proline.studio.search.SearchToggleButton;
import fr.proline.studio.table.LazyTable;
import fr.proline.studio.table.TableInfo;
import fr.proline.studio.table.TablePopupMenu;
import fr.proline.studio.utils.IconManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;

public class PeptideMatchPanel
extends HourglassPanel
implements DataBoxPanelInterface,
GlobalTabelModelProviderInterface {
    private AbstractDataBox m_dataBox;
    private final boolean m_forRSM;
    private final boolean m_mergedData;
    private final boolean m_startingPanel;
    private final boolean m_proteinMatchUnknown;
    private final boolean m_isDecoyAndValidated;
    private PeptideMatchTable m_peptideMatchTable;
    private JScrollPane m_scrollPane;
    private MarkerContainerPanel m_markerContainerPanel;
    private JButton m_decoyButton;
    private SearchToggleButton m_searchToggleButton;
    private InfoToggleButton m_infoToggleButton;
    private SettingsButton m_settingsButton;
    private FilterButton m_filterButton;
    private ExportButton m_exportButton;
    private JButton m_graphicsButton;
    private AddDataAnalyzerButton m_addCompareDataButton;

    public PeptideMatchPanel(boolean forRSM, boolean mergedData, boolean startingPanel, boolean proteinMatchUnknown, boolean isDecoyAndValidated) {
        this.m_forRSM = forRSM;
        this.m_mergedData = mergedData;
        this.m_startingPanel = startingPanel;
        this.m_proteinMatchUnknown = proteinMatchUnknown;
        this.m_isDecoyAndValidated = isDecoyAndValidated;
        this.initComponents();
    }

    @Override
    public void setDataBox(AbstractDataBox dataBox) {
        this.m_dataBox = dataBox;
    }

    @Override
    public AbstractDataBox getDataBox() {
        return this.m_dataBox;
    }

    @Override
    public void addSingleValue(Object v) {
        this.getGlobalTableModelInterface().addSingleValue(v);
    }

    public GlobalTableModelInterface getGlobalTableModelInterface() {
        return (GlobalTableModelInterface)this.m_peptideMatchTable.getModel();
    }

    public JXTable getGlobalAssociatedTable() {
        return this.m_peptideMatchTable;
    }

    public void setData(long taskId, DPeptideMatch[] peptideMatches, long[] peptideMatchesId, boolean finished) {
        if (this.m_startingPanel) {
            if (this.m_forRSM) {
                ResultSummary rsm = (ResultSummary)this.m_dataBox.getData(ResultSummary.class);
                if (rsm != null) {
                    this.m_decoyButton.setEnabled(rsm.getDecoyResultSummary() != null);
                }
            } else {
                ResultSet rset = (ResultSet)this.m_dataBox.getData(ResultSet.class);
                if (rset != null) {
                    this.m_decoyButton.setEnabled(rset.getDecoyResultSet() != null);
                }
            }
        }
        ((PeptideMatchTableModel)((CompoundTableModel)this.m_peptideMatchTable.getModel()).getBaseModel()).setData(taskId, peptideMatches, peptideMatchesId);
        this.m_infoToggleButton.updateInfo();
        if (peptideMatches != null && peptideMatches.length > 0) {
            this.m_peptideMatchTable.getSelectionModel().setSelectionInterval(0, 0);
            this.m_markerContainerPanel.setMaxLineNumber(peptideMatches.length);
            if (!this.m_startingPanel) {
                this.m_markerContainerPanel.removeAllMarkers();
            }
        }
        if (finished) {
            this.m_peptideMatchTable.setSortable(true);
        }
    }

    public void dataUpdated(SubTask subTask, boolean finished) {
        this.m_peptideMatchTable.dataUpdated(subTask, finished);
    }

    private String getTopComponentName() {
        Container c;
        for (c = this.getParent(); c != null && !(c instanceof AbstractTopPanel); c = c.getParent()) {
        }
        if (c != null && c instanceof AbstractTopPanel) {
            return ((AbstractTopPanel)c).getTitle();
        }
        return "";
    }

    public DPeptideMatch getSelectedPeptideMatch() {
        PeptideMatchTable table = this.m_peptideMatchTable;
        int selectedRow = table.getSelectedRow();
        if (selectedRow == -1) {
            return null;
        }
        selectedRow = table.convertRowIndexToModel(selectedRow);
        CompoundTableModel compoundTableModel = (CompoundTableModel)table.getModel();
        selectedRow = compoundTableModel.convertCompoundRowToBaseModelRow(selectedRow);
        PeptideMatchTableModel tableModel = (PeptideMatchTableModel)compoundTableModel.getBaseModel();
        return tableModel.getPeptideMatch(selectedRow);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        final JPanel peptideMatch = this.createPeptideMatchPanel();
        final JLayeredPane layeredPane = new JLayeredPane();
        layeredPane.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                Component c = e.getComponent();
                peptideMatch.setBounds(0, 0, c.getWidth(), c.getHeight());
                layeredPane.revalidate();
                layeredPane.repaint();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.add(layeredPane, "Center");
        layeredPane.add((Component)peptideMatch, JLayeredPane.DEFAULT_LAYER);
        layeredPane.add((Component)this.m_infoToggleButton.getInfoPanel(), JLayeredPane.PALETTE_LAYER);
        layeredPane.add((Component)this.m_searchToggleButton.getSearchPanel(), (Object)(JLayeredPane.PALETTE_LAYER + 1));
    }

    private JToolBar initToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        if (this.m_startingPanel) {
            IconManager.IconType iconType = this.m_forRSM ? IconManager.IconType.DATASET_RSM_DECOY : IconManager.IconType.DATASET_RSET_DECOY;
            this.m_decoyButton = new JButton(IconManager.getIcon((IconManager.IconType)iconType));
            this.m_decoyButton.setToolTipText("Display Decoy Data");
            this.m_decoyButton.setEnabled(false);
            this.m_decoyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WindowBox wbox;
                    if (PeptideMatchPanel.this.m_forRSM) {
                        ResultSummary rsm = (ResultSummary)PeptideMatchPanel.this.m_dataBox.getData(ResultSummary.class);
                        ResultSummary decoyRsm = rsm.getDecoyResultSummary();
                        if (decoyRsm == null) {
                            return;
                        }
                        String savedWindow = SaveDataBoxActionListener.saveParentContainer("tmp", PeptideMatchPanel.this.m_decoyButton);
                        AbstractDataBox[] databoxes = WindowSavedManager.readBoxes(savedWindow);
                        wbox = WindowBoxFactory.getFromBoxesWindowBox("Decoy " + PeptideMatchPanel.this.getTopComponentName(), databoxes, true, false, '2');
                        wbox.setEntryData(PeptideMatchPanel.this.m_dataBox.getProjectId(), decoyRsm);
                    } else {
                        ResultSet rset = (ResultSet)PeptideMatchPanel.this.m_dataBox.getData(ResultSet.class);
                        ResultSet decoyRset = rset.getDecoyResultSet();
                        if (decoyRset == null) {
                            return;
                        }
                        String savedWindow = SaveDataBoxActionListener.saveParentContainer("tmp", PeptideMatchPanel.this.m_decoyButton);
                        AbstractDataBox[] databoxes = WindowSavedManager.readBoxes(savedWindow);
                        wbox = WindowBoxFactory.getFromBoxesWindowBox("Decoy " + PeptideMatchPanel.this.getTopComponentName(), databoxes, true, false, '1');
                        wbox.setEntryData(PeptideMatchPanel.this.m_dataBox.getProjectId(), decoyRset);
                    }
                    DataBoxViewerTopPanel win = new DataBoxViewerTopPanel(wbox);
                    WindowManager.getDefault().getMainWindow().displayWindow((AbstractTopPanel)win);
                }
            });
        }
        this.m_settingsButton = new SettingsButton((ProgressInterface)this.m_peptideMatchTable.getModel(), (SettingsInterface)this.m_peptideMatchTable);
        this.m_searchToggleButton = new SearchToggleButton((ProgressInterface)this.m_peptideMatchTable, (JXTable)this.m_peptideMatchTable, (FilterTableModelInterface)((CompoundTableModel)this.m_peptideMatchTable.getModel()));
        this.m_filterButton = new FilterButton((FilterTableModelInterface)((CompoundTableModel)this.m_peptideMatchTable.getModel())){

            protected void filteringDone() {
                PeptideMatchPanel.this.m_dataBox.addDataChanged(ExtendedTableModelInterface.class);
                PeptideMatchPanel.this.m_dataBox.propagateDataChanged();
                PeptideMatchPanel.this.m_infoToggleButton.updateInfo();
            }
        };
        this.m_exportButton = new ExportButton((ProgressInterface)((CompoundTableModel)this.m_peptideMatchTable.getModel()), "Peptide Match", (JXTable)this.m_peptideMatchTable);
        this.m_addCompareDataButton = new AddDataAnalyzerButton((ProgressInterface)((CompoundTableModel)this.m_peptideMatchTable.getModel())){

            public void actionPerformed() {
                JXTable table = PeptideMatchPanel.this.getGlobalAssociatedTable();
                TableInfo tableInfo = new TableInfo(PeptideMatchPanel.this.m_dataBox.getId(), PeptideMatchPanel.this.m_dataBox.getUserName(), PeptideMatchPanel.this.m_dataBox.getDataName(), PeptideMatchPanel.this.m_dataBox.getTypeName(), table);
                Image i = PeptideMatchPanel.this.m_dataBox.getIcon();
                if (i != null) {
                    tableInfo.setIcon(new ImageIcon(i));
                }
                DataAnalyzerWindowBoxManager.addTableInfo(tableInfo);
            }
        };
        if (this.m_startingPanel) {
            this.m_graphicsButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.CHART));
            this.m_graphicsButton.setToolTipText("Graphics : Histogram / Scatter Plot");
            this.m_graphicsButton.setFocusPainted(false);
            this.m_graphicsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!((CompoundTableModel)PeptideMatchPanel.this.m_peptideMatchTable.getModel()).isLoaded()) {
                        ProgressBarDialog dialog = ProgressBarDialog.getDialog((Window)WindowManager.getDefault().getMainWindow(), (ProgressInterface)((CompoundTableModel)PeptideMatchPanel.this.m_peptideMatchTable.getModel()), (String)"Data loading", (String)"Histogram functionnality is not available while data is loading. Please Wait.");
                        dialog.setLocation(PeptideMatchPanel.this.getLocationOnScreen().x + PeptideMatchPanel.this.m_graphicsButton.getWidth() + 5, PeptideMatchPanel.this.m_graphicsButton.getLocationOnScreen().y + PeptideMatchPanel.this.getHeight() + 5);
                        dialog.setVisible(true);
                        if (!dialog.isWaitingFinished()) {
                            return;
                        }
                    }
                    WindowBox wbox = WindowBoxFactory.getGraphicsWindowBox("Graphic", PeptideMatchPanel.this.m_dataBox, true);
                    DataBoxViewerTopPanel win = new DataBoxViewerTopPanel(wbox);
                    WindowManager.getDefault().getMainWindow().displayWindow((AbstractTopPanel)win);
                }
            });
        }
        this.m_infoToggleButton = new InfoToggleButton((ProgressInterface)this.m_peptideMatchTable, (InfoInterface)this.m_peptideMatchTable);
        if (this.m_startingPanel) {
            toolbar.add(this.m_decoyButton);
        }
        toolbar.add((Component)this.m_searchToggleButton);
        toolbar.add((Component)this.m_filterButton);
        toolbar.add((Component)this.m_settingsButton);
        toolbar.add((Component)this.m_exportButton);
        toolbar.add((Component)this.m_addCompareDataButton);
        if (this.m_startingPanel) {
            toolbar.add(this.m_graphicsButton);
        }
        toolbar.add((Component)this.m_infoToggleButton);
        return toolbar;
    }

    private JPanel createPeptideMatchPanel() {
        JPanel peptideMatchPanel = new JPanel();
        peptideMatchPanel.setBounds(0, 0, 500, 400);
        peptideMatchPanel.setLayout(new BorderLayout());
        JPanel internalPanel = this.createInternalPanel();
        peptideMatchPanel.add((Component)internalPanel, "Center");
        JToolBar toolbar = this.initToolbar();
        peptideMatchPanel.add((Component)toolbar, "West");
        return peptideMatchPanel;
    }

    private JPanel createInternalPanel() {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        this.m_scrollPane = new JScrollPane();
        this.m_peptideMatchTable = new PeptideMatchTable();
        PeptideMatchTableModel peptideMatchTableModel = new PeptideMatchTableModel(this.m_peptideMatchTable, this.m_forRSM, !this.m_startingPanel && !this.m_proteinMatchUnknown, this.m_isDecoyAndValidated, this.m_mergedData);
        CompoundTableModel compoundTableModel = new CompoundTableModel((GlobalTableModelInterface)peptideMatchTableModel, true);
        this.m_peptideMatchTable.setModel((TableModel)compoundTableModel);
        this.m_peptideMatchTable.getColumnExt(this.m_peptideMatchTable.convertColumnIndexToView(0)).setVisible(false);
        this.m_markerContainerPanel = new MarkerContainerPanel(this.m_scrollPane, (MarkerComponentInterface)this.m_peptideMatchTable);
        this.m_scrollPane.setViewportView((Component)((Object)this.m_peptideMatchTable));
        this.m_peptideMatchTable.setFillsViewportHeight(true);
        this.m_peptideMatchTable.setViewport(this.m_scrollPane.getViewport());
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 3;
        internalPanel.add((Component)this.m_markerContainerPanel, c);
        return internalPanel;
    }

    public ActionListener getRemoveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getRemoveAction(splittedPanel);
    }

    public ActionListener getAddAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getAddAction(splittedPanel);
    }

    public ActionListener getSaveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getSaveAction(splittedPanel);
    }

    public CrossSelectionInterface getCrossSelectionInterface() {
        return this.m_peptideMatchTable;
    }

    private class PeptideMatchTable
    extends LazyTable
    implements InfoInterface {
        String searchTextBeingDone;
        private boolean selectionWillBeRestored;
        private DisplayTablePopupMenu m_popupMenu;

        public PeptideMatchTable() {
            super(PeptideMatchPanel.this.m_scrollPane.getVerticalScrollBar());
            this.searchTextBeingDone = null;
            this.selectionWillBeRestored = false;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            super.valueChanged(e);
            if (this.selectionWillBeRestored) {
                return;
            }
            if (e.getValueIsAdjusting()) {
                return;
            }
            PeptideMatchPanel.this.m_dataBox.addDataChanged(DPeptideMatch.class);
            PeptideMatchPanel.this.m_dataBox.propagateDataChanged();
        }

        public boolean selectPeptideMatch(Long proteinSetId, String searchText) {
            PeptideMatchTableModel tableModel = (PeptideMatchTableModel)((CompoundTableModel)this.getModel()).getBaseModel();
            int row = tableModel.findRow(proteinSetId);
            if (row == -1) {
                return false;
            }
            row = ((CompoundTableModel)this.getModel()).convertBaseModelRowToCompoundRow(row);
            if (row == -1) {
                return false;
            }
            this.searchTextBeingDone = searchText;
            row = this.convertRowIndexToView(row);
            this.getSelectionModel().setSelectionInterval(row, row);
            this.scrollRowToVisible(row);
            this.searchTextBeingDone = null;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dataUpdated(SubTask subTask, boolean finished) {
            LazyTable.LastAction keepLastAction = this.m_lastAction;
            try {
                int rowSelected = this.getSelectionModel().getMinSelectionIndex();
                int rowSelectedInModel = rowSelected == -1 ? -1 : this.convertRowIndexToModel(rowSelected);
                this.selectionWillBeRestored(true);
                try {
                    ((PeptideMatchTableModel)((CompoundTableModel)this.getModel()).getBaseModel()).dataUpdated();
                }
                finally {
                    this.selectionWillBeRestored(false);
                }
                if (rowSelectedInModel != -1) {
                    int rowSelectedInView = this.convertRowIndexToView(rowSelectedInModel);
                    this.setSelection(rowSelectedInView);
                    if ((keepLastAction == LazyTable.LastAction.ACTION_SELECTING || keepLastAction == LazyTable.LastAction.ACTION_SORTING) && subTask.getSubTaskId() == ((CompoundTableModel)this.getModel()).getSubTaskId(this.getSortedColumnIndex())) {
                        PeptideMatchPanel.this.m_peptideMatchTable.scrollRowToVisible(rowSelectedInView);
                    }
                }
            }
            finally {
                this.m_lastAction = keepLastAction;
            }
            if (finished) {
                this.setSortable(true);
            }
        }

        @Override
        public void sortingChanged(int col) {
        }

        public void selectionWillBeRestored(boolean b) {
            this.selectionWillBeRestored = b;
        }

        public int getLoadingPercentage() {
            return PeptideMatchPanel.this.m_dataBox.getLoadingPercentage();
        }

        public boolean isLoaded() {
            return PeptideMatchPanel.this.m_dataBox.isLoaded();
        }

        public TablePopupMenu initPopupMenu() {
            this.m_popupMenu = new DisplayTablePopupMenu(PeptideMatchPanel.this);
            return this.m_popupMenu;
        }

        public void prepostPopupMenu() {
            this.m_popupMenu.prepostPopupMenu();
        }

        public void addTableModelListener(TableModelListener l) {
            this.getModel().addTableModelListener(l);
        }

        public String getInfo() {
            int count;
            return count + ((count = this.getModel().getRowCount()) > 1 ? " Peptides" : " Peptide");
        }
    }
}

