/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui;

import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.core.orm.msi.dto.DProteinSet;
import fr.proline.studio.export.ExportButton;
import fr.proline.studio.extendedtablemodel.AddDataAnalyzerButton;
import fr.proline.studio.extendedtablemodel.CompoundTableModel;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.GlobalTabelModelProviderInterface;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.FilterButton;
import fr.proline.studio.filter.FilterTableModelInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.gui.HourglassPanel;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.info.InfoInterface;
import fr.proline.studio.info.InfoToggleButton;
import fr.proline.studio.markerbar.MarkerComponentInterface;
import fr.proline.studio.markerbar.MarkerContainerPanel;
import fr.proline.studio.parameter.SettingsButton;
import fr.proline.studio.parameter.SettingsInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataAnalyzerWindowBoxManager;
import fr.proline.studio.pattern.DataBoxPanelInterface;
import fr.proline.studio.progress.ProgressInterface;
import fr.proline.studio.rsmexplorer.actions.table.DisplayTablePopupMenu;
import fr.proline.studio.rsmexplorer.gui.model.ProteinTableModel;
import fr.proline.studio.table.DecoratedMarkerTable;
import fr.proline.studio.table.TableInfo;
import fr.proline.studio.table.TablePopupMenu;
import fr.proline.studio.utils.URLCellRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;

public class RsmProteinsOfProteinSetPanel
extends HourglassPanel
implements DataBoxPanelInterface,
GlobalTabelModelProviderInterface {
    private AbstractDataBox m_dataBox;
    private DProteinSet m_proteinSetCur = null;
    private JTextField m_proteinNameTextField;
    private ProteinTable m_proteinTable;
    private JScrollPane m_scrollPane;
    private SettingsButton m_settingsButton;
    private FilterButton m_filterButton;
    private ExportButton m_exportButton;
    private AddDataAnalyzerButton m_addCompareDataButton;
    private InfoToggleButton m_infoToggleButton;
    private MarkerContainerPanel m_markerContainerPanel;

    public RsmProteinsOfProteinSetPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        final JPanel proteinPanel = this.createProteinPanel();
        final JLayeredPane layeredPane = new JLayeredPane();
        layeredPane.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                Component c = e.getComponent();
                proteinPanel.setBounds(0, 0, c.getWidth(), c.getHeight());
                layeredPane.revalidate();
                layeredPane.repaint();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.add(layeredPane, "Center");
        layeredPane.add((Component)proteinPanel, JLayeredPane.DEFAULT_LAYER);
        layeredPane.add((Component)this.m_infoToggleButton.getInfoPanel(), JLayeredPane.PALETTE_LAYER);
    }

    private JPanel createProteinPanel() {
        JPanel proteinPanel = new JPanel();
        proteinPanel.setBounds(0, 0, 500, 400);
        proteinPanel.setLayout(new BorderLayout());
        JPanel internalPanel = this.createInternalPanel();
        proteinPanel.add((Component)internalPanel, "Center");
        JToolBar toolbar = this.initToolbar();
        proteinPanel.add((Component)toolbar, "West");
        return proteinPanel;
    }

    private JPanel createInternalPanel() {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        this.m_proteinNameTextField = new JTextField();
        this.m_proteinNameTextField.setEditable(false);
        this.m_proteinNameTextField.setBackground(Color.white);
        this.m_scrollPane = new JScrollPane();
        this.m_proteinTable = new ProteinTable();
        CompoundTableModel model = new CompoundTableModel((GlobalTableModelInterface)new ProteinTableModel(this.m_proteinTable), true);
        this.m_proteinTable.setModel((TableModel)model);
        this.m_markerContainerPanel = new MarkerContainerPanel(this.m_scrollPane, (MarkerComponentInterface)this.m_proteinTable);
        this.m_scrollPane.setViewportView((Component)((Object)this.m_proteinTable));
        this.m_proteinTable.setFillsViewportHeight(true);
        this.m_proteinTable.setViewport(this.m_scrollPane.getViewport());
        URLCellRenderer urlRenderer = (URLCellRenderer)model.getRenderer(0, ProteinTableModel.Column.PROTEIN_NAME.ordinal());
        this.m_proteinTable.addMouseListener((MouseListener)urlRenderer);
        this.m_proteinTable.addMouseMotionListener((MouseMotionListener)urlRenderer);
        this.m_proteinTable.getColumnExt(this.m_proteinTable.convertColumnIndexToView(ProteinTableModel.Column.PROTEIN_ID.ordinal())).setVisible(false);
        c.gridx = 0;
        c.gridy = 0;
        internalPanel.add((Component)new JLabel("Typical Protein:"), c);
        ++c.gridx;
        c.weightx = 1.0;
        internalPanel.add((Component)this.m_proteinNameTextField, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        c.weighty = 1.0;
        internalPanel.add((Component)this.m_markerContainerPanel, c);
        return internalPanel;
    }

    private JToolBar initToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        this.m_settingsButton = new SettingsButton((ProgressInterface)this.m_proteinTable.getModel(), (SettingsInterface)this.m_proteinTable);
        this.m_filterButton = new FilterButton((FilterTableModelInterface)((CompoundTableModel)this.m_proteinTable.getModel())){

            protected void filteringDone() {
                RsmProteinsOfProteinSetPanel.this.m_dataBox.addDataChanged(ExtendedTableModelInterface.class);
                RsmProteinsOfProteinSetPanel.this.m_dataBox.propagateDataChanged();
                RsmProteinsOfProteinSetPanel.this.m_infoToggleButton.updateInfo();
            }
        };
        this.m_exportButton = new ExportButton((ProgressInterface)((CompoundTableModel)this.m_proteinTable.getModel()), "Proteins", (JXTable)this.m_proteinTable);
        this.m_addCompareDataButton = new AddDataAnalyzerButton((ProgressInterface)((CompoundTableModel)this.m_proteinTable.getModel())){

            public void actionPerformed() {
                JXTable table = RsmProteinsOfProteinSetPanel.this.getGlobalAssociatedTable();
                TableInfo tableInfo = new TableInfo(RsmProteinsOfProteinSetPanel.this.m_dataBox.getId(), RsmProteinsOfProteinSetPanel.this.m_dataBox.getUserName(), RsmProteinsOfProteinSetPanel.this.m_dataBox.getDataName(), RsmProteinsOfProteinSetPanel.this.m_dataBox.getTypeName(), table);
                Image i = RsmProteinsOfProteinSetPanel.this.m_dataBox.getIcon();
                if (i != null) {
                    tableInfo.setIcon(new ImageIcon(i));
                }
                DataAnalyzerWindowBoxManager.addTableInfo(tableInfo);
            }
        };
        this.m_infoToggleButton = new InfoToggleButton((ProgressInterface)this.m_proteinTable, (InfoInterface)this.m_proteinTable);
        toolbar.add((Component)this.m_filterButton);
        toolbar.add((Component)this.m_settingsButton);
        toolbar.add((Component)this.m_exportButton);
        toolbar.add((Component)this.m_addCompareDataButton);
        toolbar.add((Component)this.m_infoToggleButton);
        return toolbar;
    }

    public DProteinMatch getSelectedProteinMatch() {
        ProteinTable table = this.m_proteinTable;
        int selectedRow = table.getSelectedRow();
        if (selectedRow == -1) {
            return null;
        }
        CompoundTableModel compoundTableModel = (CompoundTableModel)table.getModel();
        if (compoundTableModel.getRowCount() == 0) {
            return null;
        }
        selectedRow = table.convertRowIndexToModel(selectedRow);
        selectedRow = compoundTableModel.convertCompoundRowToBaseModelRow(selectedRow);
        ProteinTableModel tableModel = (ProteinTableModel)compoundTableModel.getBaseModel();
        return tableModel.getProteinMatch(selectedRow);
    }

    public void setData(DProteinSet proteinSet, String searchedText) {
        if (proteinSet == this.m_proteinSetCur) {
            return;
        }
        this.m_proteinSetCur = proteinSet;
        if (proteinSet == null) {
            this.clearData();
            return;
        }
        DProteinMatch[] sameSetArray = proteinSet.getSameSet();
        DProteinMatch[] subSetArray = proteinSet.getSubSet();
        DProteinMatch typicalProtein = proteinSet.getTypicalProteinMatch();
        if (typicalProtein == null) {
            this.clearData();
            return;
        }
        this.m_proteinNameTextField.setText(typicalProtein.getDescription());
        ((ProteinTableModel)((CompoundTableModel)this.m_proteinTable.getModel()).getBaseModel()).setData(proteinSet.getResultSummaryId(), proteinSet.getTypicalProteinMatch().getId(), sameSetArray, subSetArray);
        int row = ((ProteinTableModel)((CompoundTableModel)this.m_proteinTable.getModel()).getBaseModel()).findRowToSelect(searchedText);
        if (row != -1) {
            row = ((CompoundTableModel)this.m_proteinTable.getModel()).convertBaseModelRowToCompoundRow(row);
        }
        this.m_proteinTable.getSelectionModel().setSelectionInterval(row, row);
        this.m_markerContainerPanel.setMaxLineNumber(proteinSet.getSameSetCount() + proteinSet.getSubSetCount());
        this.m_markerContainerPanel.removeAllMarkers();
        this.m_infoToggleButton.updateInfo();
        this.m_proteinTable.setSortable(true);
    }

    private void clearData() {
        this.m_proteinNameTextField.setText("");
        ((ProteinTableModel)((CompoundTableModel)this.m_proteinTable.getModel()).getBaseModel()).setData(-1L, -1L, null, null);
    }

    @Override
    public void setDataBox(AbstractDataBox dataBox) {
        this.m_dataBox = dataBox;
    }

    @Override
    public AbstractDataBox getDataBox() {
        return this.m_dataBox;
    }

    @Override
    public void addSingleValue(Object v) {
        this.getGlobalTableModelInterface().addSingleValue(v);
    }

    public GlobalTableModelInterface getGlobalTableModelInterface() {
        return (GlobalTableModelInterface)this.m_proteinTable.getModel();
    }

    public JXTable getGlobalAssociatedTable() {
        return this.m_proteinTable;
    }

    public ActionListener getRemoveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getRemoveAction(splittedPanel);
    }

    public ActionListener getAddAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getAddAction(splittedPanel);
    }

    public ActionListener getSaveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getSaveAction(splittedPanel);
    }

    public CrossSelectionInterface getCrossSelectionInterface() {
        return this.m_proteinTable;
    }

    private class ProteinTable
    extends DecoratedMarkerTable
    implements ProgressInterface,
    InfoInterface {
        private DisplayTablePopupMenu m_popupMenu;

        public void addTableModelListener(TableModelListener l) {
            this.getModel().addTableModelListener(l);
        }

        public void valueChanged(ListSelectionEvent e) {
            super.valueChanged(e);
            if (e.getValueIsAdjusting()) {
                return;
            }
            RsmProteinsOfProteinSetPanel.this.m_dataBox.addDataChanged(DProteinMatch.class);
            RsmProteinsOfProteinSetPanel.this.m_dataBox.propagateDataChanged();
        }

        public boolean isLoaded() {
            return RsmProteinsOfProteinSetPanel.this.m_dataBox.isLoaded();
        }

        public int getLoadingPercentage() {
            return RsmProteinsOfProteinSetPanel.this.m_dataBox.getLoadingPercentage();
        }

        public TablePopupMenu initPopupMenu() {
            this.m_popupMenu = new DisplayTablePopupMenu(RsmProteinsOfProteinSetPanel.this);
            return this.m_popupMenu;
        }

        public void prepostPopupMenu() {
            this.m_popupMenu.prepostPopupMenu();
        }

        public String getInfo() {
            int count;
            return count + ((count = this.getModel().getRowCount()) > 1 ? " Proteins" : " Protein");
        }
    }
}

