/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.admin;

import fr.proline.core.orm.uds.FragmentationRule;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.gui.JCheckBoxList;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FragmentationRuleSetDialog
extends DefaultDialog {
    protected static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");
    private static FragmentationRuleSetDialog m_singletonDialog = null;
    private JTextField m_nameTextField;
    private JCheckBoxList<FragmentationRule> m_fragmentationRulesCBList;

    public static final FragmentationRuleSetDialog getDialog(Window parent) {
        if (m_singletonDialog == null) {
            m_singletonDialog = new FragmentationRuleSetDialog(parent);
        }
        return m_singletonDialog;
    }

    private FragmentationRuleSetDialog(Window parent) {
        super(parent, Dialog.ModalityType.DOCUMENT_MODAL);
        this.initInternalPanel();
    }

    private void initInternalPanel() {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new GridBagLayout());
        JLabel nameLabel = new JLabel("Name :");
        this.m_nameTextField = new JTextField(30);
        this.m_nameTextField.setText("");
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        internalPanel.add((Component)nameLabel, c);
        ++c.gridx;
        internalPanel.add((Component)this.m_nameTextField, c);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 0;
        JLabel rulesLabel = new JLabel("Fragmentation Rules:");
        internalPanel.add((Component)rulesLabel, c);
        List<FragmentationRule> rules = Arrays.asList(DatabaseDataManager.getDatabaseDataManager().getFragmentationRulesArray());
        ArrayList<Boolean> selected = new ArrayList<Boolean>(Collections.nCopies(rules.size(), Boolean.FALSE));
        this.m_fragmentationRulesCBList = new JCheckBoxList(rules, selected);
        JScrollPane rulesPane = new JScrollPane();
        rulesPane.setViewportView((Component)this.m_fragmentationRulesCBList);
        ++c.gridx;
        internalPanel.add((Component)rulesPane, c);
        this.setInternalComponent(internalPanel);
    }

    protected boolean okCalled() {
        if (StringUtils.isEmpty((CharSequence)this.getName())) {
            this.setStatus(true, "A name should be specified");
            this.highlight(this.m_nameTextField);
            return false;
        }
        if (this.getSelectedFragmentationRule().isEmpty()) {
            this.setStatus(true, "At least one rule should be specified");
            this.highlight((Component)this.m_fragmentationRulesCBList);
            return false;
        }
        return true;
    }

    public List<FragmentationRule> getSelectedFragmentationRule() {
        return this.m_fragmentationRulesCBList.getSelectedItems();
    }

    public String getName() {
        return this.m_nameTextField.getText();
    }
}

