/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.admin;

import fr.proline.core.orm.uds.SpectrumTitleParsingRule;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.gui.InfoDialog;
import fr.proline.studio.rsmexplorer.gui.admin.PeaklistSoftwarePanel;
import fr.proline.studio.utils.IconManager;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PeakListSoftwareDialog
extends DefaultDialog {
    private static PeakListSoftwareDialog m_singletonDialog = null;
    private static final String COMBOBOX_SELECTION_STRING = "< Select Predefined >";
    private JTextField m_nameTextField;
    private JTextField m_versionTextField;
    private JTextField m_rawFileIdentifierTextField;
    private JTextField m_firstCycleTextField;
    private JTextField m_lastCycleTextField;
    private JTextField m_firstScanTextField;
    private JTextField m_lastScanTextField;
    private JTextField m_firstTimeTextField;
    private JTextField m_lastTimeTextField;
    private JComboBox m_rawFileIdentifierComboBox;
    private JComboBox m_firstCycleComboBox;
    private JComboBox m_lastCycleComboBox;
    private JComboBox m_firstScanComboBox;
    private JComboBox m_lastScanComboBox;
    private JComboBox m_firstTimeComboBox;
    private JComboBox m_lastTimeComboBox;
    private HashSet<String> rawFileIdentifierSet = new HashSet();
    private HashSet<String> firstCycleSet = new HashSet();
    private HashSet<String> lastCycleSet = new HashSet();
    private HashSet<String> firstScanSet = new HashSet();
    private HashSet<String> lastScanSet = new HashSet();
    private HashSet<String> firstTimeSet = new HashSet();
    private HashSet<String> lastTimeSet = new HashSet();
    private boolean m_comboboxAreBeingUpdated = false;

    public static PeakListSoftwareDialog getDialog(Window parent, DialogMode mode) {
        if (m_singletonDialog == null) {
            m_singletonDialog = new PeakListSoftwareDialog(parent);
        }
        m_singletonDialog.initMode(mode);
        return m_singletonDialog;
    }

    public PeakListSoftwareDialog(Window parent) {
        super(parent, Dialog.ModalityType.DOCUMENT_MODAL);
        this.initInternalPanel();
    }

    private void initMode(DialogMode mode) {
        boolean enableParsingFields = true;
        boolean enableModifications = true;
        switch (mode) {
            case CREATE_USER: {
                this.setTitle("Add Peaklist Software");
                break;
            }
            case MODIFY_USER: {
                this.setTitle("Modify Peaklist Software");
                enableParsingFields = false;
                break;
            }
            case VIEW_USER: {
                this.setTitle("View Peaklist Software");
                enableParsingFields = false;
                enableModifications = false;
            }
        }
        this.m_nameTextField.setText("");
        this.m_versionTextField.setText("");
        this.m_rawFileIdentifierTextField.setText("");
        this.m_firstCycleTextField.setText("");
        this.m_lastCycleTextField.setText("");
        this.m_firstScanTextField.setText("");
        this.m_lastScanTextField.setText("");
        this.m_firstTimeTextField.setText("");
        this.m_lastTimeTextField.setText("");
        this.m_nameTextField.setEnabled(enableModifications);
        this.m_versionTextField.setEnabled(enableModifications);
        this.m_rawFileIdentifierTextField.setEnabled(enableParsingFields);
        this.m_rawFileIdentifierComboBox.setEnabled(enableParsingFields);
        this.m_firstCycleTextField.setEnabled(enableParsingFields);
        this.m_firstCycleComboBox.setEnabled(enableParsingFields);
        this.m_lastCycleTextField.setEnabled(enableParsingFields);
        this.m_lastCycleComboBox.setEnabled(enableParsingFields);
        this.m_firstScanTextField.setEnabled(enableParsingFields);
        this.m_firstScanComboBox.setEnabled(enableParsingFields);
        this.m_lastScanTextField.setEnabled(enableParsingFields);
        this.m_lastScanComboBox.setEnabled(enableParsingFields);
        this.m_firstTimeTextField.setEnabled(enableParsingFields);
        this.m_firstTimeComboBox.setEnabled(enableParsingFields);
        this.m_lastTimeTextField.setEnabled(enableParsingFields);
        this.m_lastTimeComboBox.setEnabled(enableParsingFields);
        DatabaseDataManager.getDatabaseDataManager().getParsingRules(this.rawFileIdentifierSet, this.firstCycleSet, this.lastCycleSet, this.firstScanSet, this.lastScanSet, this.firstTimeSet, this.lastTimeSet);
        this.fillComboboxWithHashSet(this.m_rawFileIdentifierComboBox, this.rawFileIdentifierSet);
        this.fillComboboxWithHashSet(this.m_firstCycleComboBox, this.firstCycleSet);
        this.fillComboboxWithHashSet(this.m_lastCycleComboBox, this.lastCycleSet);
        this.fillComboboxWithHashSet(this.m_firstScanComboBox, this.firstScanSet);
        this.fillComboboxWithHashSet(this.m_lastScanComboBox, this.lastScanSet);
        this.fillComboboxWithHashSet(this.m_firstTimeComboBox, this.firstTimeSet);
        this.fillComboboxWithHashSet(this.m_lastTimeComboBox, this.lastTimeSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillComboboxWithHashSet(JComboBox combobox, HashSet<String> hashSet) {
        this.m_comboboxAreBeingUpdated = true;
        try {
            combobox.removeAllItems();
            combobox.addItem(COMBOBOX_SELECTION_STRING);
            for (String rule : hashSet) {
                combobox.addItem(rule);
            }
        }
        finally {
            this.m_comboboxAreBeingUpdated = false;
        }
    }

    private void addActionListenerToCombobox(final JComboBox combobox, final JTextField textField) {
        combobox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PeakListSoftwareDialog.this.m_comboboxAreBeingUpdated) {
                    return;
                }
                String parsingRule = combobox.getSelectedItem().toString();
                if (parsingRule.compareTo(PeakListSoftwareDialog.COMBOBOX_SELECTION_STRING) == 0) {
                    return;
                }
                textField.setText(parsingRule);
                combobox.setSelectedIndex(0);
            }
        });
    }

    private void initInternalPanel() {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new GridBagLayout());
        JPanel peaklistPanel = this.createPeaklistPanel();
        JPanel testPanel = this.createTestPanel();
        JPanel parsingRulesPanel = this.createParsingRulesPanel();
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        internalPanel.add((Component)peaklistPanel, c);
        ++c.gridy;
        internalPanel.add((Component)parsingRulesPanel, c);
        ++c.gridy;
        internalPanel.add((Component)testPanel, c);
        this.setInternalComponent(internalPanel);
    }

    private JPanel createPeaklistPanel() {
        JPanel peaklistPanel = new JPanel(new GridBagLayout());
        peaklistPanel.setLayout(new GridBagLayout());
        peaklistPanel.setBorder(BorderFactory.createTitledBorder("Peaklist Software"));
        JLabel nameLabel = new JLabel("Name :");
        JLabel versionLabel = new JLabel("Version :");
        this.m_nameTextField = new JTextField(30);
        this.m_versionTextField = new JTextField(30);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        peaklistPanel.add((Component)nameLabel, c);
        ++c.gridx;
        peaklistPanel.add((Component)this.m_nameTextField, c);
        c.gridx = 0;
        ++c.gridy;
        peaklistPanel.add((Component)versionLabel, c);
        ++c.gridx;
        peaklistPanel.add((Component)this.m_versionTextField, c);
        return peaklistPanel;
    }

    private JPanel createParsingRulesPanel() {
        JPanel parsingRulesPanel = new JPanel(new GridBagLayout());
        parsingRulesPanel.setLayout(new GridBagLayout());
        parsingRulesPanel.setBorder(BorderFactory.createTitledBorder("Spectrum Title Parsing Rules"));
        JLabel rawFileIdentifierLabel = new JLabel("Raw File Identifier :");
        JLabel firstCycleLabel = new JLabel("First Cycle :");
        JLabel lastCycleLabel = new JLabel("Last Cycle");
        JLabel firstScanLabel = new JLabel("First Scan :");
        JLabel lastScanLabel = new JLabel("Last Scan :");
        JLabel firstTimeLabel = new JLabel("First Time :");
        JLabel lastTimeLabel = new JLabel("Last Time :");
        this.m_rawFileIdentifierTextField = new JTextField(30);
        this.m_rawFileIdentifierComboBox = new JComboBox();
        this.m_firstCycleTextField = new JTextField(30);
        this.m_firstCycleComboBox = new JComboBox();
        this.m_lastCycleTextField = new JTextField(30);
        this.m_lastCycleComboBox = new JComboBox();
        this.m_firstScanTextField = new JTextField(30);
        this.m_firstScanComboBox = new JComboBox();
        this.m_lastScanTextField = new JTextField(30);
        this.m_lastScanComboBox = new JComboBox();
        this.m_firstTimeTextField = new JTextField(30);
        this.m_firstTimeComboBox = new JComboBox();
        this.m_lastTimeTextField = new JTextField(30);
        this.m_lastTimeComboBox = new JComboBox();
        this.addActionListenerToCombobox(this.m_rawFileIdentifierComboBox, this.m_rawFileIdentifierTextField);
        this.addActionListenerToCombobox(this.m_firstCycleComboBox, this.m_firstCycleTextField);
        this.addActionListenerToCombobox(this.m_lastCycleComboBox, this.m_lastCycleTextField);
        this.addActionListenerToCombobox(this.m_firstScanComboBox, this.m_firstScanTextField);
        this.addActionListenerToCombobox(this.m_lastScanComboBox, this.m_lastScanTextField);
        this.addActionListenerToCombobox(this.m_firstTimeComboBox, this.m_firstTimeTextField);
        this.addActionListenerToCombobox(this.m_lastTimeComboBox, this.m_lastTimeTextField);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        ++c.gridy;
        parsingRulesPanel.add((Component)rawFileIdentifierLabel, c);
        ++c.gridx;
        parsingRulesPanel.add((Component)this.m_rawFileIdentifierTextField, c);
        ++c.gridx;
        parsingRulesPanel.add((Component)this.m_rawFileIdentifierComboBox, c);
        c.gridx = 0;
        ++c.gridy;
        parsingRulesPanel.add((Component)firstCycleLabel, c);
        ++c.gridx;
        parsingRulesPanel.add((Component)this.m_firstCycleTextField, c);
        ++c.gridx;
        parsingRulesPanel.add((Component)this.m_firstCycleComboBox, c);
        c.gridx = 0;
        ++c.gridy;
        parsingRulesPanel.add((Component)lastCycleLabel, c);
        ++c.gridx;
        parsingRulesPanel.add((Component)this.m_lastCycleTextField, c);
        ++c.gridx;
        parsingRulesPanel.add((Component)this.m_lastCycleComboBox, c);
        c.gridx = 0;
        ++c.gridy;
        parsingRulesPanel.add((Component)firstScanLabel, c);
        ++c.gridx;
        parsingRulesPanel.add((Component)this.m_firstScanTextField, c);
        ++c.gridx;
        parsingRulesPanel.add((Component)this.m_firstScanComboBox, c);
        c.gridx = 0;
        ++c.gridy;
        parsingRulesPanel.add((Component)lastScanLabel, c);
        ++c.gridx;
        parsingRulesPanel.add((Component)this.m_lastScanTextField, c);
        ++c.gridx;
        parsingRulesPanel.add((Component)this.m_lastScanComboBox, c);
        c.gridx = 0;
        ++c.gridy;
        parsingRulesPanel.add((Component)firstTimeLabel, c);
        ++c.gridx;
        parsingRulesPanel.add((Component)this.m_firstTimeTextField, c);
        ++c.gridx;
        parsingRulesPanel.add((Component)this.m_firstTimeComboBox, c);
        c.gridx = 0;
        ++c.gridy;
        parsingRulesPanel.add((Component)lastTimeLabel, c);
        ++c.gridx;
        parsingRulesPanel.add((Component)this.m_lastTimeTextField, c);
        ++c.gridx;
        parsingRulesPanel.add((Component)this.m_lastTimeComboBox, c);
        return parsingRulesPanel;
    }

    private JPanel createTestPanel() {
        JPanel testPanel = new JPanel(new GridBagLayout());
        testPanel.setLayout(new GridBagLayout());
        testPanel.setBorder(BorderFactory.createTitledBorder("Spectrum Title Parsing Test"));
        JLabel spectrumTitleLabel = new JLabel("Spectrum Title:");
        JTextField spectrumTitleTextField = new JTextField(30);
        JButton testButton = new JButton("Test", IconManager.getIcon((IconManager.IconType)IconManager.IconType.TEST));
        PeakListSoftwareDialog dialog = this;
        testButton.addActionListener(new TestButtonAction(spectrumTitleTextField, dialog));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        testPanel.add((Component)spectrumTitleLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        testPanel.add((Component)spectrumTitleTextField, c);
        ++c.gridx;
        c.weightx = 0.0;
        testPanel.add((Component)testButton, c);
        return testPanel;
    }

    public void setPeaklistSoftwareInfo(String name, String version, SpectrumTitleParsingRule parsingRule) {
        this.m_nameTextField.setText(name);
        this.m_versionTextField.setText(version);
        String rule = parsingRule.getRawFileIdentifier();
        this.m_rawFileIdentifierTextField.setText(rule);
        rule = parsingRule.getFirstCycle();
        this.m_firstCycleTextField.setText(rule);
        rule = parsingRule.getLastCycle();
        this.m_lastCycleTextField.setText(rule);
        rule = parsingRule.getFirstScan();
        this.m_firstScanTextField.setText(rule);
        rule = parsingRule.getLastScan();
        this.m_lastScanTextField.setText(rule);
        rule = parsingRule.getFirstTime();
        this.m_firstTimeTextField.setText(rule);
        rule = parsingRule.getLastTime();
        this.m_lastTimeTextField.setText(rule);
    }

    public String getPeaklistSoftwareName() {
        return this.m_nameTextField.getText().trim();
    }

    public String getVersion() {
        return this.m_versionTextField.getText().trim();
    }

    public String getRawFileIdentifier() {
        return this.m_rawFileIdentifierTextField.getText().trim();
    }

    public String getFirstCycle() {
        return this.m_firstCycleTextField.getText().trim();
    }

    public String getLastCycle() {
        return this.m_lastCycleTextField.getText().trim();
    }

    public String getFirstScan() {
        return this.m_firstScanTextField.getText().trim();
    }

    public String getLastScan() {
        return this.m_lastScanTextField.getText().trim();
    }

    public String getFirstTime() {
        return this.m_firstTimeTextField.getText().trim();
    }

    public String getLastTime() {
        return this.m_lastTimeTextField.getText().trim();
    }

    public SpectrumTitleParsingRule getSpectrumTitleParsingRule() {
        SpectrumTitleParsingRule parsingRule = new SpectrumTitleParsingRule();
        parsingRule.setRawFileIdentifier(this.getRawFileIdentifier());
        parsingRule.setFirstCycle(this.getFirstCycle());
        parsingRule.setLastCycle(this.getLastCycle());
        parsingRule.setFirstScan(this.getFirstScan());
        parsingRule.setLastScan(this.getLastScan());
        parsingRule.setFirstTime(this.getFirstTime());
        parsingRule.setLastTime(this.getLastTime());
        return parsingRule;
    }

    private boolean checkParameters() {
        String name = this.getPeaklistSoftwareName();
        if (name.isEmpty() || name.length() < 3) {
            this.setStatus(true, "Name must contain at least 3 characters.");
            this.highlight(this.m_nameTextField);
            return false;
        }
        return true;
    }

    protected boolean okCalled() {
        return this.checkParameters();
    }

    public static enum DialogMode {
        CREATE_USER,
        MODIFY_USER,
        VIEW_USER;

    }

    class TestButtonAction
    implements ActionListener {
        JTextField _spectrumTitleTextField;
        PeakListSoftwareDialog _dialog;

        public TestButtonAction(JTextField spectrumTitleTextField, PeakListSoftwareDialog dialog) {
            this._spectrumTitleTextField = spectrumTitleTextField;
            this._dialog = dialog;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StringBuilder sb = new StringBuilder();
            String spectrumTitle = this._spectrumTitleTextField.getText().trim();
            PeaklistSoftwarePanel.parse(sb, PeakListSoftwareDialog.this.m_rawFileIdentifierTextField.getText().trim(), "Raw File Identifier :", spectrumTitle);
            PeaklistSoftwarePanel.parse(sb, PeakListSoftwareDialog.this.m_firstCycleTextField.getText().trim(), "First Cycle :", spectrumTitle);
            PeaklistSoftwarePanel.parse(sb, PeakListSoftwareDialog.this.m_lastCycleTextField.getText().trim(), "Last Cycle :", spectrumTitle);
            PeaklistSoftwarePanel.parse(sb, PeakListSoftwareDialog.this.m_firstScanTextField.getText().trim(), "First Scan :", spectrumTitle);
            PeaklistSoftwarePanel.parse(sb, PeakListSoftwareDialog.this.m_lastScanTextField.getText().trim(), "Last Scan :", spectrumTitle);
            PeaklistSoftwarePanel.parse(sb, PeakListSoftwareDialog.this.m_firstTimeTextField.getText().trim(), "First Time :", spectrumTitle);
            PeaklistSoftwarePanel.parse(sb, PeakListSoftwareDialog.this.m_lastTimeTextField.getText().trim(), "Last Time :", spectrumTitle);
            InfoDialog parseResultDialog = new InfoDialog((Window)((Object)this._dialog), InfoDialog.InfoType.NO_ICON, "Spectrum Title Parsing Result", sb.toString(), false);
            parseResultDialog.setButtonVisible(0, false);
            parseResultDialog.setButtonName(1, "Close");
            parseResultDialog.centerToWindow((Window)((Object)this._dialog));
            parseResultDialog.setVisible(true);
        }
    }
}

