/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.admin;

import fr.proline.studio.WindowManager;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseProjectTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dam.tasks.data.DRawFile;
import fr.proline.studio.dam.tasks.data.ProjectInfo;
import fr.proline.studio.dock.AbstractDockFrame;
import fr.proline.studio.dpm.serverfilesystem.ServerFileSystemView;
import fr.proline.studio.export.ExportButton;
import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.extendedtablemodel.CompoundTableModel;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.ConvertValueInterface;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.filter.FilterButton;
import fr.proline.studio.filter.FilterTableModelInterface;
import fr.proline.studio.filter.IntegerFilter;
import fr.proline.studio.filter.LongFilter;
import fr.proline.studio.filter.StringDiffFilter;
import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.progress.ProgressInterface;
import fr.proline.studio.table.AbstractDecoratedGlobalTableModel;
import fr.proline.studio.table.DecoratedMarkerTable;
import fr.proline.studio.table.ExportFontModelUtilities;
import fr.proline.studio.table.TableDefaultRendererManager;
import fr.proline.studio.table.TablePopupMenu;
import fr.proline.studio.table.renderer.DefaultAlignRenderer;
import fr.proline.studio.table.renderer.DoubleRenderer;
import fr.proline.studio.utils.CyclicColorPalette;
import fr.proline.studio.utils.IconManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;

public class ProjectsPanel
extends JPanel
implements ListSelectionListener {
    private JDialog m_dialogOwner = null;
    private Boolean m_isEditable = true;
    private final ProjectsInfoTableModel m_projectsBaseModel = new ProjectsInfoTableModel();
    private final CompoundTableModel m_projectsModel = new CompoundTableModel((GlobalTableModelInterface)this.m_projectsBaseModel, true);
    private DecoratedMarkerTable m_projectsTable;
    private final RawFilesTableModel m_rawFileTableModel = new RawFilesTableModel();
    private DecoratedMarkerTable m_rawfilesTable;
    private ArrayList<ProjectInfo> m_resultProjectsList = new ArrayList();
    private HashMap<String, ProjectInfo.Status> m_projectStatusMap = new HashMap();
    private HashMap<Long, ProjectInfo> m_projectMap = new HashMap();
    private SharedProjectDialg m_sharedProjectDialog;
    private HashMap<Long, ProjectInfo> m_sharedProjects4SelectMap;
    private ProjectsInfoTableModel m_sharedProjects4SelectModel = new ProjectsInfoTableModel();
    private DecoratedMarkerTable m_sharedProjectTable = this.createProjectsTable();
    String m_mzdbPath;
    static String sharedProjectText = "Project(s) Which Share Raw Files With Selected Project(s)";

    public ProjectsPanel(JDialog dialog, Boolean editable) {
        this.m_isEditable = editable;
        this.m_dialogOwner = dialog;
        this.m_mzdbPath = this.getDRawFilePathRoot();
        this.setLayout(new BorderLayout());
        JPanel internalPanel = this.createInternalPanel();
        this.add((Component)internalPanel, "Center");
    }

    private JPanel createInternalPanel() {
        JPanel internalPanel = new JPanel(new BorderLayout());
        internalPanel.setBorder(BorderFactory.createTitledBorder("Projects"));
        JScrollPane projectTableScrollPane = new JScrollPane();
        this.m_projectsTable = this.createProjectsTable();
        projectTableScrollPane.setViewportView((Component)this.m_projectsTable);
        this.m_projectsTable.setFillsViewportHeight(true);
        this.m_projectsTable.setModel((TableModel)this.m_projectsModel);
        this.m_projectsTable.getSelectionModel().addListSelectionListener(this);
        List columns = this.m_projectsTable.getColumns(true);
        TableColumnExt columnExt = (TableColumnExt)columns.get(10);
        if (columnExt != null) {
            columnExt.setPreferredWidth(30);
            columnExt.setVisible(false);
        }
        JToolBar toolbar = this.initTopToolbar();
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)projectTableScrollPane, "Center");
        topPanel.add((Component)toolbar, "West");
        this.createRawFileTable();
        JScrollPane rawFilesScrollPane = new JScrollPane();
        rawFilesScrollPane.setViewportView((Component)this.m_rawfilesTable);
        this.m_rawfilesTable.setFillsViewportHeight(true);
        this.m_rawfilesTable.setModel((TableModel)((Object)this.m_rawFileTableModel));
        JToolBar bottomToolbar = this.initBottomToolbar();
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)rawFilesScrollPane, "Center");
        bottomPanel.add((Component)bottomToolbar, "West");
        JSplitPane splitPane = new JSplitPane(0);
        splitPane.setTopComponent(topPanel);
        splitPane.setBottomComponent(bottomPanel);
        splitPane.setDividerLocation(150);
        internalPanel.add((Component)splitPane, "Center");
        this.loadProjectsData();
        return internalPanel;
    }

    private JToolBar initTopToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        FilterButton filterButton = new FilterButton((FilterTableModelInterface)this.m_projectsModel){

            protected void filteringDone() {
            }
        };
        ExportButton exportButton = new ExportButton((ProgressInterface)this.m_projectsModel, "Project", (JXTable)this.m_projectsTable);
        toolbar.add((Component)filterButton);
        toolbar.add((Component)exportButton);
        return toolbar;
    }

    private JToolBar initBottomToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        ExportButton exportButton = new ExportButton((ProgressInterface)this.m_rawFileTableModel, "Raw Files", (JXTable)this.m_rawfilesTable);
        toolbar.add((Component)exportButton);
        JButton otherProjectBt = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.PROJECT));
        otherProjectBt.setToolTipText(sharedProjectText);
        otherProjectBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ProjectsPanel.this.m_sharedProjectDialog == null) {
                    ProjectsPanel.this.m_sharedProjectDialog = new SharedProjectDialg();
                }
                for (int i = 0; i < ProjectsPanel.this.m_sharedProjects4SelectModel.getRowCount(); ++i) {
                    ProjectInfo proj = (ProjectInfo)ProjectsPanel.this.m_sharedProjects4SelectModel.getRowValue(ProjectInfo.class, i);
                    if (!proj.isSelected()) continue;
                    ProjectsPanel.this.m_sharedProjectTable.addRowSelectionInterval(i, i);
                }
                ProjectsPanel.this.m_sharedProjectDialog.setVisible(true);
            }
        });
        toolbar.add(otherProjectBt);
        return toolbar;
    }

    private DecoratedMarkerTable createProjectsTable() {
        DecoratedMarkerTable table = new DecoratedMarkerTable(){

            public TablePopupMenu initPopupMenu() {
                return new TablePopupMenu();
            }

            public void prepostPopupMenu() {
            }

            public void addTableModelListener(TableModelListener l) {
                this.getModel().addTableModelListener(l);
            }

            public TableCellRenderer getCellRenderer(int row, int col) {
                int columnIndex = this.convertColumnIndexToModel(col);
                switch (columnIndex) {
                    case 0: {
                        TableColumn column0 = this.getColumnModel().getColumn(columnIndex);
                        column0.setPreferredWidth(30);
                        return new StatusRenderer();
                    }
                    case 4: {
                        DefaultAlignRenderer rightAign = new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 4);
                        return new DoubleRenderer((TableCellRenderer)rightAign, 0, true, true);
                    }
                }
                return super.getCellRenderer(row, columnIndex);
            }
        };
        return table;
    }

    private void createRawFileTable() {
        this.m_rawfilesTable = new DecoratedMarkerTable(){

            public void addTableModelListener(TableModelListener l) {
                this.getModel().addTableModelListener(l);
            }

            public TablePopupMenu initPopupMenu() {
                return new TablePopupMenu();
            }

            public void prepostPopupMenu() {
            }

            public TableCellRenderer getCellRenderer(int row, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        TableColumn column0 = this.getColumnModel().getColumn(columnIndex);
                        column0.setPreferredWidth(30);
                        return new StatusRenderer();
                    }
                }
                return super.getCellRenderer(row, columnIndex);
            }
        };
    }

    private void loadProjectsData() {
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                if (success) {
                    ProjectsPanel.this.updateData();
                }
            }
        };
        DatabaseProjectTask task = new DatabaseProjectTask(callback);
        task.initLoadProjectsList(this.m_resultProjectsList);
        AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
    }

    private void updateData() {
        this.m_projectsBaseModel.setData(this.m_resultProjectsList);
        this.m_projectStatusMap = new HashMap();
        for (ProjectInfo pi : this.m_resultProjectsList) {
            this.m_projectStatusMap.put("" + pi.getProjectId(), pi.getStatus());
            this.m_projectMap.put(pi.getProjectId(), pi);
        }
        if (this.m_resultProjectsList.size() > 0) {
            this.m_projectsTable.setRowSelectionInterval(0, 0);
        }
    }

    private void updateRawFiles(ArrayList<DRawFile> resultRawfiles, List<Long> selectedProjectIds) {
        ArrayList<String> idList = new ArrayList<String>();
        ArrayList<DRawFile> fileList = new ArrayList<DRawFile>();
        this.m_sharedProjects4SelectMap = new HashMap();
        for (DRawFile file : resultRawfiles) {
            String identifier = file.getIdentifier();
            if (idList.contains(identifier)) continue;
            idList.add(identifier);
            fileList.add(file);
            String path = file.getRawFileDirectory();
            if (path.startsWith(this.m_mzdbPath)) {
                file.setRawFileDirectory(path.replaceFirst(this.m_mzdbPath, "<" + this.m_mzdbPath + ">"));
            }
            DRawFile.ProjectStatus ps = DRawFile.ProjectStatus.ACTIVE;
            int nbArchived = 0;
            String projectIds = file.getProjectIds();
            String[] ids = projectIds.split(",");
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            for (String id : ids) {
                Long idProject = Long.parseLong(id);
                if (this.m_sharedProjects4SelectMap.get(idProject) == null) {
                    ProjectInfo proj = this.m_projectMap.get(idProject);
                    if (selectedProjectIds.contains(idProject)) {
                        proj.setSelected(true);
                    } else {
                        proj.setSelected(false);
                    }
                    this.m_sharedProjects4SelectMap.put(idProject, proj);
                }
                ProjectInfo.Status status = this.m_projectStatusMap.get(id);
                String projectColor = CyclicColorPalette.getHTMLColor((Color)(switch (status) {
                    case ProjectInfo.Status.ARCHIVED -> {
                        ++nbArchived;
                        yield Color.GRAY;
                    }
                    case ProjectInfo.Status.INACTIVE -> {
                        ++nbArchived;
                        yield Color.BLUE;
                    }
                    default -> Color.BLACK;
                }));
                sb.append("<span style='color:#").append(projectColor).append(";'>" + id + "</span>,");
            }
            String toShow = sb.substring(0, sb.length() - 1) + "</html>";
            file.setProjectIdsDecorted(toShow);
            if (nbArchived == file.getProjectsCount()) {
                ps = DRawFile.ProjectStatus.ALL_ARCHIVED;
            } else if (nbArchived > 0) {
                ps = DRawFile.ProjectStatus.SOME_ARCHIVED;
            }
            file.setProjectStatus(ps);
        }
        List data = this.m_sharedProjects4SelectMap.values().stream().sorted(Comparator.comparingLong(ProjectInfo::getProjectId)).collect(Collectors.toList());
        this.m_sharedProjects4SelectModel.setData(data);
        this.m_rawFileTableModel.setData(fileList);
    }

    private String getDRawFilePathRoot() {
        ArrayList paths = ServerFileSystemView.getServerFileSystemView().getLabels("mzdb_files");
        if (paths != null && !paths.isEmpty()) {
            return (String)paths.get(0);
        }
        return "";
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int[] rows = this.m_projectsTable.getSelectedRows();
        int size = this.m_projectsModel.getRowCount();
        for (ProjectInfo project : this.m_resultProjectsList) {
            project.setSelected(false);
        }
        final List projectIds = Arrays.stream(rows).mapToObj(i -> {
            int mi = this.m_projectsModel.convertRowToOriginalModel(i);
            mi = this.m_projectsTable.convertRowIndexToModel(i);
            mi = this.m_projectsModel.convertCompoundRowToBaseModelRow(mi);
            return this.m_resultProjectsList.get(mi).getProjectId();
        }).collect(Collectors.toList());
        if (projectIds != null && !projectIds.isEmpty()) {
            final ArrayList resultRawfiles = new ArrayList();
            AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

                public boolean mustBeCalledInAWT() {
                    return true;
                }

                public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                    if (success) {
                        ProjectsPanel.this.updateRawFiles(resultRawfiles, projectIds);
                    }
                }
            };
            DatabaseProjectTask task = new DatabaseProjectTask(callback);
            task.initLoadRawFilesList(projectIds, resultRawfiles);
            AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
        }
    }

    public class ProjectsInfoTableModel
    extends AbstractDecoratedGlobalTableModel<ProjectInfo> {
        public static final int COLTYPE_STATUS = 0;
        public static final int COLTYPE_PROJECTID = 1;
        public static final int COLTYPE_NAME = 2;
        public static final int COLTYPE_DESCRIPTION = 3;
        public static final int COLTYPE_SIZE = 4;
        public static final int COLTYPE_USER = 5;
        public static final int COLTYPE_RAW_FILES_COUNT = 6;
        public static final int COLTYPE_DB_NAME = 7;
        public static final int COLTYPE_LAST_DATASET_DATE = 8;
        public static final int COLTYPE_PROPERTIES = 9;
        public static final int COLTYPE_IS_SELECTED = 10;

        public ProjectsInfoTableModel() {
            String[] columnNames = new String[]{" ", "Id", "Project", "Description", "Size (MB)", "Owner", "Raw Files Count", "Databases", "Dataset Date", "Properties", "isSelected"};
            this.m_columnNames = columnNames;
            String[] columnTooltips = new String[]{"Status", "Id", "Project", "Description", "Size (MB)", "Owner", "Raw Files Count", "Databases", "Dataset Date", "Properties", "isSelected"};
            this.m_columnTooltips = columnTooltips;
        }

        public int getRowCount() {
            return this.m_entities.size();
        }

        public int getColumnCount() {
            return this.m_columnNames.length;
        }

        public Object getValueAt(int row, int col) {
            ProjectInfo project = (ProjectInfo)this.m_entities.get(row);
            switch (col) {
                case 0: {
                    return project.getStatus();
                }
                case 1: {
                    return project.getProjectId();
                }
                case 2: {
                    return project.getName();
                }
                case 3: {
                    return project.getDescription();
                }
                case 4: {
                    return project.getSize();
                }
                case 5: {
                    return project.getUser();
                }
                case 6: {
                    return project.getRawFilesCount();
                }
                case 7: {
                    return project.getDBName();
                }
                case 8: {
                    return project.getLastDatasetDate();
                }
                case 9: {
                    return project.getProperties();
                }
                case 10: {
                    return project.isSelected();
                }
            }
            return "";
        }

        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Integer.class;
                }
                case 1: {
                    return Long.class;
                }
                case 2: {
                    return String.class;
                }
                case 3: {
                    return String.class;
                }
                case 4: {
                    return Double.class;
                }
                case 5: {
                    return String.class;
                }
                case 6: {
                    return Integer.class;
                }
                case 7: {
                    return String.class;
                }
                case 8: {
                    return Date.class;
                }
                case 9: {
                    return String.class;
                }
            }
            return Object.class;
        }

        public String getToolTipForHeader(int col) {
            return this.m_columnTooltips[col];
        }

        public TableCellRenderer getRenderer(int row, int col) {
            return null;
        }

        public void addFilters(LinkedHashMap<Integer, Filter> filtersMap) {
            filtersMap.put(0, (Filter)new IntegerFilter(this.m_columnNames[0], null, 0));
            filtersMap.put(2, (Filter)new StringDiffFilter(this.m_columnNames[2], null, 2));
            filtersMap.put(1, (Filter)new LongFilter(this.m_columnNames[1], null, 1));
            filtersMap.put(2, (Filter)new StringDiffFilter(this.m_columnNames[2], null, 2));
            filtersMap.put(3, (Filter)new StringDiffFilter(this.m_columnNames[3], null, 3));
            filtersMap.put(5, (Filter)new StringDiffFilter(this.m_columnNames[5], null, 5));
            filtersMap.put(7, (Filter)new StringDiffFilter(this.m_columnNames[7], null, 7));
            ConvertValueInterface dateConverter = new ConvertValueInterface(){

                public Object convertValue(Object o) {
                    if (o == null) {
                        return null;
                    }
                    return ((Date)o).getTime();
                }
            };
            filtersMap.put(8, (Filter)new LongFilter(this.m_columnNames[8], dateConverter, 8));
        }

        public Object getRowValue(Class c, int row) {
            if (c.equals(ProjectInfo.class)) {
                return this.m_entities.get(row);
            }
            return null;
        }

        public int[] getKeysColumn() {
            int[] keys = new int[]{1, 2};
            return keys;
        }
    }

    public class RawFilesTableModel
    extends AbstractDecoratedGlobalTableModel<DRawFile> {
        public static final int COLTYPE_PROJECT_STATUS = 0;
        public static final int COLTYPE_CREATION_TIMESTAMP = 1;
        public static final int COLTYPE_IDENTIFIER = 2;
        public static final int COLTYPE_RAW_FILE_NAME = 3;
        public static final int COLTYPE_RAW_FILE_DIRECTORY = 4;
        public static final int COLTYPE_PROJECT_IDS = 5;
        public static final int COLTYPE_PROJECTS_COUNT = 6;
        public static final int COLTYPE_SERIALIZED_PROPERTIES = 7;

        public RawFilesTableModel() {
            String[] columnNames = new String[]{" ", "Creation Date", "Identifier", "Raw File Name", "Raw File Directory", "Project Ids", "Projects Count", "Properties"};
            this.m_columnNames = columnNames;
            String[] columnTooltips = new String[]{"Projects Status", "Creation Date", "Identifier", "Raw File Name", "Raw File Directory", "Project Ids", "Projects Count", "Properties"};
            this.m_columnTooltips = columnTooltips;
        }

        public Object getDataValueAt(int rowIndex, int columnIndex) {
            DRawFile file = (DRawFile)this.m_entities.get(rowIndex);
            switch (columnIndex) {
                case 5: {
                    return file.getProjectIds();
                }
            }
            return this.getValueAt(rowIndex, columnIndex);
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            DRawFile file = (DRawFile)this.m_entities.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return file.getProjectStatus();
                }
                case 1: {
                    return file.getCreationTimestamp();
                }
                case 2: {
                    return file.getIdentifier();
                }
                case 3: {
                    return file.getRawFileName();
                }
                case 4: {
                    return file.getRawFileDirectory();
                }
                case 5: {
                    return file.getProjectIdsDecorted();
                }
                case 6: {
                    return file.getProjectsCount();
                }
                case 7: {
                    return file.getSerializedProperties();
                }
            }
            return "";
        }

        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Integer.class;
                }
                case 1: {
                    return Timestamp.class;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    return String.class;
                }
                case 6: {
                    return Integer.class;
                }
                case 7: {
                    return String.class;
                }
            }
            return Object.class;
        }

        public ArrayList<ExportFontData> getExportFonts(int row, int col) {
            if (col == 5) {
                String projectId = (String)this.getDataValueAt(row, col);
                ArrayList<ExportFontData> fonds = ExportFontModelUtilities.getExportFonts(projectId, ProjectsPanel.this.m_projectStatusMap);
                return fonds;
            }
            return null;
        }

        public TableCellRenderer getRenderer(int row, int col) {
            return null;
        }

        public Object getRowValue(Class c, int row) {
            if (c.equals(DRawFile.class)) {
                return this.m_entities.get(row);
            }
            return null;
        }

        public int[] getKeysColumn() {
            int[] keys = new int[]{2};
            return keys;
        }

        public void addFilters(LinkedHashMap<Integer, Filter> filtersMap) {
        }
    }

    private class StatusRenderer
    extends DefaultTableCellRenderer {
        String active = "<html><font color='" + CyclicColorPalette.getHTMLColor((Color)Color.green) + "'>&#x2587;&nbsp;</font></html>";
        String archived = "<html><font color='" + CyclicColorPalette.getHTMLColor((Color)Color.blue) + "'>&#x2587;&nbsp;</font></html>";
        String some_archived = "<html><font color='" + CyclicColorPalette.getHTMLColor((Color)Color.orange) + "'>&#x2587;&nbsp;</font></html>";
        String inactive = "<html><font color='" + CyclicColorPalette.getHTMLColor((Color)Color.gray) + "'>&#x2587;&nbsp;</font></html>";

        private StatusRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setHorizontalTextPosition(0);
            this.setVerticalTextPosition(3);
            if (value instanceof ProjectInfo.Status) {
                ProjectInfo.Status status = (ProjectInfo.Status)value;
                switch (status) {
                    case ACTIVE: {
                        this.setText(this.active);
                        this.setToolTipText("Active");
                        break;
                    }
                    case ARCHIVED: {
                        this.setText(this.archived);
                        this.setToolTipText("Archived");
                        break;
                    }
                    case INACTIVE: {
                        this.setText(this.inactive);
                        this.setToolTipText("Inactive");
                    }
                }
            } else if (value instanceof DRawFile.ProjectStatus) {
                DRawFile.ProjectStatus status = (DRawFile.ProjectStatus)value;
                switch (status) {
                    case ACTIVE: {
                        this.setText(this.active);
                        this.setToolTipText("Active");
                        break;
                    }
                    case SOME_ARCHIVED: {
                        this.setText(this.some_archived);
                        this.setToolTipText("Some Archived");
                        break;
                    }
                    case ALL_ARCHIVED: {
                        this.setText(this.inactive);
                        this.setToolTipText("All archived/Inactive");
                    }
                }
            }
            this.setHorizontalAlignment(0);
            if (isSelected) {
                this.setBackground(UIManager.getDefaults().getColor("Table.selectionBackground"));
                this.setForeground(Color.WHITE);
            } else {
                this.setBackground(UIManager.getDefaults().getColor("Table.background"));
                this.setForeground(Color.BLACK);
            }
            return this;
        }
    }

    class SharedProjectDialg
    extends DefaultDialog {
        private SharedProjectDialg() {
            this.setIconImage(IconManager.getImage((IconManager.IconType)IconManager.IconType.PROJECT));
            AbstractDockFrame f = WindowManager.getDefault().getMainWindow();
            this.setSize(new Dimension(500, 480));
            this.setResizable(true);
            this.setButtonVisible(1, false);
            this.setButtonName(0, "Close");
            this.initInternalPanel();
            this.setLocationRelativeTo(ProjectsPanel.this);
            this.setVisible(true);
        }

        void initInternalPanel() {
            JPanel sharedProjectPane = new JPanel(new BorderLayout());
            sharedProjectPane.setBorder(BorderFactory.createTitledBorder(sharedProjectText));
            JScrollPane sharedProjectTableScrollPane = new JScrollPane();
            sharedProjectTableScrollPane.setViewportView((Component)ProjectsPanel.this.m_sharedProjectTable);
            ProjectsPanel.this.m_sharedProjectTable.setFillsViewportHeight(true);
            ProjectsPanel.this.m_sharedProjectTable.setModel((TableModel)((Object)ProjectsPanel.this.m_sharedProjects4SelectModel));
            ProjectsPanel.this.m_sharedProjectTable.packAll();
            sharedProjectPane.add((Component)sharedProjectTableScrollPane, "Center");
            this.setInternalComponent(sharedProjectPane);
        }
    }
}

